/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.common;

import java.awt.color.ColorSpace;

public final class SimpleCMYKColorSpace
extends ColorSpace {
    private static ColorSpace theInstance = null;
    private ColorSpace csRGB = ColorSpace.getInstance(1004);
    private static final double power1 = 0.4166666666666667;

    public static final synchronized ColorSpace getInstance() {
        if (theInstance == null) {
            theInstance = new SimpleCMYKColorSpace();
        }
        return theInstance;
    }

    private SimpleCMYKColorSpace() {
        super(9, 4);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof SimpleCMYKColorSpace;
    }

    public float[] toRGB(float[] fArray) {
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = fArray[3];
        float f6 = 1.0f - f5;
        float[] fArray2 = new float[]{f6 * (1.0f - f2), f6 * (1.0f - f3), f6 * (1.0f - f4)};
        for (int i2 = 0; i2 < 3; ++i2) {
            float f7 = fArray2[i2];
            if (f7 < 0.0f) {
                f7 = 0.0f;
            }
            if (f7 < 0.0031308f) {
                fArray2[i2] = 12.92f * f7;
                continue;
            }
            if (f7 > 1.0f) {
                f7 = 1.0f;
            }
            fArray2[i2] = (float)(1.055 * Math.pow(f7, 0.4166666666666667) - 0.055);
        }
        return fArray2;
    }

    public float[] fromRGB(float[] fArray) {
        for (int i2 = 0; i2 < 3; ++i2) {
            if (fArray[i2] < 0.040449936f) {
                int n2 = i2;
                fArray[n2] = fArray[n2] / 12.92f;
                continue;
            }
            fArray[i2] = (float)Math.pow(((double)fArray[i2] + 0.055) / 1.055, 2.4);
        }
        float f2 = 1.0f - fArray[0];
        float f3 = 1.0f - fArray[1];
        float f4 = 1.0f - fArray[2];
        float f5 = Math.min(f2, Math.min(f3, f4));
        if (f5 != 1.0f) {
            float f6 = 1.0f - f5;
            f2 = (f2 - f5) / f6;
            f3 = (f3 - f5) / f6;
            f4 = (f4 - f5) / f6;
        } else {
            f4 = 0.0f;
            f3 = 0.0f;
            f2 = 0.0f;
        }
        return new float[]{f2, f3, f4, f5};
    }

    public float[] toCIEXYZ(float[] fArray) {
        return this.csRGB.toCIEXYZ(this.toRGB(fArray));
    }

    public float[] fromCIEXYZ(float[] fArray) {
        return this.fromRGB(this.csRGB.fromCIEXYZ(fArray));
    }
}

