/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.bmp;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.bmp.BMPImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class BMPImageReaderSpi
extends ImageReaderSpi {
    private static String[] writerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.bmp.BMPImageWriterSpi"};
    private static String[] formatNames = new String[]{"bmp", "BMP"};
    private static String[] extensions = new String[]{"bmp"};
    private static String[] mimeTypes = new String[]{"image/bmp", "image/x-bmp", "image/x-windows-bmp"};
    private boolean registered = false;

    public BMPImageReaderSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), formatNames, extensions, mimeTypes, "com.sun.media.imageioimpl.plugins.bmp.BMPImageReader", STANDARD_INPUT_TYPE, writerSpiNames, false, null, null, null, null, true, "com_sun_media_imageio_plugins_bmp_image_1.0", "com.sun.media.imageioimpl.plugins.bmp.BMPMetadataFormat", null, null);
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
        ImageUtil.processOnRegistration(serviceRegistry, clazz, "BMP", this, 8, 7);
    }

    public String getDescription(Locale locale) {
        String string = PackageUtil.getSpecificationTitle() + " BMP Image Reader";
        return string;
    }

    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        byte[] byArray = new byte[2];
        imageInputStream.mark();
        imageInputStream.readFully(byArray);
        imageInputStream.reset();
        return byArray[0] == 66 && byArray[1] == 77;
    }

    public ImageReader createReaderInstance(Object object) throws IIOException {
        return new BMPImageReader(this);
    }
}

