/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.bmp;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.bmp.BMPImageWriter;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class BMPImageWriterSpi
extends ImageWriterSpi {
    private static String[] readerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.bmp.BMPImageReaderSpi"};
    private static String[] formatNames = new String[]{"bmp", "BMP"};
    private static String[] extensions = new String[]{"bmp"};
    private static String[] mimeTypes = new String[]{"image/bmp", "image/x-bmp", "image/x-windows-bmp"};
    private boolean registered = false;

    public BMPImageWriterSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), formatNames, extensions, mimeTypes, "com.sun.media.imageioimpl.plugins.bmp.BMPImageWriter", STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, true, "com_sun_media_imageio_plugins_bmp_image_1.0", "com.sun.media.imageioimpl.plugins.bmp.BMPMetadataFormat", null, null);
    }

    public String getDescription(Locale locale) {
        String string = PackageUtil.getSpecificationTitle() + " BMP Image Writer";
        return string;
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
        ImageUtil.processOnRegistration(serviceRegistry, clazz, "BMP", this, 8, 7);
    }

    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        int n2 = imageTypeSpecifier.getSampleModel().getDataType();
        if (n2 < 0 || n2 > 3) {
            return false;
        }
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        int n3 = sampleModel.getNumBands();
        if (n3 != 1 && n3 != 3) {
            return false;
        }
        if (n3 == 1 && n2 != 0) {
            return false;
        }
        return n2 <= 0 || sampleModel instanceof SinglePixelPackedSampleModel;
    }

    public ImageWriter createWriterInstance(Object object) throws IIOException {
        return new BMPImageWriter(this);
    }
}

