/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.clib;

import com.sun.media.imageioimpl.plugins.clib.I18N;
import com.sun.medialib.codec.jiio.mediaLibImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;

public abstract class CLibImageWriter
extends ImageWriter {
    private static final Object getDataBufferData(DataBuffer dataBuffer) {
        Object[] objectArray;
        int n2 = dataBuffer.getDataType();
        switch (n2) {
            case 0: {
                objectArray = ((DataBufferByte)dataBuffer).getData();
                break;
            }
            case 1: {
                objectArray = ((DataBufferUShort)dataBuffer).getData();
                break;
            }
            default: {
                throw new IllegalArgumentException(I18N.getString("Generic0") + " " + n2);
            }
        }
        return objectArray;
    }

    private static final int getMediaLibDataType(int n2) {
        int n3;
        switch (n2) {
            case 0: {
                n3 = 1;
                break;
            }
            case 1: {
                n3 = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException(I18N.getString("Generic0") + " " + n2);
            }
        }
        return n3;
    }

    private static final int getMediaLibFormat(SampleModel sampleModel, ColorModel colorModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        int n2 = 0;
        if (sampleModel instanceof SinglePixelPackedSampleModel && sampleModel.getNumBands() == 4 && colorModel != null && colorModel.hasAlpha()) {
            int[] nArray = ((SinglePixelPackedSampleModel)sampleModel).getBitMasks();
            if (nArray[3] == -16777216) {
                if (nArray[0] == 255 && nArray[1] == 65280 && nArray[2] == 0xFF0000) {
                    n2 = 8;
                } else if (nArray[0] == 0xFF0000 && nArray[1] == 65280 && nArray[2] == 255) {
                    n2 = 7;
                }
            }
        } else if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            int[] nArray = componentSampleModel.getBandOffsets();
            int n3 = componentSampleModel.getPixelStride();
            if (n3 == nArray.length) {
                int n4;
                int n5 = n3;
                boolean bl2 = true;
                int[] nArray2 = componentSampleModel.getBankIndices();
                for (n4 = 1; n4 < nArray2.length; ++n4) {
                    if (nArray2[n4] == nArray2[0]) continue;
                    bl2 = false;
                }
                if (bl2) {
                    if (colorModel instanceof IndexColorModel) {
                        n2 = 1;
                    } else if (n5 == 1) {
                        n2 = 2;
                    } else if (n5 == 2 && nArray[0] == 0 && nArray[1] == 1) {
                        n2 = 9;
                    } else if (n5 == 3) {
                        int n6 = n4 = colorModel != null ? colorModel.getColorSpace().getType() : 5;
                        if (n4 == 5) {
                            if (nArray[0] == 2 && nArray[1] == 1 && nArray[2] == 0) {
                                n2 = 4;
                            } else if (nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2) {
                                n2 = 3;
                            }
                        } else if (n4 == 4 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2) {
                            n2 = 12;
                        }
                    } else if (n5 == 4) {
                        int n7 = n4 = colorModel != null ? colorModel.getColorSpace().getType() : 5;
                        if (n4 == 5) {
                            if (nArray[3] == 0) {
                                if (nArray[0] == 3 && nArray[1] == 2 && nArray[2] == 1) {
                                    n2 = 6;
                                } else if (nArray[0] == 1 && nArray[1] == 2 && nArray[2] == 3) {
                                    n2 = 5;
                                }
                            } else if (nArray[3] == 3) {
                                if (nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2) {
                                    n2 = 10;
                                } else if (nArray[0] == 2 && nArray[1] == 1 && nArray[2] == 0) {
                                    n2 = 15;
                                }
                            }
                        } else if (n4 == 9 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2 && nArray[3] == 3) {
                            n2 = 11;
                        } else if (n4 == 4 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2 && nArray[3] == 3) {
                            n2 = colorModel != null && colorModel.hasAlpha() ? 13 : 14;
                        }
                    }
                }
            }
        }
        return n2;
    }

    private static final Raster getContiguousData(RenderedImage renderedImage, Rectangle rectangle) {
        Raster raster;
        if (renderedImage == null) {
            throw new IllegalArgumentException("im == null");
        }
        if (rectangle == null) {
            throw new IllegalArgumentException("region == null");
        }
        if (renderedImage.getNumXTiles() == 1 && renderedImage.getNumYTiles() == 1) {
            raster = renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY());
            Rectangle rectangle2 = raster.getBounds();
            if (!rectangle2.equals(rectangle)) {
                raster = raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
            }
        } else {
            SampleModel sampleModel = renderedImage.getSampleModel();
            WritableRaster writableRaster = sampleModel.getSampleSize(0) == 8 ? Raster.createInterleavedRaster(0, renderedImage.getWidth(), renderedImage.getHeight(), sampleModel.getNumBands(), new Point(renderedImage.getMinX(), renderedImage.getMinY())) : null;
            raster = renderedImage.copyData(writableRaster);
        }
        return raster;
    }

    private static void reformat(Raster raster, int[] nArray, int n2, int n3, WritableRaster writableRaster) {
        int n4;
        if (raster == null) {
            throw new IllegalArgumentException("source == null!");
        }
        if (writableRaster == null) {
            throw new IllegalArgumentException("dst == null!");
        }
        Rectangle rectangle = raster.getBounds();
        if (rectangle.isEmpty()) {
            throw new IllegalArgumentException("source.getBounds().isEmpty()!");
        }
        boolean bl2 = false;
        int n5 = raster.getSampleModel().getNumBands();
        if (nArray != null) {
            if (nArray.length > n5) {
                throw new IllegalArgumentException("sourceBands.length > numSourceBands!");
            }
            n4 = nArray.length == n5 ? 1 : 0;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] < 0 || nArray[i2] >= n5) {
                    throw new IllegalArgumentException("sourceBands[i] < 0 || sourceBands[i] >= numSourceBands!");
                }
                if (nArray[i2] == i2) continue;
                n4 = 0;
            }
            bl2 = n4 == 0;
        }
        n4 = rectangle.width;
        int[] nArray2 = new int[n4 * n5];
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = nArray != null ? nArray.length : n5;
        int n9 = writableRaster.getWidth();
        int n10 = writableRaster.getHeight() - 1;
        int n11 = n5 * n2;
        for (int i3 = 0; i3 <= n10; ++i3) {
            int n12;
            int n13;
            int n14;
            int n15;
            raster.getPixels(n6, n7, n4, 1, nArray2);
            if (bl2) {
                n15 = 0;
                n14 = 0;
                for (n13 = 0; n13 < n9; ++n13) {
                    for (n12 = 0; n12 < n8; ++n12) {
                        nArray2[n14++] = nArray2[n15 + nArray[n12]];
                    }
                    n15 += n11;
                }
            } else {
                n15 = n11;
                n14 = n5;
                for (n13 = 1; n13 < n9; ++n13) {
                    n12 = n15;
                    for (int i4 = 0; i4 < n5; ++i4) {
                        nArray2[n14++] = nArray2[n12++];
                    }
                    n15 += n11;
                }
            }
            writableRaster.setPixels(0, i3, n9, 1, nArray2);
            n7 += n3;
        }
    }

    protected CLibImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    private static final Rectangle getSourceRegion(ImageWriteParam imageWriteParam, int n2, int n3, int n4, int n5) {
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        if (imageWriteParam != null) {
            Rectangle rectangle2 = imageWriteParam.getSourceRegion();
            if (rectangle2 != null) {
                rectangle = rectangle.intersection(rectangle2);
            }
            int n6 = imageWriteParam.getSubsamplingXOffset();
            int n7 = imageWriteParam.getSubsamplingYOffset();
            rectangle.x += n6;
            rectangle.y += n7;
            rectangle.width -= n6;
            rectangle.height -= n7;
        }
        return rectangle;
    }

    protected mediaLibImage getMediaLibImage(RenderedImage renderedImage, ImageWriteParam imageWriteParam, boolean bl2, int[] nArray) {
        int[] nArray2;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray3;
        if (nArray == null) {
            throw new IllegalArgumentException("supportedFormats == null!");
        }
        Rectangle rectangle = CLibImageWriter.getSourceRegion(imageWriteParam, renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        if (rectangle.isEmpty()) {
            throw new IllegalArgumentException("sourceRegion.isEmpty()");
        }
        boolean bl3 = false;
        boolean bl4 = false;
        int n7 = 0;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n8 = sampleModel.getNumBands();
        int[] nArray4 = nArray3 = imageWriteParam != null ? imageWriteParam.getSourceBands() : null;
        if (nArray3 != null) {
            n6 = nArray3.length;
            if (n6 != n8) {
                bl3 = true;
            } else {
                for (n5 = 0; n5 < n8; ++n5) {
                    if (nArray3[n5] == n5) continue;
                    bl3 = true;
                    break;
                }
            }
        } else {
            n6 = n8;
        }
        if (!(bl3 || imageWriteParam == null || imageWriteParam.getSourceXSubsampling() == 1 && imageWriteParam.getSourceXSubsampling() == 1)) {
            bl3 = true;
        }
        if (!bl3) {
            if (bl2 && sampleModel.getNumBands() == 1 && sampleModel.getSampleSize(0) == 1 && sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getDataType() == 0) {
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                if (multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                    bl4 = true;
                } else {
                    bl3 = true;
                }
            } else {
                n7 = CLibImageWriter.getMediaLibFormat(sampleModel, renderedImage.getColorModel());
                bl3 = true;
                n5 = nArray.length;
                for (int i2 = 0; i2 < n5; ++i2) {
                    if (n7 != nArray[i2]) continue;
                    bl3 = false;
                    break;
                }
            }
        }
        Raster raster = null;
        if (bl3) {
            WritableRaster writableRaster;
            SampleModel sampleModel2;
            int n9;
            int[] nArray5 = sampleModel.getSampleSize();
            int n10 = nArray5[0];
            for (n4 = 1; n4 < n8; ++n4) {
                n10 = Math.max(n10, nArray5[n4]);
            }
            if (n10 <= 8) {
                n4 = 0;
            } else if (n10 <= 16) {
                n4 = 1;
            } else {
                throw new UnsupportedOperationException(I18N.getString("CLibImageWriter0") + " " + n10);
            }
            if (imageWriteParam != null) {
                int n11 = imageWriteParam.getSourceXSubsampling();
                n9 = imageWriteParam.getSourceYSubsampling();
                n3 = (rectangle.width + n11 - 1) / n11;
                n2 = (rectangle.height + n9 - 1) / n9;
            } else {
                n3 = rectangle.width;
                n2 = rectangle.height;
            }
            nArray2 = new int[n6];
            for (n9 = 0; n9 < n6; ++n9) {
                nArray2[n9] = n9;
            }
            if (bl2 && sampleModel.getNumBands() == 1 && n10 == 1) {
                sampleModel2 = new MultiPixelPackedSampleModel(n4, n3, n2, 1);
                bl4 = true;
            } else {
                sampleModel2 = new PixelInterleavedSampleModel(n4, n3, n2, nArray2.length, n3 * n8, nArray2);
            }
            WritableRaster writableRaster2 = Raster.createWritableRaster(sampleModel2, null);
            if (imageWriteParam != null && (imageWriteParam.getSourceXSubsampling() != 1 || imageWriteParam.getSourceXSubsampling() != 1)) {
                CLibImageWriter.reformat(CLibImageWriter.getContiguousData(renderedImage, rectangle), nArray3, imageWriteParam.getSourceXSubsampling(), imageWriteParam.getSourceYSubsampling(), writableRaster2);
            } else if (nArray3 == null && renderedImage.getSampleModel().getClass().isInstance(sampleModel2) && sampleModel2.getTransferType() == renderedImage.getSampleModel().getTransferType()) {
                writableRaster = writableRaster2.createWritableTranslatedChild(rectangle.x, rectangle.y);
                renderedImage.copyData(writableRaster);
            } else {
                writableRaster = writableRaster2.createWritableTranslatedChild(rectangle.x, rectangle.y);
                Raster raster2 = CLibImageWriter.getContiguousData(renderedImage, rectangle);
                if (nArray3 != null) {
                    raster2 = raster2.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, nArray3);
                }
                writableRaster.setRect(raster2);
            }
            raster = writableRaster2;
            sampleModel = writableRaster2.getSampleModel();
        } else {
            raster = CLibImageWriter.getContiguousData(renderedImage, rectangle).createTranslatedChild(0, 0);
            sampleModel = raster.getSampleModel();
            n7 = CLibImageWriter.getMediaLibFormat(sampleModel, renderedImage.getColorModel());
        }
        mediaLibImage mediaLibImage2 = null;
        if (bl4) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            n4 = multiPixelPackedSampleModel.getScanlineStride();
            n3 = raster.getDataBuffer().getOffset() - raster.getSampleModelTranslateY() * n4 - raster.getSampleModelTranslateX() / 8 + multiPixelPackedSampleModel.getOffset(0, 0);
            Object object = CLibImageWriter.getDataBufferData(raster.getDataBuffer());
            mediaLibImage2 = new mediaLibImage(0, 1, raster.getWidth(), raster.getHeight(), n4, n3, (byte)multiPixelPackedSampleModel.getBitOffset(0), object);
        } else {
            int n12;
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            n4 = CLibImageWriter.getMediaLibDataType(sampleModel.getDataType());
            Object object = CLibImageWriter.getDataBufferData(raster.getDataBuffer());
            n2 = componentSampleModel.getScanlineStride();
            nArray2 = componentSampleModel.getBandOffsets();
            int n13 = nArray2[0];
            for (n12 = 1; n12 < nArray2.length; ++n12) {
                if (nArray2[n12] >= n13) continue;
                n13 = nArray2[n12];
            }
            n12 = (raster.getMinY() - raster.getSampleModelTranslateY()) * n2 + (raster.getMinX() - raster.getSampleModelTranslateX()) * n8 + n13;
            mediaLibImage2 = !bl3 && n7 != 0 ? new mediaLibImage(n4, n8, raster.getWidth(), raster.getHeight(), n2, n12, n7, object) : new mediaLibImage(n4, n8, raster.getWidth(), raster.getHeight(), n2, n12, object);
        }
        return mediaLibImage2;
    }
}

