/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.gif;

import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import org.w3c.dom.Node;

abstract class GIFMetadata
extends IIOMetadata {
    static final int UNDEFINED_INTEGER_VALUE = -1;

    protected static void fatal(Node node, String string) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(string, node);
    }

    protected static String getStringAttribute(Node node, String string, String string2, boolean bl2, String[] stringArray) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl2) {
                return string2;
            }
            GIFMetadata.fatal(node, "Required attribute " + string + " not present!");
        }
        String string3 = node2.getNodeValue();
        if (stringArray != null) {
            if (string3 == null) {
                GIFMetadata.fatal(node, "Null value for " + node.getNodeName() + " attribute " + string + "!");
            }
            boolean bl3 = false;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!string3.equals(stringArray[i2])) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                GIFMetadata.fatal(node, "Bad value for " + node.getNodeName() + " attribute " + string + "!");
            }
        }
        return string3;
    }

    protected static int getIntAttribute(Node node, String string, int n2, boolean bl2, boolean bl3, int n3, int n4) throws IIOInvalidTreeException {
        String string2 = GIFMetadata.getStringAttribute(node, string, null, bl2, null);
        if (string2 == null || "".equals(string2)) {
            return n2;
        }
        int n5 = n2;
        try {
            n5 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            GIFMetadata.fatal(node, "Bad value for " + node.getNodeName() + " attribute " + string + "!");
        }
        if (bl3 && (n5 < n3 || n5 > n4)) {
            GIFMetadata.fatal(node, "Bad value for " + node.getNodeName() + " attribute " + string + "!");
        }
        return n5;
    }

    protected static float getFloatAttribute(Node node, String string, float f2, boolean bl2) throws IIOInvalidTreeException {
        String string2 = GIFMetadata.getStringAttribute(node, string, null, bl2, null);
        if (string2 == null) {
            return f2;
        }
        return Float.parseFloat(string2);
    }

    protected static int getIntAttribute(Node node, String string, boolean bl2, int n2, int n3) throws IIOInvalidTreeException {
        return GIFMetadata.getIntAttribute(node, string, -1, true, bl2, n2, n3);
    }

    protected static float getFloatAttribute(Node node, String string) throws IIOInvalidTreeException {
        return GIFMetadata.getFloatAttribute(node, string, -1.0f, true);
    }

    protected static boolean getBooleanAttribute(Node node, String string, boolean bl2, boolean bl3) throws IIOInvalidTreeException {
        String string2;
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl3) {
                return bl2;
            }
            GIFMetadata.fatal(node, "Required attribute " + string + " not present!");
        }
        if ((string2 = node2.getNodeValue()).equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (string2.equalsIgnoreCase("FALSE")) {
            return false;
        }
        GIFMetadata.fatal(node, "Attribute " + string + " must be 'TRUE' or 'FALSE'!");
        return false;
    }

    protected static boolean getBooleanAttribute(Node node, String string) throws IIOInvalidTreeException {
        return GIFMetadata.getBooleanAttribute(node, string, false, true);
    }

    protected static int getEnumeratedAttribute(Node node, String string, String[] stringArray, int n2, boolean bl2) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl2) {
                return n2;
            }
            GIFMetadata.fatal(node, "Required attribute " + string + " not present!");
        }
        String string2 = node2.getNodeValue();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!string2.equals(stringArray[i2])) continue;
            return i2;
        }
        GIFMetadata.fatal(node, "Illegal value for attribute " + string + "!");
        return -1;
    }

    protected static int getEnumeratedAttribute(Node node, String string, String[] stringArray) throws IIOInvalidTreeException {
        return GIFMetadata.getEnumeratedAttribute(node, string, stringArray, -1, true);
    }

    protected static String getAttribute(Node node, String string, String string2, boolean bl2) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl2) {
                return string2;
            }
            GIFMetadata.fatal(node, "Required attribute " + string + " not present!");
        }
        return node2.getNodeValue();
    }

    protected static String getAttribute(Node node, String string) throws IIOInvalidTreeException {
        return GIFMetadata.getAttribute(node, string, null, true);
    }

    protected GIFMetadata(boolean bl2, String string, String string2, String[] stringArray, String[] stringArray2) {
        super(bl2, string, string2, stringArray, stringArray2);
    }

    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string.equals(this.nativeMetadataFormatName)) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    protected byte[] getColorTable(Node node, String string, boolean bl2, int n2) throws IIOInvalidTreeException {
        int n3;
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        int n4 = -1;
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            GIFMetadata.fatal(node, "Palette has no entries!");
        }
        while (node2 != null) {
            if (!node2.getNodeName().equals(string)) {
                GIFMetadata.fatal(node, "Only a " + string + " may be a child of a " + node2.getNodeName() + "!");
            }
            if ((n3 = GIFMetadata.getIntAttribute(node2, "index", true, 0, 255)) > n4) {
                n4 = n3;
            }
            byArray[n3] = (byte)GIFMetadata.getIntAttribute(node2, "red", true, 0, 255);
            byArray2[n3] = (byte)GIFMetadata.getIntAttribute(node2, "green", true, 0, 255);
            byArray3[n3] = (byte)GIFMetadata.getIntAttribute(node2, "blue", true, 0, 255);
            node2 = node2.getNextSibling();
        }
        n3 = n4 + 1;
        if (bl2 && n3 != n2) {
            GIFMetadata.fatal(node, "Unexpected length for palette!");
        }
        byte[] byArray4 = new byte[3 * n3];
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray4[n5++] = byArray[i2];
            byArray4[n5++] = byArray2[i2];
            byArray4[n5++] = byArray3[i2];
        }
        return byArray4;
    }

    protected abstract void mergeNativeTree(Node var1) throws IIOInvalidTreeException;

    protected abstract void mergeStandardTree(Node var1) throws IIOInvalidTreeException;
}

