/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.gif;

import com.sun.media.imageioimpl.plugins.gif.GIFStreamMetadata;
import javax.imageio.metadata.IIOInvalidTreeException;
import org.w3c.dom.Node;

class GIFWritableStreamMetadata
extends GIFStreamMetadata {
    static final String NATIVE_FORMAT_NAME = "javax_imageio_gif_stream_1.0";

    public GIFWritableStreamMetadata() {
        super(true, NATIVE_FORMAT_NAME, "com.sun.media.imageioimpl.plugins.gif.GIFStreamMetadataFormat", null, null);
        this.reset();
    }

    public boolean isReadOnly() {
        return false;
    }

    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string.equals(NATIVE_FORMAT_NAME)) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    public void reset() {
        this.version = null;
        this.logicalScreenWidth = -1;
        this.logicalScreenHeight = -1;
        this.colorResolution = -1;
        this.pixelAspectRatio = 0;
        this.backgroundColorIndex = 0;
        this.sortFlag = false;
        this.globalColorTable = null;
    }

    protected void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        Node node2 = node;
        if (!node2.getNodeName().equals(NATIVE_FORMAT_NAME)) {
            GIFWritableStreamMetadata.fatal(node2, "Root must be javax_imageio_gif_stream_1.0");
        }
        for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string = node2.getNodeName();
            if (string.equals("Version")) {
                this.version = GIFWritableStreamMetadata.getStringAttribute(node2, "value", null, true, versionStrings);
                continue;
            }
            if (string.equals("LogicalScreenDescriptor")) {
                this.logicalScreenWidth = GIFWritableStreamMetadata.getIntAttribute(node2, "logicalScreenWidth", -1, true, true, 1, 65535);
                this.logicalScreenHeight = GIFWritableStreamMetadata.getIntAttribute(node2, "logicalScreenHeight", -1, true, true, 1, 65535);
                this.colorResolution = GIFWritableStreamMetadata.getIntAttribute(node2, "colorResolution", -1, true, true, 1, 8);
                this.pixelAspectRatio = GIFWritableStreamMetadata.getIntAttribute(node2, "pixelAspectRatio", 0, true, true, 0, 255);
                continue;
            }
            if (string.equals("GlobalColorTable")) {
                int n2 = GIFWritableStreamMetadata.getIntAttribute(node2, "sizeOfGlobalColorTable", true, 2, 256);
                if (n2 != 2 && n2 != 4 && n2 != 8 && n2 != 16 && n2 != 32 && n2 != 64 && n2 != 128 && n2 != 256) {
                    GIFWritableStreamMetadata.fatal(node2, "Bad value for GlobalColorTable attribute sizeOfGlobalColorTable!");
                }
                this.backgroundColorIndex = GIFWritableStreamMetadata.getIntAttribute(node2, "backgroundColorIndex", 0, true, true, 0, 255);
                this.sortFlag = GIFWritableStreamMetadata.getBooleanAttribute(node2, "sortFlag", false, true);
                this.globalColorTable = this.getColorTable(node2, "ColorTableEntry", true, n2);
                continue;
            }
            GIFWritableStreamMetadata.fatal(node2, "Unknown child of root node!");
        }
    }

    protected void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        Node node2 = node;
        if (!node2.getNodeName().equals("javax_imageio_1.0")) {
            GIFWritableStreamMetadata.fatal(node2, "Root must be javax_imageio_1.0");
        }
        block0: for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            int n2;
            String string;
            Node node3;
            String string2 = node2.getNodeName();
            if (string2.equals("Chroma")) {
                for (node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    string = node3.getNodeName();
                    if (string.equals("Palette")) {
                        this.globalColorTable = this.getColorTable(node3, "PaletteEntry", false, -1);
                        continue;
                    }
                    if (!string.equals("BackgroundIndex")) continue;
                    this.backgroundColorIndex = GIFWritableStreamMetadata.getIntAttribute(node3, "value", -1, true, true, 0, 255);
                }
                continue;
            }
            if (string2.equals("Data")) {
                for (node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    string = node3.getNodeName();
                    if (!string.equals("BitsPerSample")) continue;
                    this.colorResolution = GIFWritableStreamMetadata.getIntAttribute(node3, "value", -1, true, true, 1, 8);
                    continue block0;
                }
                continue;
            }
            if (string2.equals("Dimension")) {
                for (node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    string = node3.getNodeName();
                    if (string.equals("PixelAspectRatio")) {
                        float f2 = GIFWritableStreamMetadata.getFloatAttribute(node3, "value");
                        if (f2 == 1.0f) {
                            this.pixelAspectRatio = 0;
                            continue;
                        }
                        n2 = (int)(f2 * 64.0f - 15.0f);
                        this.pixelAspectRatio = Math.max(Math.min(n2, 255), 0);
                        continue;
                    }
                    if (string.equals("HorizontalScreenSize")) {
                        this.logicalScreenWidth = GIFWritableStreamMetadata.getIntAttribute(node3, "value", -1, true, true, 1, 65535);
                        continue;
                    }
                    if (!string.equals("VerticalScreenSize")) continue;
                    this.logicalScreenHeight = GIFWritableStreamMetadata.getIntAttribute(node3, "value", -1, true, true, 1, 65535);
                }
                continue;
            }
            if (!string2.equals("Document")) continue;
            for (node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                string = node3.getNodeName();
                if (!string.equals("FormatVersion")) continue;
                String string3 = GIFWritableStreamMetadata.getStringAttribute(node3, "value", null, true, null);
                for (n2 = 0; n2 < versionStrings.length; ++n2) {
                    if (!string3.equals(versionStrings[n2])) continue;
                    this.version = string3;
                    continue block0;
                }
                continue block0;
            }
        }
    }

    public void setFromTree(String string, Node node) throws IIOInvalidTreeException {
        this.reset();
        this.mergeTree(string, node);
    }
}

