/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.common.InvertedCMYKColorSpace;
import com.sun.media.imageioimpl.plugins.clib.CLibImageReader;
import com.sun.media.imageioimpl.plugins.clib.InputStreamAdapter;
import com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGMetadata;
import com.sun.media.imageioimpl.plugins.jpeg.I18N;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.jpeg.Decoder;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

final class CLibJPEGImageReader
extends CLibImageReader {
    private static final boolean DEBUG = false;
    private mediaLibImage infoImage = null;
    private int infoImageIndex = -1;
    private byte[] iccProfileData = null;
    private IIOMetadata imageMetadata = null;
    private int imageMetadataIndex = -1;
    private HashMap imageTypes = new HashMap();
    private int bitDepth;

    CLibJPEGImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected final synchronized mediaLibImage decode(InputStream inputStream) throws IOException {
        mediaLibImage mediaLibImage2 = null;
        Decoder decoder = null;
        try {
            int n2;
            if (inputStream instanceof InputStreamAdapter) {
                ImageInputStream imageInputStream = ((InputStreamAdapter)inputStream).getWrappedStream();
                decoder = new Decoder(imageInputStream);
            } else {
                decoder = new Decoder(inputStream);
            }
            mediaLibImage2 = decoder.decode(null);
            this.iccProfileData = decoder.getEmbeddedICCProfile();
            if (this.iccProfileData != null && mediaLibImage2.getType() == 1 && ((n2 = mediaLibImage2.getFormat()) == 11 || n2 == 14)) {
                long l2 = System.currentTimeMillis();
                byte[] byArray = mediaLibImage2.getByteData();
                int n3 = byArray.length;
                for (int i2 = mediaLibImage2.getOffset(); i2 < n3; ++i2) {
                    byArray[i2] = (byte)(255 - byArray[i2] & 0xFF);
                }
            }
        }
        catch (Throwable throwable) {
            throw new IIOException("codecLib error", throwable);
        }
        if (mediaLibImage2 == null) {
            throw new IIOException(I18N.getString("CLibJPEGImageReader0"));
        }
        try {
            this.bitDepth = decoder.getDepth();
        }
        catch (Throwable throwable) {
            throw new IIOException("codecLib error", throwable);
        }
        decoder.dispose();
        return mediaLibImage2;
    }

    private synchronized mediaLibImage getInfoImage(int n2) throws IOException {
        if (this.infoImage == null || n2 != this.infoImageIndex) {
            if (n2 == this.getImageIndex()) {
                this.infoImage = this.getImage(n2);
                this.infoImageIndex = n2;
                return this.infoImage;
            }
            if (this.input == null) {
                throw new IllegalStateException("input == null");
            }
            ImageInputStream imageInputStream = null;
            if (!(this.input instanceof ImageInputStream)) {
                throw new IllegalArgumentException("!(input instanceof ImageInputStream)");
            }
            imageInputStream = (ImageInputStream)this.input;
            this.seekToImage(n2);
            imageInputStream.mark();
            Decoder decoder = null;
            try {
                decoder = new Decoder(imageInputStream);
                this.infoImage = decoder.getSize();
                this.iccProfileData = decoder.getEmbeddedICCProfile();
            }
            catch (Throwable throwable) {
                throw new IIOException("codecLib error", throwable);
            }
            if (this.infoImage == null || this.infoImage.getFormat() == 0 && (this.infoImage = this.getImage(n2)) == null) {
                throw new IIOException(I18N.getString("CLibJPEGImageReader0"));
            }
            this.infoImageIndex = n2;
            try {
                this.bitDepth = decoder.getDepth();
            }
            catch (Throwable throwable) {
                throw new IIOException("codecLib error", throwable);
            }
            imageInputStream.reset();
            decoder.dispose();
        }
        return this.infoImage;
    }

    public int getWidth(int n2) throws IOException {
        return this.getInfoImage(n2).getWidth();
    }

    public int getHeight(int n2) throws IOException {
        return this.getInfoImage(n2).getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getImageTypes(int n2) throws IOException {
        this.seekToImage(n2);
        ArrayList arrayList = null;
        HashMap hashMap = this.imageTypes;
        synchronized (hashMap) {
            Integer n3 = new Integer(n2);
            if (this.imageTypes.containsKey(n3)) {
                arrayList = (ArrayList)this.imageTypes.get(n3);
            } else {
                ColorSpace colorSpace;
                arrayList = new ArrayList();
                mediaLibImage mediaLibImage2 = this.getInfoImage(n2);
                if (this.iccProfileData != null) {
                    ICC_Profile iCC_Profile = ICC_Profile.getInstance(this.iccProfileData);
                    colorSpace = new ICC_ColorSpace(iCC_Profile);
                    arrayList.add(CLibJPEGImageReader.createImageType(mediaLibImage2, colorSpace, this.bitDepth, null, null, null, null));
                }
                colorSpace = mediaLibImage2.getFormat() == 11 ? InvertedCMYKColorSpace.getInstance() : null;
                arrayList.add(CLibJPEGImageReader.createImageType(mediaLibImage2, colorSpace, this.bitDepth, null, null, null, null));
            }
        }
        return arrayList.iterator();
    }

    public synchronized IIOMetadata getImageMetadata(int n2) throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("input == null");
        }
        if (this.imageMetadata == null || n2 != this.imageMetadataIndex) {
            this.seekToImage(n2);
            ImageInputStream imageInputStream = (ImageInputStream)this.input;
            long l2 = imageInputStream.getStreamPosition();
            try {
                this.imageMetadata = new CLibJPEGMetadata(imageInputStream);
                this.imageMetadataIndex = n2;
            }
            catch (IIOException iIOException) {
                throw iIOException;
            }
            finally {
                imageInputStream.seek(l2);
            }
        }
        return this.imageMetadata;
    }

    public boolean readerSupportsThumbnails() {
        return true;
    }

    public int getNumThumbnails(int n2) throws IOException {
        CLibJPEGMetadata cLibJPEGMetadata = (CLibJPEGMetadata)this.getImageMetadata(n2);
        return cLibJPEGMetadata.getNumThumbnails();
    }

    public BufferedImage readThumbnail(int n2, int n3) throws IOException {
        CLibJPEGMetadata cLibJPEGMetadata = (CLibJPEGMetadata)this.getImageMetadata(n2);
        return cLibJPEGMetadata.getThumbnail(n3);
    }

    protected void resetLocal() {
        this.infoImage = null;
        this.infoImageIndex = -1;
        this.iccProfileData = null;
        this.imageMetadata = null;
        this.imageMetadataIndex = -1;
        this.imageTypes.clear();
        super.resetLocal();
    }
}

