/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import java.awt.image.ColorModel;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChannelDefinitionBox
extends Box {
    private short num;
    private short[] channels;
    private short[] types;
    private short[] associations;

    private static int computeLength(ColorModel colorModel) {
        int n2 = colorModel.getComponentSize().length - 1;
        return 10 + (colorModel.isAlphaPremultiplied() ? n2 * 18 : n2 * 12);
    }

    public static void fillBasedOnBands(int n2, boolean bl2, short[] sArray, short[] sArray2, short[] sArray3) {
        int n3;
        int n4 = n2 * (bl2 ? 3 : 2);
        if (bl2) {
            for (n3 = n2 * 2; n3 < n4; ++n3) {
                sArray[n3] = (short)(n3 - n2 * 2);
                sArray2[n3] = 2;
                sArray3[n3] = (short)(n3 + 1 - n2 * 2);
            }
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n5 = n3 + n2;
            sArray[n3] = (short)n3;
            sArray2[n3] = 0;
            sArray3[n5] = sArray3[n3] = (short)(n3 + 1);
            sArray[n5] = (short)n2;
            sArray2[n5] = 1;
        }
    }

    public ChannelDefinitionBox(ColorModel colorModel) {
        super(ChannelDefinitionBox.computeLength(colorModel), 1667523942, null);
        short s2 = (short)(colorModel.getComponentSize().length - 1);
        this.num = (short)(s2 * (colorModel.isAlphaPremultiplied() ? 3 : 2));
        this.channels = new short[this.num];
        this.types = new short[this.num];
        this.associations = new short[this.num];
        ChannelDefinitionBox.fillBasedOnBands(s2, colorModel.isAlphaPremultiplied(), this.channels, this.types, this.associations);
    }

    public ChannelDefinitionBox(byte[] byArray) {
        super(8 + byArray.length, 1667523942, byArray);
    }

    public ChannelDefinitionBox(short[] sArray, short[] sArray2, short[] sArray3) {
        super(10 + sArray.length * 6, 1667523942, null);
        this.num = (short)sArray.length;
        this.channels = sArray;
        this.types = sArray2;
        this.associations = sArray3;
    }

    public ChannelDefinitionBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList nodeList = node.getChildNodes();
        int n2 = 0;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node2 = nodeList.item(i2);
            String string = node2.getNodeName();
            if ("NumberOfDefinition".equals(string)) {
                this.num = Box.getShortElementValue(node2);
            }
            if (!"Definitions".equals(string)) continue;
            this.channels = new short[this.num];
            this.types = new short[this.num];
            this.associations = new short[this.num];
            NodeList nodeList2 = node2.getChildNodes();
            for (int i3 = 0; i3 < nodeList2.getLength(); ++i3) {
                node2 = nodeList2.item(i3);
                string = node2.getNodeName();
                if ("ChannelNumber".equals(string)) {
                    this.channels[n2] = Box.getShortElementValue(node2);
                }
                if ("ChannelType".equals(string)) {
                    this.types[n2] = Box.getShortElementValue(node2);
                }
                if (!"Association".equals(string)) continue;
                this.associations[n2++] = Box.getShortElementValue(node2);
            }
        }
    }

    protected void parse(byte[] byArray) {
        this.num = (short)(byArray[0] << 8 | byArray[1]);
        this.channels = new short[this.num];
        this.types = new short[this.num];
        this.associations = new short[this.num];
        int n2 = 2;
        for (int i2 = 0; i2 < this.num; ++i2) {
            this.channels[i2] = (short)(((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
            this.types[i2] = (short)(((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
            this.associations[i2] = (short)(((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
        }
    }

    public short[] getChannel() {
        return this.channels;
    }

    public short[] getTypes() {
        return this.types;
    }

    public short[] getAssociation() {
        return this.associations;
    }

    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(Box.getName(this.getType()));
        this.setDefaultAttributes(iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("NumberOfDefinition");
        iIOMetadataNode2.setUserObject(new Short(this.num));
        iIOMetadataNode2.setNodeValue("" + this.num);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("Definitions");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        for (int i2 = 0; i2 < this.num; ++i2) {
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("ChannelNumber");
            iIOMetadataNode3.setUserObject(new Short(this.channels[i2]));
            iIOMetadataNode3.setNodeValue("" + this.channels[i2]);
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode3 = new IIOMetadataNode("ChannelType");
            iIOMetadataNode3.setUserObject(new Short(this.types[i2]));
            iIOMetadataNode3.setNodeValue("" + this.types[i2]);
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode3 = new IIOMetadataNode("Association");
            iIOMetadataNode3.setUserObject(new Short(this.associations[i2]));
            iIOMetadataNode3.setNodeValue("" + this.associations[i2]);
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        }
        return iIOMetadataNode;
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        int n2 = this.num * 6 + 2;
        this.data = new byte[n2];
        this.data[0] = (byte)(this.num >> 8);
        this.data[1] = (byte)(this.num & 0xFF);
        int n3 = 2;
        for (int i2 = 0; i2 < this.num; ++i2) {
            this.data[n3++] = (byte)(this.channels[i2] >> 8);
            this.data[n3++] = (byte)(this.channels[i2] & 0xFF);
            this.data[n3++] = (byte)(this.types[i2] >> 8);
            this.data[n3++] = (byte)(this.types[i2] & 0xFF);
            this.data[n3++] = (byte)(this.associations[i2] >> 8);
            this.data[n3++] = (byte)(this.associations[i2] & 0xFF);
        }
    }
}

