/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import java.awt.color.ICC_Profile;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ColorSpecificationBox
extends Box {
    public static final int ECS_sRGB = 16;
    public static final int ECS_GRAY = 17;
    public static final int ECS_YCC = 18;
    private static String[] elementNames = new String[]{"Method", "Precedence", "ApproximationAccuracy", "EnumeratedColorSpace", "ICCProfile"};
    private byte method;
    private byte precedence;
    private byte approximation;
    private int ecs;
    private ICC_Profile profile;

    public static String[] getElementNames() {
        return elementNames;
    }

    private static int computeLength(byte by2, ICC_Profile iCC_Profile) {
        int n2 = 15;
        if (by2 == 2 && iCC_Profile != null) {
            n2 += iCC_Profile.getData().length;
        }
        return n2;
    }

    public ColorSpecificationBox(byte by2, byte by3, byte by4, int n2, ICC_Profile iCC_Profile) {
        super(ColorSpecificationBox.computeLength(by2, iCC_Profile), 1668246642, null);
        this.method = by2;
        this.precedence = by3;
        this.approximation = by4;
        this.ecs = n2;
        this.profile = iCC_Profile;
    }

    public ColorSpecificationBox(byte[] byArray) {
        super(8 + byArray.length, 1668246642, byArray);
    }

    public ColorSpecificationBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node2 = nodeList.item(i2);
            String string = node2.getNodeName();
            if ("Method".equals(string)) {
                this.method = Box.getByteElementValue(node2);
            }
            if ("Precedence".equals(string)) {
                this.precedence = Box.getByteElementValue(node2);
            }
            if ("ApproximationAccuracy".equals(string)) {
                this.approximation = Box.getByteElementValue(node2);
            }
            if ("EnumeratedColorSpace".equals(string)) {
                this.ecs = Box.getIntElementValue(node2);
            }
            if (!"ICCProfile".equals(string)) continue;
            if (node2 instanceof IIOMetadataNode) {
                this.profile = (ICC_Profile)((IIOMetadataNode)node2).getUserObject();
                continue;
            }
            String string2 = node.getNodeValue();
            if (string2 == null) continue;
            this.profile = ICC_Profile.getInstance(Box.parseByteArray(string2));
        }
    }

    public byte getMethod() {
        return this.method;
    }

    public byte getPrecedence() {
        return this.precedence;
    }

    public byte getApproximationAccuracy() {
        return this.approximation;
    }

    public int getEnumeratedColorSpace() {
        return this.ecs;
    }

    public ICC_Profile getICCProfile() {
        return this.profile;
    }

    public IIOMetadataNode getNativeNode() {
        return this.getNativeNodeForSimpleBox();
    }

    protected void parse(byte[] byArray) {
        this.method = byArray[0];
        this.precedence = byArray[1];
        this.approximation = byArray[2];
        if (this.method == 2) {
            byte[] byArray2 = new byte[byArray.length - 3];
            System.arraycopy(byArray, 3, byArray2, 0, byArray.length - 3);
            this.profile = ICC_Profile.getInstance(byArray2);
        } else {
            this.ecs = (byArray[3] & 0xFF) << 24 | (byArray[4] & 0xFF) << 16 | (byArray[5] & 0xFF) << 8 | byArray[6] & 0xFF;
        }
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        int n2 = 7;
        byte[] byArray = null;
        if (this.profile != null) {
            byArray = this.profile.getData();
            n2 += byArray.length;
        }
        this.data = new byte[n2];
        this.data[0] = this.method;
        this.data[1] = this.precedence;
        this.data[2] = this.approximation;
        ColorSpecificationBox.copyInt(this.data, 3, this.ecs);
        if (this.profile != null) {
            System.arraycopy(byArray, 0, this.data, 7, n2 - 7);
        }
    }
}

