/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentMappingBox
extends Box {
    private short[] components;
    private byte[] type;
    private byte[] map;

    public ComponentMappingBox(byte[] byArray) {
        super(8 + byArray.length, 1668112752, byArray);
    }

    public ComponentMappingBox(short[] sArray, byte[] byArray, byte[] byArray2) {
        super(8 + (sArray.length << 2), 1668112752, null);
        this.components = sArray;
        this.type = byArray;
        this.map = byArray2;
    }

    public ComponentMappingBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength() / 3;
        this.components = new short[n2];
        this.type = new byte[n2];
        this.map = new byte[n2];
        n2 *= 3;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = nodeList.item(i2);
            String string = node2.getNodeName();
            if ("Component".equals(string)) {
                this.components[n3] = Box.getShortElementValue(node2);
            }
            if ("ComponentType".equals(string)) {
                this.type[n3] = Box.getByteElementValue(node2);
            }
            if (!"ComponentAssociation".equals(string)) continue;
            this.map[n3++] = Box.getByteElementValue(node2);
        }
    }

    protected void parse(byte[] byArray) {
        int n2 = byArray.length / 4;
        this.components = new short[n2];
        this.type = new byte[n2];
        this.map = new byte[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.components[i2] = (short)((byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF);
            this.type[i2] = byArray[n3++];
            this.map[i2] = byArray[n3++];
        }
    }

    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(Box.getName(this.getType()));
        this.setDefaultAttributes(iIOMetadataNode);
        for (int i2 = 0; i2 < this.components.length; ++i2) {
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Component");
            Short s2 = new Short(this.components[i2]);
            iIOMetadataNode2.setUserObject(new Short(this.components[i2]));
            iIOMetadataNode2.setNodeValue("" + this.components[i2]);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("ComponentType");
            iIOMetadataNode2.setUserObject(new Byte(this.type[i2]));
            iIOMetadataNode2.setNodeValue("" + this.type[i2]);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("ComponentAssociation");
            iIOMetadataNode2.setUserObject(new Byte(this.map[i2]));
            iIOMetadataNode2.setNodeValue("" + this.map[i2]);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public short[] getComponent() {
        return this.components;
    }

    public byte[] getComponentType() {
        return this.type;
    }

    public byte[] getComponentAssociation() {
        return this.map;
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[this.type.length << 2];
        int n2 = 0;
        for (int i2 = 0; i2 < this.type.length; ++i2) {
            this.data[n2++] = (byte)(this.components[i2] >> 8);
            this.data[n2++] = (byte)(this.components[i2] & 0xFF);
            this.data[n2++] = this.type[i2];
            this.data[n2++] = this.map[i2];
        }
    }
}

