/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileTypeBox
extends Box {
    private static String[] elementNames = new String[]{"Brand", "MinorVersion", "CompatibilityList"};
    private int brand;
    private int minorVersion;
    private int[] compatibility;

    public static String[] getElementNames() {
        return elementNames;
    }

    public FileTypeBox(int n2, int n3, int[] nArray) {
        super(16 + (nArray == null ? 0 : nArray.length << 2), 1718909296, null);
        this.brand = n2;
        this.minorVersion = n3;
        this.compatibility = nArray;
    }

    public FileTypeBox(byte[] byArray) {
        super(8 + byArray.length, 1718909296, byArray);
    }

    public FileTypeBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node2 = nodeList.item(i2);
            String string = node2.getNodeName();
            if ("Brand".equals(string)) {
                this.brand = Box.getIntElementValue(node2);
            }
            if ("MinorVersion".equals(string)) {
                this.minorVersion = Box.getIntElementValue(node2);
            }
            if (!"CompatibilityList".equals(string)) continue;
            this.compatibility = Box.getIntArrayElementValue(node2);
        }
    }

    public int getBrand() {
        return this.brand;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int[] getCompatibilityList() {
        return this.compatibility;
    }

    public IIOMetadataNode getNativeNode() {
        return this.getNativeNodeForSimpleBox();
    }

    protected void parse(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.brand = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        this.minorVersion = (byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        int n2 = (byArray.length - 8) / 4;
        if (n2 > 0) {
            this.compatibility = new int[n2];
            int n3 = 0;
            int n4 = 8;
            while (n3 < n2) {
                this.compatibility[n3] = (byArray[n4] & 0xFF) << 24 | (byArray[n4 + 1] & 0xFF) << 16 | (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 3] & 0xFF;
                ++n3;
                n4 += 4;
            }
        }
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[8 + (this.compatibility != null ? this.compatibility.length << 2 : 0)];
        FileTypeBox.copyInt(this.data, 0, this.brand);
        FileTypeBox.copyInt(this.data, 4, this.minorVersion);
        if (this.compatibility != null) {
            int n2 = 0;
            int n3 = 8;
            while (n2 < this.compatibility.length) {
                FileTypeBox.copyInt(this.data, n3, this.compatibility[n2]);
                ++n2;
                n3 += 4;
            }
        }
    }
}

