/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageReadParam;
import com.sun.media.imageioimpl.common.SimpleRenderedImage;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KRenderedImageCodecLib;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class J2KImageReaderCodecLib
extends ImageReader {
    private ImageInputStream iis = null;
    private long streamPosition0;
    private boolean gotHeader = false;
    private int width = -1;
    private int height = -1;
    private int tileWidth = -1;
    private int tileHeight = -1;
    private int tileGridXOffset = 0;
    private int tileGridYOffset = 0;
    private J2KMetadata imageMetadata = null;
    SimpleRenderedImage image = null;

    public void processImageUpdateWrapper(BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        this.processImageUpdate(bufferedImage, n2, n3, n4, n5, n6, n7, nArray);
    }

    public void processImageProgressWrapper(float f2) {
        this.processImageProgress(f2);
    }

    public J2KImageReaderCodecLib(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public void setInput(Object object, boolean bl2, boolean bl3) {
        super.setInput(object, bl2, bl3);
        this.ignoreMetadata = bl3;
        this.iis = (ImageInputStream)object;
        this.iis.mark();
        this.imageMetadata = null;
        try {
            this.streamPosition0 = this.iis.getStreamPosition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ImageReadParam getDefaultReadParam() {
        return new J2KImageReadParam();
    }

    public int getNumImages(boolean bl2) throws IOException {
        if (this.input == null) {
            throw new IllegalStateException(I18N.getString("J2KImageReader6"));
        }
        if (this.seekForwardOnly) {
            throw new IllegalStateException(I18N.getString("J2KImageReader7"));
        }
        return 1;
    }

    public Iterator getImageTypes(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        if (this.image != null) {
            ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
            arrayList.add(new ImageTypeSpecifier(this.image.getColorModel(), this.image.getSampleModel()));
            return arrayList.iterator();
        }
        return null;
    }

    public int getWidth(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        return this.width;
    }

    public int getHeight(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        return this.height;
    }

    public int getTileGridXOffset(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        return this.tileGridXOffset;
    }

    public int getTileGridYOffset(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        return this.tileGridYOffset;
    }

    public int getTileWidth(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        return this.tileWidth;
    }

    public int getTileHeight(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        return this.tileHeight;
    }

    public boolean isImageTiled(int n2) throws IOException {
        int n3 = this.getWidth(n2);
        int n4 = this.getTileWidth(n2);
        if (n4 > 0 && (n3 + n4 - 1) / n4 > 1) {
            return true;
        }
        int n5 = this.getHeight(n2);
        int n6 = this.getTileHeight(n2);
        return n6 > 0 && (n5 + n6 - 1) / n6 > 1;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public IIOMetadata getImageMetadata(int n2) throws IOException {
        if (this.ignoreMetadata) {
            return null;
        }
        this.checkIndex(n2);
        if (this.imageMetadata == null) {
            try {
                this.iis.reset();
                this.iis.mark();
                if (this.image == null || !(this.image instanceof J2KRenderedImageCodecLib)) {
                    this.image = new J2KRenderedImageCodecLib(this.iis, this, null);
                }
                this.imageMetadata = ((J2KRenderedImageCodecLib)this.image).readImageMetadata();
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            finally {
                this.iis.reset();
                this.iis.mark();
            }
        }
        return this.imageMetadata;
    }

    public boolean isRandomAccessEasy(int n2) throws IOException {
        return true;
    }

    public RenderedImage readAsRenderedImage(int n2, ImageReadParam imageReadParam) throws IOException {
        this.checkIndex(n2);
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        if (imageReadParam instanceof J2KImageReadParam && ((J2KImageReadParam)imageReadParam).getResolution() >= 0) {
            J2KImageReader j2KImageReader = new J2KImageReader(null);
            this.iis.seek(this.streamPosition0);
            j2KImageReader.setInput(this.iis);
            this.image = (SimpleRenderedImage)((ImageReader)j2KImageReader).readAsRenderedImage(n2, imageReadParam);
        } else {
            this.image = new J2KRenderedImageCodecLib(this.iis, this, imageReadParam);
        }
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return this.image;
    }

    public BufferedImage read(int n2, ImageReadParam imageReadParam) throws IOException {
        WritableRaster writableRaster;
        this.checkIndex(n2);
        this.clearAbortRequest();
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        this.processImageStarted(n2);
        if (imageReadParam instanceof J2KImageReadParam && ((J2KImageReadParam)imageReadParam).getResolution() >= 0) {
            J2KImageReader j2KImageReader = new J2KImageReader(null);
            this.iis.seek(this.streamPosition0);
            j2KImageReader.setInput(this.iis);
            if (this.abortRequested()) {
                this.processReadAborted();
            } else {
                this.processImageComplete();
            }
            return ((ImageReader)j2KImageReader).read(n2, imageReadParam);
        }
        BufferedImage bufferedImage = imageReadParam.getDestination();
        this.iis.reset();
        this.iis.mark();
        this.image = new J2KRenderedImageCodecLib(this.iis, this, imageReadParam);
        J2KRenderedImageCodecLib j2KRenderedImageCodecLib = (J2KRenderedImageCodecLib)this.image;
        Point point = imageReadParam.getDestinationOffset();
        if (bufferedImage == null) {
            ColorModel colorModel = j2KRenderedImageCodecLib.getColorModel();
            SampleModel sampleModel = j2KRenderedImageCodecLib.getSampleModel();
            ImageTypeSpecifier imageTypeSpecifier = imageReadParam.getDestinationType();
            if (imageTypeSpecifier != null) {
                colorModel = imageTypeSpecifier.getColorModel();
            }
            writableRaster = Raster.createWritableRaster(sampleModel.createCompatibleSampleModel(j2KRenderedImageCodecLib.getMinX() + j2KRenderedImageCodecLib.getWidth(), j2KRenderedImageCodecLib.getMinY() + j2KRenderedImageCodecLib.getHeight()), new Point(0, 0));
            bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel != null ? colorModel.isAlphaPremultiplied() : false, new Hashtable());
        } else {
            writableRaster = bufferedImage.getWritableTile(0, 0);
        }
        j2KRenderedImageCodecLib.setDestImage(bufferedImage);
        j2KRenderedImageCodecLib.readAsRaster(writableRaster);
        j2KRenderedImageCodecLib.clearDestImage();
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return bufferedImage;
    }

    public Raster readRaster(int n2, ImageReadParam imageReadParam) throws IOException {
        BufferedImage bufferedImage = this.read(n2, imageReadParam);
        return bufferedImage.getWritableTile(0, 0);
    }

    public void readHeader() throws IOException {
        if (this.gotHeader) {
            return;
        }
        try {
            this.iis.reset();
            this.iis.mark();
            if (this.image == null) {
                this.image = new J2KRenderedImageCodecLib(this.iis, this, null);
            }
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
            this.tileWidth = this.image.getTileWidth();
            this.tileHeight = this.image.getTileHeight();
            this.tileGridXOffset = this.image.getTileGridXOffset();
            this.tileGridYOffset = this.image.getTileGridYOffset();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        finally {
            this.iis.reset();
            this.iis.mark();
        }
        this.gotHeader = true;
    }

    private void checkIndex(int n2) {
        if (this.input == null) {
            throw new IllegalStateException(I18N.getString("J2KImageReader6"));
        }
        if (n2 != 0) {
            throw new IndexOutOfBoundsException(I18N.getString("J2KImageReader4"));
        }
    }

    public boolean getAbortRequest() {
        return this.abortRequested();
    }

    public void reset() {
        super.reset();
        this.iis = null;
        this.gotHeader = false;
        this.width = -1;
        this.height = -1;
        this.tileWidth = -1;
        this.tileHeight = -1;
        this.tileGridXOffset = 0;
        this.tileGridYOffset = 0;
        this.imageMetadata = null;
        this.image = null;
    }
}

