/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageWriteParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.RenderedImageSrc;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import jj2000.j2k.StringSpec;
import jj2000.j2k.codestream.writer.CodestreamWriter;
import jj2000.j2k.codestream.writer.FileCodestreamWriter;
import jj2000.j2k.codestream.writer.HeaderEncoder;
import jj2000.j2k.entropy.CBlkSizeSpec;
import jj2000.j2k.entropy.PrecinctSizeSpec;
import jj2000.j2k.entropy.encoder.CodedCBlkDataSrcEnc;
import jj2000.j2k.entropy.encoder.EntropyCoder;
import jj2000.j2k.entropy.encoder.PostCompRateAllocator;
import jj2000.j2k.fileformat.writer.FileFormatWriter;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.ImgData;
import jj2000.j2k.image.ImgDataConverter;
import jj2000.j2k.image.Tiler;
import jj2000.j2k.image.forwcomptransf.ForwCompTransf;
import jj2000.j2k.quantization.quantizer.CBlkQuantDataSrcEnc;
import jj2000.j2k.quantization.quantizer.Quantizer;
import jj2000.j2k.roi.encoder.ROIScaler;
import jj2000.j2k.util.CodestreamManipulator;
import jj2000.j2k.wavelet.analysis.CBlkWTDataSrc;
import jj2000.j2k.wavelet.analysis.ForwardWT;

public class J2KImageWriter
extends ImageWriter {
    public static String WRITE_ABORTED = "Write aborted.";
    private ImageOutputStream stream = null;

    public void processImageProgressWrapper(float f2) {
        this.processImageProgress(f2);
    }

    public J2KImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("J2KImageWriter0"));
            }
            this.stream = (ImageOutputStream)object;
        } else {
            this.stream = null;
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new J2KImageWriteParam();
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return new J2KMetadata(imageTypeSpecifier, imageWriteParam, this);
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        if (iIOMetadata instanceof J2KMetadata) {
            return (IIOMetadata)((J2KMetadata)iIOMetadata).clone();
        }
        try {
            J2KMetadata j2KMetadata = new J2KMetadata();
            List<String> list = Arrays.asList(iIOMetadata.getMetadataFormatNames());
            String string = null;
            if (list.contains("com_sun_media_imageio_plugins_jpeg2000_image_1.0")) {
                string = "com_sun_media_imageio_plugins_jpeg2000_image_1.0";
            } else if (iIOMetadata.isStandardMetadataFormatSupported()) {
                string = "javax_imageio_1.0";
            }
            if (string != null) {
                j2KMetadata.setFromTree(string, iIOMetadata.getAsTree(string));
                return j2KMetadata;
            }
        }
        catch (IIOInvalidTreeException iIOInvalidTreeException) {
            return null;
        }
        return null;
    }

    public boolean canWriteRasters() {
        return true;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        IIOMetadata iIOMetadata2;
        Object object;
        ColorModel colorModel;
        int n2;
        J2KImageWriteParamJava j2KImageWriteParamJava;
        if (this.stream == null) {
            throw new IllegalStateException(I18N.getString("J2KImageWriter7"));
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter8"));
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        RenderedImage renderedImage = null;
        boolean bl2 = iIOImage.hasRaster();
        Raster raster = null;
        SampleModel sampleModel = null;
        if (bl2) {
            raster = iIOImage.getRaster();
            sampleModel = raster.getSampleModel();
        } else {
            renderedImage = iIOImage.getRenderedImage();
            sampleModel = renderedImage.getSampleModel();
        }
        this.checkSampleModel(sampleModel);
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        }
        if ((j2KImageWriteParamJava = new J2KImageWriteParamJava(iIOImage, imageWriteParam)).getPackPacketHeaderInTile() && j2KImageWriteParamJava.getPackPacketHeaderInMain()) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter1"));
        }
        if (j2KImageWriteParamJava.getLossless() && j2KImageWriteParamJava.getEncodingRate() != Double.MAX_VALUE) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter2"));
        }
        if (!bl2 && renderedImage.getColorModel() instanceof IndexColorModel || bl2 && raster.getSampleModel() instanceof MultiPixelPackedSampleModel) {
            j2KImageWriteParamJava.setDecompositionLevel("0");
            j2KImageWriteParamJava.setLossless(true);
            j2KImageWriteParamJava.setEncodingRate(Double.MAX_VALUE);
            j2KImageWriteParamJava.setQuantizationType("reversible");
            j2KImageWriteParamJava.setFilters("w5x3");
        } else if (j2KImageWriteParamJava.getEncodingRate() == Double.MAX_VALUE) {
            j2KImageWriteParamJava.setLossless(true);
            j2KImageWriteParamJava.setQuantizationType("reversible");
            j2KImageWriteParamJava.setFilters("w5x3");
        }
        boolean bl3 = j2KImageWriteParamJava.getPackPacketHeaderInTile();
        boolean bl4 = j2KImageWriteParamJava.getPackPacketHeaderInMain();
        boolean bl5 = false;
        boolean bl6 = false;
        int[] nArray = imageWriteParam.getSourceBands();
        int n3 = sampleModel.getNumBands();
        if (nArray != null) {
            n3 = nArray.length;
        }
        RenderedImageSrc renderedImageSrc = null;
        renderedImageSrc = bl2 ? new RenderedImageSrc(raster, j2KImageWriteParamJava, this) : new RenderedImageSrc(renderedImage, j2KImageWriteParamJava, this);
        boolean[] blArray = new boolean[n3];
        if (nArray != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                blArray[n2] = renderedImageSrc.isOrigSigned(nArray[n2]);
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                blArray[n2] = renderedImageSrc.isOrigSigned(n2);
            }
        }
        n2 = j2KImageWriteParamJava.getTileWidth();
        int n4 = j2KImageWriteParamJava.getTileHeight();
        int n5 = j2KImageWriteParamJava.getMinX();
        int n6 = j2KImageWriteParamJava.getMinY();
        if (n5 < 0 || n6 < 0) {
            throw new IIOException(I18N.getString("J2KImageWriter3"));
        }
        int n7 = j2KImageWriteParamJava.getTileGridXOffset();
        int n8 = j2KImageWriteParamJava.getTileGridYOffset();
        if (n7 < 0 || n8 < 0 || n7 > n5 || n8 > n6) {
            throw new IIOException(I18N.getString("J2KImageWriter4"));
        }
        Tiler tiler = new Tiler((BlkImgDataSrc)renderedImageSrc, n5, n6, n7, n8, n2, n4);
        ForwCompTransf forwCompTransf = new ForwCompTransf((BlkImgDataSrc)tiler, j2KImageWriteParamJava);
        ImgDataConverter imgDataConverter = new ImgDataConverter((BlkImgDataSrc)forwCompTransf);
        ForwardWT forwardWT = ForwardWT.createInstance((BlkImgDataSrc)imgDataConverter, (J2KImageWriteParamJava)j2KImageWriteParamJava);
        Quantizer quantizer = Quantizer.createInstance((CBlkWTDataSrc)forwardWT, (J2KImageWriteParamJava)j2KImageWriteParamJava);
        ROIScaler rOIScaler = ROIScaler.createInstance((Quantizer)quantizer, (J2KImageWriteParamJava)j2KImageWriteParamJava);
        EntropyCoder entropyCoder = EntropyCoder.createInstance((CBlkQuantDataSrcEnc)rOIScaler, (J2KImageWriteParamJava)j2KImageWriteParamJava, (CBlkSizeSpec)j2KImageWriteParamJava.getCodeBlockSize(), (PrecinctSizeSpec)j2KImageWriteParamJava.getPrecinctPartition(), (StringSpec)j2KImageWriteParamJava.getBypass(), (StringSpec)j2KImageWriteParamJava.getResetMQ(), (StringSpec)j2KImageWriteParamJava.getTerminateOnByte(), (StringSpec)j2KImageWriteParamJava.getCausalCXInfo(), (StringSpec)j2KImageWriteParamJava.getCodeSegSymbol(), (StringSpec)j2KImageWriteParamJava.getMethodForMQLengthCalc(), (StringSpec)j2KImageWriteParamJava.getMethodForMQTermination());
        File file = File.createTempFile("jiio-", ".tmp");
        file.deleteOnExit();
        FileCodestreamWriter fileCodestreamWriter = new FileCodestreamWriter(file, Integer.MAX_VALUE);
        float f2 = (float)j2KImageWriteParamJava.getEncodingRate();
        PostCompRateAllocator postCompRateAllocator = PostCompRateAllocator.createInstance((CodedCBlkDataSrcEnc)entropyCoder, (float)f2, (CodestreamWriter)fileCodestreamWriter, (J2KImageWriteParamJava)j2KImageWriteParamJava);
        HeaderEncoder headerEncoder = new HeaderEncoder((ImgData)renderedImageSrc, blArray, forwardWT, tiler, j2KImageWriteParamJava, rOIScaler, postCompRateAllocator);
        postCompRateAllocator.setHeaderEncoder(headerEncoder);
        headerEncoder.encodeMainHeader();
        try {
            postCompRateAllocator.initialize();
        }
        catch (RuntimeException runtimeException) {
            if (WRITE_ABORTED.equals(runtimeException.getMessage())) {
                fileCodestreamWriter.close();
                file.delete();
                this.processWriteAborted();
                return;
            }
            throw runtimeException;
        }
        headerEncoder.reset();
        headerEncoder.encodeMainHeader();
        fileCodestreamWriter.commitBitstreamHeader(headerEncoder);
        postCompRateAllocator.runAndWrite();
        fileCodestreamWriter.close();
        int n9 = fileCodestreamWriter.getLength();
        int n10 = j2KImageWriteParamJava.getPacketPerTilePart();
        int n11 = tiler.getNumTiles();
        if (n10 > 0 || bl3 || bl4) {
            CodestreamManipulator codestreamManipulator = new CodestreamManipulator(file, n11, n10, bl4, bl3, bl5, bl6);
            n9 += codestreamManipulator.doCodestreamManipulation();
        }
        int n12 = renderedImageSrc.getNumComps();
        int[] nArray2 = new int[n12];
        for (int i2 = 0; i2 < n12; ++i2) {
            nArray2[i2] = renderedImageSrc.getNomRangeBits(i2);
        }
        ColorModel colorModel2 = colorModel = renderedImage != null ? renderedImage.getColorModel() : null;
        if (nArray != null && (object = imageWriteParam.getDestinationType()) != null) {
            colorModel = ((ImageTypeSpecifier)object).getColorModel();
        }
        if (colorModel == null) {
            colorModel = ImageUtil.createColorModel(sampleModel);
        }
        object = null;
        if (imageWriteParam instanceof J2KImageWriteParam && !((J2KImageWriteParam)imageWriteParam).getWriteCodeStreamOnly()) {
            iIOMetadata2 = iIOImage.getMetadata();
            J2KMetadata j2KMetadata = new J2KMetadata(colorModel, sampleModel, renderedImageSrc.getImgWidth(), renderedImageSrc.getImgHeight(), imageWriteParam, this);
            if (iIOMetadata2 == null) {
                object = j2KMetadata;
            } else {
                if (colorModel != null) {
                    ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
                    object = (J2KMetadata)this.convertImageMetadata(iIOMetadata2, imageTypeSpecifier, imageWriteParam);
                } else {
                    String string = null;
                    List<String> list = Arrays.asList(iIOMetadata2.getMetadataFormatNames());
                    if (list.contains("com_sun_media_imageio_plugins_jpeg2000_image_1.0")) {
                        string = "com_sun_media_imageio_plugins_jpeg2000_image_1.0";
                    } else if (iIOMetadata2.isStandardMetadataFormatSupported()) {
                        string = "javax_imageio_1.0";
                    }
                    object = new J2KMetadata();
                    if (string != null) {
                        ((J2KMetadata)object).setFromTree(string, iIOMetadata2.getAsTree(string));
                    }
                }
                ((J2KMetadata)object).mergeTree("com_sun_media_imageio_plugins_jpeg2000_image_1.0", j2KMetadata.getAsTree("com_sun_media_imageio_plugins_jpeg2000_image_1.0"));
            }
        }
        iIOMetadata2 = new FileFormatWriter(file, this.stream, renderedImageSrc.getImgHeight(), renderedImageSrc.getImgWidth(), n12, nArray2, n9, colorModel, sampleModel, (J2KMetadata)object);
        n9 += iIOMetadata2.writeFileFormat();
        file.delete();
        this.processImageComplete();
    }

    public synchronized void abort() {
        super.abort();
    }

    public void reset() {
        super.reset();
        this.stream = null;
    }

    public boolean getAbortRequest() {
        return this.abortRequested();
    }

    private void checkSampleModel(SampleModel sampleModel) {
        int n2 = sampleModel.getDataType();
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter5"));
        }
        if (sampleModel.getNumBands() > 16384) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter6"));
        }
    }
}

