/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.ChannelDefinitionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.IISRandomAccessIO;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.decoder.CodedCBlkDataSrcDec;
import jj2000.j2k.entropy.decoder.EntropyDecoder;
import jj2000.j2k.fileformat.reader.FileFormatReader;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.ImgDataConverter;
import jj2000.j2k.image.invcomptransf.InvCompTransf;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.CBlkQuantDataSrcDec;
import jj2000.j2k.quantization.dequantizer.Dequantizer;
import jj2000.j2k.roi.ROIDeScaler;
import jj2000.j2k.wavelet.synthesis.CBlkWTDataSrcDec;
import jj2000.j2k.wavelet.synthesis.InverseWT;

public class J2KReadState {
    private ImageInputStream iis = null;
    private FileFormatReader ff;
    private HeaderInfo hi;
    private HeaderDecoder hd;
    private RandomAccessIO in;
    private BitstreamReaderAgent breader;
    private EntropyDecoder entdec;
    private ROIDeScaler roids;
    private Dequantizer deq;
    private InverseWT invWT;
    private InvCompTransf ictransf;
    private ImgDataConverter converter;
    private ImgDataConverter converter2;
    private DecoderSpecs decSpec = null;
    private J2KImageReadParamJava j2krparam = null;
    private int[] destinationBands = null;
    private int[] sourceBands = null;
    private int[] levelShift = null;
    private int[] minValues = null;
    private int[] maxValues = null;
    private int[] fracBits = null;
    private DataBlkInt[] dataBlocks = null;
    private int[] bandOffsets = null;
    private int maxDepth = 0;
    private boolean isSigned = false;
    private ColorModel colorModel = null;
    private SampleModel sampleModel = null;
    private int nComp = 0;
    private int tileWidth = 0;
    private int tileHeight = 0;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private Rectangle destinationRegion = null;
    private Point sourceOrigin;
    private int tileXOffset;
    private int tileYOffset;
    private int width;
    private int height;
    private int[] pixbuf = null;
    private byte[] bytebuf = null;
    private int[] channelMap = null;
    private boolean noTransform = true;
    private int resolution;
    private int stepX;
    private int stepY;
    private int tileStepX;
    private int tileStepY;
    private J2KMetadata metadata;
    private BufferedImage destImage;
    private J2KImageReader reader;

    public J2KReadState(ImageInputStream imageInputStream, J2KImageReadParamJava j2KImageReadParamJava, J2KMetadata j2KMetadata, J2KImageReader j2KImageReader) {
        if (imageInputStream == null || j2KImageReadParamJava == null || j2KMetadata == null) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState0"));
        }
        this.iis = imageInputStream;
        this.j2krparam = j2KImageReadParamJava;
        this.metadata = j2KMetadata;
        this.reader = j2KImageReader;
        this.initializeRead(0, j2KImageReadParamJava, j2KMetadata);
    }

    public J2KReadState(ImageInputStream imageInputStream, J2KImageReadParamJava j2KImageReadParamJava, J2KImageReader j2KImageReader) {
        if (imageInputStream == null || j2KImageReadParamJava == null) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState0"));
        }
        this.iis = imageInputStream;
        this.j2krparam = j2KImageReadParamJava;
        this.reader = j2KImageReader;
        this.initializeRead(0, j2KImageReadParamJava, null);
    }

    public int getWidth() throws IOException {
        return this.width;
    }

    public int getHeight() throws IOException {
        return this.height;
    }

    public HeaderDecoder getHeader() {
        return this.hd;
    }

    public Raster getTile(int n2, int n3, WritableRaster writableRaster) throws IOException {
        Point point = this.ictransf.getNumTiles(null);
        if (this.noTransform) {
            int n4;
            int n5;
            int n6;
            int n7;
            if (n2 >= point.x || n3 >= point.y) {
                throw new IllegalArgumentException(I18N.getString("J2KImageReader0"));
            }
            this.ictransf.setTile(n2 * this.tileStepX, n3 * this.tileStepY);
            if (writableRaster != null && this.resolution < this.hd.getDecoderSpecs().dls.getMin() || this.stepX != 1 || this.stepY != 1) {
                n7 = writableRaster.getMinX();
                n6 = writableRaster.getMinY();
                n5 = Math.min(writableRaster.getWidth(), this.ictransf.getTileWidth());
                n4 = Math.min(writableRaster.getHeight(), this.ictransf.getTileHeight());
            } else {
                n7 = this.ictransf.getCompULX(0) - (this.ictransf.getImgULX() + this.ictransf.getCompSubsX(0) - 1) / this.ictransf.getCompSubsX(0) + this.destinationRegion.x;
                n6 = this.ictransf.getCompULY(0) - (this.ictransf.getImgULY() + this.ictransf.getCompSubsY(0) - 1) / this.ictransf.getCompSubsY(0) + this.destinationRegion.y;
                n5 = this.ictransf.getTileWidth();
                n4 = this.ictransf.getTileHeight();
            }
            if (writableRaster == null) {
                writableRaster = Raster.createWritableRaster(this.sampleModel, new Point(n7, n6));
            }
            int n8 = this.sampleModel.getNumBands();
            if (n7 + n5 >= this.destinationRegion.width + this.destinationRegion.x) {
                n5 = this.destinationRegion.width + this.destinationRegion.x - n7;
            }
            if (n6 + n4 >= this.destinationRegion.height + this.destinationRegion.y) {
                n4 = this.destinationRegion.height + this.destinationRegion.y - n6;
            }
            if (this.pixbuf == null || this.pixbuf.length < n5 * n8) {
                this.pixbuf = new int[n5 * n8];
            }
            boolean bl2 = false;
            for (int i2 = 0; i2 < n4 && !this.reader.getAbortRequest(); ++i2) {
                for (int i3 = 0; i3 < n8 && !this.reader.getAbortRequest(); ++i3) {
                    int n9;
                    int n10;
                    DataBlkInt dataBlkInt = this.dataBlocks[i3];
                    dataBlkInt.ulx = 0;
                    dataBlkInt.uly = i2;
                    dataBlkInt.w = n5;
                    dataBlkInt.h = 1;
                    this.ictransf.getInternCompData((DataBlk)dataBlkInt, this.channelMap[this.sourceBands[i3]]);
                    bl2 = bl2 || dataBlkInt.progressive;
                    int[] nArray = dataBlkInt.data;
                    int n11 = dataBlkInt.offset + n5 - 1;
                    int n12 = this.fracBits[i3];
                    int n13 = this.levelShift[i3];
                    int n14 = this.minValues[i3];
                    int n15 = this.maxValues[i3];
                    if (ImageUtil.isBinary(this.sampleModel)) {
                        n14 = 0;
                        n15 = 1;
                        if (this.bytebuf == null || this.bytebuf.length < n5 * n8) {
                            this.bytebuf = new byte[n5 * n8];
                        }
                        for (n10 = n5 - 1; n10 >= 0; --n10) {
                            this.bytebuf[n10] = (byte)((n9 = (nArray[n11--] >> n12) + n13) < n14 ? n14 : (n9 > n15 ? n15 : n9));
                        }
                        ImageUtil.setUnpackedBinaryData(this.bytebuf, writableRaster, new Rectangle(n7, n6 + i2, n5, 1));
                        continue;
                    }
                    for (n10 = n5 - 1; n10 >= 0; --n10) {
                        this.pixbuf[n10] = (n9 = (nArray[n11--] >> n12) + n13) < n14 ? n14 : (n9 > n15 ? n15 : n9);
                    }
                    writableRaster.setSamples(n7, n6 + i2, n5, 1, this.destinationBands[i3], this.pixbuf);
                }
            }
        } else {
            this.readSubsampledRaster(writableRaster);
        }
        return writableRaster;
    }

    public Rectangle getDestinationRegion() {
        return this.destinationRegion;
    }

    public BufferedImage readBufferedImage() throws IOException {
        this.colorModel = this.getColorModel();
        this.sampleModel = this.getSampleModel();
        WritableRaster writableRaster = null;
        BufferedImage bufferedImage = this.j2krparam.getDestination();
        int n2 = this.destinationRegion.x;
        int n3 = this.destinationRegion.y;
        this.destinationRegion.setLocation(this.j2krparam.getDestinationOffset());
        if (bufferedImage == null) {
            ImageTypeSpecifier imageTypeSpecifier = this.j2krparam.getDestinationType();
            if (imageTypeSpecifier != null) {
                this.colorModel = imageTypeSpecifier.getColorModel();
            }
            writableRaster = Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(0, 0));
            bufferedImage = new BufferedImage(this.colorModel, writableRaster, this.colorModel.isAlphaPremultiplied(), new Hashtable());
        } else {
            writableRaster = bufferedImage.getWritableTile(0, 0);
        }
        this.destImage = bufferedImage;
        this.readSubsampledRaster(writableRaster);
        this.destinationRegion.setLocation(n2, n3);
        this.destImage = null;
        return bufferedImage;
    }

    public Raster readAsRaster() throws IOException {
        BufferedImage bufferedImage = this.j2krparam.getDestination();
        WritableRaster writableRaster = null;
        writableRaster = bufferedImage == null ? Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(0, 0)) : bufferedImage.getWritableTile(0, 0);
        this.readSubsampledRaster(writableRaster);
        return writableRaster;
    }

    private void initializeRead(int n2, J2KImageReadParamJava j2KImageReadParamJava, J2KMetadata j2KMetadata) {
        try {
            int n3;
            int n4;
            Object object;
            int n5;
            this.iis.mark();
            this.in = new IISRandomAccessIO(this.iis);
            this.ff = new FileFormatReader(this.in, j2KMetadata);
            this.ff.readFileFormat();
            this.in.seek(this.ff.getFirstCodeStreamPos());
            this.hi = new HeaderInfo();
            try {
                this.hd = new HeaderDecoder(this.in, this.j2krparam, this.hi);
            }
            catch (EOFException eOFException) {
                throw new RuntimeException(I18N.getString("J2KReadState2"));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.width = this.hd.getImgWidth();
            this.height = this.hd.getImgHeight();
            Rectangle rectangle = j2KImageReadParamJava.getSourceRegion();
            this.sourceOrigin = new Point();
            rectangle = new Rectangle(this.hd.getImgULX(), this.hd.getImgULY(), this.width, this.height);
            boolean bl2 = true;
            this.stepX = this.hd.getCompSubsX(0);
            this.stepY = this.hd.getCompSubsY(0);
            for (n5 = 1; n5 < this.nComp; ++n5) {
                if (this.stepX == this.hd.getCompSubsX(n5) && this.stepY == this.hd.getCompSubsY(n5)) continue;
                throw new RuntimeException(I18N.getString("J2KReadState12"));
            }
            n5 = this.hd.getDecoderSpecs().dls.getMin();
            int n6 = this.resolution = j2KImageReadParamJava != null ? j2KImageReadParamJava.getResolution() : n5;
            if (this.resolution < 0 || this.resolution > n5) {
                this.resolution = n5;
            }
            if (this.resolution != n5 || this.stepX != 1 || this.stepY != 1) {
                rectangle = J2KImageReader.getReducedRect(rectangle, n5, this.resolution, this.stepX, this.stepY);
            }
            this.destinationRegion = (Rectangle)rectangle.clone();
            J2KImageReader.computeRegionsWrapper(j2KImageReadParamJava, false, this.width, this.height, j2KImageReadParamJava.getDestination(), rectangle, this.destinationRegion);
            this.sourceOrigin = new Point(rectangle.x, rectangle.y);
            this.scaleX = j2KImageReadParamJava.getSourceXSubsampling();
            this.scaleY = j2KImageReadParamJava.getSourceYSubsampling();
            this.xOffset = j2KImageReadParamJava.getSubsamplingXOffset();
            this.yOffset = j2KImageReadParamJava.getSubsamplingYOffset();
            this.width = this.destinationRegion.width;
            this.height = this.destinationRegion.height;
            Point point = this.hd.getTilingOrigin(null);
            this.tileWidth = this.hd.getNomTileWidth();
            this.tileHeight = this.hd.getNomTileHeight();
            if (this.resolution != n5 || this.stepX != 1 || this.stepY != 1) {
                object = new Rectangle(point);
                ((Rectangle)object).width = this.tileWidth;
                ((Rectangle)object).height = this.tileHeight;
                object = J2KImageReader.getReducedRect((Rectangle)object, n5, this.resolution, this.stepX, this.stepY);
                point = ((Rectangle)object).getLocation();
                this.tileWidth = ((Rectangle)object).width;
                this.tileHeight = ((Rectangle)object).height;
            }
            this.tileXOffset = point.x;
            this.tileYOffset = point.y;
            this.tileStepX = this.tileWidth * (1 << n5 - this.resolution) * this.stepX > this.hd.getNomTileWidth() ? (this.tileWidth * (1 << n5 - this.resolution) * this.stepX + this.hd.getNomTileWidth() - 1) / this.hd.getNomTileWidth() : 1;
            this.tileStepY = this.tileHeight * (1 << n5 - this.resolution) * this.stepY > this.hd.getNomTileHeight() ? (this.tileHeight * (1 << n5 - this.resolution) * this.stepY + this.hd.getNomTileHeight() - 1) / this.hd.getNomTileHeight() : 1;
            if (!this.destinationRegion.equals(rectangle)) {
                this.noTransform = false;
            }
            this.decSpec = this.hd.getDecoderSpecs();
            this.nComp = this.hd.getNumComps();
            object = new int[this.nComp];
            for (int i2 = 0; i2 < this.nComp; ++i2) {
                object[i2] = this.hd.getOriginalBitDepth(i2);
            }
            ChannelDefinitionBox channelDefinitionBox = null;
            if (j2KMetadata != null) {
                channelDefinitionBox = (ChannelDefinitionBox)j2KMetadata.getElement("JPEG2000ChannelDefinitionBox");
            }
            this.channelMap = new int[this.nComp];
            if (channelDefinitionBox != null && j2KMetadata.getElement("JPEG2000PaletteBox") == null) {
                short[] sArray = channelDefinitionBox.getAssociation();
                short[] sArray2 = channelDefinitionBox.getTypes();
                short[] sArray3 = channelDefinitionBox.getChannel();
                for (n4 = 0; n4 < sArray2.length; ++n4) {
                    if (sArray2[n4] == 0) {
                        this.channelMap[sArray3[n4]] = sArray[n4] - 1;
                        continue;
                    }
                    if (sArray2[n4] != 1 && sArray2[n4] != 2) continue;
                    this.channelMap[sArray3[n4]] = sArray3[n4];
                }
            } else {
                for (int i3 = 0; i3 < this.nComp; ++i3) {
                    this.channelMap[i3] = i3;
                }
            }
            try {
                n3 = Boolean.getBoolean("jj2000.j2k.decoder.log");
                this.breader = BitstreamReaderAgent.createInstance((RandomAccessIO)this.in, (HeaderDecoder)this.hd, (J2KImageReadParamJava)this.j2krparam, (DecoderSpecs)this.decSpec, n3 != 0, (HeaderInfo)this.hi);
            }
            catch (IOException iOException) {
                throw new RuntimeException(I18N.getString("J2KReadState3") + " " + (iOException.getMessage() != null ? ":\n" + iOException.getMessage() : ""));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(I18N.getString("J2KReadState4") + " " + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""));
            }
            try {
                this.entdec = this.hd.createEntropyDecoder((CodedCBlkDataSrcDec)this.breader, this.j2krparam);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(I18N.getString("J2KReadState5") + " " + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""));
            }
            try {
                this.roids = this.hd.createROIDeScaler((CBlkQuantDataSrcDec)this.entdec, this.j2krparam, this.decSpec);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(I18N.getString("J2KReadState6") + " " + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""));
            }
            try {
                this.deq = this.hd.createDequantizer((CBlkQuantDataSrcDec)this.roids, (int[])object, this.decSpec);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(I18N.getString("J2KReadState7") + " " + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""));
            }
            try {
                this.invWT = InverseWT.createInstance((CBlkWTDataSrcDec)this.deq, (DecoderSpecs)this.decSpec);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(I18N.getString("J2KReadState8") + " " + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""));
            }
            n3 = this.breader.getImgRes();
            int n7 = this.decSpec.dls.getMin();
            this.invWT.setImgResLevel(n3);
            this.converter = new ImgDataConverter((BlkImgDataSrc)this.invWT, 0);
            this.ictransf = new InvCompTransf((BlkImgDataSrc)this.converter, this.decSpec, (int[])object);
            this.sourceBands = this.j2krparam.getSourceBands();
            if (this.sourceBands == null) {
                this.sourceBands = new int[this.nComp];
                for (int i4 = 0; i4 < this.nComp; ++i4) {
                    this.sourceBands[i4] = i4;
                }
            }
            this.nComp = this.sourceBands.length;
            this.destinationBands = this.j2krparam.getDestinationBands();
            if (this.destinationBands == null) {
                this.destinationBands = new int[this.nComp];
                for (int i5 = 0; i5 < this.nComp; ++i5) {
                    this.destinationBands[i5] = i5;
                }
            }
            J2KImageReader.checkReadParamBandSettingsWrapper(j2KImageReadParamJava, this.hd.getNumComps(), this.destinationBands.length);
            this.levelShift = new int[this.nComp];
            this.minValues = new int[this.nComp];
            this.maxValues = new int[this.nComp];
            this.fracBits = new int[this.nComp];
            this.dataBlocks = new DataBlkInt[this.nComp];
            object = new int[this.nComp];
            this.bandOffsets = new int[this.nComp];
            this.maxDepth = 0;
            this.isSigned = false;
            for (int i6 = 0; i6 < this.nComp; ++i6) {
                object[i6] = this.hd.getOriginalBitDepth(this.sourceBands[i6]);
                if (object[i6] > this.maxDepth) {
                    this.maxDepth = (int)object[i6];
                }
                this.dataBlocks[i6] = new DataBlkInt();
                this.bandOffsets[i6] = i6;
                if (this.hd.isOriginalSigned(this.sourceBands[i6])) {
                    this.isSigned = true;
                } else {
                    this.levelShift[i6] = 1 << this.ictransf.getNomRangeBits(this.sourceBands[i6]) - 1;
                }
                n4 = this.ictransf.getNomRangeBits(this.sourceBands[i6]);
                this.maxValues[i6] = (1 << (this.isSigned ? n4 - 1 : n4)) - 1;
                this.minValues[i6] = this.isSigned ? -(this.maxValues[i6] + 1) : 0;
                this.fracBits[i6] = this.ictransf.getFixedPoint(this.sourceBands[i6]);
            }
            this.iis.reset();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (Error error) {
            if (error.getMessage() != null) {
                throw new RuntimeException(error.getMessage(), error);
            }
            throw new RuntimeException(I18N.getString("J2KReadState9"), error);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getMessage() != null) {
                throw new RuntimeException(I18N.getString("J2KReadState10") + " " + runtimeException.getMessage(), runtimeException);
            }
            throw new RuntimeException(I18N.getString("J2KReadState10"), runtimeException);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(I18N.getString("J2KReadState10"), throwable);
        }
    }

    private Raster readSubsampledRaster(WritableRaster writableRaster) throws IOException {
        if (writableRaster == null) {
            writableRaster = Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(this.destinationRegion.x, this.destinationRegion.y));
        }
        int[] nArray = null;
        boolean bl2 = false;
        Point point = this.ictransf.getNumTiles(null);
        int n2 = this.sourceBands.length;
        Rectangle rectangle = writableRaster.getBounds().intersection(this.destinationRegion);
        int n3 = this.destinationRegion.x;
        int n4 = this.destinationRegion.y;
        int n5 = (rectangle.x - n3) * this.scaleX + this.sourceOrigin.x;
        int n6 = (rectangle.y - n4) * this.scaleY + this.sourceOrigin.y;
        int n7 = (rectangle.width - 1) * this.scaleX + n5;
        int n8 = (rectangle.height - 1) * this.scaleY + n6;
        int n9 = (n5 - this.tileXOffset) / this.tileWidth;
        int n10 = (n6 - this.tileYOffset) / this.tileHeight;
        int n11 = (n7 - this.tileXOffset) / this.tileWidth;
        int n12 = (n8 - this.tileYOffset) / this.tileHeight;
        n9 = this.clip(n9, 0, point.x - 1);
        n10 = this.clip(n10, 0, point.y - 1);
        n11 = this.clip(n11, 0, point.x - 1);
        n12 = this.clip(n12, 0, point.y - 1);
        int n13 = n11 - n9 + 1;
        int n14 = n12 - n10 + 1;
        int n15 = n13 * n14;
        for (int i2 = n10; i2 <= n12 && !this.reader.getAbortRequest(); ++i2) {
            for (int i3 = n9; i3 <= n11 && !this.reader.getAbortRequest(); ++i3) {
                float f2 = (i3 - n9 + (i2 - n10) * n13) / n15;
                this.ictransf.setTile(i3 * this.tileStepX, i2 * this.tileStepY);
                int n16 = this.hd.getCompSubsX(0);
                int n17 = (this.ictransf.getTileWidth() + n16 - 1) / n16;
                int n18 = this.hd.getCompSubsY(0);
                int n19 = (this.ictransf.getTileHeight() + n18 - 1) / n18;
                int n20 = 0;
                int n21 = 0;
                int n22 = this.tileXOffset + i3 * this.tileWidth;
                int n23 = this.tileYOffset + i2 * this.tileHeight;
                if (n5 > n22) {
                    if (n22 >= this.hd.getImgULX()) {
                        n20 = n5 - n22;
                        n17 -= n20;
                    }
                    n22 = n5;
                }
                if (n6 > n23) {
                    if (n23 >= this.hd.getImgULY()) {
                        n21 = n6 - n23;
                        n19 -= n21;
                    }
                    n23 = n6;
                }
                if (n7 < n22 + n17 - 1) {
                    n17 += n7 - n22 - n17 + 1;
                }
                if (n8 < n23 + n19 - 1) {
                    n19 += n8 - n23 - n19 + 1;
                }
                int n24 = (n22 + this.scaleX - 1 - this.sourceOrigin.x) / this.scaleX;
                int n25 = (n22 + this.scaleX - 1 + n17 - this.sourceOrigin.x) / this.scaleX;
                int n26 = n25 - n24;
                if (nArray == null || nArray.length < n26) {
                    nArray = new int[n26];
                }
                n25 = (n25 - 1) * this.scaleX + this.sourceOrigin.x - n22;
                int n27 = (n23 + this.scaleY - 1 - this.sourceOrigin.y) / this.scaleY;
                n24 += n3;
                int n28 = n21;
                int n29 = n27 += n4;
                while (n28 < n21 + n19 && !this.reader.getAbortRequest()) {
                    for (int i4 = 0; i4 < n2; ++i4) {
                        int n30;
                        int n31;
                        DataBlkInt dataBlkInt = this.dataBlocks[i4];
                        dataBlkInt.ulx = n20;
                        dataBlkInt.uly = n28;
                        dataBlkInt.w = n17;
                        dataBlkInt.h = 1;
                        this.ictransf.getInternCompData((DataBlk)dataBlkInt, this.channelMap[this.sourceBands[i4]]);
                        bl2 = bl2 || dataBlkInt.progressive;
                        int[] nArray2 = dataBlkInt.data;
                        int n32 = dataBlkInt.offset + n25;
                        int n33 = this.fracBits[i4];
                        int n34 = this.levelShift[i4];
                        int n35 = this.minValues[i4];
                        int n36 = this.maxValues[i4];
                        if (ImageUtil.isBinary(this.sampleModel)) {
                            n35 = 0;
                            n36 = 1;
                            if (this.bytebuf == null || this.bytebuf.length < n17 * n2) {
                                this.bytebuf = new byte[n17 * n2];
                            }
                            n31 = n26 - 1;
                            while (n31 >= 0) {
                                n30 = (nArray2[n32] >> n33) + n34;
                                this.bytebuf[n31] = (byte)(n30 < n35 ? n35 : (n30 > n36 ? n36 : n30));
                                --n31;
                                n32 -= this.scaleX;
                            }
                            ImageUtil.setUnpackedBinaryData(this.bytebuf, writableRaster, new Rectangle(n24, n29, n26, 1));
                            continue;
                        }
                        n31 = n26 - 1;
                        while (n31 >= 0) {
                            n30 = (nArray2[n32] >> n33) + n34;
                            nArray[n31] = n30 < n35 ? n35 : (n30 > n36 ? n36 : n30);
                            --n31;
                            n32 -= this.scaleX;
                        }
                        writableRaster.setSamples(n24, n29, n26, 1, this.destinationBands[i4], nArray);
                    }
                    if (this.destImage != null) {
                        this.reader.processImageUpdateWrapper(this.destImage, n24, n29, n17, 1, 1, 1, this.destinationBands);
                    }
                    float f3 = f2 + ((float)(n28 - n21) + 1.0f) / (float)n19 / (float)n15;
                    this.reader.processImageProgressWrapper(100.0f * f3);
                    n28 += this.scaleY;
                    ++n29;
                }
            }
        }
        return writableRaster;
    }

    public ImageTypeSpecifier getImageType() throws IOException {
        this.getSampleModel();
        this.getColorModel();
        return new ImageTypeSpecifier(this.colorModel, this.sampleModel);
    }

    public SampleModel getSampleModel() {
        if (this.sampleModel != null) {
            return this.sampleModel;
        }
        if (this.nComp == 1 && (this.maxDepth == 1 || this.maxDepth == 2 || this.maxDepth == 4)) {
            this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, this.maxDepth);
        } else if (this.maxDepth <= 8) {
            this.sampleModel = new PixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.nComp, this.tileWidth * this.nComp, this.bandOffsets);
        } else if (this.maxDepth <= 16) {
            this.sampleModel = new PixelInterleavedSampleModel(this.isSigned ? 2 : 1, this.tileWidth, this.tileHeight, this.nComp, this.tileWidth * this.nComp, this.bandOffsets);
        } else if (this.maxDepth <= 32) {
            this.sampleModel = new PixelInterleavedSampleModel(3, this.tileWidth, this.tileHeight, this.nComp, this.tileWidth * this.nComp, this.bandOffsets);
        } else {
            throw new IllegalArgumentException(I18N.getString("J2KReadState11") + " " + this.maxDepth);
        }
        return this.sampleModel;
    }

    public ColorModel getColorModel() {
        if (this.colorModel != null) {
            return this.colorModel;
        }
        this.colorModel = this.ff.getColorModel();
        if (this.colorModel != null) {
            return this.colorModel;
        }
        if (this.hi.siz.csiz <= 4) {
            int n2;
            ColorSpace colorSpace = this.hi.siz.csiz > 2 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1003);
            int[] nArray = new int[this.hi.siz.csiz];
            boolean bl2 = false;
            int n3 = -1;
            for (n2 = 0; n2 < this.hi.siz.csiz; n2 += 1) {
                nArray[n2] = this.hi.siz.getOrigBitDepth(n2);
                if (n3 < nArray[n2]) {
                    n3 = nArray[n2];
                }
                bl2 |= this.hi.siz.isOrigSigned(n2);
            }
            n2 = this.hi.siz.csiz % 2 == 0 ? 1 : 0;
            int n4 = -1;
            if (n3 <= 8) {
                n4 = 0;
            } else if (n3 <= 16) {
                n4 = bl2 ? 2 : 1;
            } else if (n3 <= 32) {
                n4 = 3;
            }
            if (n4 != -1) {
                this.colorModel = this.hi.siz.csiz == 1 && (n3 == 1 || n3 == 2 || n3 == 4) ? ImageUtil.createColorModel(this.getSampleModel()) : new ComponentColorModel(colorSpace, nArray, n2 != 0, false, n2 != 0 ? 3 : 1, n4);
                return this.colorModel;
            }
        }
        if (this.sampleModel == null) {
            this.sampleModel = this.getSampleModel();
        }
        if (this.sampleModel == null) {
            return null;
        }
        return ImageUtil.createColorModel(null, this.sampleModel);
    }

    Rectangle getTile0Rect() {
        return new Rectangle(this.tileXOffset, this.tileYOffset, this.tileWidth, this.tileHeight);
    }

    private int clip(int n2, int n3, int n4) {
        if (n2 < n3) {
            n2 = n3;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        return n2;
    }

    private void clipDestination(Rectangle rectangle) {
        Point point = this.j2krparam.getDestinationOffset();
        if (rectangle.x < point.x) {
            rectangle.width += rectangle.x - point.x;
            rectangle.x = point.x;
        }
        if (rectangle.y < point.y) {
            rectangle.height += rectangle.y - point.y;
            rectangle.y = point.y;
        }
    }
}

