/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageReadParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.SimpleRenderedImage;
import com.sun.media.imageioimpl.plugins.jpeg2000.BitsPerComponentBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import com.sun.media.imageioimpl.plugins.jpeg2000.ChannelDefinitionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ColorSpecificationBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ComponentMappingBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.HeaderBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLib;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.MediaLibAccessor;
import com.sun.media.imageioimpl.plugins.jpeg2000.PaletteBox;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.jp2k.CompParams;
import com.sun.medialib.codec.jp2k.Decoder;
import com.sun.medialib.codec.jp2k.Size;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.ImageInputStream;

public class J2KRenderedImageCodecLib
extends SimpleRenderedImage {
    private SampleModel originalSampleModel;
    private Raster currentTile;
    private Point currentTileGrid;
    private J2KMetadata metadata;
    private ImageInputStream iis = null;
    private J2KImageReaderCodecLib reader;
    private J2KImageReadParam param = null;
    private Decoder decoder;
    private Size size;
    private CompParams compParam;
    private int xStep;
    private int yStep;
    Rectangle destinationRegion;
    Rectangle originalRegion;
    Point sourceOrigin;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private int[] destinationBands = null;
    private int[] sourceBands = null;
    private int nComp;
    private int[] channelMap;
    private boolean noTransform = true;
    private WritableRaster rasForATile;
    private BufferedImage destImage;
    static /* synthetic */ Class array$B;

    public J2KRenderedImageCodecLib(ImageInputStream imageInputStream, J2KImageReaderCodecLib j2KImageReaderCodecLib, ImageReadParam imageReadParam) throws IOException {
        int n2;
        this.iis = imageInputStream;
        this.reader = j2KImageReaderCodecLib;
        boolean bl2 = true;
        if (imageReadParam == null) {
            imageReadParam = (J2KImageReadParam)j2KImageReaderCodecLib.getDefaultReadParam();
            bl2 = false;
        } else if (!(imageReadParam instanceof J2KImageReadParam)) {
            imageReadParam = new J2KImageReadParamJava(imageReadParam);
            bl2 = false;
        }
        this.param = (J2KImageReadParam)imageReadParam;
        this.decoder = new Decoder(imageInputStream);
        this.decoder.setMode(2);
        int n3 = ((J2KImageReadParam)imageReadParam).getResolution();
        if (n3 != -1) {
            this.decoder.setMaxLevels(n3);
        }
        this.size = this.decoder.decodeSize(null);
        this.compParam = new CompParams();
        for (n2 = 0; n2 < this.size.csize; ++n2) {
            this.decoder.decodeCompParams(this.compParam, n2);
            if (n2 == 0) {
                this.xStep = this.compParam.xstep;
                this.yStep = this.compParam.ystep;
                continue;
            }
            if (this.compParam.xstep == this.xStep && this.compParam.ystep == this.yStep) continue;
            throw new IIOException("All components must have the same subsampling factors!");
        }
        this.sourceBands = imageReadParam.getSourceBands();
        if (this.sourceBands == null) {
            this.nComp = this.size.csize;
            this.sourceBands = new int[this.nComp];
            for (n2 = 0; n2 < this.nComp; ++n2) {
                this.sourceBands[n2] = n2;
            }
        } else {
            for (n2 = 0; n2 < this.sourceBands.length; ++n2) {
                if (this.sourceBands[n2] >= 0 && this.sourceBands[n2] < this.size.csize) continue;
                throw new IIOException("Source band out of range!");
            }
        }
        this.nComp = this.sourceBands.length;
        this.destinationBands = imageReadParam.getDestinationBands();
        if (this.destinationBands == null) {
            this.destinationBands = new int[this.nComp];
            for (n2 = 0; n2 < this.nComp; ++n2) {
                this.destinationBands[n2] = n2;
            }
        } else {
            for (n2 = 0; n2 < this.destinationBands.length; ++n2) {
                if (this.destinationBands[n2] >= 0 && this.destinationBands[n2] < this.size.csize) continue;
                throw new IIOException("Destination band out of range!");
            }
        }
        if (this.destinationBands.length != this.sourceBands.length) {
            throw new IIOException("Number of source and destination bands must be equal!");
        }
        this.width = (this.size.xosize + this.size.xsize + this.xStep - 1) / this.xStep;
        this.height = (this.size.yosize + this.size.ysize + this.yStep - 1) / this.yStep;
        Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
        this.originalRegion = (Rectangle)rectangle.clone();
        this.destinationRegion = (Rectangle)rectangle.clone();
        J2KImageReader.computeRegionsWrapper(imageReadParam, bl2, this.width, this.height, imageReadParam.getDestination(), rectangle, this.destinationRegion);
        this.scaleX = imageReadParam.getSourceXSubsampling();
        this.scaleY = imageReadParam.getSourceYSubsampling();
        this.xOffset = imageReadParam.getSubsamplingXOffset();
        this.yOffset = imageReadParam.getSubsamplingYOffset();
        this.sourceOrigin = new Point(rectangle.x, rectangle.y);
        if (!this.destinationRegion.equals(this.originalRegion)) {
            this.noTransform = false;
        }
        this.tileWidth = (this.size.xtsize + this.xStep - 1) / this.xStep;
        this.tileHeight = (this.size.ytsize + this.yStep - 1) / this.yStep;
        this.tileGridXOffset = (this.size.xtosize + this.xStep - 1) / this.xStep - (this.size.xosize + this.xStep - 1) / this.xStep;
        this.tileGridYOffset = (this.size.ytosize + this.yStep - 1) / this.yStep - (this.size.yosize + this.yStep - 1) / this.yStep;
        this.width = this.destinationRegion.width;
        this.height = this.destinationRegion.height;
        this.minX = this.destinationRegion.x;
        this.minY = this.destinationRegion.y;
        this.originalSampleModel = this.createOriginalSampleModel();
        this.sampleModel = this.createSampleModel();
        this.colorModel = this.createColorModel();
        this.tileGridXOffset += (this.XToTileX(this.minX) - this.XToTileX(this.tileGridXOffset)) * this.tileWidth;
        this.tileGridYOffset += (this.YToTileY(this.minY) - this.YToTileY(this.tileGridYOffset)) * this.tileHeight;
        double d2 = ((J2KImageReadParam)imageReadParam).getDecodingRate();
        if (d2 != Double.MAX_VALUE) {
            this.decoder.setRate(d2 /= (double)ImageUtil.getElementSize(this.sampleModel), 0);
        }
    }

    public synchronized Raster getTile(int n2, int n3) {
        if (this.currentTile != null && this.currentTileGrid.x == n2 && this.currentTileGrid.y == n3) {
            return this.currentTile;
        }
        if (n2 < this.getMinTileX() || n3 < this.getMinTileY() || n2 > this.getMaxTileX() || n3 > this.getMaxTileY()) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState1"));
        }
        int n4 = this.tileXToX(n2);
        int n5 = this.tileYToY(n3);
        this.currentTile = Raster.createWritableRaster(this.sampleModel, new Point(n4, n5));
        try {
            this.readAsRaster((WritableRaster)this.currentTile);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (this.currentTileGrid == null) {
            this.currentTileGrid = new Point(n2, n3);
        } else {
            this.currentTileGrid.x = n2;
            this.currentTileGrid.y = n3;
        }
        return this.currentTile;
    }

    synchronized WritableRaster readAsRaster(WritableRaster writableRaster) throws IOException {
        int n2 = writableRaster.getMinX();
        int n3 = writableRaster.getMinY();
        try {
            if (this.noTransform) {
                int n4 = (this.size.xosize + this.xStep - 1) / this.xStep;
                int n5 = (this.size.yosize + this.yStep - 1) / this.yStep;
                int n6 = ((n2 + n4) * this.xStep - this.size.xtosize) / this.size.xtsize;
                int n7 = ((n2 + writableRaster.getWidth() - 1 + n4) * this.xStep - this.size.xtosize) / this.size.xtsize;
                int n8 = ((n3 + n4) * this.yStep - this.size.ytosize) / this.size.ytsize;
                int n9 = ((n3 + writableRaster.getHeight() - 1 + n4) * this.yStep - this.size.ytosize) / this.size.ytsize;
                int n10 = MediaLibAccessor.findCompatibleTag(writableRaster);
                if (n6 == n7 && n8 == n9) {
                    MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(writableRaster, writableRaster.getBounds().intersection(this.originalRegion), n10, true);
                    mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
                    int n11 = n6 + n8 * this.size.nxtiles;
                    this.decoder.decode(mediaLibImageArray, n11);
                    mediaLibAccessor.copyDataToRaster(this.channelMap);
                } else {
                    for (int i2 = n8; i2 <= n9; ++i2) {
                        for (int i3 = n6; i3 <= n7; ++i3) {
                            int n12 = (this.size.xtosize + i3 * this.size.xtsize + this.xStep - 1) / this.xStep - n4;
                            int n13 = (this.size.ytosize + i2 * this.size.ytsize + this.yStep - 1) / this.yStep - n5;
                            int n14 = (this.size.xtosize + (i3 + 1) * this.size.xtsize + this.xStep - 1) / this.xStep - n4;
                            int n15 = (this.size.ytosize + (i2 + 1) * this.size.ytsize + this.yStep - 1) / this.yStep - n5;
                            Rectangle rectangle = new Rectangle(n12, n13, n14 - n12, n15 - n13);
                            if (rectangle.isEmpty()) continue;
                            if (this.rasForATile == null) {
                                this.rasForATile = Raster.createWritableRaster(this.originalSampleModel, null);
                            }
                            WritableRaster writableRaster2 = this.rasForATile.createWritableChild(this.rasForATile.getMinX(), this.rasForATile.getMinY(), rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
                            MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(writableRaster2, rectangle, n10, true);
                            mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
                            int n16 = i3 + i2 * this.size.nxtiles;
                            this.decoder.decode(mediaLibImageArray, n16);
                            mediaLibAccessor.copyDataToRaster(this.channelMap);
                            Rectangle rectangle2 = writableRaster.getBounds();
                            Rectangle rectangle3 = rectangle2.intersection(rectangle);
                            if (rectangle3.isEmpty()) continue;
                            Raster raster = writableRaster2.createChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                            writableRaster.setRect(raster);
                        }
                    }
                }
            } else {
                this.readSubsampledRaster(writableRaster);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return writableRaster;
    }

    private void readSubsampledRaster(WritableRaster writableRaster) throws IOException {
        int n2 = this.sourceBands.length;
        Rectangle rectangle = writableRaster.getBounds().intersection(this.destinationRegion);
        int n3 = this.destinationRegion.x;
        int n4 = this.destinationRegion.y;
        int n5 = (rectangle.x - n3) * this.scaleX + this.sourceOrigin.x;
        int n6 = (rectangle.y - n4) * this.scaleY + this.sourceOrigin.y;
        int n7 = (rectangle.width - 1) * this.scaleX + n5;
        int n8 = (rectangle.height - 1) * this.scaleY + n6;
        int n9 = (this.size.xosize + this.xStep - 1) / this.xStep;
        int n10 = (this.size.yosize + this.yStep - 1) / this.yStep;
        int n11 = ((n5 + n9) * this.xStep - this.size.xtosize) / this.size.xtsize;
        int n12 = ((n7 + n9) * this.xStep - this.size.xtosize) / this.size.xtsize;
        int n13 = ((n6 + n10) * this.yStep - this.size.ytosize) / this.size.ytsize;
        int n14 = ((n8 + n10) * this.yStep - this.size.ytosize) / this.size.ytsize;
        n11 = this.clip(n11, 0, this.size.nxtiles - 1);
        n13 = this.clip(n13, 0, this.size.nytiles - 1);
        n12 = this.clip(n12, 0, this.size.nxtiles - 1);
        n14 = this.clip(n14, 0, this.size.nytiles - 1);
        int n15 = n12 - n11 + 1;
        int n16 = n14 - n13 + 1;
        int n17 = n15 * n16;
        int[] nArray = null;
        for (int i2 = n13; i2 <= n14 && !this.reader.getAbortRequest(); ++i2) {
            for (int i3 = n11; i3 <= n12 && !this.reader.getAbortRequest(); ++i3) {
                int n18;
                int n19;
                int n20;
                float f2 = ((float)(i3 - n11) + 1.0f + (float)(i2 * n15)) / (float)n17;
                int n21 = (i3 * this.size.xtsize + this.size.xtosize + this.xStep - 1) / this.xStep - n9;
                int n22 = (i2 * this.size.ytsize + this.size.ytosize + this.yStep - 1) / this.yStep - n10;
                int n23 = ((i3 + 1) * this.size.xtsize + this.size.xtosize + this.xStep - 1) / this.xStep - n9;
                int n24 = ((i2 + 1) * this.size.ytsize + this.size.ytosize + this.yStep - 1) / this.yStep - n10;
                this.rasForATile = this.rasForATile == null ? Raster.createWritableRaster(this.originalSampleModel, new Point(n21, n22)) : this.rasForATile.createWritableTranslatedChild(n21, n22);
                int n25 = n23 - n21;
                int n26 = n24 - n22;
                WritableRaster writableRaster2 = n25 != this.tileWidth || n26 != this.tileHeight ? this.rasForATile.createWritableChild(n21, n22, n25, n26, n21, n22, null) : this.rasForATile;
                int n27 = MediaLibAccessor.findCompatibleTag(writableRaster2);
                MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(writableRaster2, writableRaster2.getBounds().intersection(this.originalRegion), n27, true);
                mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
                this.decoder.decode(mediaLibImageArray, i3 + i2 * this.size.nxtiles);
                mediaLibAccessor.copyDataToRaster(this.channelMap);
                int n28 = n26;
                int n29 = n25;
                if (n22 + n28 >= this.originalRegion.height) {
                    n28 = this.originalRegion.height - n22;
                }
                if (n21 + n29 >= this.originalRegion.width) {
                    n29 = this.originalRegion.width - n21;
                }
                int n30 = n21;
                int n31 = n22;
                if (n5 > n21) {
                    n29 += n21 - n5;
                    n30 = n5;
                    n21 = n5;
                }
                if (n6 > n22) {
                    n28 += n22 - n6;
                    n31 = n6;
                    n22 = n6;
                }
                if (n7 < n21 + n29 - 1) {
                    n29 += n7 - n21 - n29 + 1;
                }
                if (n8 < n22 + n28 - 1) {
                    n28 += n8 - n22 - n28 + 1;
                }
                if ((n20 = (n19 = (n21 + this.scaleX - 1 + n29 - this.sourceOrigin.x) / this.scaleX) - (n18 = (n21 + this.scaleX - 1 - this.sourceOrigin.x) / this.scaleX)) <= 0) continue;
                n19 = (n19 - 1) * this.scaleX + this.sourceOrigin.x;
                int n32 = (n22 + this.scaleY - 1 - this.sourceOrigin.y) / this.scaleY;
                n22 = n32 * this.scaleY + this.sourceOrigin.y;
                n21 = n18 * this.scaleX + this.sourceOrigin.x;
                n18 += n3;
                n32 += n4;
                if (nArray == null || nArray.length < n20) {
                    nArray = new int[n20];
                }
                int n33 = n22;
                int n34 = n32;
                while (n33 < n31 + n28 && !this.reader.getAbortRequest()) {
                    for (int i4 = 0; i4 < n2; ++i4) {
                        int n35 = n20 - 1;
                        int n36 = n19;
                        while (n35 >= 0) {
                            nArray[n35] = writableRaster2.getSample(n36, n33, i4);
                            --n35;
                            n36 -= this.scaleX;
                        }
                        writableRaster.setSamples(n18, n34, n20, 1, this.destinationBands[i4], nArray);
                    }
                    if (this.destImage != null) {
                        this.reader.processImageUpdateWrapper(this.destImage, n18, n34, n29, 1, 1, 1, this.destinationBands);
                    }
                    this.reader.processImageProgressWrapper(f2 + ((float)(n33 - n22) + 1.0f) / (float)n28 / (float)n17);
                    n33 += this.scaleY;
                    ++n34;
                }
            }
        }
    }

    public void setDestImage(BufferedImage bufferedImage) {
        this.destImage = bufferedImage;
    }

    public void clearDestImage() {
        this.destImage = null;
    }

    private int getTileNum(int n2, int n3) {
        int n4 = (n3 - this.getMinTileY()) * this.getNumXTiles() + n2 - this.getMinTileX();
        if (n4 < 0 || n4 >= this.getNumXTiles() * this.getNumYTiles()) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState1"));
        }
        return n4;
    }

    private int clip(int n2, int n3, int n4) {
        if (n2 < n3) {
            n2 = n3;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        return n2;
    }

    private SampleModel createSampleModel() throws IOException {
        int n2;
        Object object;
        if (this.sampleModel != null) {
            return this.sampleModel;
        }
        if (this.metadata == null) {
            this.readImageMetadata();
        }
        HeaderBox headerBox = (HeaderBox)this.metadata.getElement("JPEG2000HeaderBox");
        int n3 = 0;
        boolean bl2 = false;
        if (headerBox != null) {
            n3 = headerBox.getBitDepth();
            bl2 = (n3 & 0x80) > 0;
            n3 = (n3 & 0x7F) + 1;
        } else {
            object = new CompParams();
            for (int i2 = 0; i2 < this.size.csize; ++i2) {
                this.decoder.decodeCompParams((CompParams)object, i2);
                n3 = (((CompParams)object).depth & 0x7F) + 1;
                bl2 = (((CompParams)object).depth & 0x80) > 0;
            }
        }
        object = (BitsPerComponentBox)this.metadata.getElement("JPEG2000BitsPerComponentBox");
        if (object != null) {
            byte[] byArray = ((BitsPerComponentBox)object).getBitDepth();
            n3 = (byArray[0] & 0x7F) + 1;
            bl2 = (byArray[0] & 0x80) > 0;
            for (n2 = 1; n2 < this.nComp; ++n2) {
                if (n3 <= byArray[this.sourceBands[n2]]) continue;
                n3 = (byArray[this.sourceBands[n2]] & 0x7F) + 1;
            }
        }
        int[] nArray = new int[this.nComp];
        for (n2 = 0; n2 < this.nComp; ++n2) {
            nArray[n2] = n2;
        }
        ChannelDefinitionBox channelDefinitionBox = (ChannelDefinitionBox)this.metadata.getElement("JPEG2000ChannelDefinitionBox");
        if (channelDefinitionBox != null && this.metadata.getElement("JPEG2000PaletteBox") == null) {
            short[] sArray = channelDefinitionBox.getAssociation();
            short[] sArray2 = channelDefinitionBox.getTypes();
            short[] sArray3 = channelDefinitionBox.getChannel();
            for (int i3 = 0; i3 < sArray2.length; ++i3) {
                if (sArray2[i3] == 0) {
                    nArray[this.sourceBands[sArray3[i3]]] = sArray[i3] - 1;
                    continue;
                }
                if (sArray2[i3] != 1 && sArray2[i3] != 2) continue;
                nArray[this.sourceBands[sArray3[i3]]] = sArray3[i3];
            }
        }
        return this.createSampleModel(this.nComp, n3, nArray, bl2, this.tileWidth, this.tileHeight);
    }

    private SampleModel createOriginalSampleModel() throws IOException {
        int n2;
        Object object;
        if (this.metadata == null) {
            this.readImageMetadata();
        }
        HeaderBox headerBox = (HeaderBox)this.metadata.getElement("JPEG2000HeaderBox");
        int n3 = 0;
        boolean bl2 = false;
        int n4 = this.size.csize;
        if (headerBox != null) {
            n3 = headerBox.getBitDepth();
            bl2 = (n3 & 0x80) > 0;
            n3 = (n3 & 0x7F) + 1;
        } else {
            object = new CompParams();
            for (int i2 = 0; i2 < this.size.csize; ++i2) {
                this.decoder.decodeCompParams((CompParams)object, i2);
                n3 = (((CompParams)object).depth & 0x7F) + 1;
                bl2 = (((CompParams)object).depth & 0x80) > 0;
            }
        }
        object = (BitsPerComponentBox)this.metadata.getElement("JPEG2000BitsPerComponentBox");
        if (object != null) {
            byte[] byArray = ((BitsPerComponentBox)object).getBitDepth();
            n3 = (byArray[0] & 0x7F) + 1;
            bl2 = (byArray[0] & 0x80) > 0;
            for (n2 = 1; n2 < n4; ++n2) {
                if (n3 <= byArray[n2]) continue;
                n3 = (byArray[n2] & 0x7F) + 1;
            }
        }
        int[] nArray = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = n2;
        }
        ChannelDefinitionBox channelDefinitionBox = (ChannelDefinitionBox)this.metadata.getElement("JPEG2000ChannelDefinitionBox");
        if (channelDefinitionBox != null && this.metadata.getElement("JPEG2000PaletteBox") == null) {
            short[] sArray = channelDefinitionBox.getAssociation();
            short[] sArray2 = channelDefinitionBox.getTypes();
            short[] sArray3 = channelDefinitionBox.getChannel();
            this.channelMap = new int[n4];
            for (int i3 = 0; i3 < sArray2.length; ++i3) {
                if (sArray2[i3] == 0) {
                    nArray[sArray3[i3]] = sArray[i3] - 1;
                    this.channelMap[sArray[i3] - 1] = sArray3[i3];
                    continue;
                }
                if (sArray2[i3] != 1 && sArray2[i3] != 2) continue;
                nArray[sArray3[i3]] = sArray3[i3];
                this.channelMap[sArray3[i3]] = sArray3[i3];
            }
        }
        return this.createSampleModel(n4, n3, nArray, bl2, this.tileWidth, this.tileHeight);
    }

    private SampleModel createSampleModel(int n2, int n3, int[] nArray, boolean bl2, int n4, int n5) {
        SampleModel sampleModel = null;
        if (n2 == 1 && (n3 == 1 || n3 == 2 || n3 == 4)) {
            sampleModel = new MultiPixelPackedSampleModel(0, n4, n5, n3);
        } else if (n3 <= 8) {
            sampleModel = new PixelInterleavedSampleModel(0, n4, n5, n2, n4 * n2, nArray);
        } else if (n3 <= 16) {
            sampleModel = new PixelInterleavedSampleModel(bl2 ? 2 : 1, n4, n5, n2, n4 * n2, nArray);
        } else if (n3 <= 32) {
            sampleModel = new PixelInterleavedSampleModel(3, n4, n5, this.nComp, n4 * this.nComp, nArray);
        } else {
            throw new IllegalArgumentException(I18N.getString("J2KReadState11") + " " + n3);
        }
        return sampleModel;
    }

    private ColorModel createColorModel() throws IOException {
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        Object object;
        if (this.colorModel != null) {
            return this.colorModel;
        }
        PaletteBox paletteBox = (PaletteBox)this.metadata.getElement("JPEG2000PaletteBox");
        ChannelDefinitionBox channelDefinitionBox = (ChannelDefinitionBox)this.metadata.getElement("JPEG2000ChannelDefinitionBox");
        if (paletteBox != null && this.nComp == 1) {
            object = paletteBox.getLUT();
            n2 = paletteBox.getNumComp();
            int[] nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = i2;
            }
            ComponentMappingBox componentMappingBox = (ComponentMappingBox)this.metadata.getElement("JPEG2000ComponentMappingBox");
            short[] sArray = null;
            objectArray2 = null;
            objectArray = null;
            if (componentMappingBox != null) {
                sArray = componentMappingBox.getComponent();
                objectArray2 = componentMappingBox.getComponentType();
                objectArray = componentMappingBox.getComponentAssociation();
            }
            if (sArray != null) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (objectArray2[i3] != 1) continue;
                    nArray[i3] = objectArray[i3];
                }
            }
            if (n2 == 3) {
                this.colorModel = new IndexColorModel(this.sampleModel.getSampleSize(0), ((Object)object[0]).length, (byte[])object[nArray[0]], (byte[])object[nArray[1]], (byte[])object[nArray[2]]);
            } else if (n2 == 4) {
                this.colorModel = new IndexColorModel(this.sampleModel.getSampleSize(0), ((Object)object[0]).length, (byte[])object[nArray[0]], (byte[])object[nArray[1]], (byte[])object[nArray[2]], (byte[])object[nArray[3]]);
            }
        } else if (channelDefinitionBox != null) {
            int n3;
            int n4;
            object = (HeaderBox)this.metadata.getElement("JPEG2000HeaderBox");
            n2 = ((HeaderBox)object).getNumComponents();
            byte by2 = ((HeaderBox)object).getBitDepth();
            boolean bl2 = false;
            int n5 = n2 - 1;
            objectArray2 = channelDefinitionBox.getChannel();
            objectArray = channelDefinitionBox.getTypes();
            short[] sArray = channelDefinitionBox.getAssociation();
            for (int i4 = 0; i4 < objectArray2.length; ++i4) {
                if (objectArray[i4] != 1 || objectArray2[i4] != n5) continue;
                bl2 = true;
            }
            boolean[] blArray = new boolean[]{false};
            if (bl2) {
                int n6;
                blArray = new boolean[n5];
                for (n6 = 0; n6 < n5; ++n6) {
                    blArray[n6] = false;
                }
                for (n6 = 0; n6 < objectArray2.length; ++n6) {
                    if (objectArray[n6] != 2) continue;
                    blArray[sArray[n6] - 1] = true;
                }
                for (n6 = 1; n6 < n5; ++n6) {
                    blArray[0] = blArray[0] & blArray[n6];
                }
            }
            ColorSpecificationBox colorSpecificationBox = (ColorSpecificationBox)this.metadata.getElement("JPEG2000ColorSpecificationBox");
            ICC_Profile iCC_Profile = null;
            int n7 = 0;
            if (colorSpecificationBox != null) {
                iCC_Profile = colorSpecificationBox.getICCProfile();
                n7 = colorSpecificationBox.getEnumeratedColorSpace();
            }
            ColorSpace colorSpace = null;
            if (iCC_Profile != null) {
                colorSpace = new ICC_ColorSpace(iCC_Profile);
            } else if (n7 == 16) {
                colorSpace = ColorSpace.getInstance(1000);
            } else if (n7 == 17) {
                colorSpace = ColorSpace.getInstance(1003);
            } else if (n7 == 18) {
                colorSpace = ColorSpace.getInstance(1002);
            }
            byte[] byArray = null;
            boolean bl3 = (by2 & 0x80) == 128;
            BitsPerComponentBox bitsPerComponentBox = (BitsPerComponentBox)this.metadata.getElement("JPEG2000BitsPerComponentBox");
            if (bitsPerComponentBox != null) {
                byArray = bitsPerComponentBox.getBitDepth();
            }
            int[] nArray = new int[n2];
            for (n4 = 0; n4 < n2; ++n4) {
                nArray[n4] = byArray != null ? (byArray[n4] & 0x7F) + 1 : (by2 & 0x7F) + 1;
            }
            n4 = 1 + (by2 & 0x7F);
            if (byArray != null) {
                for (n3 = 0; n3 < n2; ++n3) {
                    if (nArray[n3] <= n4) continue;
                    n4 = nArray[n3];
                }
            }
            n3 = -1;
            if (n4 <= 8) {
                n3 = 0;
            } else if (n4 <= 16) {
                n3 = bl3 ? 2 : 1;
            } else if (n4 <= 32) {
                n3 = 3;
            }
            if (n3 == -1) {
                return null;
            }
            if (colorSpace != null) {
                this.colorModel = new ComponentColorModel(colorSpace, nArray, bl2, blArray[0], bl2 ? 3 : 1, n3);
            }
        }
        if (this.colorModel != null) {
            return this.colorModel;
        }
        if (this.nComp <= 4) {
            int n8;
            object = this.nComp > 2 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1003);
            int[] nArray = new int[this.nComp];
            boolean bl4 = false;
            int n9 = -1;
            for (n8 = 0; n8 < this.nComp; n8 += 1) {
                nArray[n8] = (this.compParam.depth & 0x7F) + 1;
                if (n9 < nArray[n8]) {
                    n9 = nArray[n8];
                }
                bl4 |= (this.compParam.depth & 0x80) != 0;
            }
            n8 = this.nComp % 2 == 0 ? 1 : 0;
            int n10 = -1;
            if (n9 <= 8) {
                n10 = 0;
            } else if (n9 <= 16) {
                n10 = bl4 ? 2 : 1;
            } else if (n9 <= 32) {
                n10 = 3;
            }
            if (n10 != -1) {
                this.colorModel = this.nComp == 1 && (n9 == 1 || n9 == 2 || n9 == 4) ? ImageUtil.createColorModel(this.getSampleModel()) : new ComponentColorModel((ColorSpace)object, nArray, n8 != 0, false, n8 != 0 ? 3 : 1, n10);
                return this.colorModel;
            }
        }
        return ImageUtil.createColorModel(null, this.getSampleModel());
    }

    public J2KMetadata readImageMetadata() throws IOException {
        if (this.metadata == null) {
            this.metadata = new J2KMetadata();
            com.sun.medialib.codec.jp2k.Box box = null;
            Box box2 = null;
            while ((box = this.decoder.decodeBox()) != null) {
                box2 = null;
                Class clazz = Box.getBoxClass(box.type);
                if (clazz != null) {
                    try {
                        Constructor constructor = clazz.getConstructor(array$B == null ? J2KRenderedImageCodecLib.class$("[B") : array$B);
                        if (constructor != null) {
                            box2 = (Box)constructor.newInstance(new Object[]{box.data});
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            Constructor constructor = clazz.getConstructor(Integer.TYPE, array$B == null ? J2KRenderedImageCodecLib.class$("[B") : array$B);
                            if (constructor != null) {
                                box2 = (Box)constructor.newInstance(new Integer(box.type), box.data);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            box2 = this.createUnknowBox(box);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            box2 = this.createUnknowBox(box);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            box2 = this.createUnknowBox(box);
                        }
                        catch (InstantiationException instantiationException) {
                            box2 = this.createUnknowBox(box);
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        box2 = this.createUnknowBox(box);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        box2 = this.createUnknowBox(box);
                    }
                    catch (InstantiationException instantiationException) {
                        box2 = this.createUnknowBox(box);
                    }
                } else if (box.data != null) {
                    box2 = this.createUnknowBox(box);
                }
                if (box2 == null) continue;
                this.metadata.addNode(box2);
            }
        }
        return this.metadata;
    }

    private Box createUnknowBox(com.sun.medialib.codec.jp2k.Box box) {
        return new Box(8 + box.data.length, box.type, box.data);
    }
}

