/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriter;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkInt;

public class RenderedImageSrc
implements BlkImgDataSrc {
    private int w;
    private int h;
    int tileWidth;
    int tileHeight;
    int tileXOffset;
    int tileYOffset;
    int scaleX;
    int scaleY;
    int xOffset;
    int yOffset;
    int[] sourceBands = null;
    int minX;
    int minY;
    private int nc;
    private int rb;
    private int[][] barr = null;
    private DataBlkInt dbi = new DataBlkInt();
    private byte[] buf;
    private DataBlkInt intBlk;
    private RenderedImage src;
    private J2KImageWriteParamJava param;
    private Raster raster;
    private Raster aTile;
    private Point co = new Point();
    private int dcOffset = 0;
    private boolean isBinary = false;
    private Rectangle destinationRegion;
    private Rectangle sourceRegion;
    private ColorModel cm;
    private SampleModel sm;
    private boolean noTransform = true;
    private boolean noSubband = true;
    private J2KImageWriter writer;
    private boolean inputIsRaster = false;

    public RenderedImageSrc(Raster raster, J2KImageWriteParamJava j2KImageWriteParamJava, J2KImageWriter j2KImageWriter) {
        this.raster = raster;
        this.param = j2KImageWriteParamJava;
        this.writer = j2KImageWriter;
        this.inputIsRaster = true;
        this.sourceRegion = j2KImageWriteParamJava.getSourceRegion();
        this.sourceRegion = this.sourceRegion == null ? new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight()) : this.sourceRegion.intersection(raster.getBounds());
        if (this.sourceRegion.isEmpty()) {
            throw new RuntimeException(I18N.getString("J2KImageWriterCodecLib0"));
        }
        this.sm = raster.getSampleModel();
        this.getFromParam();
        this.setSampleModelAndMore();
        this.setTile(0, 0);
    }

    public RenderedImageSrc(RenderedImage renderedImage, J2KImageWriteParamJava j2KImageWriteParamJava, J2KImageWriter j2KImageWriter) {
        this.src = renderedImage;
        this.param = j2KImageWriteParamJava;
        this.writer = j2KImageWriter;
        this.sourceRegion = j2KImageWriteParamJava.getSourceRegion();
        this.sourceRegion = this.sourceRegion == null ? new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight()) : this.sourceRegion.intersection(new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight()));
        if (this.sourceRegion.isEmpty()) {
            throw new RuntimeException(I18N.getString("J2KImageWriterCodecLib0"));
        }
        this.sm = renderedImage.getSampleModel();
        this.cm = renderedImage.getColorModel();
        this.getFromParam();
        this.setSampleModelAndMore();
    }

    private void getFromParam() {
        try {
            this.tileWidth = this.param.getTileWidth();
            this.tileHeight = this.param.getTileHeight();
            this.tileXOffset = this.param.getTileGridXOffset();
            this.tileYOffset = this.param.getTileGridYOffset();
        }
        catch (IllegalStateException illegalStateException) {
            this.param.setTilingMode(2);
            if (this.inputIsRaster) {
                this.param.setTiling(this.raster.getWidth(), this.raster.getHeight(), this.raster.getMinX(), this.raster.getMinY());
            } else {
                this.param.setTiling(this.src.getWidth(), this.src.getHeight(), this.src.getMinX(), this.src.getMinY());
            }
            this.tileWidth = this.param.getTileWidth();
            this.tileHeight = this.param.getTileHeight();
            this.tileXOffset = this.param.getTileGridXOffset();
            this.tileYOffset = this.param.getTileGridYOffset();
        }
        this.scaleX = this.param.getSourceXSubsampling();
        this.scaleY = this.param.getSourceYSubsampling();
        this.xOffset = this.param.getSubsamplingXOffset();
        this.yOffset = this.param.getSubsamplingYOffset();
        this.sourceRegion.translate(this.xOffset, this.yOffset);
        this.sourceRegion.width -= this.xOffset;
        this.sourceRegion.height -= this.yOffset;
        this.xOffset = this.sourceRegion.x % this.scaleX;
        this.yOffset = this.sourceRegion.y % this.scaleY;
        this.minX = this.sourceRegion.x / this.scaleX;
        this.minY = this.sourceRegion.y / this.scaleY;
        this.w = (this.sourceRegion.width + this.scaleX - 1) / this.scaleX;
        this.h = (this.sourceRegion.height + this.scaleY - 1) / this.scaleY;
        this.tileXOffset += (this.minX - this.tileXOffset) / this.tileWidth * this.tileWidth;
        this.tileYOffset += (this.minY - this.tileYOffset) / this.tileHeight * this.tileHeight;
        this.destinationRegion = new Rectangle(this.minX, this.minY, this.w, this.h);
        if (!this.destinationRegion.equals(this.sourceRegion) || this.tileWidth != this.sm.getWidth() || this.tileHeight != this.sm.getHeight() || !this.inputIsRaster && (this.tileXOffset != this.src.getTileGridXOffset() || this.tileYOffset != this.src.getTileGridYOffset()) || this.inputIsRaster && (this.tileXOffset != this.raster.getMinX() || this.tileYOffset != this.raster.getMinY())) {
            this.noTransform = false;
        }
    }

    private void setSampleModelAndMore() {
        int n2;
        this.nc = this.sm.getNumBands();
        this.sourceBands = this.param.getSourceBands();
        if (this.sourceBands != null) {
            this.sm = this.sm.createSubsetSampleModel(this.sourceBands);
            this.noSubband = false;
        } else {
            this.sourceBands = new int[this.nc];
            for (n2 = 0; n2 < this.nc; ++n2) {
                this.sourceBands[n2] = n2;
            }
        }
        this.sm = this.sm.createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        this.nc = this.sm.getNumBands();
        this.isBinary = ImageUtil.isBinary(this.sm);
        if (this.cm != null) {
            this.rb = this.cm.getComponentSize(0);
            for (n2 = 1; n2 < this.cm.getNumComponents(); ++n2) {
                if (this.rb >= this.cm.getComponentSize(n2)) continue;
                this.rb = this.cm.getComponentSize(n2);
            }
        } else {
            this.rb = this.sm.getSampleSize(0);
            for (n2 = 1; n2 < this.sm.getNumBands(); ++n2) {
                if (this.rb >= this.sm.getSampleSize(n2)) continue;
                this.rb = this.sm.getSampleSize(n2);
            }
        }
        if (!this.isOrigSigned(0) && this.rb > 1) {
            this.dcOffset = 1 << this.rb - 1;
        }
    }

    public int getTilePartULX() {
        return this.tileXOffset;
    }

    public int getTilePartULY() {
        return this.tileYOffset;
    }

    public int getTileWidth() {
        int n2 = this.tileWidth;
        int n3 = this.co.x * this.tileWidth + this.tileXOffset;
        int n4 = this.getImgULX() + this.getImgWidth();
        if (n3 + this.tileWidth >= n4) {
            n2 = n4 - n3;
        }
        return n2;
    }

    public int getTileHeight() {
        int n2 = this.tileHeight;
        int n3 = this.co.y * this.tileHeight + this.tileYOffset;
        int n4 = this.getImgULY() + this.getImgHeight();
        if (n3 + this.tileHeight >= n4) {
            n2 = n4 - n3;
        }
        return n2;
    }

    public int getNomTileWidth() {
        return this.tileWidth;
    }

    public int getNomTileHeight() {
        return this.tileHeight;
    }

    public int getImgWidth() {
        return this.w;
    }

    public int getImgHeight() {
        return this.h;
    }

    public int getNumComps() {
        return this.nc;
    }

    public int getTileGridXOffset() {
        return this.param.getTileGridXOffset();
    }

    public int getTileGridYOffset() {
        return this.param.getTileGridYOffset();
    }

    public int getTileCompHeight(int n2, int n3) {
        return this.tileHeight;
    }

    public int getTileCompWidth(int n2, int n3) {
        return this.tileWidth;
    }

    public int getCompSubsX(int n2) {
        return 1;
    }

    public int getCompSubsY(int n2) {
        return 1;
    }

    public int getCompWidth(int n2) {
        return this.w;
    }

    public int getCompHeight(int n2) {
        return this.h;
    }

    public int getCompImgWidth(int n2) {
        return this.w;
    }

    public int getCompImgHeight(int n2) {
        return this.h;
    }

    public void setTile(int n2, int n3) {
        if (n2 >= this.getNumXTiles()) {
            n3 += n2 / this.getNumXTiles();
            n2 %= this.getNumXTiles();
        }
        this.co.x = n2;
        this.co.y = n3;
        this.aTile = null;
    }

    public void nextTile() {
        ++this.co.x;
        if (this.co.x >= this.getNumXTiles()) {
            this.co.x = 0;
            ++this.co.y;
        }
        this.setTile(this.co.x, this.co.y);
    }

    public Point getTile(Point point) {
        if (point != null) {
            return point;
        }
        return new Point(0, 0);
    }

    public int getTileIdx() {
        return this.getNumXTiles() * this.co.y + this.co.x;
    }

    public Point getTileOff(Point point, int n2) {
        if (point != null) {
            point.x = this.co.x * this.tileWidth + this.tileXOffset;
            point.y = this.co.y * this.tileHeight + this.tileYOffset;
            return this.co;
        }
        return new Point(this.co.x * this.tileWidth + this.tileXOffset, this.co.y * this.tileHeight + this.tileYOffset);
    }

    public int getCompULX(int n2) {
        return this.raster.getMinX();
    }

    public int getCompULY(int n2) {
        return this.raster.getMinY();
    }

    public int getImgULX() {
        return this.destinationRegion.x;
    }

    public int getImgULY() {
        return this.destinationRegion.y;
    }

    public Point getNumTiles(Point point) {
        if (point != null) {
            point.x = this.getNumXTiles();
            point.y = this.getNumYTiles();
            return point;
        }
        return new Point(this.getNumXTiles(), this.getNumYTiles());
    }

    public int getNumTiles() {
        return this.getNumXTiles() * this.getNumYTiles();
    }

    public int getNomRangeBits(int n2) {
        return this.rb;
    }

    public int getFixedPoint(int n2) {
        return 0;
    }

    public final DataBlk getInternCompData(DataBlk dataBlk, int n2) {
        if (this.writer != null && this.writer.getAbortRequest()) {
            throw new RuntimeException(J2KImageWriter.WRITE_ABORTED);
        }
        if (this.barr == null) {
            this.barr = new int[this.nc][];
        }
        if (dataBlk.getDataType() != 3) {
            if (this.intBlk == null) {
                this.intBlk = new DataBlkInt(dataBlk.ulx, dataBlk.uly, dataBlk.w, dataBlk.h);
            } else {
                this.intBlk.ulx = dataBlk.ulx;
                this.intBlk.uly = dataBlk.uly;
                this.intBlk.w = dataBlk.w;
                this.intBlk.h = dataBlk.h;
            }
            dataBlk = this.intBlk;
        }
        float f2 = ((float)this.getTileIdx() + ((float)dataBlk.uly + 1.0f) / (float)dataBlk.h) / (float)this.getNumTiles();
        this.writer.processImageProgressWrapper(f2 * 100.0f);
        if (this.barr[n2] == null || this.dbi.ulx > dataBlk.ulx || this.dbi.uly > dataBlk.uly || this.dbi.ulx + this.dbi.w < dataBlk.ulx + dataBlk.w || this.dbi.uly + this.dbi.h < dataBlk.uly + dataBlk.h) {
            if (this.barr[n2] == null || this.barr[n2].length < dataBlk.w * dataBlk.h) {
                this.barr[n2] = new int[dataBlk.w * dataBlk.h];
            }
            dataBlk.setData((Object)this.barr[n2]);
            int n3 = (n2 + 1) % this.nc;
            while (n3 != n2) {
                if (this.barr[n3] == null || this.barr[n3].length < dataBlk.w * dataBlk.h) {
                    this.barr[n3] = new int[dataBlk.w * dataBlk.h];
                }
                n3 = (n3 + 1) % this.nc;
            }
            this.dbi.ulx = dataBlk.ulx;
            this.dbi.uly = dataBlk.uly;
            this.dbi.w = dataBlk.w;
            this.dbi.h = dataBlk.h;
            if (this.aTile == null) {
                this.aTile = this.getTile(this.co.x, this.co.y);
                Rectangle rectangle = this.aTile.getBounds();
                this.aTile = this.aTile.createTranslatedChild(rectangle.x - this.minX, rectangle.y - this.minY);
            }
            for (n3 = 0; n3 < this.nc; ++n3) {
                this.aTile.getSamples(dataBlk.ulx, dataBlk.uly, dataBlk.w, dataBlk.h, n3, this.barr[n3]);
                int n4 = 0;
                while (n4 < this.barr[n3].length) {
                    int[] nArray = this.barr[n3];
                    int n5 = n4++;
                    nArray[n5] = nArray[n5] - this.dcOffset;
                }
            }
            dataBlk.setData((Object)this.barr[n2]);
            dataBlk.offset = 0;
            dataBlk.scanw = dataBlk.w;
        } else {
            dataBlk.setData((Object)this.barr[n2]);
            dataBlk.offset = (dataBlk.ulx - this.dbi.ulx) * this.dbi.w + dataBlk.ulx - this.dbi.ulx;
            dataBlk.scanw = this.dbi.scanw;
        }
        dataBlk.progressive = false;
        return dataBlk;
    }

    public final DataBlk getCompData(DataBlk object, int n2) {
        Object object2;
        if (object.getDataType() != 3) {
            object2 = new DataBlkInt(object.ulx, object.uly, object.w, object.h);
            object = object2;
        }
        object2 = (int[])object.getData();
        int n3 = object.ulx;
        int n4 = object.uly;
        int n5 = object.w;
        int n6 = object.h;
        object.setData(null);
        this.getInternCompData((DataBlk)object, n2);
        if (object2 == null) {
            object2 = new int[n5 * n6];
        }
        if (object.offset == 0 && object.scanw == n5) {
            System.arraycopy(object.getData(), 0, object2, 0, n5 * n6);
        } else {
            for (int i2 = n6 - 1; i2 >= 0; --i2) {
                System.arraycopy(object.getData(), object.offset + i2 * object.scanw, object2, i2 * n5, n5);
            }
        }
        object.setData(object2);
        object.offset = 0;
        object.scanw = object.w;
        return object;
    }

    public boolean isOrigSigned(int n2) {
        if (this.isBinary) {
            return true;
        }
        SampleModel sampleModel = null;
        sampleModel = this.inputIsRaster ? this.raster.getSampleModel() : this.src.getSampleModel();
        return sampleModel.getDataType() != 1 && sampleModel.getDataType() != 0;
    }

    private int getNumXTiles() {
        int n2 = this.destinationRegion.x;
        int n3 = this.tileXOffset;
        int n4 = this.tileWidth;
        return RenderedImageSrc.ToTile(n2 + this.destinationRegion.width - 1, n3, n4) - RenderedImageSrc.ToTile(n2, n3, n4) + 1;
    }

    private int getNumYTiles() {
        int n2 = this.destinationRegion.y;
        int n3 = this.tileYOffset;
        int n4 = this.tileHeight;
        return RenderedImageSrc.ToTile(n2 + this.destinationRegion.height - 1, n3, n4) - RenderedImageSrc.ToTile(n2, n3, n4) + 1;
    }

    private static int ToTile(int n2, int n3, int n4) {
        if ((n2 -= n3) < 0) {
            n2 += 1 - n4;
        }
        return n2 / n4;
    }

    private Raster getTile(int n2, int n3) {
        int n4 = this.tileXOffset + n2 * this.tileWidth;
        int n5 = this.tileYOffset + n3 * this.tileHeight;
        n2 += this.tileXOffset / this.tileWidth;
        n3 += this.tileYOffset / this.tileHeight;
        if (this.inputIsRaster) {
            if (this.noTransform) {
                return this.raster.createChild(n4, n5, this.getTileWidth(), this.getTileHeight(), n4, n5, this.sourceBands);
            }
            WritableRaster writableRaster = Raster.createWritableRaster(this.sm, new Point(n4, n5));
            int n6 = this.mapToSourceX(n4);
            int n7 = this.mapToSourceY(n5);
            int n8 = this.raster.getMinY();
            int n9 = this.raster.getMinY() + this.raster.getHeight();
            int n10 = this.getTileWidth();
            int n11 = 0;
            while (n11 < this.getTileHeight()) {
                if (n7 >= n8 && n7 < n9) {
                    Raster raster = this.raster.createChild(n6, n7, (n10 - 1) * this.scaleX + 1, 1, n6, n7, null);
                    int n12 = n4;
                    int n13 = 0;
                    int n14 = n6;
                    while (n13 < n10) {
                        for (int i2 = 0; i2 < this.nc; ++i2) {
                            int n15 = raster.getSample(n14, n7, this.sourceBands[i2]);
                            writableRaster.setSample(n12, n5, i2, n15);
                        }
                        ++n13;
                        ++n12;
                        n14 += this.scaleX;
                    }
                }
                ++n11;
                ++n5;
                n7 += this.scaleY;
            }
            return writableRaster;
        }
        if (this.noTransform) {
            Raster raster = this.src.getTile(n2, n3);
            if (this.noSubband) {
                return raster;
            }
            return raster.createChild(n4, n5, this.tileWidth, this.tileHeight, n4, n5, this.sourceBands);
        }
        WritableRaster writableRaster = Raster.createWritableRaster(this.sm, new Point(n4, n5));
        int n16 = this.mapToSourceX(n4);
        int n17 = this.mapToSourceY(n5);
        int n18 = this.src.getMinY();
        int n19 = this.src.getMinY() + this.src.getHeight();
        int n20 = this.tileWidth * this.scaleX;
        if (n16 + n20 >= this.src.getWidth()) {
            n20 = this.src.getWidth() - n16;
        }
        int n21 = (n20 + this.scaleX - 1) / this.scaleX;
        int n22 = 0;
        while (n22 < this.tileHeight) {
            if (n17 >= n18 && n17 < n19) {
                Raster raster = this.src.getData(new Rectangle(n16, n17, n20, 1));
                int n23 = n4;
                int n24 = 0;
                int n25 = n16;
                while (n24 < n21) {
                    for (int i3 = 0; i3 < this.nc; ++i3) {
                        int n26 = raster.getSample(n25, n17, this.sourceBands[i3]);
                        writableRaster.setSample(n23, n5, i3, n26);
                    }
                    ++n24;
                    ++n23;
                    n25 += this.scaleX;
                }
            }
            ++n22;
            ++n5;
            n17 += this.scaleY;
        }
        return writableRaster;
    }

    private int mapToSourceX(int n2) {
        return n2 * this.scaleX + this.xOffset;
    }

    private int mapToSourceY(int n2) {
        return n2 * this.scaleY + this.yOffset;
    }
}

