/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UUIDBox
extends Box {
    private static String[] elementNames = new String[]{"UUID", "Data"};
    private byte[] uuid;
    private byte[] udata;

    public static String[] getElementNames() {
        return elementNames;
    }

    public UUIDBox(byte[] byArray) {
        super(8 + byArray.length, 1970628964, byArray);
    }

    public UUIDBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node2 = nodeList.item(i2);
            String string = node2.getNodeName();
            if ("UUID".equals(string)) {
                this.uuid = Box.getByteArrayElementValue(node2);
            }
            if (!"Data".equals(string)) continue;
            this.udata = Box.getByteArrayElementValue(node2);
        }
    }

    protected void parse(byte[] byArray) {
        this.uuid = new byte[16];
        System.arraycopy(byArray, 0, this.uuid, 0, 16);
        this.udata = new byte[byArray.length - 16];
        System.arraycopy(byArray, 16, this.udata, 0, this.udata.length);
    }

    public byte[] getUUID() {
        return this.uuid;
    }

    public byte[] getData() {
        return this.udata;
    }

    public IIOMetadataNode getNativeNode() {
        return this.getNativeNodeForSimpleBox();
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[16 + this.udata.length];
        System.arraycopy(this.uuid, 0, this.data, 0, 16);
        System.arraycopy(this.udata, 0, this.data, 16, this.udata.length);
    }
}

