/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UUIDListBox
extends Box {
    private short num;
    private byte[][] uuids;

    public UUIDListBox(short s2, byte[][] byArray) {
        super(10 + (byArray.length << 4), 1970041716, null);
        this.num = s2;
        this.uuids = byArray;
    }

    public UUIDListBox(byte[] byArray) {
        super(8 + byArray.length, 1970041716, byArray);
    }

    public UUIDListBox(Node node) throws IIOInvalidTreeException {
        super(node);
        Node node2;
        int n2;
        NodeList nodeList = node.getChildNodes();
        int n3 = 0;
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            node2 = nodeList.item(n2);
            if (!"NumberUUID".equals(node2.getNodeName())) continue;
            this.num = Box.getShortElementValue(node2);
            this.uuids = new byte[this.num][];
        }
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            node2 = nodeList.item(n2);
            if (!"UUID".equals(node2.getNodeName()) || n3 >= this.num) continue;
            this.uuids[n3++] = Box.getByteArrayElementValue(node2);
        }
    }

    protected void parse(byte[] byArray) {
        this.num = (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        this.uuids = new byte[this.num][];
        int n2 = 2;
        for (int i2 = 0; i2 < this.num; ++i2) {
            this.uuids[i2] = new byte[16];
            System.arraycopy(byArray, n2, this.uuids[i2], 0, 16);
            n2 += 16;
        }
    }

    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(Box.getName(this.getType()));
        this.setDefaultAttributes(iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("NumberUUID");
        iIOMetadataNode2.setUserObject(new Short(this.num));
        iIOMetadataNode2.setNodeValue("" + this.num);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        for (int i2 = 0; i2 < this.num; ++i2) {
            iIOMetadataNode2 = new IIOMetadataNode("UUID");
            iIOMetadataNode2.setUserObject(this.uuids[i2]);
            iIOMetadataNode2.setNodeValue(ImageUtil.convertObjectToString(this.uuids[i2]));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[2 + this.num * 16];
        this.data[0] = (byte)(this.num >> 8);
        this.data[1] = (byte)(this.num & 0xFF);
        int n2 = 2;
        for (int i2 = 0; i2 < this.num; ++i2) {
            System.arraycopy(this.uuids[i2], 0, this.data, n2, 16);
            n2 += 16;
        }
    }
}

