/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.pcx;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.pcx.PCXImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class PCXImageReaderSpi
extends ImageReaderSpi {
    private static String[] writerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.pcx.PCXImageWriterSpi"};
    private static String[] formatNames = new String[]{"pcx", "PCX"};
    private static String[] extensions = new String[]{"pcx"};
    private static String[] mimeTypes = new String[]{"image/pcx", "image/x-pcx", "image/x-windows-pcx", "image/x-pc-paintbrush"};
    private boolean registered = false;

    public PCXImageReaderSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), formatNames, extensions, mimeTypes, "com.sun.media.imageioimpl.plugins.pcx.PCXImageReader", STANDARD_INPUT_TYPE, writerSpiNames, false, null, null, null, null, true, null, null, null, null);
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
    }

    public String getDescription(Locale locale) {
        String string = PackageUtil.getSpecificationTitle() + " PCX Image Reader";
        return string;
    }

    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        byte by2 = imageInputStream.readByte();
        imageInputStream.reset();
        return by2 == 10;
    }

    public ImageReader createReaderInstance(Object object) throws IIOException {
        return new PCXImageReader(this);
    }
}

