/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.plugins.clib.CLibImageReader;
import com.sun.media.imageioimpl.plugins.png.CLibPNGMetadata;
import com.sun.media.imageioimpl.plugins.png.I18N;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.png.Decoder;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;

final class CLibPNGImageReader
extends CLibImageReader {
    private Decoder decoder;
    private HashMap imageTypes = new HashMap();

    CLibPNGImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected final synchronized mediaLibImage decode(InputStream inputStream) throws IOException {
        try {
            this.decoder = new Decoder(inputStream);
            this.decoder.decode();
        }
        catch (Throwable throwable) {
            throw new IIOException("codecLib error", throwable);
        }
        mediaLibImage mediaLibImage2 = null;
        try {
            mediaLibImage2 = this.decoder.getImage();
        }
        catch (Throwable throwable) {
            throw new IIOException("codecLib error", throwable);
        }
        if (mediaLibImage2 == null) {
            throw new IIOException(I18N.getString("CLibPNGImageReader0"));
        }
        return mediaLibImage2;
    }

    public synchronized Iterator getImageTypes(int n2) throws IOException {
        this.seekToImage(n2);
        ArrayList arrayList = null;
        Integer n3 = new Integer(n2);
        if (this.imageTypes.containsKey(n3)) {
            arrayList = (ArrayList)this.imageTypes.get(n3);
        } else {
            arrayList = new ArrayList();
            mediaLibImage mediaLibImage2 = this.getImage(n2);
            byte[] byArray = null;
            try {
                byArray = this.decoder.getPalette();
            }
            catch (Throwable throwable) {
                throw new IIOException("codecLib error", throwable);
            }
            if (byArray != null) {
                int n4 = byArray.length / 3;
                byte[] byArray2 = new byte[n4];
                byte[] byArray3 = new byte[n4];
                byte[] byArray4 = new byte[n4];
                int n5 = 0;
                for (int i2 = 0; i2 < n4; ++i2) {
                    byArray2[i2] = byArray[n5++];
                    byArray3[i2] = byArray[n5++];
                    byArray4[i2] = byArray[n5++];
                }
                int[] nArray = null;
                try {
                    nArray = this.decoder.getTransparency();
                }
                catch (Throwable throwable) {
                    throw new IIOException("codecLib error", throwable);
                }
                byte[] byArray5 = null;
                if (nArray != null) {
                    int n6;
                    byArray5 = new byte[n4];
                    for (n6 = 0; n6 < nArray.length; ++n6) {
                        byArray5[n6] = (byte)(nArray[n6] & 0xFF);
                    }
                    for (n6 = nArray.length; n6 < n4; ++n6) {
                        byArray5[n6] = -1;
                    }
                }
                arrayList.add(CLibPNGImageReader.createImageType(mediaLibImage2, null, this.decoder.getBitDepth(), byArray2, byArray3, byArray4, byArray5));
            } else {
                Object object;
                byte[] byArray6;
                ICC_ColorSpace iCC_ColorSpace = null;
                if (this.decoder.getStandardRGB() == -1 && (byArray6 = this.decoder.getEmbeddedICCProfile()) != null) {
                    object = ICC_Profile.getInstance(byArray6);
                    ICC_ColorSpace iCC_ColorSpace2 = new ICC_ColorSpace((ICC_Profile)object);
                    int n7 = mediaLibImage2.getChannels();
                    if (iCC_ColorSpace2.getType() == 5 && (n7 >= 3 || byArray != null) || iCC_ColorSpace2.getType() == 6 && n7 < 3 && byArray == null) {
                        iCC_ColorSpace = iCC_ColorSpace2;
                    }
                }
                int n8 = this.decoder.getBitDepth();
                object = CLibPNGImageReader.createImageType(mediaLibImage2, iCC_ColorSpace, n8, null, null, null, null);
                arrayList.add(object);
                if (((ImageTypeSpecifier)object).getColorModel().getColorSpace().equals(iCC_ColorSpace)) {
                    arrayList.add(CLibPNGImageReader.createImageType(mediaLibImage2, null, n8, null, null, null, null));
                }
            }
            this.imageTypes.put(n3, arrayList);
        }
        return arrayList.iterator();
    }

    protected void resetLocal() {
        this.decoder = null;
        this.imageTypes.clear();
        super.resetLocal();
    }

    public synchronized IIOMetadata getImageMetadata(int n2) throws IIOException {
        if (this.input == null) {
            throw new IllegalStateException("input == null");
        }
        this.seekToImage(n2);
        CLibPNGMetadata cLibPNGMetadata = new CLibPNGMetadata();
        try {
            this.getImage(n2);
        }
        catch (IOException iOException) {
            throw new IIOException("codecLib error", iOException);
        }
        cLibPNGMetadata.readMetadata(this, this.decoder);
        return cLibPNGMetadata;
    }

    void forwardWarningMessage(String string) {
        this.processWarningOccurred(string);
    }
}

