/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.clib.CLibImageWriter;
import com.sun.media.imageioimpl.plugins.clib.OutputStreamAdapter;
import com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriteParam;
import com.sun.media.imageioimpl.plugins.png.CLibPNGMetadata;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.png.Encoder;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

final class CLibPNGImageWriter
extends CLibImageWriter {
    CLibPNGImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new CLibPNGImageWriteParam(this.getLocale());
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        CLibPNGMetadata cLibPNGMetadata = new CLibPNGMetadata();
        if (imageWriteParam != null && imageWriteParam.getDestinationType() != null) {
            imageTypeSpecifier = imageWriteParam.getDestinationType();
        }
        if (imageTypeSpecifier != null) {
            cLibPNGMetadata.initialize(imageTypeSpecifier, imageTypeSpecifier.getSampleModel().getNumBands(), imageWriteParam, 0);
        }
        return cLibPNGMetadata;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        CLibPNGMetadata cLibPNGMetadata = null;
        if (iIOMetadata instanceof CLibPNGMetadata) {
            cLibPNGMetadata = (CLibPNGMetadata)((CLibPNGMetadata)iIOMetadata).clone();
        } else {
            try {
                cLibPNGMetadata = new CLibPNGMetadata(iIOMetadata);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                cLibPNGMetadata = new CLibPNGMetadata();
            }
        }
        cLibPNGMetadata.initialize(imageTypeSpecifier, imageTypeSpecifier.getSampleModel().getNumBands(), imageWriteParam, cLibPNGMetadata.IHDR_interlaceMethod);
        return cLibPNGMetadata;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        Object object;
        int n2;
        ImageTypeSpecifier imageTypeSpecifier;
        if (this.output == null) {
            throw new IllegalStateException("output == null");
        }
        OutputStreamAdapter outputStreamAdapter = null;
        if (!(this.output instanceof ImageOutputStream)) {
            throw new IllegalArgumentException("!(output instanceof ImageOutputStream)");
        }
        outputStreamAdapter = new OutputStreamAdapter((ImageOutputStream)this.output);
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        ImageUtil.canEncodeImage(this, renderedImage.getColorModel(), renderedImage.getSampleModel());
        int[] nArray = new int[]{2, 9, 1, 4, 3, 15, 10};
        mediaLibImage mediaLibImage2 = this.getMediaLibImage(renderedImage, imageWriteParam, true, nArray);
        Encoder encoder = null;
        try {
            encoder = new Encoder(mediaLibImage2);
        }
        catch (Throwable throwable) {
            throw new IIOException("codecLib error", throwable);
        }
        encoder.setIDATSize(8192);
        if (imageWriteParam != null && imageWriteParam.getDestinationType() != null) {
            imageTypeSpecifier = imageWriteParam.getDestinationType();
        } else if (mediaLibImage2.getType() == 0) {
            if (renderedImage.getColorModel() instanceof IndexColorModel) {
                imageTypeSpecifier = new ImageTypeSpecifier(renderedImage.getColorModel(), renderedImage.getSampleModel());
            } else {
                int n3 = renderedImage.getSampleModel().getDataType();
                imageTypeSpecifier = ImageTypeSpecifier.createGrayscale(1, n3, false);
            }
        } else if (mediaLibImage2.getChannels() == renderedImage.getSampleModel().getNumBands()) {
            imageTypeSpecifier = new ImageTypeSpecifier(renderedImage);
        } else {
            SampleModel sampleModel = renderedImage.getSampleModel();
            int n4 = sampleModel.getDataType();
            int n5 = sampleModel.getSampleSize(0);
            n2 = mediaLibImage2.getChannels();
            switch (n2) {
                case 1: {
                    imageTypeSpecifier = ImageTypeSpecifier.createGrayscale(n5, n4, false);
                    break;
                }
                case 2: {
                    imageTypeSpecifier = ImageTypeSpecifier.createGrayscale(n5, n4, false, false);
                    break;
                }
                case 3: {
                    object = ColorSpace.getInstance(1000);
                    imageTypeSpecifier = ImageTypeSpecifier.createInterleaved((ColorSpace)object, new int[]{0, 1, 2}, n4, false, false);
                    break;
                }
                default: {
                    throw new IIOException("Cannot encode image with " + n2 + " bands!");
                }
            }
        }
        IIOMetadata iIOMetadata2 = iIOImage.getMetadata();
        iIOMetadata2 = iIOMetadata2 != null ? this.convertImageMetadata(iIOMetadata2, imageTypeSpecifier, imageWriteParam) : this.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
        ((CLibPNGMetadata)iIOMetadata2).writeMetadata(encoder);
        ColorModel colorModel = null;
        if (imageWriteParam != null) {
            ImageTypeSpecifier imageTypeSpecifier2 = imageWriteParam.getDestinationType();
            if (imageTypeSpecifier2 != null) {
                colorModel = imageTypeSpecifier2.getColorModel();
            }
            if (imageWriteParam.getCompressionMode() == 2) {
                try {
                    n2 = (int)(9.0f * (1.0f - imageWriteParam.getCompressionQuality()));
                    encoder.setCompressionLevel(n2);
                }
                catch (Throwable throwable) {
                    throw new IIOException("codecLib error", throwable);
                }
                if (imageWriteParam instanceof CLibPNGImageWriteParam) {
                    try {
                        encoder.setStrategy(((CLibPNGImageWriteParam)imageWriteParam).getStrategy());
                    }
                    catch (Throwable throwable) {
                        throw new IIOException("codecLib error", throwable);
                    }
                }
            }
        } else {
            try {
                encoder.setStrategy(0);
            }
            catch (Throwable throwable) {
                throw new IIOException("codecLib error", throwable);
            }
        }
        if (colorModel == null) {
            colorModel = renderedImage.getColorModel();
        }
        if (!((CLibPNGMetadata)iIOMetadata2).iCCP_present && colorModel != null && ImageUtil.isNonStandardICCColorSpace(colorModel.getColorSpace())) {
            String string;
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)colorModel.getColorSpace();
            ICC_Profile iCC_Profile = iCC_ColorSpace.getProfile();
            object = iCC_ColorSpace.getProfile().getData();
            byte[] byArray = iCC_Profile.getData(1684370275);
            if (byArray != null) {
                long l2 = (byArray[8] & 0xFF) << 24 | (byArray[9] & 0xFF) << 16 | (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF;
                string = new String(byArray, 12, (int)l2);
            } else {
                string = "ICCProfile";
            }
            string = CLibPNGMetadata.toPrintableLatin1(string);
            encoder.setEmbeddedICCProfile(string, (byte[])object);
        }
        try {
            encoder.encode((OutputStream)outputStreamAdapter);
        }
        catch (Throwable throwable) {
            throw new IIOException("codecLib error", throwable);
        }
    }
}

