/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class CLibPNGImageWriterSpi
extends ImageWriterSpi {
    private static final String[] names = new String[]{"png", "PNG"};
    private static final String[] suffixes = new String[]{"png"};
    private static final String[] MIMETypes = new String[]{"image/png", "image/x-png"};
    private static final String writerClassName = "com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter";
    private static final String[] readerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.png.CLibPNGImageReaderSpi"};
    private boolean registered = false;

    public CLibPNGImageWriterSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), names, suffixes, MIMETypes, writerClassName, STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, true, "javax_imageio_png_1.0", "com.sun.media.imageioimpl.plugins.png.CLibPNGMetadataFormat", null, null);
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
        if (!PackageUtil.isCodecLibAvailable()) {
            serviceRegistry.deregisterServiceProvider(this);
        } else {
            List list = ImageUtil.getJDKImageReaderWriterSPI(serviceRegistry, "PNG", false);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                serviceRegistry.setOrdering(clazz, this, list.get(i2));
            }
        }
    }

    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        boolean bl2;
        int n2;
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        ColorModel colorModel = imageTypeSpecifier.getColorModel();
        int[] nArray = sampleModel.getSampleSize();
        int n3 = nArray[0];
        for (n2 = 1; n2 < nArray.length; ++n2) {
            if (nArray[n2] == n3) continue;
            return false;
        }
        if (n3 != 1 && n3 != 8 && n3 != 16) {
            return false;
        }
        n2 = sampleModel.getNumBands();
        if (n2 < 1 || n2 > 4) {
            return false;
        }
        if (colorModel instanceof IndexColorModel) {
            return true;
        }
        boolean bl3 = bl2 = colorModel != null && colorModel.hasAlpha();
        if ((n2 == 1 || n2 == 3) && bl2) {
            return false;
        }
        return n2 != 2 && n2 != 4 || bl2;
    }

    public String getDescription(Locale locale) {
        String string = PackageUtil.getSpecificationTitle() + " natively-accelerated PNG Image Writer";
        return string;
    }

    public ImageWriter createWriterInstance(Object object) {
        return new CLibPNGImageWriter(this);
    }
}

