/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.pnm;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.pnm.I18N;
import com.sun.media.imageioimpl.plugins.pnm.PNMMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import sun.security.action.GetPropertyAction;

public class PNMImageReader
extends ImageReader {
    private static final int PBM_ASCII = 49;
    private static final int PGM_ASCII = 50;
    private static final int PPM_ASCII = 51;
    private static final int PBM_RAW = 52;
    private static final int PGM_RAW = 53;
    private static final int PPM_RAW = 54;
    private static final int LINE_FEED = 10;
    private static byte[] lineSeparator;
    private int variant;
    private int maxValue;
    private ImageInputStream iis = null;
    private boolean gotHeader = false;
    private long imageDataOffset;
    private int width;
    private int height;
    private String aLine;
    private StringTokenizer token;
    private PNMMetadata metadata;

    public PNMImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public void setInput(Object object, boolean bl2, boolean bl3) {
        super.setInput(object, bl2, bl3);
        this.iis = (ImageInputStream)object;
    }

    public int getNumImages(boolean bl2) throws IOException {
        return 1;
    }

    public int getWidth(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        return this.width;
    }

    public int getHeight(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        return this.height;
    }

    public int getVariant() {
        return this.variant;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    private void checkIndex(int n2) {
        if (n2 != 0) {
            throw new IndexOutOfBoundsException(I18N.getString("PNMImageReader1"));
        }
    }

    public synchronized void readHeader() throws IOException {
        if (this.gotHeader) {
            this.iis.seek(this.imageDataOffset);
            return;
        }
        if (this.iis != null) {
            if (this.iis.readByte() != 80) {
                throw new RuntimeException(I18N.getString("PNMImageReader0"));
            }
            this.variant = this.iis.readByte();
            if (this.variant < 49 || this.variant > 54) {
                throw new RuntimeException(I18N.getString("PNMImageReader0"));
            }
            this.metadata = new PNMMetadata();
            this.metadata.setVariant(this.variant);
            this.iis.readLine();
            this.readComments(this.iis, this.metadata);
            this.width = this.readInteger(this.iis);
            this.height = this.readInteger(this.iis);
            this.maxValue = this.variant == 49 || this.variant == 52 ? 1 : this.readInteger(this.iis);
            this.metadata.setWidth(this.width);
            this.metadata.setHeight(this.height);
            this.metadata.setMaxBitDepth(this.maxValue);
            this.gotHeader = true;
            this.imageDataOffset = this.iis.getStreamPosition();
        }
    }

    public Iterator getImageTypes(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        int n3 = (this.variant - 49) % 3;
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        int n4 = 3;
        if (this.maxValue < 256) {
            n4 = 0;
        } else if (this.maxValue < 65536) {
            n4 = 1;
        }
        SampleModel sampleModel = null;
        ColorModel colorModel = null;
        if (this.variant == 49 || this.variant == 52) {
            sampleModel = new MultiPixelPackedSampleModel(0, this.width, this.height, 1);
            byte[] byArray = new byte[]{-1, 0};
            colorModel = new IndexColorModel(1, 2, byArray, byArray, byArray);
        } else {
            int[] nArray;
            int n5 = n3 == 1 ? 1 : 3;
            int n6 = this.width * (n3 == 1 ? 1 : 3);
            if (n3 == 1) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = 0;
                nArray3[1] = 1;
                nArray = nArray3;
                nArray3[2] = 2;
            }
            sampleModel = new PixelInterleavedSampleModel(n4, this.width, this.height, n5, n6, nArray);
            colorModel = ImageUtil.createColorModel(null, sampleModel);
        }
        arrayList.add(new ImageTypeSpecifier(colorModel, sampleModel));
        return arrayList.iterator();
    }

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    public IIOMetadata getImageMetadata(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        return this.metadata;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public boolean isRandomAccessEasy(int n2) throws IOException {
        this.checkIndex(n2);
        return true;
    }

    public BufferedImage read(int n2, ImageReadParam imageReadParam) throws IOException {
        Object object;
        block77: {
            int n3;
            boolean bl2;
            this.checkIndex(n2);
            this.clearAbortRequest();
            this.processImageStarted(n2);
            if (imageReadParam == null) {
                imageReadParam = this.getDefaultReadParam();
            }
            this.readHeader();
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
            PNMImageReader.computeRegions(imageReadParam, this.width, this.height, imageReadParam.getDestination(), rectangle, rectangle2);
            int n4 = imageReadParam.getSourceXSubsampling();
            int n5 = imageReadParam.getSourceYSubsampling();
            int[] nArray = imageReadParam.getSourceBands();
            int[] nArray2 = imageReadParam.getDestinationBands();
            boolean bl3 = nArray != null && nArray2 != null;
            boolean bl4 = bl2 = rectangle2.equals(new Rectangle(0, 0, this.width, this.height)) || bl3;
            if (this.isRaw(this.variant) && this.maxValue >= 256) {
                this.maxValue = 255;
            }
            int n6 = 1;
            if (this.variant == 51 || this.variant == 54) {
                n6 = 3;
            }
            if (!bl3) {
                nArray = new int[n6];
                nArray2 = new int[n6];
                for (n3 = 0; n3 < n6; ++n3) {
                    nArray2[n3] = nArray[n3] = n3;
                }
            }
            n3 = 3;
            if (this.maxValue < 256) {
                n3 = 0;
            } else if (this.maxValue < 65536) {
                n3 = 1;
            }
            SampleModel sampleModel = null;
            ColorModel colorModel = null;
            if (this.variant == 49 || this.variant == 52) {
                sampleModel = new MultiPixelPackedSampleModel(0, rectangle2.width, rectangle2.height, 1);
                object = new byte[]{-1, 0};
                colorModel = new IndexColorModel(1, 2, (byte[])object, (byte[])object, (byte[])object);
            } else {
                sampleModel = new PixelInterleavedSampleModel(n3, rectangle2.width, rectangle2.height, nArray.length, rectangle2.width * nArray.length, nArray2);
                colorModel = ImageUtil.createColorModel(null, sampleModel);
            }
            object = imageReadParam.getDestination();
            WritableRaster writableRaster = null;
            if (object == null) {
                sampleModel = sampleModel.createCompatibleSampleModel(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
                if (bl3) {
                    sampleModel = sampleModel.createSubsetSampleModel(nArray);
                }
                writableRaster = Raster.createWritableRaster(sampleModel, new Point());
                object = new BufferedImage(colorModel, writableRaster, false, null);
            } else {
                writableRaster = ((BufferedImage)object).getWritableTile(0, 0);
                sampleModel = ((BufferedImage)object).getSampleModel();
                colorModel = ((BufferedImage)object).getColorModel();
                bl2 &= rectangle2.equals(writableRaster.getBounds());
            }
            block0 : switch (this.variant) {
                case 52: {
                    DataBuffer dataBuffer = writableRaster.getDataBuffer();
                    byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                    if (bl2) {
                        this.iis.readFully(byArray, 0, byArray.length);
                        this.processImageUpdate((BufferedImage)object, 0, 0, this.width, this.height, 1, 1, nArray2);
                        this.processImageProgress(100.0f);
                        break;
                    }
                    if (n4 == 1 && rectangle.x % 8 == 0) {
                        int n7 = rectangle.x >> 3;
                        int n8 = this.width + 7 >> 3;
                        int n9 = writableRaster.getWidth() + 7 >> 3;
                        int n10 = rectangle.width + 7 >> 3;
                        int n11 = rectangle.y * n8;
                        this.iis.skipBytes(n11 + n7);
                        n11 = n8 * (n5 - 1) + n8 - n10;
                        byte[] byArray2 = new byte[n10];
                        int n12 = rectangle2.x & 7;
                        boolean bl5 = n12 != 0;
                        int n13 = 0;
                        int n14 = 0;
                        int n15 = rectangle2.y * n9 + (rectangle2.x >> 3);
                        while (n13 < rectangle2.height) {
                            if (bl5) {
                                this.iis.read(byArray2, 0, n10);
                                int n16 = 255 << n12 & 0xFF;
                                int n17 = ~n16 & 0xFF;
                                int n18 = 8 - n12;
                                int n19 = 0;
                                int n20 = n15;
                                while (n19 < n10 - 1) {
                                    byArray[n20] = (byte)((byArray2[n19] & n17) << n18 | (byArray2[n19 + 1] & n16) >> n12);
                                    ++n19;
                                    ++n20;
                                }
                                byArray[n20] = (byte)((byArray2[n19] & n17) << n18);
                            } else {
                                this.iis.read(byArray, n15, n10);
                            }
                            this.iis.skipBytes(n11);
                            n15 += n9;
                            this.processImageUpdate((BufferedImage)object, 0, n13, rectangle2.width, 1, 1, 1, nArray2);
                            this.processImageProgress(100.0f * (float)n13 / (float)rectangle2.height);
                            ++n13;
                            n14 += n5;
                        }
                    } else {
                        int n21 = this.width + 7 >> 3;
                        byte[] byArray3 = new byte[n21];
                        this.iis.skipBytes(rectangle.y * n21);
                        int n22 = ((BufferedImage)object).getWidth() + 7 >> 3;
                        int n23 = n21 * (n5 - 1);
                        int n24 = n22 * rectangle2.y + (rectangle2.x >> 3);
                        int n25 = 0;
                        int n26 = 0;
                        int n27 = n24;
                        while (n25 < rectangle2.height) {
                            this.iis.read(byArray3, 0, n21);
                            this.iis.skipBytes(n23);
                            int n28 = 0;
                            int n29 = 7 - (rectangle2.x & 7);
                            for (int i2 = rectangle.x; i2 < rectangle.x + rectangle.width; i2 += n4) {
                                n28 |= (byArray3[i2 >> 3] >> 7 - (i2 & 7) & 1) << n29;
                                if (--n29 != -1) continue;
                                byArray[n27++] = (byte)n28;
                                n28 = 0;
                                n29 = 7;
                            }
                            if (n29 != 7) {
                                byArray[n27++] = (byte)n28;
                            }
                            n27 += rectangle2.x >> 3;
                            this.processImageUpdate((BufferedImage)object, 0, n25, rectangle2.width, 1, 1, 1, nArray2);
                            this.processImageProgress(100.0f * (float)n25 / (float)rectangle2.height);
                            ++n25;
                            n26 += n5;
                        }
                    }
                    break;
                }
                case 49: {
                    DataBuffer dataBuffer = writableRaster.getDataBuffer();
                    byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                    if (bl2) {
                        int n30 = 0;
                        for (int i3 = 0; i3 < this.height; ++i3) {
                            int n31 = 0;
                            int n32 = 7;
                            for (int i4 = 0; i4 < this.width; ++i4) {
                                n31 |= (this.readInteger(this.iis) & 1) << n32;
                                if (--n32 != -1) continue;
                                byArray[n30++] = (byte)n31;
                                n31 = 0;
                                n32 = 7;
                            }
                            if (n32 != 7) {
                                byArray[n30++] = (byte)n31;
                            }
                            this.processImageUpdate((BufferedImage)object, 0, i3, this.width, 1, 1, 1, nArray2);
                            this.processImageProgress(100.0f * (float)i3 / (float)this.height);
                        }
                    } else {
                        this.skipInteger(this.iis, rectangle.y * this.width + rectangle.x);
                        int n33 = n4 - 1;
                        int n34 = (n5 - 1) * this.width + this.width - rectangle2.width * n4;
                        int n35 = (((BufferedImage)object).getWidth() + 7 >> 3) * rectangle2.y + (rectangle2.x >> 3);
                        int n36 = n35;
                        for (int i5 = 0; i5 < rectangle2.height; ++i5) {
                            int n37 = 0;
                            int n38 = 7 - (rectangle2.x & 7);
                            for (int i6 = 0; i6 < rectangle2.width; ++i6) {
                                n37 |= (this.readInteger(this.iis) & 1) << n38;
                                if (--n38 == -1) {
                                    byArray[n36++] = (byte)n37;
                                    n37 = 0;
                                    n38 = 7;
                                }
                                this.skipInteger(this.iis, n33);
                            }
                            if (n38 != 7) {
                                byArray[n36++] = (byte)n37;
                            }
                            n36 += rectangle2.x >> 3;
                            this.skipInteger(this.iis, n34);
                            this.processImageUpdate((BufferedImage)object, 0, i5, rectangle2.width, 1, 1, 1, nArray2);
                            this.processImageProgress(100.0f * (float)i5 / (float)rectangle2.height);
                        }
                    }
                    break;
                }
                case 50: 
                case 51: 
                case 53: 
                case 54: {
                    int n39 = (n4 - 1) * n6;
                    int n40 = (n5 * this.width - rectangle2.width * n4) * n6;
                    int n41 = (((BufferedImage)object).getWidth() * rectangle2.y + rectangle2.x) * n6;
                    switch (n3) {
                        case 0: {
                            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                            byte[] byArray = dataBufferByte.getData();
                            if (this.isRaw(this.variant)) {
                                if (bl2) {
                                    this.iis.readFully(byArray);
                                    this.processImageUpdate((BufferedImage)object, 0, 0, this.width, this.height, 1, 1, nArray2);
                                    this.processImageProgress(100.0f);
                                    break block0;
                                }
                                this.iis.skipBytes(rectangle.y * this.width * n6);
                                int n42 = (n5 - 1) * this.width * n6;
                                byte[] byArray4 = new byte[this.width * n6];
                                int n43 = n4 * n6;
                                int n44 = rectangle.x * n6;
                                int n45 = this.width;
                                int n46 = n41;
                                for (int i7 = 0; i7 < rectangle2.height; ++i7) {
                                    this.iis.read(byArray4);
                                    int n47 = rectangle.x;
                                    int n48 = n44;
                                    while (n47 < rectangle.x + rectangle.width) {
                                        for (int i8 = 0; i8 < nArray.length; ++i8) {
                                            byArray[n46 + nArray2[i8]] = byArray4[n48 + nArray[i8]];
                                        }
                                        n46 += nArray.length;
                                        n47 += n4;
                                        n48 += n43;
                                    }
                                    n46 += rectangle2.x * n6;
                                    this.iis.skipBytes(n42);
                                    this.processImageUpdate((BufferedImage)object, 0, i7, rectangle2.width, 1, 1, 1, nArray2);
                                    this.processImageProgress(100.0f * (float)i7 / (float)rectangle2.height);
                                }
                            } else {
                                this.skipInteger(this.iis, (rectangle.y * this.width + rectangle.x) * n6);
                                if (bl3) {
                                    byte[] byArray5 = new byte[n6];
                                    int n49 = n41;
                                    for (int i9 = 0; i9 < rectangle2.height; ++i9) {
                                        for (int i10 = 0; i10 < rectangle2.width; ++i10) {
                                            int n50;
                                            for (n50 = 0; n50 < n6; ++n50) {
                                                byArray5[n50] = (byte)this.readInteger(this.iis);
                                            }
                                            for (n50 = 0; n50 < nArray.length; ++n50) {
                                                byArray[n49 + nArray2[n50]] = byArray5[nArray[n50]];
                                            }
                                            n49 += nArray.length;
                                            this.skipInteger(this.iis, n39);
                                        }
                                        n49 += rectangle2.x * nArray.length;
                                        this.skipInteger(this.iis, n40);
                                        this.processImageUpdate((BufferedImage)object, 0, i9, rectangle2.width, 1, 1, 1, nArray2);
                                        this.processImageProgress(100.0f * (float)i9 / (float)rectangle2.height);
                                    }
                                } else {
                                    int n51 = n41;
                                    for (int i11 = 0; i11 < rectangle2.height; ++i11) {
                                        for (int i12 = 0; i12 < rectangle2.width; ++i12) {
                                            for (int i13 = 0; i13 < n6; ++i13) {
                                                byArray[n51++] = (byte)this.readInteger(this.iis);
                                            }
                                            this.skipInteger(this.iis, n39);
                                        }
                                        n51 += rectangle2.x * nArray.length;
                                        this.skipInteger(this.iis, n40);
                                        this.processImageUpdate((BufferedImage)object, 0, i11, rectangle2.width, 1, 1, 1, nArray2);
                                        this.processImageProgress(100.0f * (float)i11 / (float)rectangle2.height);
                                    }
                                }
                            }
                            break block77;
                        }
                        case 1: {
                            DataBufferUShort dataBufferUShort = (DataBufferUShort)writableRaster.getDataBuffer();
                            short[] sArray = dataBufferUShort.getData();
                            this.skipInteger(this.iis, rectangle.y * this.width * n6 + rectangle.x);
                            if (bl3) {
                                short[] sArray2 = new short[n6];
                                int n52 = n41;
                                for (int i14 = 0; i14 < rectangle2.height; ++i14) {
                                    for (int i15 = 0; i15 < rectangle2.width; ++i15) {
                                        int n53;
                                        for (n53 = 0; n53 < n6; ++n53) {
                                            sArray2[n53] = (short)this.readInteger(this.iis);
                                        }
                                        for (n53 = 0; n53 < nArray.length; ++n53) {
                                            sArray[n52 + nArray2[n53]] = sArray2[nArray[n53]];
                                        }
                                        n52 += nArray.length;
                                        this.skipInteger(this.iis, n39);
                                    }
                                    n52 += rectangle2.x * nArray.length;
                                    this.skipInteger(this.iis, n40);
                                    this.processImageUpdate((BufferedImage)object, 0, i14, rectangle2.width, 1, 1, 1, nArray2);
                                    this.processImageProgress(100.0f * (float)i14 / (float)rectangle2.height);
                                }
                            } else {
                                int n54 = n41;
                                for (int i16 = 0; i16 < rectangle2.height; ++i16) {
                                    for (int i17 = 0; i17 < rectangle2.width; ++i17) {
                                        for (int i18 = 0; i18 < n6; ++i18) {
                                            sArray[n54++] = (short)this.readInteger(this.iis);
                                        }
                                        this.skipInteger(this.iis, n39);
                                    }
                                    n54 += rectangle2.x * nArray.length;
                                    this.skipInteger(this.iis, n40);
                                    this.processImageUpdate((BufferedImage)object, 0, i16, rectangle2.width, 1, 1, 1, nArray2);
                                    this.processImageProgress(100.0f * (float)i16 / (float)rectangle2.height);
                                }
                            }
                            break block77;
                        }
                        case 3: {
                            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
                            int[] nArray3 = dataBufferInt.getData();
                            this.skipInteger(this.iis, rectangle.y * this.width * n6 + rectangle.x);
                            if (bl3) {
                                int[] nArray4 = new int[n6];
                                int n55 = n41;
                                for (int i19 = 0; i19 < rectangle2.height; ++i19) {
                                    for (int i20 = 0; i20 < rectangle2.width; ++i20) {
                                        int n56;
                                        for (n56 = 0; n56 < n6; ++n56) {
                                            nArray4[n56] = this.readInteger(this.iis);
                                        }
                                        for (n56 = 0; n56 < nArray.length; ++n56) {
                                            nArray3[n55 + nArray2[n56]] = nArray4[nArray[n56]];
                                        }
                                        n55 += nArray.length;
                                        this.skipInteger(this.iis, n39);
                                    }
                                    n55 += rectangle2.x * nArray.length;
                                    this.skipInteger(this.iis, n40);
                                    this.processImageUpdate((BufferedImage)object, 0, i19, rectangle2.width, 1, 1, 1, nArray2);
                                    this.processImageProgress(100.0f * (float)i19 / (float)rectangle2.height);
                                }
                            } else {
                                int n57 = n41;
                                for (int i21 = 0; i21 < rectangle2.height; ++i21) {
                                    for (int i22 = 0; i22 < rectangle2.width; ++i22) {
                                        for (int i23 = 0; i23 < n6; ++i23) {
                                            nArray3[n57++] = this.readInteger(this.iis);
                                        }
                                        this.skipInteger(this.iis, n39);
                                    }
                                    n57 += rectangle2.x * nArray.length;
                                    this.skipInteger(this.iis, n40);
                                    this.processImageUpdate((BufferedImage)object, 0, i21, rectangle2.width, 1, 1, 1, nArray2);
                                    this.processImageProgress(100.0f * (float)i21 / (float)rectangle2.height);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return object;
    }

    public boolean canReadRaster() {
        return true;
    }

    public Raster readRaster(int n2, ImageReadParam imageReadParam) throws IOException {
        BufferedImage bufferedImage = this.read(n2, imageReadParam);
        return bufferedImage.getData();
    }

    public void reset() {
        super.reset();
        this.iis = null;
        this.gotHeader = false;
        System.gc();
    }

    private boolean isRaw(int n2) {
        return n2 >= 52;
    }

    private void readComments(ImageInputStream imageInputStream, PNMMetadata pNMMetadata) throws IOException {
        String string = null;
        int n2 = -1;
        imageInputStream.mark();
        while ((string = imageInputStream.readLine()) != null && (n2 = string.indexOf("#")) >= 0) {
            pNMMetadata.addComment(string.substring(n2 + 1).trim());
        }
        imageInputStream.reset();
    }

    private int readInteger(ImageInputStream imageInputStream) throws IOException {
        boolean bl2 = false;
        while (this.aLine == null) {
            this.aLine = imageInputStream.readLine();
            if (this.aLine == null) {
                return 0;
            }
            int n2 = this.aLine.indexOf("#");
            if (n2 == 0) {
                this.aLine = null;
            } else if (n2 > 0) {
                this.aLine = this.aLine.substring(0, n2 - 1);
            }
            if (this.aLine == null) continue;
            this.token = new StringTokenizer(this.aLine);
        }
        while (this.token.hasMoreTokens()) {
            String string = this.token.nextToken();
            try {
                return new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        if (!bl2) {
            this.aLine = null;
            return this.readInteger(imageInputStream);
        }
        return 0;
    }

    private void skipInteger(ImageInputStream imageInputStream, int n2) throws IOException {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.readInteger(imageInputStream);
        }
    }

    static {
        if (lineSeparator == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            lineSeparator = string.getBytes();
        }
    }
}

