/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.pnm;

import com.sun.media.imageio.plugins.pnm.PNMImageWriteParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.pnm.I18N;
import com.sun.media.imageioimpl.plugins.pnm.PNMMetadata;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.security.AccessController;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import sun.security.action.GetPropertyAction;

public class PNMImageWriter
extends ImageWriter {
    private static final int PBM_ASCII = 49;
    private static final int PGM_ASCII = 50;
    private static final int PPM_ASCII = 51;
    private static final int PBM_RAW = 52;
    private static final int PGM_RAW = 53;
    private static final int PPM_RAW = 54;
    private static final int SPACE = 32;
    private static final String COMMENT = "# written by com.sun.media.imageioimpl.PNMImageWriter";
    private static byte[] lineSeparator;
    private int variant;
    private int maxValue;
    private ImageOutputStream stream = null;

    public PNMImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("PNMImageWriter0"));
            }
            this.stream = (ImageOutputStream)object;
        } else {
            this.stream = null;
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new PNMImageWriteParam();
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return new PNMMetadata(imageTypeSpecifier, imageWriteParam);
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        PNMMetadata pNMMetadata = null;
        if (iIOMetadata instanceof PNMMetadata) {
            pNMMetadata = (PNMMetadata)((PNMMetadata)iIOMetadata).clone();
        } else {
            try {
                pNMMetadata = new PNMMetadata(iIOMetadata);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                pNMMetadata = new PNMMetadata();
            }
        }
        pNMMetadata.initialize(imageTypeSpecifier, imageWriteParam);
        return pNMMetadata;
    }

    public boolean canWriteRasters() {
        return true;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        boolean bl2;
        boolean bl3;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        int n2;
        int[] nArray;
        int n3;
        int n4;
        int n5;
        SampleModel sampleModel;
        Rectangle rectangle;
        boolean bl4;
        Raster raster;
        RenderedImage renderedImage;
        block80: {
            SampleModel sampleModel2;
            ColorModel colorModel;
            block79: {
                int n6;
                ImageTypeSpecifier imageTypeSpecifier;
                Object object;
                this.clearAbortRequest();
                this.processImageStarted(0);
                if (imageWriteParam == null) {
                    imageWriteParam = this.getDefaultWriteParam();
                }
                renderedImage = null;
                raster = null;
                bl4 = iIOImage.hasRaster();
                rectangle = imageWriteParam.getSourceRegion();
                sampleModel = null;
                colorModel = null;
                if (bl4) {
                    raster = iIOImage.getRaster();
                    sampleModel = raster.getSampleModel();
                    rectangle = rectangle == null ? raster.getBounds() : rectangle.intersection(raster.getBounds());
                } else {
                    renderedImage = iIOImage.getRenderedImage();
                    sampleModel = renderedImage.getSampleModel();
                    colorModel = renderedImage.getColorModel();
                    Rectangle rectangle2 = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
                    rectangle = rectangle == null ? rectangle2 : rectangle.intersection(rectangle2);
                }
                if (rectangle.isEmpty()) {
                    throw new RuntimeException(I18N.getString("PNMImageWrite1"));
                }
                ImageUtil.canEncodeImage(this, colorModel, sampleModel);
                n5 = imageWriteParam.getSourceXSubsampling();
                n4 = imageWriteParam.getSourceYSubsampling();
                int n7 = imageWriteParam.getSubsamplingXOffset();
                int n8 = imageWriteParam.getSubsamplingYOffset();
                rectangle.translate(n7, n8);
                rectangle.width -= n7;
                rectangle.height -= n8;
                int n9 = rectangle.x / n5;
                int n10 = rectangle.y / n4;
                n3 = (rectangle.width + n5 - 1) / n5;
                int n11 = (rectangle.height + n4 - 1) / n4;
                Rectangle rectangle3 = new Rectangle(n9, n10, n3, n11);
                int n12 = sampleModel.getHeight();
                int n13 = sampleModel.getWidth();
                int[] nArray2 = sampleModel.getSampleSize();
                nArray = imageWriteParam.getSourceBands();
                boolean bl5 = true;
                n2 = sampleModel.getNumBands();
                if (nArray != null) {
                    sampleModel = sampleModel.createSubsetSampleModel(nArray);
                    colorModel = null;
                    bl5 = false;
                    n2 = sampleModel.getNumBands();
                } else {
                    nArray = new int[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        nArray[i2] = i2;
                    }
                }
                byArray3 = null;
                byArray2 = null;
                byArray = null;
                bl3 = false;
                if (n2 == 1) {
                    if (colorModel instanceof IndexColorModel) {
                        object = (IndexColorModel)colorModel;
                        int n14 = ((IndexColorModel)object).getMapSize();
                        if (n14 < 1 << nArray2[0]) {
                            throw new RuntimeException(I18N.getString("PNMImageWrite2"));
                        }
                        if (nArray2[0] == 1) {
                            this.variant = 52;
                            bl3 = ((IndexColorModel)object).getRed(1) > ((IndexColorModel)object).getRed(0);
                        } else {
                            this.variant = 54;
                            byArray3 = new byte[n14];
                            byArray2 = new byte[n14];
                            byArray = new byte[n14];
                            ((IndexColorModel)object).getReds(byArray3);
                            ((IndexColorModel)object).getGreens(byArray2);
                            ((IndexColorModel)object).getBlues(byArray);
                        }
                    } else {
                        this.variant = nArray2[0] == 1 ? 52 : (nArray2[0] <= 8 ? 53 : 50);
                    }
                } else if (n2 == 3) {
                    this.variant = nArray2[0] <= 8 && nArray2[1] <= 8 && nArray2[2] <= 8 ? 54 : 51;
                } else {
                    throw new RuntimeException(I18N.getString("PNMImageWrite3"));
                }
                object = iIOImage.getMetadata();
                if (colorModel != null) {
                    imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
                } else {
                    int n15 = sampleModel.getDataType();
                    switch (n2) {
                        case 1: {
                            imageTypeSpecifier = ImageTypeSpecifier.createGrayscale(nArray2[0], n15, false);
                            break;
                        }
                        case 3: {
                            ColorSpace colorSpace = ColorSpace.getInstance(1000);
                            imageTypeSpecifier = ImageTypeSpecifier.createInterleaved(colorSpace, new int[]{0, 1, 2}, n15, false, false);
                            break;
                        }
                        default: {
                            throw new IIOException("Cannot encode image with " + n2 + " bands!");
                        }
                    }
                }
                PNMMetadata pNMMetadata = object != null ? (PNMMetadata)this.convertImageMetadata((IIOMetadata)object, imageTypeSpecifier, imageWriteParam) : (PNMMetadata)this.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
                boolean bl6 = imageWriteParam instanceof PNMImageWriteParam ? ((PNMImageWriteParam)imageWriteParam).getRaw() : pNMMetadata.isRaw();
                this.maxValue = pNMMetadata.getMaxValue();
                for (n6 = 0; n6 < nArray2.length; ++n6) {
                    int n16 = (1 << nArray2[n6]) - 1;
                    if (n16 <= this.maxValue) continue;
                    this.maxValue = n16;
                }
                if (bl6) {
                    n6 = pNMMetadata.getMaxBitDepth();
                    if (!this.isRaw(this.variant) && n6 <= 8) {
                        this.variant += 3;
                    } else if (this.isRaw(this.variant) && n6 > 8) {
                        this.variant -= 3;
                    }
                } else if (this.isRaw(this.variant)) {
                    this.variant -= 3;
                }
                this.stream.writeByte(80);
                this.stream.writeByte(this.variant);
                this.stream.write(lineSeparator);
                this.stream.write(COMMENT.getBytes());
                Iterator iterator = pNMMetadata.getComments();
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        this.stream.write(lineSeparator);
                        String string = "# " + (String)iterator.next();
                        this.stream.write(string.getBytes());
                    }
                }
                this.stream.write(lineSeparator);
                this.writeInteger(this.stream, n3);
                this.stream.write(32);
                this.writeInteger(this.stream, n11);
                if (this.variant != 52 && this.variant != 49) {
                    this.stream.write(lineSeparator);
                    this.writeInteger(this.stream, this.maxValue);
                }
                if (this.variant == 52 || this.variant == 53 || this.variant == 54) {
                    this.stream.write(10);
                }
                bl2 = false;
                if (this.variant != 52 || sampleModel.getTransferType() != 0 || !(sampleModel instanceof MultiPixelPackedSampleModel)) break block79;
                sampleModel2 = (MultiPixelPackedSampleModel)sampleModel;
                int n17 = 0;
                n17 = bl4 ? raster.getMinX() : renderedImage.getMinX();
                if (((MultiPixelPackedSampleModel)sampleModel2).getBitOffset((rectangle.x - n17) % n13) != 0 || ((MultiPixelPackedSampleModel)sampleModel2).getPixelBitStride() != 1 || n5 != 1) break block80;
                bl2 = true;
                break block80;
            }
            if ((this.variant == 53 || this.variant == 54) && sampleModel instanceof ComponentSampleModel && !(colorModel instanceof IndexColorModel) && ((ComponentSampleModel)(sampleModel2 = (ComponentSampleModel)sampleModel)).getPixelStride() == n2 && n5 == 1) {
                bl2 = true;
                if (this.variant == 54) {
                    int[] nArray3 = ((ComponentSampleModel)sampleModel2).getBandOffsets();
                    for (int i3 = 0; i3 < n2; ++i3) {
                        if (nArray3[i3] == i3) continue;
                        bl2 = false;
                        break;
                    }
                }
            }
        }
        if (bl2) {
            int n18 = this.variant == 52 ? (n3 + 7) / 8 : n3 * sampleModel.getNumBands();
            byte[] byArray4 = null;
            byte[] byArray5 = new byte[n18];
            for (int i4 = 0; i4 < rectangle.height && !this.abortRequested(); ++i4) {
                Raster raster2 = null;
                if (bl4) {
                    raster2 = raster.createChild(rectangle.x, i4, rectangle.width, 1, 0, 0, null);
                } else {
                    raster2 = renderedImage.getData(new Rectangle(rectangle.x, rectangle.y + i4, n3, 1));
                    raster2 = raster2.createTranslatedChild(0, 0);
                }
                byArray4 = ((DataBufferByte)raster2.getDataBuffer()).getData();
                sampleModel = raster2.getSampleModel();
                int n19 = 0;
                if (sampleModel instanceof ComponentSampleModel) {
                    n19 = ((ComponentSampleModel)sampleModel).getOffset(raster2.getMinX() - raster2.getSampleModelTranslateX(), raster2.getMinY() - raster2.getSampleModelTranslateY());
                } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
                    n19 = ((MultiPixelPackedSampleModel)sampleModel).getOffset(raster2.getMinX() - raster2.getSampleModelTranslateX(), raster2.getMinX() - raster2.getSampleModelTranslateY());
                }
                if (bl3) {
                    int n20 = n19;
                    for (int i5 = 0; i5 < n18; ++i5) {
                        byArray5[i5] = ~byArray4[n20];
                        ++n20;
                    }
                    byArray4 = byArray5;
                    n19 = 0;
                }
                this.stream.write(byArray4, n19, n18);
                this.processImageProgress(100.0f * (float)i4 / (float)rectangle.height);
            }
            this.stream.flush();
            if (this.abortRequested()) {
                this.processWriteAborted();
            } else {
                this.processImageComplete();
            }
            return;
        }
        int n21 = rectangle.width * n2;
        int[] nArray4 = new int[n21];
        byte[] byArray6 = byArray3 == null ? new byte[n3 * n2] : new byte[n3 * 3];
        int n22 = 0;
        int n23 = rectangle.y + rectangle.height;
        for (int i6 = rectangle.y; i6 < n23 && !this.abortRequested(); i6 += n4) {
            Raster raster3 = null;
            raster3 = bl4 ? raster.createChild(rectangle.x, i6, rectangle.width, 1, rectangle.x, i6, nArray) : renderedImage.getData(new Rectangle(rectangle.x, i6, rectangle.width, 1));
            raster3.getPixels(rectangle.x, i6, rectangle.width, 1, nArray4);
            if (bl3) {
                for (int i7 = 0; i7 < n21; i7 += n5) {
                    int n24 = i7;
                    byArray6[n24] = (byte)(byArray6[n24] ^ 1);
                }
            }
            switch (this.variant) {
                case 49: 
                case 50: {
                    for (int i8 = 0; i8 < n21; i8 += n5) {
                        if (n22++ % 16 == 0) {
                            this.stream.write(lineSeparator);
                        } else {
                            this.stream.write(32);
                        }
                        this.writeInteger(this.stream, nArray4[i8]);
                    }
                    this.stream.write(lineSeparator);
                    break;
                }
                case 51: {
                    int n25;
                    int n26;
                    if (byArray3 == null) {
                        int[] nArray5 = ((ComponentSampleModel)sampleModel).getBandOffsets();
                        for (n26 = 0; n26 < n21; n26 += n5 * n2) {
                            for (n25 = 0; n25 < n2; ++n25) {
                                if (n22++ % 16 == 0) {
                                    this.stream.write(lineSeparator);
                                } else {
                                    this.stream.write(32);
                                }
                                this.writeInteger(this.stream, nArray4[n26 + n25]);
                            }
                        }
                    } else {
                        for (int i9 = 0; i9 < n21; i9 += n5) {
                            if (n22++ % 5 == 0) {
                                this.stream.write(lineSeparator);
                            } else {
                                this.stream.write(32);
                            }
                            this.writeInteger(this.stream, byArray3[nArray4[i9]] & 0xFF);
                            this.stream.write(32);
                            this.writeInteger(this.stream, byArray2[nArray4[i9]] & 0xFF);
                            this.stream.write(32);
                            this.writeInteger(this.stream, byArray[nArray4[i9]] & 0xFF);
                        }
                    }
                    this.stream.write(lineSeparator);
                    break;
                }
                case 52: {
                    int n27;
                    int n28 = 0;
                    int n26 = 0;
                    int n25 = 0;
                    int n29 = 7;
                    for (n27 = 0; n27 < n21; n27 += n5) {
                        n25 |= nArray4[n27] << n29;
                        if (--n29 != -1) continue;
                        byArray6[n28++] = (byte)n25;
                        n25 = 0;
                        n29 = 7;
                    }
                    if (n29 != 7) {
                        byArray6[n28++] = (byte)n25;
                    }
                    this.stream.write(byArray6, 0, n28);
                    break;
                }
                case 53: {
                    int n27;
                    int n30 = 0;
                    for (n27 = 0; n27 < n21; n27 += n5) {
                        byArray6[n30++] = (byte)nArray4[n27];
                    }
                    this.stream.write(byArray6, 0, n3);
                    break;
                }
                case 54: {
                    int n30;
                    int n27;
                    if (byArray3 == null) {
                        n30 = 0;
                        for (n27 = 0; n27 < n21; n27 += n5 * n2) {
                            for (int i10 = 0; i10 < n2; ++i10) {
                                byArray6[n30++] = (byte)(nArray4[n27 + i10] & 0xFF);
                            }
                        }
                    } else {
                        n30 = 0;
                        for (n27 = 0; n27 < n21; n27 += n5) {
                            byArray6[n30++] = byArray3[nArray4[n27]];
                            byArray6[n30++] = byArray2[nArray4[n27]];
                            byArray6[n30++] = byArray[nArray4[n27]];
                        }
                    }
                    this.stream.write(byArray6, 0, byArray6.length);
                }
            }
            this.processImageProgress(100.0f * (float)(i6 - rectangle.y) / (float)rectangle.height);
        }
        this.stream.flush();
        if (this.abortRequested()) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
        }
    }

    public void reset() {
        super.reset();
        this.stream = null;
    }

    private void writeInteger(ImageOutputStream imageOutputStream, int n2) throws IOException {
        imageOutputStream.write(Integer.toString(n2).getBytes());
    }

    private void writeByte(ImageOutputStream imageOutputStream, byte by2) throws IOException {
        imageOutputStream.write(Byte.toString(by2).getBytes());
    }

    private boolean isRaw(int n2) {
        return n2 >= 52;
    }

    static {
        if (lineSeparator == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            lineSeparator = string.getBytes();
        }
    }
}

