/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.pnm;

import com.sun.media.imageio.plugins.pnm.PNMImageWriteParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.pnm.I18N;
import java.awt.image.SampleModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PNMMetadata
extends IIOMetadata
implements Cloneable {
    static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_pnm_image_1.0";
    private int maxSample;
    private int width;
    private int height;
    private int variant;
    private ArrayList comments;
    private int maxSampleSize;

    PNMMetadata() {
        super(true, nativeMetadataFormatName, "com.sun.media.imageioimpl.plugins.pnm.PNMMetadataFormat", null, null);
    }

    public PNMMetadata(IIOMetadata iIOMetadata) throws IIOInvalidTreeException {
        this();
        if (iIOMetadata != null) {
            List<String> list = Arrays.asList(iIOMetadata.getMetadataFormatNames());
            if (list.contains(nativeMetadataFormatName)) {
                this.setFromTree(nativeMetadataFormatName, iIOMetadata.getAsTree(nativeMetadataFormatName));
            } else if (iIOMetadata.isStandardMetadataFormatSupported()) {
                String string = "javax_imageio_1.0";
                this.setFromTree(string, iIOMetadata.getAsTree(string));
            }
        }
    }

    PNMMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        this();
        this.initialize(imageTypeSpecifier, imageWriteParam);
    }

    void initialize(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        ImageTypeSpecifier imageTypeSpecifier2 = null;
        if (imageWriteParam != null) {
            imageTypeSpecifier2 = imageWriteParam.getDestinationType();
            if (imageTypeSpecifier2 == null) {
                imageTypeSpecifier2 = imageTypeSpecifier;
            }
        } else {
            imageTypeSpecifier2 = imageTypeSpecifier;
        }
        if (imageTypeSpecifier2 != null) {
            int n2;
            SampleModel sampleModel = imageTypeSpecifier2.getSampleModel();
            int[] nArray = sampleModel.getSampleSize();
            this.width = sampleModel.getWidth();
            this.height = sampleModel.getHeight();
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (nArray[n2] <= this.maxSampleSize) continue;
                this.maxSampleSize = nArray[n2];
            }
            this.maxSample = (1 << this.maxSampleSize) - 1;
            n2 = 1;
            if (imageWriteParam instanceof PNMImageWriteParam) {
                n2 = ((PNMImageWriteParam)imageWriteParam).getRaw() ? 1 : 0;
            }
            if (this.maxSampleSize == 1) {
                this.variant = 49;
            } else if (sampleModel.getNumBands() == 1) {
                this.variant = 50;
            } else if (sampleModel.getNumBands() == 3) {
                this.variant = 51;
            }
            if (this.variant <= 51 && n2 != 0 && this.maxSampleSize <= 8) {
                this.variant += 3;
            }
        }
    }

    protected Object clone() {
        PNMMetadata pNMMetadata = null;
        try {
            pNMMetadata = (PNMMetadata)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.comments != null) {
            int n2 = this.comments.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                pNMMetadata.addComment((String)this.comments.get(i2));
            }
        }
        return pNMMetadata;
    }

    public Node getAsTree(String string) {
        if (string == null) {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata0"));
        }
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException(I18N.getString("PNMMetadata1") + " " + string);
    }

    IIOMetadataNode getNativeTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("FormatName");
        iIOMetadataNode2.setUserObject(this.getFormatName());
        iIOMetadataNode2.setNodeValue(this.getFormatName());
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("Variant");
        iIOMetadataNode2.setUserObject(this.getVariant());
        iIOMetadataNode2.setNodeValue(this.getVariant());
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("Width");
        Number number = new Integer(this.width);
        iIOMetadataNode2.setUserObject(number);
        iIOMetadataNode2.setNodeValue(ImageUtil.convertObjectToString(number));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("Height");
        number = new Integer(this.height);
        iIOMetadataNode2.setUserObject(number);
        iIOMetadataNode2.setNodeValue(ImageUtil.convertObjectToString(number));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("MaximumSample");
        number = new Byte((byte)this.maxSample);
        iIOMetadataNode2.setUserObject(number);
        iIOMetadataNode2.setNodeValue(ImageUtil.convertObjectToString(new Integer(this.maxSample)));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.comments != null) {
            for (int i2 = 0; i2 < this.comments.size(); ++i2) {
                iIOMetadataNode2 = new IIOMetadataNode("Comment");
                number = this.comments.get(i2);
                iIOMetadataNode2.setUserObject(number);
                iIOMetadataNode2.setNodeValue(ImageUtil.convertObjectToString(number));
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        int n2 = (this.variant - 49) % 3 + 1;
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        if (n2 == 3) {
            iIOMetadataNode2.setAttribute("name", "RGB");
        } else {
            iIOMetadataNode2.setAttribute("name", "GRAY");
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("NumChannels");
        iIOMetadataNode2.setAttribute("value", "" + (n2 == 3 ? 3 : 1));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (n2 != 3) {
            iIOMetadataNode2 = new IIOMetadataNode("BlackIsZero");
            iIOMetadataNode2.setAttribute("value", "TRUE");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("SampleFormat");
        iIOMetadataNode2.setAttribute("value", "UnsignedIntegral");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        int n2 = (this.variant - 49) % 3 + 1;
        iIOMetadataNode2 = new IIOMetadataNode("BitsPerSample");
        if (n2 == 1) {
            iIOMetadataNode2.setAttribute("value", "1");
        } else if (n2 == 2) {
            iIOMetadataNode2.setAttribute("value", "8");
        } else {
            iIOMetadataNode2.setAttribute("value", "8 8 8");
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("SignificantBitsPerSample");
        if (n2 == 1 || n2 == 2) {
            iIOMetadataNode2.setAttribute("value", "" + this.maxSampleSize);
        } else {
            iIOMetadataNode2.setAttribute("value", this.maxSampleSize + " " + this.maxSampleSize + " " + this.maxSampleSize);
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "Normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardTextNode() {
        if (this.comments != null) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
            Iterator iterator = this.comments.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
                iIOMetadataNode2.setAttribute("keyword", "comment");
                iIOMetadataNode2.setAttribute("value", string);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            return iIOMetadataNode;
        }
        return null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata0"));
        }
        if (node == null) {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata2"));
        }
        if (string.equals(nativeMetadataFormatName) && node.getNodeName().equals(nativeMetadataFormatName)) {
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata1") + " " + string);
        }
    }

    public void setFromTree(String string, Node node) throws IIOInvalidTreeException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata0"));
        }
        if (node == null) {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata2"));
        }
        if (string.equals(nativeMetadataFormatName) && node.getNodeName().equals(nativeMetadataFormatName)) {
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata2") + " " + string);
        }
    }

    public void reset() {
        this.maxSampleSize = 0;
        this.variant = 0;
        this.height = 0;
        this.width = 0;
        this.maxSample = 0;
        this.comments = null;
    }

    public String getFormatName() {
        int n2 = (this.variant - 49) % 3 + 1;
        if (n2 == 1) {
            return "PBM";
        }
        if (n2 == 2) {
            return "PGM";
        }
        if (n2 == 3) {
            return "PPM";
        }
        return null;
    }

    public String getVariant() {
        if (this.variant > 51) {
            return "RAWBITS";
        }
        return "ASCII";
    }

    boolean isRaw() {
        return this.getVariant().equals("RAWBITS");
    }

    public void setVariant(int n2) {
        this.variant = n2;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    int getMaxBitDepth() {
        return this.maxSampleSize;
    }

    int getMaxValue() {
        return this.maxSample;
    }

    public void setMaxBitDepth(int n2) {
        this.maxSample = n2;
        this.maxSampleSize = 0;
        while (n2 > 0) {
            n2 >>>= 1;
            ++this.maxSampleSize;
        }
    }

    public synchronized void addComment(String string) {
        if (this.comments == null) {
            this.comments = new ArrayList();
        }
        string = string.replaceAll("[\n\r\f]", " ");
        this.comments.add(string);
    }

    Iterator getComments() {
        return this.comments == null ? null : this.comments.iterator();
    }

    private void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        NodeList nodeList = node.getChildNodes();
        String string = null;
        String string2 = null;
        for (int i2 = nodeList.getLength() - 1; i2 >= 0; --i2) {
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)nodeList.item(i2);
            String string3 = iIOMetadataNode.getNodeName();
            if (string3.equals("Comment")) {
                this.addComment((String)iIOMetadataNode.getUserObject());
                continue;
            }
            if (string3.equals("Width")) {
                this.width = (Integer)iIOMetadataNode.getUserObject();
                continue;
            }
            if (string3.equals("Height")) {
                this.width = (Integer)iIOMetadataNode.getUserObject();
                continue;
            }
            if (string3.equals("MaximumSample")) {
                int n2 = (Integer)iIOMetadataNode.getUserObject();
                this.setMaxBitDepth(n2);
                continue;
            }
            if (string3.equals("FormatName")) {
                string = (String)iIOMetadataNode.getUserObject();
                continue;
            }
            if (!string3.equals("Variant")) continue;
            string2 = (String)iIOMetadataNode.getUserObject();
        }
        if (string.equals("PBM")) {
            this.variant = 49;
        } else if (string.equals("PGM")) {
            this.variant = 50;
        } else if (string.equals("PPM")) {
            this.variant = 51;
        }
        if (string2.equals("RAWBITS")) {
            this.variant += 3;
        }
    }

    private void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        NodeList nodeList = node.getChildNodes();
        String string = null;
        int n2 = 0;
        int[] nArray = null;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string2;
            Object object;
            int n3;
            NodeList nodeList2;
            Node node2 = nodeList.item(i2);
            String string3 = node2.getNodeName();
            if (string3.equals("Chroma")) {
                nodeList2 = node2.getChildNodes();
                for (n3 = 0; n3 < nodeList2.getLength(); ++n3) {
                    Node node3 = nodeList2.item(n3);
                    object = node3.getNodeName();
                    if (((String)object).equals("NumChannels")) {
                        string2 = (String)this.getAttribute(node3, "value");
                        n2 = new Integer(string2);
                        continue;
                    }
                    if (!((String)object).equals("ColorSpaceType")) continue;
                    string = (String)this.getAttribute(node3, "name");
                }
                continue;
            }
            if (string3.equals("Compression")) continue;
            if (string3.equals("Data")) {
                int n4;
                nodeList2 = node2.getChildNodes();
                n3 = -1;
                for (n4 = 0; n4 < nodeList2.getLength(); ++n4) {
                    Object object2;
                    Object object3;
                    object = nodeList2.item(n4);
                    string2 = object.getNodeName();
                    if (string2.equals("BitsPerSample")) {
                        object3 = new ArrayList(3);
                        object2 = (String)this.getAttribute((Node)object, "value");
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object2);
                        while (stringTokenizer.hasMoreTokens()) {
                            object3.add(Integer.valueOf(stringTokenizer.nextToken()));
                        }
                        nArray = new int[object3.size()];
                        for (int i3 = 0; i3 < nArray.length; ++i3) {
                            nArray[i3] = (Integer)object3.get(i3);
                        }
                        continue;
                    }
                    if (!string2.equals("SignificantBitsPerSample")) continue;
                    object3 = (String)this.getAttribute((Node)object, "value");
                    object2 = new StringTokenizer((String)object3);
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        int n5 = Integer.valueOf(((StringTokenizer)object2).nextToken());
                        n3 = Math.max(n5, n3);
                    }
                }
                if (n3 > 0) {
                    this.setMaxBitDepth((1 << n3) - 1);
                    continue;
                }
                if (nArray == null) continue;
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    if (nArray[n4] <= n3) continue;
                    n3 = nArray[n4];
                }
                this.setMaxBitDepth((1 << n3) - 1);
                continue;
            }
            if (string3.equals("Dimension") || string3.equals("Document")) continue;
            if (string3.equals("Text")) {
                nodeList2 = node2.getChildNodes();
                for (n3 = 0; n3 < nodeList2.getLength(); ++n3) {
                    Node node4 = nodeList2.item(n3);
                    object = node4.getNodeName();
                    if (!((String)object).equals("TextEntry")) continue;
                    this.addComment((String)this.getAttribute(node4, "value"));
                }
                continue;
            }
            if (string3.equals("Transparency")) continue;
            throw new IIOInvalidTreeException(I18N.getString("PNMMetadata3") + " " + string3, node2);
        }
        this.variant = string != null && string.equals("RGB") || n2 > 1 || nArray.length > 1 ? 51 : (this.maxSampleSize > 1 ? 50 : 49);
    }

    public Object getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        return (node = namedNodeMap.getNamedItem(string)) != null ? node.getNodeValue() : null;
    }
}

