/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.raw;

import com.sun.media.imageio.stream.RawImageInputStream;
import com.sun.media.imageioimpl.plugins.raw.I18N;
import com.sun.media.imageioimpl.plugins.raw.RawRenderedImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;

public class RawImageReader
extends ImageReader {
    private RawImageInputStream iis = null;

    public static void computeRegionsWrapper(ImageReadParam imageReadParam, int n2, int n3, BufferedImage bufferedImage, Rectangle rectangle, Rectangle rectangle2) {
        RawImageReader.computeRegions(imageReadParam, n2, n3, bufferedImage, rectangle, rectangle2);
    }

    public RawImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public void setInput(Object object, boolean bl2, boolean bl3) {
        super.setInput(object, bl2, bl3);
        this.iis = (RawImageInputStream)object;
    }

    public int getNumImages(boolean bl2) throws IOException {
        return this.iis.getNumImages();
    }

    public int getWidth(int n2) throws IOException {
        this.checkIndex(n2);
        return this.iis.getImageDimension((int)n2).width;
    }

    public int getHeight(int n2) throws IOException {
        this.checkIndex(n2);
        return this.iis.getImageDimension((int)n2).height;
    }

    public int getTileWidth(int n2) throws IOException {
        this.checkIndex(n2);
        return this.iis.getImageType().getSampleModel().getWidth();
    }

    public int getTileHeight(int n2) throws IOException {
        this.checkIndex(n2);
        return this.iis.getImageType().getSampleModel().getHeight();
    }

    private void checkIndex(int n2) throws IOException {
        if (n2 < 0 || n2 >= this.getNumImages(true)) {
            throw new IndexOutOfBoundsException(I18N.getString("RawImageReader0"));
        }
    }

    public Iterator getImageTypes(int n2) throws IOException {
        this.checkIndex(n2);
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        arrayList.add(this.iis.getImageType());
        return arrayList.iterator();
    }

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    public IIOMetadata getImageMetadata(int n2) throws IOException {
        return null;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public boolean isRandomAccessEasy(int n2) throws IOException {
        this.checkIndex(n2);
        return true;
    }

    public BufferedImage read(int n2, ImageReadParam imageReadParam) throws IOException {
        WritableRaster writableRaster;
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        this.checkIndex(n2);
        this.clearAbortRequest();
        this.processImageStarted(n2);
        BufferedImage bufferedImage = imageReadParam.getDestination();
        RawRenderedImage rawRenderedImage = new RawRenderedImage(this.iis, this, imageReadParam, n2);
        Point point = imageReadParam.getDestinationOffset();
        if (bufferedImage == null) {
            ColorModel colorModel = rawRenderedImage.getColorModel();
            SampleModel sampleModel = rawRenderedImage.getSampleModel();
            ImageTypeSpecifier imageTypeSpecifier = imageReadParam.getDestinationType();
            if (imageTypeSpecifier != null) {
                colorModel = imageTypeSpecifier.getColorModel();
            }
            writableRaster = Raster.createWritableRaster(sampleModel.createCompatibleSampleModel(rawRenderedImage.getMinX() + rawRenderedImage.getWidth(), rawRenderedImage.getMinY() + rawRenderedImage.getHeight()), new Point(0, 0));
            bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel != null ? colorModel.isAlphaPremultiplied() : false, new Hashtable());
        } else {
            writableRaster = bufferedImage.getWritableTile(0, 0);
        }
        rawRenderedImage.setDestImage(bufferedImage);
        rawRenderedImage.readAsRaster(writableRaster);
        rawRenderedImage.clearDestImage();
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return bufferedImage;
    }

    public RenderedImage readAsRenderedImage(int n2, ImageReadParam imageReadParam) throws IOException {
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        this.checkIndex(n2);
        this.clearAbortRequest();
        this.processImageStarted(0);
        RawRenderedImage rawRenderedImage = new RawRenderedImage(this.iis, this, imageReadParam, n2);
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return rawRenderedImage;
    }

    public Raster readRaster(int n2, ImageReadParam imageReadParam) throws IOException {
        BufferedImage bufferedImage = this.read(n2, imageReadParam);
        return bufferedImage.getData();
    }

    public boolean canReadRaster() {
        return true;
    }

    public void reset() {
        super.reset();
        this.iis = null;
    }

    public void processImageUpdateWrapper(BufferedImage bufferedImage, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        this.processImageUpdate(bufferedImage, n2, n3, n4, n5, n6, n7, nArray);
    }

    public void processImageProgressWrapper(float f2) {
        this.processImageProgress(f2);
    }

    public boolean getAbortRequest() {
        return this.abortRequested();
    }
}

