/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.raw;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.raw.I18N;
import com.sun.media.imageioimpl.plugins.raw.RawImageWriteParam;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class RawImageWriter
extends ImageWriter {
    private ImageOutputStream stream = null;
    private int imageIndex;
    private int tileWidth;
    private int tileHeight;
    private int tileXOffset;
    private int tileYOffset;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private int[] sourceBands = null;
    private int numBands;
    private RenderedImage input;
    private Raster inputRaster;
    private Rectangle destinationRegion = null;
    private SampleModel sampleModel;
    private boolean noTransform = true;
    private boolean noSubband = true;
    private boolean writeRaster = false;
    private boolean optimal = false;
    private int pxlStride;
    private int lineStride;
    private int bandStride;

    public RawImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("RawImageWriter0"));
            }
            this.stream = (ImageOutputStream)object;
        } else {
            this.stream = null;
        }
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public boolean canWriteRasters() {
        return true;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new RawImageWriteParam(this.getLocale());
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        int n2;
        this.clearAbortRequest();
        this.processImageStarted(this.imageIndex++);
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        }
        this.writeRaster = iIOImage.hasRaster();
        Rectangle rectangle = imageWriteParam.getSourceRegion();
        ColorModel colorModel = null;
        Rectangle rectangle2 = null;
        if (this.writeRaster) {
            this.inputRaster = iIOImage.getRaster();
            this.sampleModel = this.inputRaster.getSampleModel();
            rectangle2 = this.inputRaster.getBounds();
        } else {
            this.input = iIOImage.getRenderedImage();
            this.sampleModel = this.input.getSampleModel();
            rectangle2 = new Rectangle(this.input.getMinX(), this.input.getMinY(), this.input.getWidth(), this.input.getHeight());
            colorModel = this.input.getColorModel();
        }
        rectangle = rectangle == null ? (Rectangle)rectangle2.clone() : rectangle.intersection(rectangle2);
        if (rectangle.isEmpty()) {
            throw new RuntimeException(I18N.getString("RawImageWriter1"));
        }
        this.scaleX = imageWriteParam.getSourceXSubsampling();
        this.scaleY = imageWriteParam.getSourceYSubsampling();
        this.xOffset = imageWriteParam.getSubsamplingXOffset();
        this.yOffset = imageWriteParam.getSubsamplingYOffset();
        rectangle.translate(this.xOffset, this.yOffset);
        rectangle.width -= this.xOffset;
        rectangle.height -= this.yOffset;
        this.xOffset = rectangle.x % this.scaleX;
        this.yOffset = rectangle.y % this.scaleY;
        int n3 = rectangle.x / this.scaleX;
        int n4 = rectangle.y / this.scaleY;
        int n5 = (rectangle.width + this.scaleX - 1) / this.scaleX;
        int n6 = (rectangle.height + this.scaleY - 1) / this.scaleY;
        this.destinationRegion = new Rectangle(n3, n4, n5, n6);
        this.noTransform = this.destinationRegion.equals(rectangle2);
        this.tileHeight = this.sampleModel.getHeight();
        this.tileWidth = this.sampleModel.getWidth();
        if (this.noTransform) {
            if (this.writeRaster) {
                this.tileXOffset = this.inputRaster.getMinX();
                this.tileYOffset = this.inputRaster.getMinY();
            } else {
                this.tileXOffset = this.input.getTileGridXOffset();
                this.tileYOffset = this.input.getTileGridYOffset();
            }
        } else {
            this.tileXOffset = this.destinationRegion.x;
            this.tileYOffset = this.destinationRegion.y;
        }
        this.sourceBands = imageWriteParam.getSourceBands();
        boolean bl2 = true;
        this.numBands = this.sampleModel.getNumBands();
        if (this.sourceBands != null) {
            this.sampleModel = this.sampleModel.createSubsetSampleModel(this.sourceBands);
            colorModel = null;
            bl2 = false;
            this.numBands = this.sampleModel.getNumBands();
        } else {
            this.sourceBands = new int[this.numBands];
            for (int i2 = 0; i2 < this.numBands; ++i2) {
                this.sourceBands[i2] = i2;
            }
        }
        if (this.sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.sampleModel;
            int[] nArray = componentSampleModel.getBandOffsets();
            this.bandStride = nArray[0];
            for (int i3 = 1; i3 < nArray.length; ++i3) {
                if (this.bandStride <= nArray[i3]) continue;
                this.bandStride = nArray[i3];
            }
            int[] nArray2 = componentSampleModel.getBankIndices();
            n2 = nArray2[0];
            for (int i4 = 1; i4 < nArray2.length; ++i4) {
                if (n2 <= nArray2[i4]) continue;
                n2 = nArray2[i4];
            }
            this.pxlStride = componentSampleModel.getPixelStride();
            this.lineStride = componentSampleModel.getScanlineStride();
            this.optimal = this.bandStride == 0 || this.pxlStride < this.lineStride && this.pxlStride == this.numBands || this.lineStride < this.pxlStride && this.lineStride == this.numBands || this.pxlStride < this.lineStride && this.lineStride == this.numBands * componentSampleModel.getWidth() || this.lineStride < this.pxlStride && this.pxlStride == this.numBands * componentSampleModel.getHeight() || componentSampleModel instanceof BandedSampleModel;
        } else if (this.sampleModel instanceof SinglePixelPackedSampleModel || this.sampleModel instanceof MultiPixelPackedSampleModel) {
            this.optimal = true;
        }
        int n7 = this.getMaxTileX() - this.getMinTileX() + 1;
        int n8 = n7 * (this.getMaxTileY() - this.getMinTileY() + 1);
        for (int i5 = this.getMinTileY(); i5 <= this.getMaxTileY(); ++i5) {
            for (n2 = this.getMinTileX(); n2 <= this.getMaxTileX(); ++n2) {
                this.writeRaster(this.getTile(n2, i5));
                float f2 = ((float)(n2 + i5 * n7) + 1.0f) / (float)n8;
                this.processImageProgress(f2 * 100.0f);
            }
        }
        this.stream.flush();
        if (this.abortRequested()) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
        }
    }

    public int getWidth() {
        return this.destinationRegion.width;
    }

    public int getHeight() {
        return this.destinationRegion.height;
    }

    private void writeRaster(Raster object) throws IOException {
        Object object2;
        Object object3;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = null;
        int[] nArray2 = null;
        int n4 = 0;
        int n5 = this.sampleModel.getNumBands();
        int n6 = this.sampleModel.getDataType();
        if (this.sampleModel instanceof ComponentSampleModel) {
            int n7;
            object3 = (ComponentSampleModel)this.sampleModel;
            nArray2 = ((ComponentSampleModel)object3).getBandOffsets();
            for (n7 = 0; n7 < n5; ++n7) {
                if (n3 >= nArray2[n7]) continue;
                n3 = nArray2[n7];
            }
            nArray = ((ComponentSampleModel)object3).getBankIndices();
            for (n7 = 0; n7 < n5; ++n7) {
                if (n2 >= nArray[n7]) continue;
                n2 = nArray[n7];
            }
            n4 = (int)ImageUtil.getBandSize(this.sampleModel);
        }
        object3 = null;
        short[] sArray = null;
        int[] nArray3 = null;
        float[] fArray = null;
        double[] dArray = null;
        if (((Raster)object).getParent() != null && !this.sampleModel.equals(((Raster)object).getParent().getSampleModel())) {
            object2 = Raster.createWritableRaster(this.sampleModel, new Point(((Raster)object).getMinX(), ((Raster)object).getMinY()));
            ((WritableRaster)object2).setRect((Raster)object);
            object = object2;
        }
        object2 = ((Raster)object).getDataBuffer();
        if (this.optimal) {
            if (n2 > 0) {
                block61: for (int i2 = 0; i2 < this.numBands; ++i2) {
                    int n8 = nArray[this.sourceBands[i2]];
                    switch (n6) {
                        case 0: {
                            object3 = ((DataBufferByte)object2).getData(n8);
                            this.stream.write((byte[])object3, 0, ((Object)object3).length);
                            continue block61;
                        }
                        case 2: {
                            sArray = ((DataBufferShort)object2).getData(n8);
                            this.stream.writeShorts(sArray, 0, sArray.length);
                            continue block61;
                        }
                        case 1: {
                            sArray = ((DataBufferUShort)object2).getData(n8);
                            this.stream.writeShorts(sArray, 0, sArray.length);
                            continue block61;
                        }
                        case 3: {
                            nArray3 = ((DataBufferInt)object2).getData(n8);
                            this.stream.writeInts(nArray3, 0, nArray3.length);
                            continue block61;
                        }
                        case 4: {
                            fArray = ((DataBufferFloat)object2).getData(n8);
                            this.stream.writeFloats(fArray, 0, fArray.length);
                            continue block61;
                        }
                        case 5: {
                            dArray = ((DataBufferDouble)object2).getData(n8);
                            this.stream.writeDoubles(dArray, 0, dArray.length);
                        }
                    }
                }
            } else {
                switch (n6) {
                    case 0: {
                        object3 = ((DataBufferByte)object2).getData();
                        break;
                    }
                    case 2: {
                        sArray = ((DataBufferShort)object2).getData();
                        break;
                    }
                    case 1: {
                        sArray = ((DataBufferUShort)object2).getData();
                        break;
                    }
                    case 3: {
                        nArray3 = ((DataBufferInt)object2).getData();
                        break;
                    }
                    case 4: {
                        fArray = ((DataBufferFloat)object2).getData();
                        break;
                    }
                    case 5: {
                        dArray = ((DataBufferDouble)object2).getData();
                    }
                }
                if (!this.noSubband && n3 >= ((Raster)object).getWidth() * ((Raster)object).getHeight() * (this.numBands - 1)) {
                    block62: for (int i3 = 0; i3 < this.numBands; ++i3) {
                        int n9 = nArray2[this.sourceBands[i3]];
                        switch (n6) {
                            case 0: {
                                this.stream.write((byte[])object3, n9, n4);
                                continue block62;
                            }
                            case 1: 
                            case 2: {
                                this.stream.writeShorts(sArray, n9, n4);
                                continue block62;
                            }
                            case 3: {
                                this.stream.writeInts(nArray3, n9, n4);
                                continue block62;
                            }
                            case 4: {
                                this.stream.writeFloats(fArray, n9, n4);
                                continue block62;
                            }
                            case 5: {
                                this.stream.writeDoubles(dArray, n9, n4);
                            }
                        }
                    }
                } else {
                    switch (n6) {
                        case 0: {
                            this.stream.write((byte[])object3, 0, ((Object)object3).length);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.stream.writeShorts(sArray, 0, sArray.length);
                            break;
                        }
                        case 3: {
                            this.stream.writeInts(nArray3, 0, nArray3.length);
                            break;
                        }
                        case 4: {
                            this.stream.writeFloats(fArray, 0, fArray.length);
                            break;
                        }
                        case 5: {
                            this.stream.writeDoubles(dArray, 0, dArray.length);
                        }
                    }
                }
            }
        } else if (this.sampleModel instanceof ComponentSampleModel) {
            switch (n6) {
                case 0: {
                    object3 = ((DataBufferByte)object2).getData();
                    break;
                }
                case 2: {
                    sArray = ((DataBufferShort)object2).getData();
                    break;
                }
                case 1: {
                    sArray = ((DataBufferUShort)object2).getData();
                    break;
                }
                case 3: {
                    nArray3 = ((DataBufferInt)object2).getData();
                    break;
                }
                case 4: {
                    fArray = ((DataBufferFloat)object2).getData();
                    break;
                }
                case 5: {
                    dArray = ((DataBufferDouble)object2).getData();
                }
            }
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.sampleModel;
            int n10 = componentSampleModel.getOffset(((Raster)object).getMinX() - ((Raster)object).getSampleModelTranslateX(), ((Raster)object).getMinY() - ((Raster)object).getSampleModelTranslateY()) - nArray2[0];
            int n11 = this.pxlStride;
            int n12 = 1;
            int n13 = this.pxlStride;
            int n14 = ((Raster)object).getWidth();
            int n15 = ((Raster)object).getHeight();
            int n16 = n14;
            int n17 = n15;
            if (n11 < this.lineStride) {
                if (n3 > this.pxlStride) {
                    n12 = n14;
                }
                n11 = this.lineStride;
            } else {
                if (n3 > this.lineStride) {
                    n12 = n15;
                }
                n13 = this.lineStride;
                n16 = n15;
                n17 = n14;
            }
            int n18 = n16 * this.numBands;
            byte[] byArray = null;
            short[] sArray2 = null;
            int[] nArray4 = null;
            float[] fArray2 = null;
            double[] dArray2 = null;
            Object object4 = null;
            Object[] objectArray = null;
            switch (n6) {
                case 0: {
                    object4 = object3;
                    objectArray = byArray = new byte[n18];
                    break;
                }
                case 1: 
                case 2: {
                    object4 = sArray;
                    sArray2 = new short[n18];
                    objectArray = sArray2;
                    break;
                }
                case 3: {
                    object4 = nArray3;
                    nArray4 = new int[n18];
                    objectArray = nArray4;
                    break;
                }
                case 4: {
                    object4 = fArray;
                    fArray2 = new float[n18];
                    objectArray = fArray2;
                    break;
                }
                case 5: {
                    object4 = dArray;
                    dArray2 = new double[n18];
                    objectArray = dArray2;
                }
            }
            if (n12 > 1) {
                for (int i4 = 0; i4 < n17; ++i4) {
                    for (int i5 = 0; i5 < this.numBands; ++i5) {
                        int n19 = nArray2[i5];
                        System.arraycopy(object4, n10 + n19, objectArray, i5 * n16, n16);
                    }
                    switch (n6) {
                        case 0: {
                            this.stream.write((byte[])objectArray, 0, n18);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.stream.writeShorts((short[])objectArray, 0, n18);
                            break;
                        }
                        case 3: {
                            this.stream.writeInts((int[])objectArray, 0, n18);
                            break;
                        }
                        case 4: {
                            this.stream.writeFloats((float[])objectArray, 0, n18);
                            break;
                        }
                        case 5: {
                            this.stream.writeDoubles((double[])objectArray, 0, n18);
                        }
                    }
                    n10 += n11;
                }
            } else {
                switch (n6) {
                    case 0: {
                        for (int i6 = 0; i6 < n17; ++i6) {
                            int n20 = 0;
                            for (int i7 = 0; i7 < this.numBands; ++i7) {
                                int n21 = nArray2[i7];
                                int n22 = 0;
                                int n23 = n10;
                                while (n22 < n16) {
                                    byArray[n20++] = (byte)object3[n23 + n21];
                                    ++n22;
                                    n23 += n13;
                                }
                            }
                            this.stream.write(byArray, 0, n18);
                            n10 += n11;
                        }
                        break;
                    }
                    case 1: 
                    case 2: {
                        for (int i8 = 0; i8 < n17; ++i8) {
                            int n24 = 0;
                            for (int i9 = 0; i9 < this.numBands; ++i9) {
                                int n25 = nArray2[i9];
                                int n26 = 0;
                                int n27 = n10;
                                while (n26 < n16) {
                                    sArray2[n24++] = sArray[n27 + n25];
                                    ++n26;
                                    n27 += n13;
                                }
                            }
                            this.stream.writeShorts(sArray2, 0, n18);
                            n10 += n11;
                        }
                        break;
                    }
                    case 3: {
                        for (int i10 = 0; i10 < n17; ++i10) {
                            int n28 = 0;
                            for (int i11 = 0; i11 < this.numBands; ++i11) {
                                int n29 = nArray2[i11];
                                int n30 = 0;
                                int n31 = n10;
                                while (n30 < n16) {
                                    nArray4[n28++] = nArray3[n31 + n29];
                                    ++n30;
                                    n31 += n13;
                                }
                            }
                            this.stream.writeInts(nArray4, 0, n18);
                            n10 += n11;
                        }
                        break;
                    }
                    case 4: {
                        for (int i12 = 0; i12 < n17; ++i12) {
                            int n32 = 0;
                            for (int i13 = 0; i13 < this.numBands; ++i13) {
                                int n33 = nArray2[i13];
                                int n34 = 0;
                                int n35 = n10;
                                while (n34 < n16) {
                                    fArray2[n32++] = fArray[n35 + n33];
                                    ++n34;
                                    n35 += n13;
                                }
                            }
                            this.stream.writeFloats(fArray2, 0, n18);
                            n10 += n11;
                        }
                        break;
                    }
                    case 5: {
                        for (int i14 = 0; i14 < n17; ++i14) {
                            int n36 = 0;
                            for (int i15 = 0; i15 < this.numBands; ++i15) {
                                int n37 = nArray2[i15];
                                int n38 = 0;
                                int n39 = n10;
                                while (n38 < n16) {
                                    dArray2[n36++] = dArray[n39 + n37];
                                    ++n38;
                                    n39 += n13;
                                }
                            }
                            this.stream.writeDoubles(dArray2, 0, n18);
                            n10 += n11;
                        }
                        break;
                    }
                }
            }
        }
    }

    private Raster getTile(int n2, int n3) {
        int n4 = this.tileXOffset + n2 * this.tileWidth;
        int n5 = this.tileYOffset + n3 * this.tileHeight;
        Rectangle rectangle = new Rectangle(n4, n5, this.tileWidth, this.tileHeight);
        if (this.writeRaster) {
            rectangle = rectangle.intersection(this.destinationRegion);
            if (this.noTransform) {
                return this.inputRaster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, this.sourceBands);
            }
            n4 = rectangle.x;
            n5 = rectangle.y;
            WritableRaster writableRaster = Raster.createWritableRaster(this.sampleModel, new Point(n4, n5));
            int n6 = this.mapToSourceX(n4);
            int n7 = this.mapToSourceY(n5);
            int n8 = this.inputRaster.getMinY();
            int n9 = this.inputRaster.getMinY() + this.inputRaster.getHeight();
            int n10 = rectangle.width;
            int n11 = (n10 - 1) * this.scaleX + 1;
            int n12 = 0;
            while (n12 < rectangle.height) {
                if (n7 >= n8 && n7 < n9) {
                    Raster raster = this.inputRaster.createChild(n6, n7, n11, 1, n6, n7, null);
                    int n13 = n4;
                    int n14 = 0;
                    int n15 = n6;
                    while (n14 < n10) {
                        for (int i2 = 0; i2 < this.numBands; ++i2) {
                            int n16 = raster.getSample(n15, n7, this.sourceBands[i2]);
                            writableRaster.setSample(n13, n5, i2, n16);
                        }
                        ++n14;
                        ++n13;
                        n15 += this.scaleX;
                    }
                }
                ++n12;
                ++n5;
                n7 += this.scaleY;
            }
            return writableRaster;
        }
        if (this.noTransform) {
            Raster raster = this.input.getTile(n2, n3);
            if (this.destinationRegion.contains(rectangle) && this.noSubband) {
                return raster;
            }
            rectangle = rectangle.intersection(this.destinationRegion);
            return raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, this.sourceBands);
        }
        rectangle = rectangle.intersection(this.destinationRegion);
        n4 = rectangle.x;
        n5 = rectangle.y;
        WritableRaster writableRaster = Raster.createWritableRaster(this.sampleModel, new Point(n4, n5));
        int n17 = this.mapToSourceX(n4);
        int n18 = this.mapToSourceY(n5);
        int n19 = this.input.getMinY();
        int n20 = this.input.getMinY() + this.input.getHeight();
        int n21 = rectangle.width;
        int n22 = (n21 - 1) * this.scaleX + 1;
        int n23 = 0;
        while (n23 < rectangle.height) {
            if (n18 >= n19 && n18 < n20) {
                Raster raster = this.input.getData(new Rectangle(n17, n18, n22, 1));
                int n24 = n4;
                int n25 = 0;
                int n26 = n17;
                while (n25 < n21) {
                    for (int i3 = 0; i3 < this.numBands; ++i3) {
                        int n27 = raster.getSample(n26, n18, this.sourceBands[i3]);
                        writableRaster.setSample(n24, n5, i3, n27);
                    }
                    ++n25;
                    ++n24;
                    n26 += this.scaleX;
                }
            }
            ++n23;
            ++n5;
            n18 += this.scaleY;
        }
        return writableRaster;
    }

    private int mapToSourceX(int n2) {
        return n2 * this.scaleX + this.xOffset;
    }

    private int mapToSourceY(int n2) {
        return n2 * this.scaleY + this.yOffset;
    }

    private int getMinTileX() {
        return RawImageWriter.ToTile(this.destinationRegion.x, this.tileXOffset, this.tileWidth);
    }

    private int getMaxTileX() {
        return RawImageWriter.ToTile(this.destinationRegion.x + this.destinationRegion.width - 1, this.tileXOffset, this.tileWidth);
    }

    private int getMinTileY() {
        return RawImageWriter.ToTile(this.destinationRegion.y, this.tileYOffset, this.tileHeight);
    }

    private int getMaxTileY() {
        return RawImageWriter.ToTile(this.destinationRegion.y + this.destinationRegion.height - 1, this.tileYOffset, this.tileHeight);
    }

    private static int ToTile(int n2, int n3, int n4) {
        if ((n2 -= n3) < 0) {
            n2 += 1 - n4;
        }
        return n2 / n4;
    }

    public void reset() {
        super.reset();
        this.stream = null;
        this.optimal = false;
        this.sourceBands = null;
        this.destinationRegion = null;
        this.noTransform = true;
        this.noSubband = true;
        this.writeRaster = false;
    }
}

