/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.raw;

import com.sun.media.imageio.stream.RawImageInputStream;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.SimpleRenderedImage;
import com.sun.media.imageioimpl.plugins.raw.I18N;
import com.sun.media.imageioimpl.plugins.raw.RawImageReader;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;

public class RawRenderedImage
extends SimpleRenderedImage {
    private SampleModel originalSampleModel;
    private Raster currentTile;
    private Point currentTileGrid;
    private RawImageInputStream iis = null;
    private RawImageReader reader;
    private ImageReadParam param = null;
    private int imageIndex;
    private Rectangle destinationRegion;
    private Rectangle originalRegion;
    private Point sourceOrigin;
    private Dimension originalDimension;
    private int maxXTile;
    private int maxYTile;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private int[] destinationBands = null;
    private int[] sourceBands = null;
    private int nComp;
    private boolean noTransform = true;
    private WritableRaster rasForATile;
    private BufferedImage destImage;
    private long position;
    private long tileDataSize;
    private int originalNumXTiles;

    public RawRenderedImage(RawImageInputStream rawImageInputStream, RawImageReader rawImageReader, ImageReadParam imageReadParam, int n2) throws IOException {
        int n3;
        this.iis = rawImageInputStream;
        this.reader = rawImageReader;
        this.param = imageReadParam;
        this.imageIndex = n2;
        this.position = rawImageInputStream.getImageOffset(n2);
        this.originalDimension = rawImageInputStream.getImageDimension(n2);
        ImageTypeSpecifier imageTypeSpecifier = rawImageInputStream.getImageType();
        this.sampleModel = this.originalSampleModel = imageTypeSpecifier.getSampleModel();
        this.colorModel = imageTypeSpecifier.getColorModel();
        int[] nArray = this.sourceBands = imageReadParam == null ? null : imageReadParam.getSourceBands();
        if (this.sourceBands == null) {
            this.nComp = this.originalSampleModel.getNumBands();
            this.sourceBands = new int[this.nComp];
            for (n3 = 0; n3 < this.nComp; ++n3) {
                this.sourceBands[n3] = n3;
            }
        } else {
            this.sampleModel = this.originalSampleModel.createSubsetSampleModel(this.sourceBands);
            this.colorModel = ImageUtil.createColorModel(null, this.sampleModel);
        }
        this.nComp = this.sourceBands.length;
        int[] nArray2 = this.destinationBands = imageReadParam == null ? null : imageReadParam.getDestinationBands();
        if (this.destinationBands == null) {
            this.destinationBands = new int[this.nComp];
            for (n3 = 0; n3 < this.nComp; ++n3) {
                this.destinationBands[n3] = n3;
            }
        }
        Dimension dimension = rawImageInputStream.getImageDimension(n2);
        this.width = dimension.width;
        this.height = dimension.height;
        Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
        this.originalRegion = (Rectangle)rectangle.clone();
        this.destinationRegion = (Rectangle)rectangle.clone();
        if (imageReadParam != null) {
            RawImageReader.computeRegionsWrapper(imageReadParam, this.width, this.height, imageReadParam.getDestination(), rectangle, this.destinationRegion);
            this.scaleX = imageReadParam.getSourceXSubsampling();
            this.scaleY = imageReadParam.getSourceYSubsampling();
            this.xOffset = imageReadParam.getSubsamplingXOffset();
            this.yOffset = imageReadParam.getSubsamplingYOffset();
        }
        this.sourceOrigin = new Point(rectangle.x, rectangle.y);
        if (!this.destinationRegion.equals(rectangle)) {
            this.noTransform = false;
        }
        this.tileDataSize = ImageUtil.getTileSize(this.originalSampleModel);
        this.tileWidth = this.originalSampleModel.getWidth();
        this.tileHeight = this.originalSampleModel.getHeight();
        this.tileGridXOffset = this.destinationRegion.x;
        this.tileGridYOffset = this.destinationRegion.y;
        this.originalNumXTiles = this.getNumXTiles();
        this.width = this.destinationRegion.width;
        this.height = this.destinationRegion.height;
        this.minX = this.destinationRegion.x;
        this.minY = this.destinationRegion.y;
        this.sampleModel = this.sampleModel.createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        this.maxXTile = this.originalDimension.width / this.tileWidth;
        this.maxYTile = this.originalDimension.height / this.tileHeight;
    }

    public synchronized Raster getTile(int n2, int n3) {
        block21: {
            if (this.currentTile != null && this.currentTileGrid.x == n2 && this.currentTileGrid.y == n3) {
                return this.currentTile;
            }
            if (n2 >= this.getNumXTiles() || n3 >= this.getNumYTiles()) {
                throw new IllegalArgumentException(I18N.getString("RawRenderedImage0"));
            }
            try {
                this.iis.seek(this.position + (long)(n3 * this.originalNumXTiles + n2) * this.tileDataSize);
                int n4 = this.tileXToX(n2);
                int n5 = this.tileYToY(n3);
                this.currentTile = Raster.createWritableRaster(this.sampleModel, new Point(n4, n5));
                if (this.noTransform) {
                    switch (this.sampleModel.getDataType()) {
                        case 0: {
                            byte[][] byArray = ((DataBufferByte)this.currentTile.getDataBuffer()).getBankData();
                            for (int i2 = 0; i2 < byArray.length; ++i2) {
                                this.iis.readFully(byArray[i2], 0, byArray[i2].length);
                            }
                            break block21;
                        }
                        case 2: {
                            short[][] sArray = ((DataBufferShort)this.currentTile.getDataBuffer()).getBankData();
                            for (int i3 = 0; i3 < sArray.length; ++i3) {
                                this.iis.readFully(sArray[i3], 0, sArray[i3].length);
                            }
                            break block21;
                        }
                        case 1: {
                            short[][] sArray = ((DataBufferUShort)this.currentTile.getDataBuffer()).getBankData();
                            for (int i4 = 0; i4 < sArray.length; ++i4) {
                                this.iis.readFully(sArray[i4], 0, sArray[i4].length);
                            }
                            break block21;
                        }
                        case 3: {
                            int[][] nArray = ((DataBufferInt)this.currentTile.getDataBuffer()).getBankData();
                            for (int i5 = 0; i5 < nArray.length; ++i5) {
                                this.iis.readFully(nArray[i5], 0, nArray[i5].length);
                            }
                            break block21;
                        }
                        case 4: {
                            float[][] fArray = ((DataBufferFloat)this.currentTile.getDataBuffer()).getBankData();
                            for (int i6 = 0; i6 < fArray.length; ++i6) {
                                this.iis.readFully(fArray[i6], 0, fArray[i6].length);
                            }
                            break block21;
                        }
                        case 5: {
                            double[][] dArray = ((DataBufferDouble)this.currentTile.getDataBuffer()).getBankData();
                            for (int i7 = 0; i7 < dArray.length; ++i7) {
                                this.iis.readFully(dArray[i7], 0, dArray[i7].length);
                            }
                            break;
                        }
                    }
                    break block21;
                }
                this.currentTile = this.readSubsampledRaster((WritableRaster)this.currentTile);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        if (this.currentTileGrid == null) {
            this.currentTileGrid = new Point(n2, n3);
        } else {
            this.currentTileGrid.x = n2;
            this.currentTileGrid.y = n3;
        }
        return this.currentTile;
    }

    public void readAsRaster(WritableRaster writableRaster) throws IOException {
        this.readSubsampledRaster(writableRaster);
    }

    private Raster readSubsampledRaster(WritableRaster writableRaster) throws IOException {
        Object object;
        if (writableRaster == null) {
            writableRaster = Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(this.destinationRegion.x, this.destinationRegion.y));
        }
        int n2 = this.sourceBands.length;
        int n3 = this.sampleModel.getDataType();
        int n4 = DataBuffer.getDataTypeSize(n3);
        int n5 = (n4 + 7) / 8;
        Rectangle rectangle = writableRaster.getBounds().intersection(this.destinationRegion);
        int n6 = this.destinationRegion.x;
        int n7 = this.destinationRegion.y;
        int n8 = (rectangle.x - n6) * this.scaleX + this.sourceOrigin.x;
        int n9 = (rectangle.y - n7) * this.scaleY + this.sourceOrigin.y;
        int n10 = (rectangle.width - 1) * this.scaleX + n8;
        int n11 = (rectangle.height - 1) * this.scaleY + n9;
        int n12 = n8 / this.tileWidth;
        int n13 = n9 / this.tileHeight;
        int n14 = n10 / this.tileWidth;
        int n15 = n11 / this.tileHeight;
        n12 = this.clip(n12, 0, this.maxXTile);
        n13 = this.clip(n13, 0, this.maxYTile);
        n14 = this.clip(n14, 0, this.maxXTile);
        n15 = this.clip(n15, 0, this.maxYTile);
        int n16 = this.getNumXTiles();
        int n17 = this.getNumYTiles();
        int n18 = n16 * n17;
        byte[] byArray = null;
        short[] sArray = null;
        int[] nArray = null;
        float[] fArray = null;
        double[] dArray = null;
        boolean bl2 = true;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int[] nArray2 = null;
        int[] nArray3 = null;
        if (this.originalSampleModel instanceof ComponentSampleModel) {
            int n22;
            object = (ComponentSampleModel)this.originalSampleModel;
            nArray3 = ((ComponentSampleModel)object).getBankIndices();
            int n23 = 0;
            for (n22 = 0; n22 < nArray3.length; ++n22) {
                if (n23 <= nArray3[n22]) continue;
                n23 = nArray3[n22];
            }
            if (n23 > 0) {
                bl2 = false;
            }
            n19 = ((ComponentSampleModel)object).getPixelStride();
            n20 = ((ComponentSampleModel)object).getScanlineStride();
            nArray2 = ((ComponentSampleModel)object).getBandOffsets();
            for (n22 = 0; n22 < nArray2.length; ++n22) {
                if (n21 >= nArray2[n22]) continue;
                n21 = nArray2[n22];
            }
        } else if (this.originalSampleModel instanceof MultiPixelPackedSampleModel) {
            n20 = ((MultiPixelPackedSampleModel)this.originalSampleModel).getScanlineStride();
        } else if (this.originalSampleModel instanceof SinglePixelPackedSampleModel) {
            n19 = 1;
            n20 = ((SinglePixelPackedSampleModel)this.originalSampleModel).getScanlineStride();
        }
        object = null;
        short[] sArray2 = null;
        int[] nArray4 = null;
        float[] fArray2 = null;
        double[] dArray2 = null;
        int[] nArray5 = null;
        int n24 = 0;
        int n25 = 0;
        int n26 = 0;
        if (writableRaster.getSampleModel() instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
            nArray3 = componentSampleModel.getBankIndices();
            nArray5 = componentSampleModel.getBandOffsets();
            n24 = componentSampleModel.getPixelStride();
            n25 = componentSampleModel.getScanlineStride();
            n26 = componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY()) - nArray5[0];
            switch (n3) {
                case 0: {
                    object = ((DataBufferByte)writableRaster.getDataBuffer()).getData();
                    break;
                }
                case 2: {
                    sArray2 = ((DataBufferShort)writableRaster.getDataBuffer()).getData();
                    break;
                }
                case 1: {
                    sArray2 = ((DataBufferUShort)writableRaster.getDataBuffer()).getData();
                    break;
                }
                case 3: {
                    nArray4 = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
                    break;
                }
                case 4: {
                    fArray2 = ((DataBufferFloat)writableRaster.getDataBuffer()).getData();
                    break;
                }
                case 5: {
                    dArray2 = ((DataBufferDouble)writableRaster.getDataBuffer()).getData();
                }
            }
        } else if (writableRaster.getSampleModel() instanceof SinglePixelPackedSampleModel) {
            n2 = 1;
            nArray3 = new int[]{0};
            nArray5 = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray5[i2] = 0;
            }
            n24 = 1;
            n25 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        }
        for (int i3 = n13; i3 <= n15 && !this.reader.getAbortRequest(); ++i3) {
            for (int i4 = n12; i4 <= n14 && !this.reader.getAbortRequest(); ++i4) {
                int n27;
                int n28;
                int n29;
                int n30;
                int n31;
                int n32;
                int n33;
                int n34;
                int n35;
                int n36;
                int n37;
                int n38;
                int n39;
                int n40;
                int n41;
                int n42;
                int n43;
                long l2 = this.position + (long)(i3 * this.originalNumXTiles + i4) * this.tileDataSize;
                this.iis.seek(l2);
                float f2 = (i4 - n12 + i3 * n16) / n16;
                int n44 = i4 * this.tileWidth;
                int n45 = i3 * this.tileHeight;
                int n46 = this.tileHeight;
                int n47 = this.tileWidth;
                if (n45 + n46 >= this.originalDimension.height) {
                    n46 = this.originalDimension.height - n45;
                }
                if (n44 + n47 >= this.originalDimension.width) {
                    n47 = this.originalDimension.width - n44;
                }
                int n48 = n44;
                int n49 = n45;
                if (n8 > n44) {
                    n47 += n44 - n8;
                    n48 = n8;
                    n44 = n8;
                }
                if (n9 > n45) {
                    n46 += n45 - n9;
                    n49 = n9;
                    n45 = n9;
                }
                if (n10 < n44 + n47 - 1) {
                    n47 += n10 - n44 - n47 + 1;
                }
                if (n11 < n45 + n46 - 1) {
                    n46 += n11 - n45 - n46 + 1;
                }
                int n50 = (n44 + this.scaleX - 1 - this.sourceOrigin.x) / this.scaleX;
                int n51 = (n44 + this.scaleX - 1 + n47 - this.sourceOrigin.x) / this.scaleX;
                int n52 = n51 - n50;
                n51 = (n51 - 1) * this.scaleX + this.sourceOrigin.x;
                int n53 = (n45 + this.scaleY - 1 - this.sourceOrigin.y) / this.scaleY;
                n44 = n50 * this.scaleX + this.sourceOrigin.x;
                n45 = n53 * this.scaleY + this.sourceOrigin.y;
                n50 += n6;
                n53 += n7;
                n48 -= i4 * this.tileWidth;
                n49 -= i3 * this.tileHeight;
                if (this.sampleModel instanceof MultiPixelPackedSampleModel) {
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)this.originalSampleModel;
                    this.iis.skipBytes(multiPixelPackedSampleModel.getOffset(n48, n49) * n5);
                    n43 = (multiPixelPackedSampleModel.getOffset(n51, 0) - multiPixelPackedSampleModel.getOffset(n44, 0) + 1) * n5;
                    n42 = (n20 * this.scaleY - n43) * n5;
                    if (byArray == null || byArray.length < (n43 *= n5)) {
                        byArray = new byte[n43];
                    }
                    n41 = multiPixelPackedSampleModel.getBitOffset(n48);
                    n40 = 0;
                    n39 = n53;
                    while (n40 < n46 && !this.reader.getAbortRequest()) {
                        this.iis.readFully(byArray, 0, n43);
                        if (this.scaleX == 1) {
                            if (n41 != 0) {
                                n38 = 255 << n41 & 0xFF;
                                n37 = ~n38 & 0xFF;
                                n36 = 8 - n41;
                                for (n35 = 0; n35 < n43 - 1; ++n35) {
                                    byArray[n35] = (byte)((byArray[n35] & n37) << n36 | (byArray[n35 + 1] & n38) >> n41);
                                }
                                byArray[n35] = (byte)((byArray[n35] & n37) << n36);
                            }
                        } else {
                            n38 = 7;
                            n37 = 0;
                            n36 = 128;
                            n35 = 0;
                            n34 = n44 & 7;
                            while (n35 < n52) {
                                byArray[n37] = (byte)(byArray[n37] & ~(1 << n38) | (byArray[n34 >> 3] >> 7 - (n34 & 7) & 1) << n38);
                                if (--n38 == -1) {
                                    n38 = 7;
                                    ++n37;
                                }
                                ++n35;
                                n34 += this.scaleX;
                            }
                        }
                        ImageUtil.setPackedBinaryData(byArray, writableRaster, new Rectangle(n50, n39, n52, 1));
                        this.iis.skipBytes(n42);
                        if (this.destImage != null) {
                            this.reader.processImageUpdateWrapper(this.destImage, n50, n39, n47, 1, 1, 1, this.destinationBands);
                        }
                        this.reader.processImageProgressWrapper(f2 + ((float)(n40 - n45) + 1.0f) / (float)n46 / (float)n18);
                        n40 += this.scaleY;
                        ++n39;
                    }
                    continue;
                }
                if (n19 < n20) {
                    n33 = n47 * n19;
                    n43 = (n20 * this.scaleY - n33) * n5;
                } else {
                    n33 = n46 * n20;
                    n43 = (n19 * this.scaleX - n33) * n5;
                }
                switch (this.sampleModel.getDataType()) {
                    case 0: {
                        if (byArray != null && byArray.length >= n33) break;
                        byArray = new byte[n33];
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (sArray != null && sArray.length >= n33) break;
                        sArray = new short[n33];
                        break;
                    }
                    case 3: {
                        if (nArray != null && nArray.length >= n33) break;
                        nArray = new int[n33];
                        break;
                    }
                    case 4: {
                        if (fArray != null && fArray.length >= n33) break;
                        fArray = new float[n33];
                        break;
                    }
                    case 5: {
                        if (dArray != null && dArray.length >= n33) break;
                        dArray = new double[n33];
                    }
                }
                if (this.sampleModel instanceof PixelInterleavedSampleModel) {
                    this.iis.skipBytes((n48 * n19 + n49 * n20) * n5);
                    if (n19 < n20) {
                        n42 = 0;
                        n41 = n53;
                        n40 = this.scaleY;
                        n39 = n46;
                        n38 = this.scaleX * n19;
                        n37 = n24;
                        n36 = n25;
                    } else {
                        n42 = 0;
                        n41 = n50;
                        n40 = this.scaleX;
                        n39 = n47;
                        n38 = this.scaleY * n20;
                        n37 = n25;
                        n36 = n24;
                    }
                    n35 = n26 + (n53 - writableRaster.getSampleModelTranslateY()) * n25 + (n50 - writableRaster.getSampleModelTranslateX()) * n24;
                    n34 = n42;
                    n32 = n41;
                    while (n34 < n39 && !this.reader.getAbortRequest()) {
                        switch (n3) {
                            case 0: {
                                if (n38 == n2 && n37 == n2) {
                                    this.iis.readFully((byte[])object, n35, n33);
                                    break;
                                }
                                this.iis.readFully(byArray, 0, n33);
                                break;
                            }
                            case 1: 
                            case 2: {
                                if (n38 == n2 && n37 == n2) {
                                    this.iis.readFully(sArray2, n35, n33);
                                    break;
                                }
                                this.iis.readFully(sArray, 0, n33);
                                break;
                            }
                            case 3: {
                                if (n38 == n2 && n37 == n2) {
                                    this.iis.readFully(nArray4, n35, n33);
                                    break;
                                }
                                this.iis.readFully(nArray, 0, n33);
                                break;
                            }
                            case 4: {
                                if (n38 == n2 && n37 == n2) {
                                    this.iis.readFully(fArray2, n35, n33);
                                    break;
                                }
                                this.iis.readFully(fArray, 0, n33);
                                break;
                            }
                            case 5: {
                                if (n38 == n2 && n37 == n2) {
                                    this.iis.readFully(dArray2, n35, n33);
                                    break;
                                }
                                this.iis.readFully(dArray, 0, n33);
                            }
                        }
                        if (n38 != n2 || n37 != n2) {
                            for (n31 = 0; n31 < n2; ++n31) {
                                n30 = nArray5[this.destinationBands[n31]];
                                n35 += n30;
                                n29 = nArray2[this.sourceBands[n31]];
                                switch (n3) {
                                    case 0: {
                                        n28 = 0;
                                        n27 = n35;
                                        while (n28 < n33) {
                                            object[n27] = byArray[n28 + n29];
                                            n28 += n38;
                                            n27 += n37;
                                        }
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        n28 = 0;
                                        n27 = n35;
                                        while (n28 < n33) {
                                            sArray2[n27] = sArray[n28 + n29];
                                            n28 += n38;
                                            n27 += n37;
                                        }
                                        break;
                                    }
                                    case 3: {
                                        n28 = 0;
                                        n27 = n35;
                                        while (n28 < n33) {
                                            nArray4[n27] = nArray[n28 + n29];
                                            n28 += n38;
                                            n27 += n37;
                                        }
                                        break;
                                    }
                                    case 4: {
                                        n28 = 0;
                                        n27 = n35;
                                        while (n28 < n33) {
                                            fArray2[n27] = fArray[n28 + n29];
                                            n28 += n38;
                                            n27 += n37;
                                        }
                                        break;
                                    }
                                    case 5: {
                                        n28 = 0;
                                        n27 = n35;
                                        while (n28 < n33) {
                                            dArray2[n27] = dArray[n28 + n29];
                                            n28 += n38;
                                            n27 += n37;
                                        }
                                        break;
                                    }
                                }
                                n35 -= n30;
                            }
                        }
                        this.iis.skipBytes(n43);
                        n35 += n36;
                        if (this.destImage != null) {
                            if (n19 < n20) {
                                this.reader.processImageUpdateWrapper(this.destImage, n50, n32, n39, 1, 1, 1, this.destinationBands);
                            } else {
                                this.reader.processImageUpdateWrapper(this.destImage, n32, n53, 1, n39, 1, 1, this.destinationBands);
                            }
                        }
                        this.reader.processImageProgressWrapper(f2 + ((float)n34 + 1.0f) / (float)n39 / (float)n18);
                        n34 += n40;
                        ++n32;
                    }
                    continue;
                }
                if (this.sampleModel instanceof BandedSampleModel || this.sampleModel instanceof SinglePixelPackedSampleModel || n21 == 0) {
                    n42 = this.sampleModel instanceof BandedSampleModel;
                    n41 = (int)ImageUtil.getBandSize(this.originalSampleModel);
                    for (n40 = 0; n40 < n2; ++n40) {
                        this.iis.seek(l2 + (long)(n41 * this.sourceBands[n40] * n5));
                        n39 = nArray5[this.destinationBands[n40]];
                        this.iis.skipBytes((n49 * n20 + n48 * n19) * n5);
                        if (n19 < n20) {
                            n38 = 0;
                            n37 = n53;
                            n36 = this.scaleY;
                            n35 = n46;
                            n34 = this.scaleX * n19;
                            n32 = n24;
                            n31 = n25;
                        } else {
                            n38 = 0;
                            n37 = n50;
                            n36 = this.scaleX;
                            n35 = n47;
                            n34 = this.scaleY * n20;
                            n32 = n25;
                            n31 = n24;
                        }
                        n30 = n26 + (n53 - writableRaster.getSampleModelTranslateY()) * n25 + (n50 - writableRaster.getSampleModelTranslateX()) * n24 + n39;
                        n29 = nArray3[this.destinationBands[n40]];
                        switch (n3) {
                            case 0: {
                                object = ((DataBufferByte)writableRaster.getDataBuffer()).getData(n29);
                                break;
                            }
                            case 2: {
                                sArray2 = ((DataBufferShort)writableRaster.getDataBuffer()).getData(n29);
                                break;
                            }
                            case 1: {
                                sArray2 = ((DataBufferUShort)writableRaster.getDataBuffer()).getData(n29);
                                break;
                            }
                            case 3: {
                                nArray4 = ((DataBufferInt)writableRaster.getDataBuffer()).getData(n29);
                                break;
                            }
                            case 4: {
                                fArray2 = ((DataBufferFloat)writableRaster.getDataBuffer()).getData(n29);
                                break;
                            }
                            case 5: {
                                dArray2 = ((DataBufferDouble)writableRaster.getDataBuffer()).getData(n29);
                            }
                        }
                        n28 = n38;
                        n27 = n37;
                        while (n28 < n35 && !this.reader.getAbortRequest()) {
                            switch (n3) {
                                case 0: {
                                    if (n34 == 1 && n32 == 1) {
                                        this.iis.readFully((byte[])object, n30, n33);
                                        break;
                                    }
                                    this.iis.readFully(byArray, 0, n33);
                                    int n54 = 0;
                                    int n55 = n30;
                                    while (n54 < n33) {
                                        object[n55] = byArray[n54];
                                        n54 += n34;
                                        n55 += n32;
                                    }
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    if (n34 == 1 && n32 == 1) {
                                        this.iis.readFully(sArray2, n30, n33);
                                        break;
                                    }
                                    this.iis.readFully(sArray, 0, n33);
                                    int n56 = 0;
                                    int n55 = n30;
                                    while (n56 < n33) {
                                        sArray2[n55] = sArray[n56];
                                        n56 += n34;
                                        n55 += n32;
                                    }
                                    break;
                                }
                                case 3: {
                                    if (n34 == 1 && n32 == 1) {
                                        this.iis.readFully(nArray4, n30, n33);
                                        break;
                                    }
                                    this.iis.readFully(nArray, 0, n33);
                                    int n57 = 0;
                                    int n55 = n30;
                                    while (n57 < n33) {
                                        nArray4[n55] = nArray[n57];
                                        n57 += n34;
                                        n55 += n32;
                                    }
                                    break;
                                }
                                case 4: {
                                    if (n34 == 1 && n32 == 1) {
                                        this.iis.readFully(fArray2, n30, n33);
                                        break;
                                    }
                                    this.iis.readFully(fArray, 0, n33);
                                    int n58 = 0;
                                    int n55 = n30;
                                    while (n58 < n33) {
                                        fArray2[n55] = fArray[n58];
                                        n58 += n34;
                                        n55 += n32;
                                    }
                                    break;
                                }
                                case 5: {
                                    if (n34 == 1 && n32 == 1) {
                                        this.iis.readFully(dArray2, n30, n33);
                                        break;
                                    }
                                    this.iis.readFully(dArray, 0, n33);
                                    int n59 = 0;
                                    int n55 = n30;
                                    while (n59 < n33) {
                                        dArray2[n55] = dArray[n59];
                                        n59 += n34;
                                        n55 += n32;
                                    }
                                    break;
                                }
                            }
                            this.iis.skipBytes(n43);
                            n30 += n31;
                            if (this.destImage != null) {
                                int[] nArray6 = new int[]{this.destinationBands[n40]};
                                if (n19 < n20) {
                                    this.reader.processImageUpdateWrapper(this.destImage, n50, n27, n35, 1, 1, 1, nArray6);
                                } else {
                                    this.reader.processImageUpdateWrapper(this.destImage, n27, n53, 1, n35, 1, 1, nArray6);
                                }
                            }
                            this.reader.processImageProgressWrapper((f2 + ((float)n28 + 1.0f) / (float)n35 / (float)n2 / (float)n18) * 100.0f);
                            n28 += n36;
                            ++n27;
                        }
                    }
                    continue;
                }
                if (this.sampleModel instanceof ComponentSampleModel) {
                    n42 = (int)this.tileDataSize;
                    switch (this.sampleModel.getDataType()) {
                        case 0: {
                            if (byArray == null || (long)byArray.length < this.tileDataSize) {
                                byArray = new byte[(int)this.tileDataSize];
                            }
                            this.iis.readFully(byArray, 0, (int)this.tileDataSize);
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (sArray == null || sArray.length < (n42 /= 2)) {
                                sArray = new short[n42];
                            }
                            this.iis.readFully(sArray, 0, n42);
                            break;
                        }
                        case 3: {
                            if (nArray == null || nArray.length < (n42 /= 4)) {
                                nArray = new int[n42];
                            }
                            this.iis.readFully(nArray, 0, n42);
                            break;
                        }
                        case 4: {
                            if (fArray == null || fArray.length < (n42 /= 4)) {
                                fArray = new float[n42];
                            }
                            this.iis.readFully(fArray, 0, n42);
                            break;
                        }
                        case 5: {
                            if (dArray == null || dArray.length < (n42 /= 8)) {
                                dArray = new double[n42];
                            }
                            this.iis.readFully(dArray, 0, n42);
                        }
                    }
                    for (n41 = 0; n41 < n2; ++n41) {
                        n40 = nArray5[this.destinationBands[n41]];
                        n39 = ((ComponentSampleModel)writableRaster.getSampleModel()).getOffset(n50 - writableRaster.getSampleModelTranslateX(), n53 - writableRaster.getSampleModelTranslateY(), this.destinationBands[n41]);
                        n38 = nArray3[this.destinationBands[n41]];
                        switch (n3) {
                            case 0: {
                                object = ((DataBufferByte)writableRaster.getDataBuffer()).getData(n38);
                                break;
                            }
                            case 2: {
                                sArray2 = ((DataBufferShort)writableRaster.getDataBuffer()).getData(n38);
                                break;
                            }
                            case 1: {
                                sArray2 = ((DataBufferUShort)writableRaster.getDataBuffer()).getData(n38);
                                break;
                            }
                            case 3: {
                                nArray4 = ((DataBufferInt)writableRaster.getDataBuffer()).getData(n38);
                                break;
                            }
                            case 4: {
                                fArray2 = ((DataBufferFloat)writableRaster.getDataBuffer()).getData(n38);
                                break;
                            }
                            case 5: {
                                dArray2 = ((DataBufferDouble)writableRaster.getDataBuffer()).getData(n38);
                            }
                        }
                        n37 = ((ComponentSampleModel)this.originalSampleModel).getOffset(n48, n49, this.sourceBands[n41]);
                        n36 = this.scaleX * n19;
                        n35 = 0;
                        n34 = n53;
                        while (n35 < n46 && !this.reader.getAbortRequest()) {
                            switch (n3) {
                                case 0: {
                                    int n60 = 0;
                                    n31 = n37;
                                    n30 = n39;
                                    while (n60 < n52) {
                                        object[n30] = byArray[n31];
                                        ++n60;
                                        n31 += n36;
                                        n30 += n24;
                                    }
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    int n61 = 0;
                                    n31 = n37;
                                    n30 = n39;
                                    while (n61 < n52) {
                                        sArray2[n30] = sArray[n31];
                                        ++n61;
                                        n31 += n36;
                                        n30 += n24;
                                    }
                                    break;
                                }
                                case 3: {
                                    int n62 = 0;
                                    n31 = n37;
                                    n30 = n39;
                                    while (n62 < n52) {
                                        nArray4[n30] = nArray[n31];
                                        ++n62;
                                        n31 += n36;
                                        n30 += n24;
                                    }
                                    break;
                                }
                                case 4: {
                                    int n63 = 0;
                                    n31 = n37;
                                    n30 = n39;
                                    while (n63 < n52) {
                                        fArray2[n30] = fArray[n31];
                                        ++n63;
                                        n31 += n36;
                                        n30 += n24;
                                    }
                                    break;
                                }
                                case 5: {
                                    int n64 = 0;
                                    n31 = n37;
                                    n30 = n39;
                                    while (n64 < n52) {
                                        dArray2[n30] = dArray[n31];
                                        ++n64;
                                        n31 += n36;
                                        n30 += n24;
                                    }
                                    break;
                                }
                            }
                            n39 += n25;
                            n37 += n20 * this.scaleY;
                            if (this.destImage != null) {
                                int[] nArray7 = new int[]{this.destinationBands[n41]};
                                this.reader.processImageUpdateWrapper(this.destImage, n50, n34, n46, 1, 1, 1, nArray7);
                            }
                            this.reader.processImageProgressWrapper(f2 + ((float)n35 + 1.0f) / (float)n46 / (float)n2 / (float)n18);
                            n35 += this.scaleY;
                            ++n34;
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException(I18N.getString("RawRenderedImage1"));
            }
        }
        return writableRaster;
    }

    public void setDestImage(BufferedImage bufferedImage) {
        this.destImage = bufferedImage;
    }

    public void clearDestImage() {
        this.destImage = null;
    }

    private int getTileNum(int n2, int n3) {
        int n4 = (n3 - this.getMinTileY()) * this.getNumXTiles() + n2 - this.getMinTileX();
        if (n4 < 0 || n4 >= this.getNumXTiles() * this.getNumYTiles()) {
            throw new IllegalArgumentException(I18N.getString("RawRenderedImage0"));
        }
        return n4;
    }

    private int clip(int n2, int n3, int n4) {
        if (n2 < n3) {
            n2 = n3;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        return n2;
    }
}

