/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriter;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.w3c.dom.Node;

public abstract class TIFFBaseJPEGCompressor
extends TIFFCompressor {
    private static final boolean DEBUG = false;
    protected static final String STREAM_METADATA_NAME = "javax_imageio_jpeg_stream_1.0";
    protected static final String IMAGE_METADATA_NAME = "javax_imageio_jpeg_image_1.0";
    private ImageWriteParam param = null;
    protected JPEGImageWriteParam JPEGParam = null;
    protected ImageWriter JPEGWriter = null;
    protected boolean writeAbbreviatedStream = false;
    protected IIOMetadata JPEGStreamMetadata = null;
    private IIOMetadata JPEGImageMetadata = null;
    private boolean usingCodecLib;
    private IIOByteArrayOutputStream baos;

    private static void pruneNodes(Node node, boolean bl2) {
        if (node == null) {
            throw new IllegalArgumentException("tree == null!");
        }
        if (!node.getNodeName().equals(IMAGE_METADATA_NAME)) {
            throw new IllegalArgumentException("root node name is not javax_imageio_jpeg_image_1.0!");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList("JPEGvariety", "markerSequence", "sof", "componentSpec", "sos", "scanComponentSpec"));
        if (!bl2) {
            arrayList.add("dht");
            arrayList.add("dhtable");
            arrayList.add("dqt");
            arrayList.add("dqtable");
        }
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)node;
        List list = TIFFBaseJPEGCompressor.getAllNodes(iIOMetadataNode, null);
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = (Node)list.get(i2);
            if (arrayList.contains(node2.getNodeName())) continue;
            node2.getParentNode().removeChild(node2);
        }
    }

    private static List getAllNodes(IIOMetadataNode iIOMetadataNode, List list) {
        if (list == null) {
            list = new ArrayList<Node>();
        }
        if (iIOMetadataNode.hasChildNodes()) {
            for (Node node = iIOMetadataNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                list.add(node);
                list = TIFFBaseJPEGCompressor.getAllNodes((IIOMetadataNode)node, list);
            }
        }
        return list;
    }

    public TIFFBaseJPEGCompressor(String string, int n2, boolean bl2, ImageWriteParam imageWriteParam) {
        super(string, n2, bl2);
        this.param = imageWriteParam;
    }

    protected void initJPEGWriter(boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        if (this.JPEGWriter != null && (bl2 || bl3)) {
            object2 = this.JPEGWriter.getOriginatingProvider();
            if (bl2 && ((object = ((ImageReaderWriterSpi)object2).getNativeStreamMetadataFormatName()) == null || !((String)object).equals(STREAM_METADATA_NAME))) {
                this.JPEGWriter = null;
            }
            if (this.JPEGWriter != null && bl3 && ((object = ((ImageReaderWriterSpi)object2).getNativeImageMetadataFormatName()) == null || !((String)object).equals(IMAGE_METADATA_NAME))) {
                this.JPEGWriter = null;
            }
        }
        if (this.JPEGWriter == null) {
            object2 = ImageIO.getImageWritersByFormatName("jpeg");
            while (object2.hasNext()) {
                object = (ImageWriter)object2.next();
                if (bl2 || bl3) {
                    String string;
                    ImageWriterSpi imageWriterSpi = ((ImageWriter)object).getOriginatingProvider();
                    if (bl2 && ((string = imageWriterSpi.getNativeStreamMetadataFormatName()) == null || !string.equals(STREAM_METADATA_NAME)) || bl3 && ((string = imageWriterSpi.getNativeImageMetadataFormatName()) == null || !string.equals(IMAGE_METADATA_NAME))) continue;
                }
                this.JPEGWriter = object;
                break;
            }
            if (this.JPEGWriter == null) {
                throw new IllegalStateException("No appropriate JPEG writers found!");
            }
        }
        this.usingCodecLib = this.JPEGWriter.getClass().getName().startsWith("com.sun.media");
        if (this.JPEGParam == null) {
            if (this.param != null && this.param instanceof JPEGImageWriteParam) {
                this.JPEGParam = (JPEGImageWriteParam)this.param;
            } else {
                this.JPEGParam = new JPEGImageWriteParam(this.writer != null ? this.writer.getLocale() : null);
                if (this.param.getCompressionMode() == 2) {
                    this.JPEGParam.setCompressionMode(2);
                    this.JPEGParam.setCompressionQuality(this.param.getCompressionQuality());
                }
            }
        }
    }

    private IIOMetadata getImageMetadata(boolean bl2) throws IIOException {
        if (this.JPEGImageMetadata == null && IMAGE_METADATA_NAME.equals(this.JPEGWriter.getOriginatingProvider().getNativeImageMetadataFormatName())) {
            TIFFImageWriter tIFFImageWriter = (TIFFImageWriter)this.writer;
            this.JPEGImageMetadata = this.JPEGWriter.getDefaultImageMetadata(tIFFImageWriter.imageType, this.JPEGParam);
            Node node = this.JPEGImageMetadata.getAsTree(IMAGE_METADATA_NAME);
            try {
                TIFFBaseJPEGCompressor.pruneNodes(node, bl2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IIOException("Error pruning unwanted nodes", illegalArgumentException);
            }
            try {
                this.JPEGImageMetadata.setFromTree(IMAGE_METADATA_NAME, node);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                throw new IIOException("Cannot set pruned image metadata!", iIOInvalidTreeException);
            }
        }
        return this.JPEGImageMetadata;
    }

    public final int encode(byte[] byArray, int n2, int n3, int n4, int[] nArray, int n5) throws IOException {
        int n6;
        int[] nArray2;
        Object object;
        DataBufferByte dataBufferByte;
        long l2;
        ImageOutputStream imageOutputStream;
        if (this.JPEGWriter == null) {
            throw new IIOException("JPEG writer has not been initialized!");
        }
        if (!(nArray.length == 3 && nArray[0] == 8 && nArray[1] == 8 && nArray[2] == 8 || nArray.length == 1 && nArray[0] == 8)) {
            throw new IIOException("Can only JPEG compress 8- and 24-bit images!");
        }
        if (this.usingCodecLib && !this.writeAbbreviatedStream) {
            imageOutputStream = this.stream;
            l2 = this.stream.getStreamPosition();
        } else {
            if (this.baos == null) {
                this.baos = new IIOByteArrayOutputStream();
            } else {
                this.baos.reset();
            }
            imageOutputStream = new MemoryCacheImageOutputStream(this.baos);
            l2 = 0L;
        }
        this.JPEGWriter.setOutput(imageOutputStream);
        if (n2 == 0 || this.usingCodecLib) {
            dataBufferByte = new DataBufferByte(byArray, byArray.length);
        } else {
            int n7 = n5 * n4;
            object = new byte[n7];
            System.arraycopy(byArray, n2, object, 0, n7);
            dataBufferByte = new DataBufferByte((byte[])object, n7);
            n2 = 0;
        }
        if (nArray.length == 3) {
            nArray2 = new int[]{n2, n2 + 1, n2 + 2};
            object = ColorSpace.getInstance(1000);
        } else {
            nArray2 = new int[]{n2};
            object = ColorSpace.getInstance(1003);
        }
        ComponentColorModel componentColorModel = new ComponentColorModel((ColorSpace)object, false, false, 1, 0);
        PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, n3, n4, nArray.length, n5, nArray2);
        WritableRaster writableRaster = Raster.createWritableRaster(pixelInterleavedSampleModel, dataBufferByte, new Point(0, 0));
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        IIOMetadata iIOMetadata = this.getImageMetadata(this.writeAbbreviatedStream);
        if (this.usingCodecLib && !this.writeAbbreviatedStream) {
            this.JPEGWriter.write(null, new IIOImage(bufferedImage, null, iIOMetadata), this.JPEGParam);
            n6 = (int)(this.stream.getStreamPosition() - l2);
        } else {
            if (this.writeAbbreviatedStream) {
                this.JPEGWriter.prepareWriteSequence(this.JPEGStreamMetadata);
                imageOutputStream.flush();
                this.baos.reset();
                IIOImage iIOImage = new IIOImage(bufferedImage, null, iIOMetadata);
                this.JPEGWriter.writeToSequence(iIOImage, this.JPEGParam);
                this.JPEGWriter.endWriteSequence();
            } else {
                this.JPEGWriter.write(null, new IIOImage(bufferedImage, null, iIOMetadata), this.JPEGParam);
            }
            n6 = this.baos.size();
            this.baos.writeTo(this.stream);
            this.baos.reset();
        }
        return n6;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.JPEGWriter != null) {
            this.JPEGWriter.dispose();
        }
    }

    private static class IIOByteArrayOutputStream
    extends ByteArrayOutputStream {
        IIOByteArrayOutputStream() {
        }

        IIOByteArrayOutputStream(int n2) {
            super(n2);
        }

        public synchronized void writeTo(ImageOutputStream imageOutputStream) throws IOException {
            imageOutputStream.write(this.buf, 0, this.count);
        }
    }
}

