/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.I18N;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.IIOException;

public class TIFFDeflateDecompressor
extends TIFFDecompressor {
    private static final boolean DEBUG = false;
    Inflater inflater = new Inflater();
    int predictor;

    public TIFFDeflateDecompressor(int n2) throws IIOException {
        if (n2 != 1 && n2 != 2) {
            throw new IIOException("Illegal value for Predictor in TIFF file");
        }
        this.predictor = n2;
    }

    public synchronized void decodeRaw(byte[] byArray, int n2, int n3, int n4) throws IOException {
        int n5;
        int n6;
        int n7;
        byte[] byArray2;
        int n8;
        if (this.predictor == 2) {
            int n9 = this.bitsPerSample.length;
            for (n8 = 0; n8 < n9; ++n8) {
                if (this.bitsPerSample[n8] == 8) continue;
                throw new IIOException(this.bitsPerSample[n8] + "-bit samples " + "are not supported for Horizontal " + "differencing Predictor");
            }
        }
        this.stream.seek(this.offset);
        byte[] byArray3 = new byte[this.byteCount];
        this.stream.readFully(byArray3);
        n8 = (this.srcWidth * n3 + 7) / 8;
        if (n8 == n4) {
            byArray2 = byArray;
            n7 = n2;
        } else {
            byArray2 = new byte[n8 * this.srcHeight];
            n7 = 0;
        }
        this.inflater.setInput(byArray3);
        try {
            this.inflater.inflate(byArray2, n7, n8 * this.srcHeight);
        }
        catch (DataFormatException dataFormatException) {
            throw new IIOException(I18N.getString("TIFFDeflateDecompressor0"), dataFormatException);
        }
        this.inflater.reset();
        if (this.predictor == 2) {
            for (n6 = 0; n6 < this.srcHeight; ++n6) {
                n5 = n7 + this.samplesPerPixel * (n6 * this.srcWidth + 1);
                for (int i2 = this.samplesPerPixel; i2 < this.srcWidth * this.samplesPerPixel; ++i2) {
                    int n10 = n5;
                    byArray2[n10] = (byte)(byArray2[n10] + byArray2[n5 - this.samplesPerPixel]);
                    ++n5;
                }
            }
        }
        if (n8 != n4) {
            n6 = 0;
            for (n5 = 0; n5 < this.srcHeight; ++n5) {
                System.arraycopy(byArray2, n6, byArray, n2, n8);
                n6 += n8;
                n2 += n4;
            }
        }
    }
}

