/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import java.util.Arrays;
import java.util.List;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class TIFFFieldNode
extends IIOMetadataNode {
    private boolean isIFD;
    private Boolean isInitialized = Boolean.FALSE;
    private TIFFField field;

    private static String getNodeName(TIFFField tIFFField) {
        return tIFFField.getData() instanceof TIFFDirectory ? "TIFFIFD" : "TIFFField";
    }

    public TIFFFieldNode(TIFFField tIFFField) {
        super(TIFFFieldNode.getNodeName(tIFFField));
        this.isIFD = tIFFField.getData() instanceof TIFFDirectory;
        this.field = tIFFField;
        TIFFTag tIFFTag = tIFFField.getTag();
        int n2 = tIFFTag.getNumber();
        String string = tIFFTag.getName();
        if (this.isIFD) {
            TIFFDirectory tIFFDirectory;
            TIFFTagSet[] tIFFTagSetArray;
            if (n2 != 0) {
                this.setAttribute("parentTagNumber", Integer.toString(n2));
            }
            if (string != null) {
                this.setAttribute("parentTagName", string);
            }
            if ((tIFFTagSetArray = (tIFFDirectory = (TIFFDirectory)tIFFField.getData()).getTagSets()) != null) {
                String string2 = "";
                for (int i2 = 0; i2 < tIFFTagSetArray.length; ++i2) {
                    string2 = string2 + tIFFTagSetArray[i2].getClass().getName();
                    if (i2 == tIFFTagSetArray.length - 1) continue;
                    string2 = string2 + ",";
                }
                this.setAttribute("tagSets", string2);
            }
        } else {
            this.setAttribute("number", Integer.toString(n2));
            this.setAttribute("name", string);
        }
    }

    private synchronized void initialize() {
        if (this.isInitialized == Boolean.TRUE) {
            return;
        }
        if (this.isIFD) {
            TIFFDirectory tIFFDirectory = (TIFFDirectory)this.field.getData();
            TIFFField[] tIFFFieldArray = tIFFDirectory.getTIFFFields();
            if (tIFFFieldArray != null) {
                TIFFTagSet[] tIFFTagSetArray = tIFFDirectory.getTagSets();
                List<TIFFTagSet> list = Arrays.asList(tIFFTagSetArray);
                int n2 = tIFFFieldArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    TIFFField tIFFField = tIFFFieldArray[i2];
                    int n3 = tIFFField.getTagNumber();
                    TIFFTag tIFFTag = TIFFIFD.getTag(n3, list);
                    Node node = tIFFField.getAsNativeNode();
                    if (node == null) continue;
                    this.appendChild(node);
                }
            }
        } else {
            IIOMetadataNode iIOMetadataNode;
            int n4 = this.field.getCount();
            if (this.field.getType() == 7) {
                iIOMetadataNode = new IIOMetadataNode("TIFFUndefined");
                byte[] byArray = this.field.getAsBytes();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i3 = 0; i3 < n4; ++i3) {
                    stringBuffer.append(Integer.toString(byArray[i3] & 0xFF));
                    if (i3 >= n4 - 1) continue;
                    stringBuffer.append(",");
                }
                iIOMetadataNode.setAttribute("value", stringBuffer.toString());
            } else {
                iIOMetadataNode = new IIOMetadataNode("TIFF" + TIFFField.getTypeName(this.field.getType()) + "s");
                TIFFTag tIFFTag = this.field.getTag();
                for (int i4 = 0; i4 < n4; ++i4) {
                    int n5;
                    String string;
                    IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TIFF" + TIFFField.getTypeName(this.field.getType()));
                    iIOMetadataNode2.setAttribute("value", this.field.getValueAsString(i4));
                    if (tIFFTag.hasValueNames() && this.field.isIntegral() && (string = tIFFTag.getValueName(n5 = this.field.getAsInt(i4))) != null) {
                        iIOMetadataNode2.setAttribute("description", string);
                    }
                    iIOMetadataNode.appendChild(iIOMetadataNode2);
                }
            }
            this.appendChild(iIOMetadataNode);
        }
        this.isInitialized = Boolean.TRUE;
    }

    public Node appendChild(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        return super.insertBefore(node, null);
    }

    public boolean hasChildNodes() {
        this.initialize();
        return super.hasChildNodes();
    }

    public int getLength() {
        this.initialize();
        return super.getLength();
    }

    public Node getFirstChild() {
        this.initialize();
        return super.getFirstChild();
    }

    public Node getLastChild() {
        this.initialize();
        return super.getLastChild();
    }

    public Node getPreviousSibling() {
        this.initialize();
        return super.getPreviousSibling();
    }

    public Node getNextSibling() {
        this.initialize();
        return super.getNextSibling();
    }

    public Node insertBefore(Node node, Node node2) {
        this.initialize();
        return super.insertBefore(node, node2);
    }

    public Node replaceChild(Node node, Node node2) {
        this.initialize();
        return super.replaceChild(node, node2);
    }

    public Node removeChild(Node node) {
        this.initialize();
        return super.removeChild(node);
    }

    public Node cloneNode(boolean bl2) {
        this.initialize();
        return super.cloneNode(bl2);
    }
}

