/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class TIFFIFD
extends TIFFDirectory {
    private long stripOrTileByteCountsPosition = -1L;
    private long stripOrTileOffsetsPosition = -1L;
    private long lastPosition = -1L;

    public static TIFFTag getTag(int n2, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TIFFTagSet tIFFTagSet = (TIFFTagSet)iterator.next();
            TIFFTag tIFFTag = tIFFTagSet.getTag(n2);
            if (tIFFTag == null) continue;
            return tIFFTag;
        }
        return null;
    }

    public static TIFFTag getTag(String string, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TIFFTagSet tIFFTagSet = (TIFFTagSet)iterator.next();
            TIFFTag tIFFTag = tIFFTagSet.getTag(string);
            if (tIFFTag == null) continue;
            return tIFFTag;
        }
        return null;
    }

    private static void writeTIFFFieldToStream(TIFFField tIFFField, ImageOutputStream imageOutputStream) throws IOException {
        int n2 = tIFFField.getCount();
        Object object = tIFFField.getData();
        switch (tIFFField.getType()) {
            case 2: {
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = ((String[])object)[i2];
                    int n3 = string.length();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        imageOutputStream.writeByte(string.charAt(i3) & 0xFF);
                    }
                    imageOutputStream.writeByte(0);
                }
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                imageOutputStream.write((byte[])object);
                break;
            }
            case 3: {
                imageOutputStream.writeChars((char[])object, 0, ((char[])object).length);
                break;
            }
            case 8: {
                imageOutputStream.writeShorts((short[])object, 0, ((short[])object).length);
                break;
            }
            case 9: {
                imageOutputStream.writeInts((int[])object, 0, ((int[])object).length);
                break;
            }
            case 4: {
                for (int i4 = 0; i4 < n2; ++i4) {
                    imageOutputStream.writeInt((int)((long[])object)[i4]);
                }
                break;
            }
            case 13: {
                imageOutputStream.writeInt(0);
                break;
            }
            case 11: {
                imageOutputStream.writeFloats((float[])object, 0, ((float[])object).length);
                break;
            }
            case 12: {
                imageOutputStream.writeDoubles((double[])object, 0, ((double[])object).length);
                break;
            }
            case 10: {
                for (int i5 = 0; i5 < n2; ++i5) {
                    imageOutputStream.writeInt(((int[][])object)[i5][0]);
                    imageOutputStream.writeInt(((int[][])object)[i5][1]);
                }
                break;
            }
            case 5: {
                for (int i6 = 0; i6 < n2; ++i6) {
                    long l2 = ((long[][])object)[i6][0];
                    long l3 = ((long[][])object)[i6][1];
                    imageOutputStream.writeInt((int)l2);
                    imageOutputStream.writeInt((int)l3);
                }
                break;
            }
        }
    }

    public TIFFIFD(List list, TIFFTag tIFFTag) {
        super(list.toArray(new TIFFTagSet[list.size()]), tIFFTag);
    }

    public TIFFIFD(List list) {
        this(list, null);
    }

    public List getTagSetList() {
        return Arrays.asList(this.getTagSets());
    }

    public Iterator iterator() {
        return Arrays.asList(this.getTIFFFields()).iterator();
    }

    public void initialize(ImageInputStream imageInputStream, boolean bl2) throws IOException {
        this.removeTIFFFields();
        List list = this.getTagSetList();
        int n2 = imageInputStream.readUnsignedShort();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            Object object2;
            Object object3;
            long l2;
            TIFFTag tIFFTag;
            int n3;
            int n4;
            int n5;
            block36: {
                n5 = imageInputStream.readUnsignedShort();
                n4 = imageInputStream.readUnsignedShort();
                n3 = (int)imageInputStream.readUnsignedInt();
                tIFFTag = TIFFIFD.getTag(n5, list);
                if (bl2 && tIFFTag == null) {
                    imageInputStream.skipBytes(4);
                    continue;
                }
                l2 = imageInputStream.getStreamPosition() + 4L;
                int n6 = TIFFTag.getSizeOfType(n4);
                if (n3 * n6 > 4) {
                    long l3 = imageInputStream.readUnsignedInt();
                    imageInputStream.seek(l3);
                }
                if (n5 == 279 || n5 == 325 || n5 == 514) {
                    this.stripOrTileByteCountsPosition = imageInputStream.getStreamPosition();
                } else if (n5 == 273 || n5 == 324 || n5 == 513) {
                    this.stripOrTileOffsetsPosition = imageInputStream.getStreamPosition();
                }
                object3 = null;
                try {
                    switch (n4) {
                        case 1: 
                        case 2: 
                        case 6: 
                        case 7: {
                            object2 = new byte[n3];
                            imageInputStream.readFully((byte[])object2, 0, n3);
                            if (n4 == 2) {
                                String[] stringArray;
                                object = new Vector();
                                boolean bl3 = false;
                                int n7 = 0;
                                for (int i3 = 0; i3 <= n3; ++i3) {
                                    if (i3 < n3 && object2[i3] != 0) {
                                        if (bl3) continue;
                                        n7 = i3;
                                        bl3 = true;
                                        continue;
                                    }
                                    if (!bl3) continue;
                                    String string = new String((byte[])object2, n7, i3 - n7);
                                    ((Vector)object).add(string);
                                    bl3 = false;
                                }
                                n3 = ((Vector)object).size();
                                if (n3 != 0) {
                                    stringArray = new String[n3];
                                    for (int i4 = 0; i4 < n3; ++i4) {
                                        stringArray[i4] = (String)((Vector)object).elementAt(i4);
                                    }
                                } else {
                                    n3 = 1;
                                    stringArray = new String[]{""};
                                }
                                object3 = stringArray;
                                break;
                            }
                            object3 = object2;
                            break;
                        }
                        case 3: {
                            object = new char[n3];
                            for (int i5 = 0; i5 < n3; ++i5) {
                                object[i5] = (char)imageInputStream.readUnsignedShort();
                            }
                            object3 = object;
                            break;
                        }
                        case 4: 
                        case 13: {
                            long[] lArray = new long[n3];
                            for (int i6 = 0; i6 < n3; ++i6) {
                                lArray[i6] = imageInputStream.readUnsignedInt();
                            }
                            object3 = lArray;
                            break;
                        }
                        case 5: {
                            long[][] lArray = new long[n3][2];
                            for (int i7 = 0; i7 < n3; ++i7) {
                                lArray[i7][0] = imageInputStream.readUnsignedInt();
                                lArray[i7][1] = imageInputStream.readUnsignedInt();
                            }
                            object3 = lArray;
                            break;
                        }
                        case 8: {
                            short[] sArray = new short[n3];
                            for (int i8 = 0; i8 < n3; ++i8) {
                                sArray[i8] = imageInputStream.readShort();
                            }
                            object3 = sArray;
                            break;
                        }
                        case 9: {
                            int[] nArray = new int[n3];
                            for (int i9 = 0; i9 < n3; ++i9) {
                                nArray[i9] = imageInputStream.readInt();
                            }
                            object3 = nArray;
                            break;
                        }
                        case 10: {
                            int[][] nArray = new int[n3][2];
                            for (int i10 = 0; i10 < n3; ++i10) {
                                nArray[i10][0] = imageInputStream.readInt();
                                nArray[i10][1] = imageInputStream.readInt();
                            }
                            object3 = nArray;
                            break;
                        }
                        case 11: {
                            float[] fArray = new float[n3];
                            for (int i11 = 0; i11 < n3; ++i11) {
                                fArray[i11] = imageInputStream.readFloat();
                            }
                            object3 = fArray;
                            break;
                        }
                        case 12: {
                            double[] dArray = new double[n3];
                            for (int i12 = 0; i12 < n3; ++i12) {
                                dArray[i12] = imageInputStream.readDouble();
                            }
                            object3 = dArray;
                            break;
                        }
                    }
                }
                catch (EOFException eOFException) {
                    if (BaselineTIFFTagSet.getInstance().getTag(n5) != null) break block36;
                    throw eOFException;
                }
            }
            if (tIFFTag != null && tIFFTag.isDataTypeOK(n4) && tIFFTag.isIFDPointer() && object3 != null) {
                imageInputStream.mark();
                imageInputStream.seek(((long[])object3)[0]);
                object2 = new ArrayList(1);
                object2.add(tIFFTag.getTagSet());
                object = new TIFFIFD((List)object2);
                ((TIFFIFD)object).initialize(imageInputStream, bl2);
                object3 = object;
                imageInputStream.reset();
            }
            if (tIFFTag == null) {
                tIFFTag = new TIFFTag(null, n5, 1 << n4, null);
            }
            if (object3 != null) {
                object2 = new TIFFField(tIFFTag, n4, n3, object3);
                this.addTIFFField((TIFFField)object2);
            }
            imageInputStream.seek(l2);
        }
        this.lastPosition = imageInputStream.getStreamPosition();
    }

    public void writeToStream(ImageOutputStream imageOutputStream) throws IOException {
        int n2 = this.getNumTIFFFields();
        imageOutputStream.writeShort(n2);
        long l2 = imageOutputStream.getStreamPosition() + (long)(12 * n2) + 4L;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            long l3;
            int n3;
            TIFFField tIFFField = (TIFFField)iterator.next();
            TIFFTag tIFFTag = tIFFField.getTag();
            int n4 = tIFFField.getType();
            int n5 = tIFFField.getCount();
            if (n4 == 0) {
                n4 = 7;
            }
            int n6 = n5 * TIFFTag.getSizeOfType(n4);
            if (n4 == 2) {
                n3 = 0;
                for (int i2 = 0; i2 < n5; ++i2) {
                    n3 += tIFFField.getAsString(i2).length() + 1;
                }
                n6 = n5 = n3;
            }
            n3 = tIFFField.getTagNumber();
            imageOutputStream.writeShort(n3);
            imageOutputStream.writeShort(n4);
            imageOutputStream.writeInt(n5);
            imageOutputStream.writeInt(0);
            imageOutputStream.mark();
            imageOutputStream.skipBytes(-4);
            if (n6 > 4 || tIFFTag.isIFDPointer()) {
                l2 = l2 + 3L & 0xFFFFFFFFFFFFFFFCL;
                imageOutputStream.writeInt((int)l2);
                imageOutputStream.seek(l2);
                l3 = l2;
                if (tIFFTag.isIFDPointer()) {
                    TIFFIFD tIFFIFD = (TIFFIFD)tIFFField.getData();
                    tIFFIFD.writeToStream(imageOutputStream);
                    l2 = tIFFIFD.lastPosition;
                } else {
                    TIFFIFD.writeTIFFFieldToStream(tIFFField, imageOutputStream);
                    l2 = imageOutputStream.getStreamPosition();
                }
            } else {
                l3 = imageOutputStream.getStreamPosition();
                TIFFIFD.writeTIFFFieldToStream(tIFFField, imageOutputStream);
            }
            if (n3 == 279 || n3 == 325 || n3 == 514) {
                this.stripOrTileByteCountsPosition = l3;
            } else if (n3 == 273 || n3 == 324 || n3 == 513) {
                this.stripOrTileOffsetsPosition = l3;
            }
            imageOutputStream.reset();
        }
        this.lastPosition = l2;
    }

    public long getStripOrTileByteCountsPosition() {
        return this.stripOrTileByteCountsPosition;
    }

    public long getStripOrTileOffsetsPosition() {
        return this.stripOrTileOffsetsPosition;
    }

    public long getLastPosition() {
        return this.lastPosition;
    }

    void setPositions(long l2, long l3, long l4) {
        this.stripOrTileOffsetsPosition = l2;
        this.stripOrTileByteCountsPosition = l3;
        this.lastPosition = l4;
    }

    public TIFFIFD getShallowClone() {
        BaselineTIFFTagSet baselineTIFFTagSet = BaselineTIFFTagSet.getInstance();
        List list = this.getTagSetList();
        if (!list.contains(baselineTIFFTagSet)) {
            return this;
        }
        TIFFIFD tIFFIFD = new TIFFIFD(list, this.getParentTag());
        SortedSet sortedSet = baselineTIFFTagSet.getTagNumbers();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TIFFField tIFFField;
            TIFFField tIFFField2 = (TIFFField)iterator.next();
            Integer n2 = new Integer(tIFFField2.getTagNumber());
            if (sortedSet.contains(n2)) {
                Object object = tIFFField2.getData();
                int n3 = tIFFField2.getType();
                try {
                    switch (n3) {
                        case 1: 
                        case 6: 
                        case 7: {
                            object = ((byte[])object).clone();
                            break;
                        }
                        case 2: {
                            object = ((String[])object).clone();
                            break;
                        }
                        case 3: {
                            object = ((char[])object).clone();
                            break;
                        }
                        case 4: 
                        case 13: {
                            object = ((long[])object).clone();
                            break;
                        }
                        case 5: {
                            object = ((long[][])object).clone();
                            break;
                        }
                        case 8: {
                            object = ((short[])object).clone();
                            break;
                        }
                        case 9: {
                            object = ((int[])object).clone();
                            break;
                        }
                        case 10: {
                            object = ((int[][])object).clone();
                            break;
                        }
                        case 11: {
                            object = ((float[])object).clone();
                            break;
                        }
                        case 12: {
                            object = ((double[])object).clone();
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                tIFFField = new TIFFField(tIFFField2.getTag(), n3, tIFFField2.getCount(), object);
            } else {
                tIFFField = tIFFField2;
            }
            tIFFIFD.addTIFFField(tIFFField);
        }
        tIFFIFD.setPositions(this.stripOrTileOffsetsPosition, this.stripOrTileByteCountsPosition, this.lastPosition);
        return tIFFIFD;
    }
}

