/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TIFFImageMetadata
extends IIOMetadata {
    public static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_tiff_image_1.0";
    public static final String nativeMetadataFormatClassName = "com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadataFormat";
    List tagSets;
    TIFFIFD rootIFD;
    private static final String[] colorSpaceNames = new String[]{"GRAY", "GRAY", "RGB", "RGB", "GRAY", "CMYK", "YCbCr", "Lab", "Lab"};
    private static final String[] orientationNames = new String[]{null, "Normal", "FlipH", "Rotate180", "FlipV", "FlipHRotate90", "Rotate270", "FlipVRotate90", "Rotate90"};

    public TIFFImageMetadata(List list) {
        super(true, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
        this.tagSets = list;
        this.rootIFD = new TIFFIFD(list);
    }

    public TIFFImageMetadata(TIFFIFD tIFFIFD) {
        super(true, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
        this.tagSets = tIFFIFD.getTagSetList();
        this.rootIFD = tIFFIFD;
    }

    public void initializeFromStream(ImageInputStream imageInputStream, boolean bl2) throws IOException {
        this.rootIFD.initialize(imageInputStream, bl2);
    }

    public void addShortOrLongField(int n2, int n3) {
        TIFFField tIFFField = new TIFFField(this.rootIFD.getTag(n2), n3);
        this.rootIFD.addTIFFField(tIFFField);
    }

    public boolean isReadOnly() {
        return false;
    }

    private Node getIFDAsTree(TIFFIFD tIFFIFD, String string, int n2) {
        Object object;
        Iterator iterator;
        List list;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("TIFFIFD");
        if (n2 != 0) {
            iIOMetadataNode.setAttribute("parentTagNumber", Integer.toString(n2));
        }
        if (string != null) {
            iIOMetadataNode.setAttribute("parentTagName", string);
        }
        if ((list = tIFFIFD.getTagSetList()).size() > 0) {
            iterator = list.iterator();
            object = "";
            while (iterator.hasNext()) {
                TIFFTagSet tIFFTagSet = (TIFFTagSet)iterator.next();
                object = (String)object + tIFFTagSet.getClass().getName();
                if (!iterator.hasNext()) continue;
                object = (String)object + ",";
            }
            iIOMetadataNode.setAttribute("tagSets", (String)object);
        }
        iterator = tIFFIFD.iterator();
        while (iterator.hasNext()) {
            object = (TIFFField)iterator.next();
            int n3 = ((TIFFField)object).getTagNumber();
            TIFFTag tIFFTag = TIFFIFD.getTag(n3, list);
            Node node = null;
            if (tIFFTag == null) {
                node = ((TIFFField)object).getAsNativeNode();
            } else if (tIFFTag.isIFDPointer()) {
                TIFFIFD tIFFIFD2 = (TIFFIFD)((TIFFField)object).getData();
                node = this.getIFDAsTree(tIFFIFD2, tIFFTag.getName(), tIFFTag.getNumber());
            } else {
                node = ((TIFFField)object).getAsNativeNode();
            }
            if (node == null) continue;
            iIOMetadataNode.appendChild(node);
        }
        return iIOMetadataNode;
    }

    public Node getAsTree(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(nativeMetadataFormatName);
        Node node = this.getIFDAsTree(this.rootIFD, null, 0);
        iIOMetadataNode.appendChild(node);
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = null;
        int n2 = -1;
        boolean bl2 = false;
        TIFFField tIFFField = this.getTIFFField(262);
        if (tIFFField != null) {
            n2 = tIFFField.getAsInt(0);
            bl2 = n2 == 3;
        }
        int n3 = -1;
        if (bl2) {
            n3 = 3;
        } else {
            tIFFField = this.getTIFFField(277);
            if (tIFFField != null) {
                n3 = tIFFField.getAsInt(0);
            } else {
                tIFFField = this.getTIFFField(258);
                if (tIFFField != null) {
                    n3 = tIFFField.getCount();
                }
            }
        }
        if (n2 != -1) {
            if (n2 >= 0 && n2 < colorSpaceNames.length) {
                iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
                String string = n2 == 5 && n3 == 3 ? "CMY" : colorSpaceNames[n2];
                iIOMetadataNode2.setAttribute("name", string);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            iIOMetadataNode2 = new IIOMetadataNode("BlackIsZero");
            iIOMetadataNode2.setAttribute("value", n2 == 0 ? "FALSE" : "TRUE");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        if (n3 != -1) {
            iIOMetadataNode2 = new IIOMetadataNode("NumChannels");
            iIOMetadataNode2.setAttribute("value", Integer.toString(n3));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        if ((tIFFField = this.getTIFFField(320)) != null) {
            boolean bl3 = false;
            iIOMetadataNode2 = new IIOMetadataNode("Palette");
            int n4 = tIFFField.getCount() / (bl3 ? 4 : 3);
            for (int i2 = 0; i2 < n4; ++i2) {
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PaletteEntry");
                iIOMetadataNode3.setAttribute("index", Integer.toString(i2));
                int n5 = tIFFField.getAsInt(i2) * 255 / 65535;
                int n6 = tIFFField.getAsInt(n4 + i2) * 255 / 65535;
                int n7 = tIFFField.getAsInt(2 * n4 + i2) * 255 / 65535;
                iIOMetadataNode3.setAttribute("red", Integer.toString(n5));
                iIOMetadataNode3.setAttribute("green", Integer.toString(n6));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(n7));
                if (bl3) {
                    int n8 = 0;
                    iIOMetadataNode3.setAttribute("alpha", Integer.toString(n8));
                }
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = null;
        TIFFField tIFFField = this.getTIFFField(259);
        if (tIFFField != null) {
            String string = null;
            int n2 = tIFFField.getAsInt(0);
            boolean bl2 = true;
            if (n2 == 1) {
                string = "None";
                bl2 = true;
            } else {
                int[] nArray = TIFFImageWriter.compressionNumbers;
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    if (n2 != nArray[i2]) continue;
                    string = TIFFImageWriter.compressionTypes[i2];
                    bl2 = TIFFImageWriter.isCompressionLossless[i2];
                    break;
                }
            }
            if (string != null) {
                iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
                iIOMetadataNode2.setAttribute("value", string);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
                iIOMetadataNode2 = new IIOMetadataNode("Lossless");
                iIOMetadataNode2.setAttribute("value", bl2 ? "TRUE" : "FALSE");
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        iIOMetadataNode2 = new IIOMetadataNode("NumProgressiveScans");
        iIOMetadataNode2.setAttribute("value", "1");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    private String repeat(String string, int n2) {
        if (n2 == 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer((string.length() + 1) * n2 - 1);
        stringBuffer.append(string);
        for (int i2 = 1; i2 < n2; ++i2) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public IIOMetadataNode getStandardDataNode() {
        int n2;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = null;
        boolean bl2 = false;
        TIFFField tIFFField = this.getTIFFField(262);
        if (tIFFField != null) {
            bl2 = tIFFField.getAsInt(0) == 3;
        }
        tIFFField = this.getTIFFField(284);
        String string = "PixelInterleaved";
        if (tIFFField != null && tIFFField.getAsInt(0) == 2) {
            string = "PlaneInterleaved";
        }
        iIOMetadataNode2 = new IIOMetadataNode("PlanarConfiguration");
        iIOMetadataNode2.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        tIFFField = this.getTIFFField(262);
        if (tIFFField != null) {
            int n3 = tIFFField.getAsInt(0);
            String string2 = "UnsignedIntegral";
            if (n3 == 3) {
                string2 = "Index";
            } else {
                tIFFField = this.getTIFFField(339);
                if (tIFFField != null) {
                    n2 = tIFFField.getAsInt(0);
                    string2 = n2 == 2 ? "SignedIntegral" : (n2 == 1 ? "UnsignedIntegral" : (n2 == 3 ? "Real" : null));
                }
            }
            if (string2 != null) {
                iIOMetadataNode2 = new IIOMetadataNode("SampleFormat");
                iIOMetadataNode2.setAttribute("value", string2);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        tIFFField = this.getTIFFField(258);
        int[] nArray = null;
        if (tIFFField != null) {
            nArray = tIFFField.getAsInts();
        } else {
            int n4;
            tIFFField = this.getTIFFField(259);
            int n5 = n4 = tIFFField != null ? tIFFField.getAsInt(0) : 1;
            nArray = this.getTIFFField(34665) != null || n4 == 7 || n4 == 6 || this.getTIFFField(513) != null ? ((tIFFField = this.getTIFFField(262)) != null && (tIFFField.getAsInt(0) == 0 || tIFFField.getAsInt(0) == 1) ? new int[]{8} : new int[]{8, 8, 8}) : new int[]{1};
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (n2 > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(Integer.toString(nArray[n2]));
        }
        iIOMetadataNode2 = new IIOMetadataNode("BitsPerSample");
        if (bl2) {
            iIOMetadataNode2.setAttribute("value", this.repeat(stringBuffer.toString(), 3));
        } else {
            iIOMetadataNode2.setAttribute("value", stringBuffer.toString());
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        tIFFField = this.getTIFFField(266);
        n2 = tIFFField != null ? tIFFField.getAsInt(0) : 1;
        stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(" ");
            }
            int n6 = nArray[i2] == 1 ? 7 : nArray[i2] - 1;
            int n7 = n2 == 1 ? n6 : 0;
            stringBuffer.append(Integer.toString(n7));
        }
        iIOMetadataNode2 = new IIOMetadataNode("SampleMSB");
        if (bl2) {
            iIOMetadataNode2.setAttribute("value", this.repeat(stringBuffer.toString(), 3));
        } else {
            iIOMetadataNode2.setAttribute("value", stringBuffer.toString());
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardDimensionNode() {
        int n2;
        float f2;
        int n3;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = null;
        long[] lArray = null;
        long[] lArray2 = null;
        TIFFField tIFFField = this.getTIFFField(282);
        if (tIFFField != null) {
            lArray = (long[])tIFFField.getAsRational(0).clone();
        }
        if ((tIFFField = this.getTIFFField(283)) != null) {
            lArray2 = (long[])tIFFField.getAsRational(0).clone();
        }
        if (lArray != null && lArray2 != null) {
            iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
            float f3 = (float)((double)lArray[1] * (double)lArray2[0]) / (float)(lArray[0] * lArray2[1]);
            iIOMetadataNode2.setAttribute("value", Float.toString(f3));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        if (lArray != null || lArray2 != null) {
            tIFFField = this.getTIFFField(296);
            int n4 = tIFFField != null ? tIFFField.getAsInt(0) : 2;
            int n5 = n3 = n4 != 1 ? 1 : 0;
            if (n4 == 2) {
                if (lArray != null) {
                    lArray[0] = lArray[0] * 100L;
                    lArray[1] = lArray[1] * 254L;
                }
                if (lArray2 != null) {
                    lArray2[0] = lArray2[0] * 100L;
                    lArray2[1] = lArray2[1] * 254L;
                }
            }
            if (n3 != 0) {
                if (lArray != null) {
                    f2 = (float)(10.0 * (double)lArray[1] / (double)lArray[0]);
                    iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelSize");
                    iIOMetadataNode2.setAttribute("value", Float.toString(f2));
                    iIOMetadataNode.appendChild(iIOMetadataNode2);
                }
                if (lArray2 != null) {
                    f2 = (float)(10.0 * (double)lArray2[1] / (double)lArray2[0]);
                    iIOMetadataNode2 = new IIOMetadataNode("VerticalPixelSize");
                    iIOMetadataNode2.setAttribute("value", Float.toString(f2));
                    iIOMetadataNode.appendChild(iIOMetadataNode2);
                }
            }
        }
        int n6 = n2 = (tIFFField = this.getTIFFField(296)) != null ? tIFFField.getAsInt(0) : 2;
        if (n2 == 2 || n2 == 3) {
            tIFFField = this.getTIFFField(286);
            if (tIFFField != null) {
                long[] lArray3 = tIFFField.getAsRational(0);
                f2 = (float)lArray3[0] / (float)lArray3[1];
                f2 = n2 == 2 ? (f2 *= 254.0f) : (f2 *= 10.0f);
                iIOMetadataNode2 = new IIOMetadataNode("HorizontalPosition");
                iIOMetadataNode2.setAttribute("value", Float.toString(f2));
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            if ((tIFFField = this.getTIFFField(287)) != null) {
                long[] lArray4 = tIFFField.getAsRational(0);
                f2 = (float)lArray4[0] / (float)lArray4[1];
                f2 = n2 == 2 ? (f2 *= 254.0f) : (f2 *= 10.0f);
                iIOMetadataNode2 = new IIOMetadataNode("VerticalPosition");
                iIOMetadataNode2.setAttribute("value", Float.toString(f2));
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        if ((tIFFField = this.getTIFFField(274)) != null && (n3 = tIFFField.getAsInt(0)) >= 0 && n3 < orientationNames.length) {
            iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
            iIOMetadataNode2.setAttribute("value", orientationNames[n3]);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardDocumentNode() {
        String string;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Document");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("FormatVersion");
        iIOMetadataNode2.setAttribute("value", "6.0");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        TIFFField tIFFField = this.getTIFFField(254);
        if (tIFFField != null) {
            int n2 = tIFFField.getAsInt(0);
            String string2 = null;
            if ((n2 & 4) != 0) {
                string2 = "TransparencyMask";
            } else if ((n2 & 1) != 0) {
                string2 = "ReducedResolution";
            } else if ((n2 & 2) != 0) {
                string2 = "SinglePage";
            }
            if (string2 != null) {
                iIOMetadataNode2 = new IIOMetadataNode("SubimageInterpretation");
                iIOMetadataNode2.setAttribute("value", string2);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        if ((tIFFField = this.getTIFFField(306)) != null && (string = tIFFField.getAsString(0)).length() == 19) {
            boolean bl2;
            iIOMetadataNode2 = new IIOMetadataNode("ImageCreationTime");
            try {
                iIOMetadataNode2.setAttribute("year", string.substring(0, 4));
                iIOMetadataNode2.setAttribute("month", string.substring(5, 7));
                iIOMetadataNode2.setAttribute("day", string.substring(8, 10));
                iIOMetadataNode2.setAttribute("hour", string.substring(11, 13));
                iIOMetadataNode2.setAttribute("minute", string.substring(14, 16));
                iIOMetadataNode2.setAttribute("second", string.substring(17, 19));
                bl2 = true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                bl2 = false;
            }
            if (bl2) {
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardTextNode() {
        IIOMetadataNode iIOMetadataNode = null;
        IIOMetadataNode iIOMetadataNode2 = null;
        int[] nArray = new int[]{269, 270, 271, 272, 285, 305, 315, 316, 333, 33432};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            TIFFField tIFFField = this.getTIFFField(nArray[i2]);
            if (tIFFField == null) continue;
            String string = tIFFField.getAsString(0);
            if (iIOMetadataNode == null) {
                iIOMetadataNode = new IIOMetadataNode("Text");
            }
            iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            iIOMetadataNode2.setAttribute("keyword", tIFFField.getTag().getName());
            iIOMetadataNode2.setAttribute("value", string);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("Alpha");
        String string = "none";
        TIFFField tIFFField = this.getTIFFField(338);
        if (tIFFField != null) {
            int[] nArray = tIFFField.getAsInts();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] == 1) {
                    string = "premultiplied";
                    break;
                }
                if (nArray[i2] != 2) continue;
                string = "nonpremultiplied";
                break;
            }
        }
        iIOMetadataNode2.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    private static void fatal(Node node, String string) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(string, node);
    }

    private int[] listToIntArray(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            Integer n2 = new Integer((String)object);
            arrayList.add(n2);
        }
        object = new int[arrayList.size()];
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            object[i2] = (Integer)arrayList.get(i2);
        }
        return object;
    }

    private char[] listToCharArray(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            Integer n2 = new Integer((String)object);
            arrayList.add(n2);
        }
        object = new char[arrayList.size()];
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            object[i2] = (char)((Integer)arrayList.get(i2)).intValue();
        }
        return object;
    }

    private void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        TIFFField tIFFField;
        TIFFTag tIFFTag;
        Object object;
        Object object2;
        Node node2 = node;
        if (!node2.getNodeName().equals("javax_imageio_1.0")) {
            TIFFImageMetadata.fatal(node2, "Root must be javax_imageio_1.0");
        }
        String string = null;
        Node node3 = this.getChildNode(node, "Data");
        boolean bl2 = false;
        if (node3 != null && (object2 = this.getChildNode(node3, "SampleFormat")) != null) {
            string = TIFFImageMetadata.getAttribute((Node)object2, "value");
            bl2 = string.equals("Index");
        }
        if (!bl2 && (object2 = this.getChildNode(node, "Chroma")) != null && this.getChildNode((Node)object2, "Palette") != null) {
            bl2 = true;
        }
        for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            int n2;
            Object object3;
            int n3;
            object2 = node2.getNodeName();
            if (((String)object2).equals("Chroma")) {
                Object object4;
                int n4;
                String string2 = null;
                object = null;
                n3 = 0;
                for (object3 = node2.getFirstChild(); object3 != null; object3 = object3.getNextSibling()) {
                    String string3 = object3.getNodeName();
                    if (string3.equals("ColorSpaceType")) {
                        string2 = TIFFImageMetadata.getAttribute((Node)object3, "name");
                        continue;
                    }
                    if (string3.equals("NumChannels")) {
                        tIFFTag = this.rootIFD.getTag(277);
                        n4 = bl2 ? 1 : Integer.parseInt(TIFFImageMetadata.getAttribute((Node)object3, "value"));
                        tIFFField = new TIFFField(tIFFTag, n4);
                        this.rootIFD.addTIFFField(tIFFField);
                        continue;
                    }
                    if (string3.equals("BlackIsZero")) {
                        object = TIFFImageMetadata.getAttribute((Node)object3, "value");
                        continue;
                    }
                    if (!string3.equals("Palette")) continue;
                    object4 = new HashMap();
                    int n5 = -1;
                    for (Node node4 = object3.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                        String string4 = node4.getNodeName();
                        if (!string4.equals("PaletteEntry")) continue;
                        String string5 = TIFFImageMetadata.getAttribute(node4, "index");
                        int n6 = Integer.parseInt(string5);
                        if (n6 > n5) {
                            n5 = n6;
                        }
                        char c2 = (char)Integer.parseInt(TIFFImageMetadata.getAttribute(node4, "red"));
                        char c3 = (char)Integer.parseInt(TIFFImageMetadata.getAttribute(node4, "green"));
                        char c4 = (char)Integer.parseInt(TIFFImageMetadata.getAttribute(node4, "blue"));
                        ((HashMap)object4).put(new Integer(n6), new char[]{c2, c3, c4});
                        n3 = 1;
                    }
                    if (n3 == 0) continue;
                    int n7 = n5 + 1;
                    int n8 = 3 * n7;
                    char[] cArray = new char[n8];
                    Iterator iterator = ((HashMap)object4).keySet().iterator();
                    while (iterator.hasNext()) {
                        Integer n9 = (Integer)iterator.next();
                        char[] cArray2 = (char[])((HashMap)object4).get(n9);
                        n2 = n9;
                        cArray[n2] = (char)(cArray2[0] * 65535 / 255);
                        cArray[n7 + n2] = (char)(cArray2[1] * 65535 / 255);
                        cArray[2 * n7 + n2] = (char)(cArray2[2] * 65535 / 255);
                    }
                    tIFFTag = this.rootIFD.getTag(320);
                    tIFFField = new TIFFField(tIFFTag, 3, n8, cArray);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                int n10 = -1;
                if ((string2 == null || string2.equals("GRAY")) && object != null && ((String)object).equalsIgnoreCase("FALSE")) {
                    n10 = 0;
                } else if (string2 != null) {
                    if (string2.equals("GRAY")) {
                        Node node5;
                        String string6;
                        NodeList nodeList;
                        n4 = 0;
                        if (node instanceof IIOMetadataNode && (nodeList = ((IIOMetadataNode)(object4 = (IIOMetadataNode)node)).getElementsByTagName("SubimageInterpretation")).getLength() == 1 && (string6 = TIFFImageMetadata.getAttribute(node5 = nodeList.item(0), "value")).equals("TransparencyMask")) {
                            n4 = 1;
                        }
                        n10 = n4 != 0 ? 4 : 1;
                    } else if (string2.equals("RGB")) {
                        n10 = n3 != 0 ? 3 : 2;
                    } else if (string2.equals("YCbCr")) {
                        n10 = 6;
                    } else if (string2.equals("CMYK")) {
                        n10 = 5;
                    } else if (string2.equals("Lab")) {
                        n10 = 8;
                    }
                }
                if (n10 == -1) continue;
                tIFFTag = this.rootIFD.getTag(262);
                tIFFField = new TIFFField(tIFFTag, n10);
                this.rootIFD.addTIFFField(tIFFField);
                continue;
            }
            if (((String)object2).equals("Compression")) {
                for (Node node6 = node2.getFirstChild(); node6 != null; node6 = node6.getNextSibling()) {
                    object = node6.getNodeName();
                    if (!((String)object).equals("CompressionTypeName")) continue;
                    n3 = -1;
                    object3 = TIFFImageMetadata.getAttribute(node6, "value");
                    if (((String)object3).equalsIgnoreCase("None")) {
                        n3 = 1;
                    } else {
                        String[] stringArray = TIFFImageWriter.compressionTypes;
                        for (int i2 = 0; i2 < stringArray.length; ++i2) {
                            if (!stringArray[i2].equalsIgnoreCase((String)object3)) continue;
                            n3 = TIFFImageWriter.compressionNumbers[i2];
                            break;
                        }
                    }
                    if (n3 == -1) continue;
                    tIFFTag = this.rootIFD.getTag(259);
                    tIFFField = new TIFFField(tIFFTag, n3);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                continue;
            }
            if (((String)object2).equals("Data")) {
                for (Node node7 = node2.getFirstChild(); node7 != null; node7 = node7.getNextSibling()) {
                    int n11;
                    String string7;
                    object = node7.getNodeName();
                    if (((String)object).equals("PlanarConfiguration")) {
                        string7 = TIFFImageMetadata.getAttribute(node7, "value");
                        int n12 = -1;
                        if (string7.equals("PixelInterleaved")) {
                            n12 = 1;
                        } else if (string7.equals("PlaneInterleaved")) {
                            n12 = 2;
                        }
                        if (n12 == -1) continue;
                        tIFFTag = this.rootIFD.getTag(284);
                        tIFFField = new TIFFField(tIFFTag, n12);
                        this.rootIFD.addTIFFField(tIFFField);
                        continue;
                    }
                    if (((String)object).equals("BitsPerSample")) {
                        string7 = TIFFImageMetadata.getAttribute(node7, "value");
                        char[] cArray = this.listToCharArray(string7);
                        tIFFTag = this.rootIFD.getTag(258);
                        tIFFField = bl2 ? new TIFFField(tIFFTag, 3, 1, new char[]{cArray[0]}) : new TIFFField(tIFFTag, 3, cArray.length, cArray);
                        this.rootIFD.addTIFFField(tIFFField);
                        continue;
                    }
                    if (!((String)object).equals("SampleMSB")) continue;
                    string7 = TIFFImageMetadata.getAttribute(node7, "value");
                    int[] nArray = this.listToIntArray(string7);
                    boolean bl3 = true;
                    for (n11 = 0; n11 < nArray.length; ++n11) {
                        if (nArray[n11] == 0) continue;
                        bl3 = false;
                        break;
                    }
                    n11 = bl3 ? 2 : 1;
                    tIFFTag = this.rootIFD.getTag(266);
                    tIFFField = new TIFFField(tIFFTag, n11);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                continue;
            }
            if (((String)object2).equals("Dimension")) {
                Object object5;
                float f2 = -1.0f;
                boolean bl4 = false;
                float f3 = -1.0f;
                boolean bl5 = false;
                float f4 = -1.0f;
                boolean bl6 = false;
                boolean bl7 = false;
                float f5 = -1.0f;
                boolean bl8 = false;
                float f6 = -1.0f;
                boolean bl9 = false;
                block8: for (Node node8 = node2.getFirstChild(); node8 != null; node8 = node8.getNextSibling()) {
                    String string8 = node8.getNodeName();
                    if (string8.equals("PixelAspectRatio")) {
                        object5 = TIFFImageMetadata.getAttribute(node8, "value");
                        f2 = Float.parseFloat((String)object5);
                        bl4 = true;
                        continue;
                    }
                    if (string8.equals("ImageOrientation")) {
                        object5 = TIFFImageMetadata.getAttribute(node8, "value");
                        for (n2 = 0; n2 < orientationNames.length; ++n2) {
                            if (!((String)object5).equals(orientationNames[n2])) continue;
                            char[] cArray = new char[]{(char)n2};
                            tIFFField = new TIFFField(this.rootIFD.getTag(274), 3, 1, cArray);
                            this.rootIFD.addTIFFField(tIFFField);
                            continue block8;
                        }
                        continue;
                    }
                    if (string8.equals("HorizontalPixelSize")) {
                        object5 = TIFFImageMetadata.getAttribute(node8, "value");
                        f3 = Float.parseFloat((String)object5);
                        bl5 = true;
                        continue;
                    }
                    if (string8.equals("VerticalPixelSize")) {
                        object5 = TIFFImageMetadata.getAttribute(node8, "value");
                        f4 = Float.parseFloat((String)object5);
                        bl6 = true;
                        continue;
                    }
                    if (string8.equals("HorizontalPosition")) {
                        object5 = TIFFImageMetadata.getAttribute(node8, "value");
                        f5 = Float.parseFloat((String)object5);
                        bl8 = true;
                        continue;
                    }
                    if (!string8.equals("VerticalPosition")) continue;
                    object5 = TIFFImageMetadata.getAttribute(node8, "value");
                    f6 = Float.parseFloat((String)object5);
                    bl9 = true;
                }
                boolean bl10 = bl7 = bl5 || bl6;
                if (bl4) {
                    if (bl5 && !bl6) {
                        f4 = f3 / f2;
                        bl6 = true;
                    } else if (bl6 && !bl5) {
                        f3 = f4 * f2;
                        bl5 = true;
                    } else if (!bl5 && !bl6) {
                        f3 = f2;
                        f4 = 1.0f;
                        bl5 = true;
                        bl6 = true;
                    }
                }
                if (bl5) {
                    float f7 = (bl7 ? 10.0f : 1.0f) / f3;
                    object5 = new long[1][2];
                    object5[0] = new long[2];
                    object5[0][0] = (long)(f7 * 10000.0f);
                    object5[0][1] = 10000L;
                    tIFFField = new TIFFField(this.rootIFD.getTag(282), 5, 1, object5);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                if (bl6) {
                    float f8 = (bl7 ? 10.0f : 1.0f) / f4;
                    object5 = new long[1][2];
                    object5[0] = new long[2];
                    object5[0][0] = (long)(f8 * 10000.0f);
                    object5[0][1] = 10000L;
                    tIFFField = new TIFFField(this.rootIFD.getTag(283), 5, 1, object5);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                char[] cArray = new char[]{(char)(bl7 ? 3 : 1)};
                tIFFField = new TIFFField(this.rootIFD.getTag(296), 3, 1, cArray);
                this.rootIFD.addTIFFField(tIFFField);
                if (!bl7) continue;
                if (bl8) {
                    object5 = new long[1][2];
                    object5[0][0] = (long)(f5 * 10000.0f);
                    object5[0][1] = 100000L;
                    tIFFField = new TIFFField(this.rootIFD.getTag(286), 5, 1, object5);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                if (!bl9) continue;
                object5 = new long[1][2];
                object5[0][0] = (long)(f6 * 10000.0f);
                object5[0][1] = 100000L;
                tIFFField = new TIFFField(this.rootIFD.getTag(287), 5, 1, object5);
                this.rootIFD.addTIFFField(tIFFField);
                continue;
            }
            if (((String)object2).equals("Document")) {
                for (Node node9 = node2.getFirstChild(); node9 != null; node9 = node9.getNextSibling()) {
                    String string9;
                    object = node9.getNodeName();
                    if (((String)object).equals("SubimageInterpretation")) {
                        string9 = TIFFImageMetadata.getAttribute(node9, "value");
                        int n13 = -1;
                        if (string9.equals("TransparencyMask")) {
                            n13 = 4;
                        } else if (string9.equals("ReducedResolution")) {
                            n13 = 1;
                        } else if (string9.equals("SinglePage")) {
                            n13 = 2;
                        }
                        if (n13 != -1) {
                            tIFFTag = this.rootIFD.getTag(254);
                            tIFFField = new TIFFField(tIFFTag, n13);
                            this.rootIFD.addTIFFField(tIFFField);
                        }
                    }
                    if (!((String)object).equals("ImageCreationTime")) continue;
                    string9 = TIFFImageMetadata.getAttribute(node9, "year");
                    String string10 = TIFFImageMetadata.getAttribute(node9, "month");
                    String string11 = TIFFImageMetadata.getAttribute(node9, "day");
                    String string12 = TIFFImageMetadata.getAttribute(node9, "hour");
                    String string13 = TIFFImageMetadata.getAttribute(node9, "minute");
                    String string14 = TIFFImageMetadata.getAttribute(node9, "second");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string9);
                    stringBuffer.append(":");
                    if (string10.length() == 1) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(string10);
                    stringBuffer.append(":");
                    if (string11.length() == 1) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(string11);
                    stringBuffer.append(" ");
                    if (string12.length() == 1) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(string12);
                    stringBuffer.append(":");
                    if (string13.length() == 1) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(string13);
                    stringBuffer.append(":");
                    if (string14.length() == 1) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(string14);
                    String[] stringArray = new String[]{stringBuffer.toString()};
                    tIFFField = new TIFFField(this.rootIFD.getTag(306), 2, 1, stringArray);
                    this.rootIFD.addTIFFField(tIFFField);
                }
                continue;
            }
            if (((String)object2).equals("Text")) {
                object = null;
                String string15 = null;
                object3 = null;
                for (Node node10 = node2.getFirstChild(); node10 != null; node10 = node10.getNextSibling()) {
                    String string16 = node10.getNodeName();
                    if (!string16.equals("TextEntry")) continue;
                    int n14 = -1;
                    NamedNodeMap namedNodeMap = node10.getAttributes();
                    Node node11 = namedNodeMap.getNamedItem("keyword");
                    if (node11 == null) continue;
                    String string17 = node11.getNodeValue();
                    String string18 = TIFFImageMetadata.getAttribute(node10, "value");
                    if (string17.equals("") || string18.equals("")) continue;
                    if (string17.equalsIgnoreCase("DocumentName")) {
                        n14 = 269;
                    } else if (string17.equalsIgnoreCase("ImageDescription")) {
                        n14 = 270;
                    } else if (string17.equalsIgnoreCase("Make")) {
                        n14 = 271;
                    } else if (string17.equalsIgnoreCase("Model")) {
                        n14 = 272;
                    } else if (string17.equalsIgnoreCase("PageName")) {
                        n14 = 285;
                    } else if (string17.equalsIgnoreCase("Software")) {
                        n14 = 305;
                    } else if (string17.equalsIgnoreCase("Artist")) {
                        n14 = 315;
                    } else if (string17.equalsIgnoreCase("HostComputer")) {
                        n14 = 316;
                    } else if (string17.equalsIgnoreCase("InkNames")) {
                        n14 = 333;
                    } else if (string17.equalsIgnoreCase("Copyright")) {
                        n14 = 33432;
                    } else if (string17.equalsIgnoreCase("author")) {
                        object = string18;
                    } else if (string17.equalsIgnoreCase("description")) {
                        string15 = string18;
                    } else if (string17.equalsIgnoreCase("title")) {
                        object3 = string18;
                    }
                    if (n14 == -1) continue;
                    tIFFField = new TIFFField(this.rootIFD.getTag(n14), 2, 1, new String[]{string18});
                    this.rootIFD.addTIFFField(tIFFField);
                }
                if (object != null && this.getTIFFField(315) == null) {
                    tIFFField = new TIFFField(this.rootIFD.getTag(315), 2, 1, new String[]{object});
                    this.rootIFD.addTIFFField(tIFFField);
                }
                if (string15 != null && this.getTIFFField(270) == null) {
                    tIFFField = new TIFFField(this.rootIFD.getTag(270), 2, 1, new String[]{string15});
                    this.rootIFD.addTIFFField(tIFFField);
                }
                if (object3 == null || this.getTIFFField(269) != null) continue;
                tIFFField = new TIFFField(this.rootIFD.getTag(269), 2, 1, new String[]{object3});
                this.rootIFD.addTIFFField(tIFFField);
                continue;
            }
            if (!((String)object2).equals("Transparency")) continue;
            for (Node node12 = node2.getFirstChild(); node12 != null; node12 = node12.getNextSibling()) {
                object = node12.getNodeName();
                if (!((String)object).equals("Alpha")) continue;
                String string19 = TIFFImageMetadata.getAttribute(node12, "value");
                tIFFField = null;
                if (string19.equals("premultiplied")) {
                    tIFFField = new TIFFField(this.rootIFD.getTag(338), 1);
                } else if (string19.equals("nonpremultiplied")) {
                    tIFFField = new TIFFField(this.rootIFD.getTag(338), 2);
                }
                if (tIFFField == null) continue;
                this.rootIFD.addTIFFField(tIFFField);
            }
        }
        if (string != null) {
            int n15 = -1;
            if (string.equals("SignedIntegral")) {
                n15 = 2;
            } else if (string.equals("UnsignedIntegral")) {
                n15 = 1;
            } else if (string.equals("Real")) {
                n15 = 3;
            } else if (string.equals("Index")) {
                n15 = 1;
            }
            if (n15 != -1) {
                int n16 = 1;
                tIFFField = this.getTIFFField(277);
                if (tIFFField != null) {
                    n16 = tIFFField.getAsInt(0);
                } else {
                    tIFFField = this.getTIFFField(258);
                    if (tIFFField != null) {
                        n16 = tIFFField.getCount();
                    }
                }
                object = new char[n16];
                Arrays.fill((char[])object, (char)n15);
                tIFFTag = this.rootIFD.getTag(339);
                tIFFField = new TIFFField(tIFFTag, 3, ((Object)object).length, object);
                this.rootIFD.addTIFFField(tIFFField);
            }
        }
    }

    private static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        return node2 != null ? node2.getNodeValue() : null;
    }

    private Node getChildNode(Node node, String string) {
        Node node2 = null;
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n2 = nodeList.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node3 = nodeList.item(i2);
                if (!node3.getNodeName().equals(string)) continue;
                node2 = node3;
                break;
            }
        }
        return node2;
    }

    public static TIFFIFD parseIFD(Node node) throws IIOInvalidTreeException {
        Object object;
        Object object2;
        String string;
        Object object3;
        if (!node.getNodeName().equals("TIFFIFD")) {
            TIFFImageMetadata.fatal(node, "Expected \"TIFFIFD\" node");
        }
        String string2 = TIFFImageMetadata.getAttribute(node, "tagSets");
        ArrayList<TIFFTagSet> arrayList = new ArrayList<TIFFTagSet>(5);
        if (string2 != null) {
            object3 = new StringTokenizer(string2, ",");
            while (((StringTokenizer)object3).hasMoreTokens()) {
                string = ((StringTokenizer)object3).nextToken();
                object2 = null;
                try {
                    Class<?> clazz = Class.forName(string);
                    object = clazz.getMethod("getInstance", null);
                    object2 = ((Method)object).invoke(null, (Object[])null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                if (!(object2 instanceof TIFFTagSet)) {
                    TIFFImageMetadata.fatal(node, "Specified tag set class \"" + string + "\" is not an instance of TIFFTagSet");
                    continue;
                }
                arrayList.add((TIFFTagSet)object2);
            }
        }
        object3 = new TIFFIFD(arrayList);
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            Object object4;
            Object object5;
            string = node.getNodeName();
            object2 = null;
            if (string.equals("TIFFIFD")) {
                int n2;
                TIFFIFD tIFFIFD = TIFFImageMetadata.parseIFD(node);
                object = TIFFImageMetadata.getAttribute(node, "parentTagName");
                object5 = TIFFImageMetadata.getAttribute(node, "parentTagNumber");
                object4 = null;
                if (object != null) {
                    object4 = TIFFIFD.getTag((String)object, arrayList);
                } else if (object5 != null) {
                    n2 = Integer.valueOf((String)object5);
                    object4 = TIFFIFD.getTag(n2, arrayList);
                }
                if (object4 == null) {
                    object4 = new TIFFTag("unknown", 0, 0, null);
                }
                n2 = ((TIFFTag)object4).isDataTypeOK(13) ? 13 : 4;
                object2 = new TIFFField((TIFFTag)object4, n2, 1, tIFFIFD);
            } else if (string.equals("TIFFField")) {
                int n3 = Integer.parseInt(TIFFImageMetadata.getAttribute(node, "number"));
                object = null;
                object5 = arrayList.iterator();
                while (object5.hasNext()) {
                    object4 = (TIFFTagSet)object5.next();
                    if (((TIFFTagSet)object4).getTag(n3) == null) continue;
                    object = object4;
                    break;
                }
                object2 = TIFFField.createFromMetadataNode((TIFFTagSet)object, node);
            } else {
                TIFFImageMetadata.fatal(node, "Expected either \"TIFFIFD\" or \"TIFFField\" node, got " + string);
            }
            ((TIFFDirectory)object3).addTIFFField((TIFFField)object2);
        }
        return object3;
    }

    private void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        Object object;
        Node node2 = node;
        if (!node2.getNodeName().equals(nativeMetadataFormatName)) {
            TIFFImageMetadata.fatal(node2, "Root must be com_sun_media_imageio_plugins_tiff_image_1.0");
        }
        if ((node2 = node2.getFirstChild()) == null || !node2.getNodeName().equals("TIFFIFD")) {
            TIFFImageMetadata.fatal(node, "Root must have \"TIFFIFD\" child");
        }
        TIFFIFD tIFFIFD = TIFFImageMetadata.parseIFD(node2);
        List list = this.rootIFD.getTagSetList();
        Iterator iterator = tIFFIFD.getTagSetList().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof TIFFTagSet) || list.contains(object)) continue;
            this.rootIFD.addTagSet((TIFFTagSet)object);
        }
        object = tIFFIFD.iterator();
        while (object.hasNext()) {
            TIFFField tIFFField = (TIFFField)object.next();
            this.rootIFD.addTIFFField(tIFFField);
        }
    }

    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string.equals(nativeMetadataFormatName)) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    public void reset() {
        this.rootIFD = new TIFFIFD(this.tagSets);
    }

    public TIFFIFD getRootIFD() {
        return this.rootIFD;
    }

    public TIFFField getTIFFField(int n2) {
        return this.rootIFD.getTIFFField(n2);
    }

    public void removeTIFFField(int n2) {
        this.rootIFD.removeTIFFField(n2);
    }

    public TIFFImageMetadata getShallowClone() {
        return new TIFFImageMetadata(this.rootIFD.getShallowClone());
    }
}

