/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFColorConverter;
import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFImageReadParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.tiff.TIFFCIELabColorConverter;
import com.sun.media.imageioimpl.plugins.tiff.TIFFCodecLibFaxDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFDeflateDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriter;
import com.sun.media.imageioimpl.plugins.tiff.TIFFJPEGDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFLSBDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFLZWDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFNullDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFOldJPEGDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFPackBitsDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFRenderedImage;
import com.sun.media.imageioimpl.plugins.tiff.TIFFStreamMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFYCbCrColorConverter;
import com.sun.media.imageioimpl.plugins.tiff.TIFFYCbCrDecompressor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Node;

public class TIFFImageReader
extends ImageReader {
    private static final boolean DEBUG = false;
    ImageInputStream stream = null;
    boolean gotHeader = false;
    ImageReadParam imageReadParam = this.getDefaultReadParam();
    TIFFStreamMetadata streamMetadata = null;
    int currIndex = -1;
    TIFFImageMetadata imageMetadata = null;
    List imageStartPosition = new ArrayList();
    int numImages = -1;
    HashMap imageTypeMap = new HashMap();
    BufferedImage theImage = null;
    int width = -1;
    int height = -1;
    int numBands = -1;
    int tileOrStripWidth = -1;
    int tileOrStripHeight = -1;
    int planarConfiguration = 1;
    int rowsDone = 0;
    int compression;
    int photometricInterpretation;
    int samplesPerPixel;
    int[] sampleFormat;
    int[] bitsPerSample;
    int[] extraSamples;
    char[] colorMap;
    int sourceXOffset;
    int sourceYOffset;
    int srcXSubsampling;
    int srcYSubsampling;
    int dstWidth;
    int dstHeight;
    int dstMinX;
    int dstMinY;
    int dstXOffset;
    int dstYOffset;
    int tilesAcross;
    int tilesDown;
    int pixelsRead;
    int pixelsToRead;
    private int[] sourceBands;
    private int[] destinationBands;
    private TIFFDecompressor decompressor;

    public TIFFImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public void setInput(Object object, boolean bl2, boolean bl3) {
        super.setInput(object, bl2, bl3);
        this.resetLocal();
        if (object != null) {
            if (!(object instanceof ImageInputStream)) {
                throw new IllegalArgumentException("input not an ImageInputStream!");
            }
            this.stream = (ImageInputStream)object;
        } else {
            this.stream = null;
        }
    }

    private void readHeader() throws IIOException {
        if (this.gotHeader) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.streamMetadata = new TIFFStreamMetadata();
        try {
            int n2 = this.stream.readUnsignedShort();
            if (n2 == 19789) {
                this.streamMetadata.byteOrder = ByteOrder.BIG_ENDIAN;
                this.stream.setByteOrder(ByteOrder.BIG_ENDIAN);
            } else if (n2 == 18761) {
                this.streamMetadata.byteOrder = ByteOrder.LITTLE_ENDIAN;
                this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.processWarningOccurred("Bad byte order in header, assuming little-endian");
                this.streamMetadata.byteOrder = ByteOrder.LITTLE_ENDIAN;
                this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            }
            int n3 = this.stream.readUnsignedShort();
            if (n3 != 42) {
                this.processWarningOccurred("Bad magic number in header, continuing");
            }
            long l2 = this.stream.readUnsignedInt();
            this.imageStartPosition.add(new Long(l2));
            this.stream.seek(l2);
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error reading header!", iOException);
        }
        this.gotHeader = true;
    }

    private int locateImage(int n2) throws IIOException {
        this.readHeader();
        try {
            int n3;
            Long l2 = (Long)this.imageStartPosition.get(n3);
            this.stream.seek(l2);
            for (n3 = Math.min(n2, this.imageStartPosition.size() - 1); n3 < n2; ++n3) {
                int n4 = this.stream.readUnsignedShort();
                this.stream.skipBytes(12 * n4);
                long l3 = this.stream.readUnsignedInt();
                if (l3 == 0L) {
                    return n3;
                }
                this.imageStartPosition.add(new Long(l3));
                this.stream.seek(l3);
            }
        }
        catch (IOException iOException) {
            throw new IIOException("Couldn't seek!", iOException);
        }
        if (this.currIndex != n2) {
            this.imageMetadata = null;
        }
        this.currIndex = n2;
        return n2;
    }

    public int getNumImages(boolean bl2) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        if (this.seekForwardOnly && bl2) {
            throw new IllegalStateException("seekForwardOnly and allowSearch can't both be true!");
        }
        if (this.numImages > 0) {
            return this.numImages;
        }
        if (bl2) {
            this.numImages = this.locateImage(Integer.MAX_VALUE) + 1;
        }
        return this.numImages;
    }

    public IIOMetadata getStreamMetadata() throws IIOException {
        this.readHeader();
        return this.streamMetadata;
    }

    private void checkIndex(int n2) {
        if (n2 < this.minIndex) {
            throw new IndexOutOfBoundsException("imageIndex < minIndex!");
        }
        if (this.seekForwardOnly) {
            this.minIndex = n2;
        }
    }

    private void seekToImage(int n2) throws IIOException {
        this.checkIndex(n2);
        int n3 = this.locateImage(n2);
        if (n3 != n2) {
            throw new IndexOutOfBoundsException("imageIndex out of bounds!");
        }
        this.readMetadata();
        this.initializeFromMetadata();
    }

    private void readMetadata() throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        if (this.imageMetadata != null) {
            return;
        }
        try {
            ArrayList<BaselineTIFFTagSet> arrayList;
            if (this.imageReadParam instanceof TIFFImageReadParam) {
                arrayList = ((TIFFImageReadParam)this.imageReadParam).getAllowedTagSets();
            } else {
                arrayList = new ArrayList<BaselineTIFFTagSet>(1);
                arrayList.add(BaselineTIFFTagSet.getInstance());
            }
            this.imageMetadata = new TIFFImageMetadata(arrayList);
            this.imageMetadata.initializeFromStream(this.stream, this.ignoreMetadata);
        }
        catch (IIOException iIOException) {
            throw iIOException;
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error reading image metadata!", iOException);
        }
    }

    private int getWidth() {
        return this.width;
    }

    private int getHeight() {
        return this.height;
    }

    private int getNumBands() {
        return this.numBands;
    }

    private int getTileOrStripWidth() {
        TIFFField tIFFField = this.imageMetadata.getTIFFField(322);
        return tIFFField == null ? this.getWidth() : tIFFField.getAsInt(0);
    }

    private int getTileOrStripHeight() {
        TIFFField tIFFField = this.imageMetadata.getTIFFField(323);
        if (tIFFField != null) {
            return tIFFField.getAsInt(0);
        }
        tIFFField = this.imageMetadata.getTIFFField(278);
        int n2 = tIFFField == null ? -1 : tIFFField.getAsInt(0);
        return n2 == -1 ? this.getHeight() : n2;
    }

    private int getPlanarConfiguration() {
        TIFFField tIFFField = this.imageMetadata.getTIFFField(284);
        if (tIFFField != null) {
            int n2 = tIFFField.getAsInt(0);
            if (n2 == 2) {
                if (this.getCompression() == 6 && this.imageMetadata.getTIFFField(513) != null) {
                    this.processWarningOccurred("PlanarConfiguration \"Planar\" value inconsistent with JPEGInterchangeFormat; resetting to \"Chunky\".");
                    n2 = 1;
                } else {
                    TIFFField tIFFField2 = this.imageMetadata.getTIFFField(324);
                    if (tIFFField2 == null) {
                        tIFFField2 = this.imageMetadata.getTIFFField(273);
                        int n3 = this.getTileOrStripWidth();
                        int n4 = this.getTileOrStripHeight();
                        int n5 = (this.getWidth() + n3 - 1) / n3;
                        int n6 = (this.getHeight() + n4 - 1) / n4;
                        int n7 = n5 * n6;
                        long[] lArray = tIFFField2.getAsLongs();
                        if (lArray != null && lArray.length == n7) {
                            this.processWarningOccurred("PlanarConfiguration \"Planar\" value inconsistent with TileOffsets field value count; resetting to \"Chunky\".");
                            n2 = 1;
                        }
                    } else {
                        int n8 = this.getTileOrStripHeight();
                        int n9 = (this.getHeight() + n8 - 1) / n8;
                        long[] lArray = tIFFField2.getAsLongs();
                        if (lArray != null && lArray.length == n9) {
                            this.processWarningOccurred("PlanarConfiguration \"Planar\" value inconsistent with StripOffsets field value count; resetting to \"Chunky\".");
                            n2 = 1;
                        }
                    }
                }
            }
            return n2;
        }
        return 1;
    }

    private long getTileOrStripOffset(int n2) throws IIOException {
        TIFFField tIFFField = this.imageMetadata.getTIFFField(324);
        if (tIFFField == null) {
            tIFFField = this.imageMetadata.getTIFFField(273);
        }
        if (tIFFField == null) {
            tIFFField = this.imageMetadata.getTIFFField(513);
        }
        if (tIFFField == null) {
            throw new IIOException("Missing required strip or tile offsets field.");
        }
        return tIFFField.getAsLong(n2);
    }

    private long getTileOrStripByteCount(int n2) throws IOException {
        long l2;
        TIFFField tIFFField = this.imageMetadata.getTIFFField(325);
        if (tIFFField == null) {
            tIFFField = this.imageMetadata.getTIFFField(279);
        }
        if (tIFFField == null) {
            tIFFField = this.imageMetadata.getTIFFField(514);
        }
        if (tIFFField != null) {
            l2 = tIFFField.getAsLong(n2);
        } else {
            int n3;
            this.processWarningOccurred("TIFF directory contains neither StripByteCounts nor TileByteCounts field: attempting to calculate from strip or tile width and height.");
            int n4 = this.bitsPerSample[0];
            for (n3 = 1; n3 < this.samplesPerPixel; ++n3) {
                n4 += this.bitsPerSample[n3];
            }
            n3 = (this.getTileOrStripWidth() * n4 + 7) / 8;
            l2 = n3 * this.getTileOrStripHeight();
            long l3 = this.stream.length();
            if (l3 != -1L) {
                l2 = Math.min(l2, l3 - this.getTileOrStripOffset(n2));
            } else {
                this.processWarningOccurred("Stream length is unknown: cannot clamp estimated strip or tile byte count to EOF.");
            }
        }
        return l2;
    }

    private int getCompression() {
        TIFFField tIFFField = this.imageMetadata.getTIFFField(259);
        if (tIFFField == null) {
            return 1;
        }
        return tIFFField.getAsInt(0);
    }

    public int getWidth(int n2) throws IOException {
        this.seekToImage(n2);
        return this.getWidth();
    }

    public int getHeight(int n2) throws IOException {
        this.seekToImage(n2);
        return this.getHeight();
    }

    private void initializeFromMetadata() {
        int n2;
        Iterator<ImageReader> iterator;
        TIFFField tIFFField = this.imageMetadata.getTIFFField(259);
        if (tIFFField == null) {
            this.processWarningOccurred("Compression field is missing; assuming no compression");
            this.compression = 1;
        } else {
            this.compression = tIFFField.getAsInt(0);
        }
        boolean bl2 = false;
        tIFFField = this.imageMetadata.getTIFFField(256);
        if (tIFFField != null) {
            this.width = tIFFField.getAsInt(0);
        } else {
            this.processWarningOccurred("ImageWidth field is missing.");
            bl2 = true;
        }
        tIFFField = this.imageMetadata.getTIFFField(257);
        if (tIFFField != null) {
            this.height = tIFFField.getAsInt(0);
        } else {
            this.processWarningOccurred("ImageLength field is missing.");
            bl2 = true;
        }
        tIFFField = this.imageMetadata.getTIFFField(277);
        if (tIFFField != null) {
            this.samplesPerPixel = tIFFField.getAsInt(0);
        } else {
            this.samplesPerPixel = 1;
            bl2 = true;
        }
        int n3 = 1;
        if (bl2 && (tIFFField = this.imageMetadata.getTIFFField(513)) != null && (iterator = ImageIO.getImageReadersByFormatName("JPEG")) != null && iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            try {
                this.stream.mark();
                this.stream.seek(tIFFField.getAsLong(0));
                imageReader.setInput(this.stream);
                if (this.imageMetadata.getTIFFField(256) == null) {
                    this.width = imageReader.getWidth(0);
                }
                if (this.imageMetadata.getTIFFField(257) == null) {
                    this.height = imageReader.getHeight(0);
                }
                ImageTypeSpecifier imageTypeSpecifier = imageReader.getRawImageType(0);
                if (this.imageMetadata.getTIFFField(277) == null) {
                    this.samplesPerPixel = imageTypeSpecifier.getSampleModel().getNumBands();
                }
                this.stream.reset();
                n3 = imageTypeSpecifier.getColorModel().getComponentSize(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            imageReader.dispose();
        }
        if (this.samplesPerPixel < 1) {
            this.processWarningOccurred("Samples per pixel < 1!");
        }
        this.numBands = this.samplesPerPixel;
        this.colorMap = null;
        tIFFField = this.imageMetadata.getTIFFField(320);
        if (tIFFField != null) {
            this.colorMap = tIFFField.getAsChars();
        }
        if ((tIFFField = this.imageMetadata.getTIFFField(262)) == null) {
            if (this.compression == 2 || this.compression == 3 || this.compression == 4) {
                this.processWarningOccurred("PhotometricInterpretation field is missing; assuming WhiteIsZero");
                this.photometricInterpretation = 0;
            } else if (this.colorMap != null) {
                this.photometricInterpretation = 3;
            } else if (this.samplesPerPixel == 3 || this.samplesPerPixel == 4) {
                this.photometricInterpretation = 2;
            } else {
                this.processWarningOccurred("PhotometricInterpretation field is missing; assuming BlackIsZero");
                this.photometricInterpretation = 1;
            }
        } else {
            this.photometricInterpretation = tIFFField.getAsInt(0);
        }
        boolean bl3 = false;
        int n4 = -1;
        tIFFField = this.imageMetadata.getTIFFField(339);
        this.sampleFormat = new int[this.samplesPerPixel];
        bl3 = false;
        if (tIFFField == null) {
            bl3 = true;
            n4 = 4;
        } else if (tIFFField.getCount() != this.samplesPerPixel) {
            bl3 = true;
            n4 = tIFFField.getAsInt(0);
        }
        for (n2 = 0; n2 < this.samplesPerPixel; ++n2) {
            int n5 = this.sampleFormat[n2] = bl3 ? n4 : tIFFField.getAsInt(n2);
            if (this.sampleFormat[n2] == 1 || this.sampleFormat[n2] == 2 || this.sampleFormat[n2] == 3 || this.sampleFormat[n2] == 4) continue;
            this.processWarningOccurred("Illegal value for SAMPLE_FORMAT, assuming SAMPLE_FORMAT_UNDEFINED");
            this.sampleFormat[n2] = 4;
        }
        tIFFField = this.imageMetadata.getTIFFField(258);
        this.bitsPerSample = new int[this.samplesPerPixel];
        bl3 = false;
        if (tIFFField == null) {
            bl3 = true;
            n4 = n3;
        } else if (tIFFField.getCount() != this.samplesPerPixel) {
            bl3 = true;
            n4 = tIFFField.getAsInt(0);
        }
        for (n2 = 0; n2 < this.samplesPerPixel; ++n2) {
            this.bitsPerSample[n2] = bl3 ? n4 : tIFFField.getAsInt(n2);
        }
        this.extraSamples = null;
        tIFFField = this.imageMetadata.getTIFFField(338);
        if (tIFFField != null) {
            this.extraSamples = tIFFField.getAsInts();
        }
    }

    public Iterator getImageTypes(int n2) throws IIOException {
        List<ImageTypeSpecifier> list;
        Integer n3 = new Integer(n2);
        if (this.imageTypeMap.containsKey(n3)) {
            list = (List)this.imageTypeMap.get(n3);
        } else {
            list = new ArrayList(1);
            this.seekToImage(n2);
            ImageTypeSpecifier imageTypeSpecifier = TIFFDecompressor.getRawImageTypeSpecifier(this.photometricInterpretation, this.compression, this.samplesPerPixel, this.bitsPerSample, this.sampleFormat, this.extraSamples, this.colorMap);
            TIFFField tIFFField = this.imageMetadata.getTIFFField(34675);
            if (tIFFField != null && imageTypeSpecifier.getColorModel() instanceof ComponentColorModel) {
                int n4;
                byte[] byArray = tIFFField.getAsBytes();
                ICC_Profile iCC_Profile = ICC_Profile.getInstance(byArray);
                ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(iCC_Profile);
                ColorModel colorModel = imageTypeSpecifier.getColorModel();
                ColorSpace colorSpace = colorModel.getColorSpace();
                SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
                int n5 = sampleModel.getNumBands();
                if (n5 == (n4 = iCC_ColorSpace.getNumComponents()) || n5 == n4 + 1) {
                    boolean bl2 = n4 != n5;
                    boolean bl3 = bl2 && colorModel.isAlphaPremultiplied();
                    ComponentColorModel componentColorModel = new ComponentColorModel(iCC_ColorSpace, colorModel.getComponentSize(), bl2, bl3, colorModel.getTransparency(), colorModel.getTransferType());
                    list.add(new ImageTypeSpecifier(componentColorModel, sampleModel));
                    if (colorSpace.getType() == iCC_ColorSpace.getType() && colorSpace.getNumComponents() == iCC_ColorSpace.getNumComponents()) {
                        list.add(imageTypeSpecifier);
                    }
                } else {
                    list.add(imageTypeSpecifier);
                }
            } else {
                list.add(imageTypeSpecifier);
            }
            this.imageTypeMap.put(n3, list);
        }
        return list.iterator();
    }

    public IIOMetadata getImageMetadata(int n2) throws IIOException {
        this.seekToImage(n2);
        TIFFImageMetadata tIFFImageMetadata = new TIFFImageMetadata(this.imageMetadata.getRootIFD().getTagSetList());
        Node node = this.imageMetadata.getAsTree("com_sun_media_imageio_plugins_tiff_image_1.0");
        tIFFImageMetadata.setFromTree("com_sun_media_imageio_plugins_tiff_image_1.0", node);
        return tIFFImageMetadata;
    }

    public IIOMetadata getStreamMetadata(int n2) throws IIOException {
        this.readHeader();
        TIFFStreamMetadata tIFFStreamMetadata = new TIFFStreamMetadata();
        Node node = tIFFStreamMetadata.getAsTree("com_sun_media_imageio_plugins_tiff_stream_1.0");
        tIFFStreamMetadata.setFromTree("com_sun_media_imageio_plugins_tiff_stream_1.0", node);
        return tIFFStreamMetadata;
    }

    public boolean isRandomAccessEasy(int n2) throws IOException {
        if (this.currIndex != -1) {
            this.seekToImage(this.currIndex);
            return this.getCompression() == 1;
        }
        return false;
    }

    public boolean readSupportsThumbnails() {
        return false;
    }

    public boolean hasThumbnails(int n2) {
        return false;
    }

    public int getNumThumbnails(int n2) throws IOException {
        return 0;
    }

    public ImageReadParam getDefaultReadParam() {
        return new TIFFImageReadParam();
    }

    public boolean isImageTiled(int n2) throws IOException {
        this.seekToImage(n2);
        TIFFField tIFFField = this.imageMetadata.getTIFFField(322);
        return tIFFField != null;
    }

    public int getTileWidth(int n2) throws IOException {
        this.seekToImage(n2);
        return this.getTileOrStripWidth();
    }

    public int getTileHeight(int n2) throws IOException {
        this.seekToImage(n2);
        return this.getTileOrStripHeight();
    }

    public BufferedImage readTile(int n2, int n3, int n4) throws IOException {
        int n5 = this.getWidth(n2);
        int n6 = this.getHeight(n2);
        int n7 = this.getTileWidth(n2);
        int n8 = this.getTileHeight(n2);
        int n9 = n7 * n3;
        int n10 = n8 * n4;
        if (n3 < 0 || n4 < 0 || n9 >= n5 || n10 >= n6) {
            throw new IllegalArgumentException("Tile indices are out of bounds!");
        }
        if (n9 + n7 > n5) {
            n7 = n5 - n9;
        }
        if (n10 + n8 > n6) {
            n8 = n6 - n10;
        }
        ImageReadParam imageReadParam = this.getDefaultReadParam();
        Rectangle rectangle = new Rectangle(n9, n10, n7, n8);
        imageReadParam.setSourceRegion(rectangle);
        return this.read(n2, imageReadParam);
    }

    public boolean canReadRaster() {
        return false;
    }

    public Raster readRaster(int n2, ImageReadParam imageReadParam) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static int ifloor(int n2, int n3) {
        if (n2 < 0) {
            n2 -= n3 - 1;
        }
        return n2 / n3;
    }

    private static int iceil(int n2, int n3) {
        if (n2 > 0) {
            n2 += n3 - 1;
        }
        return n2 / n3;
    }

    private void prepareRead(int n2, ImageReadParam imageReadParam) throws IOException {
        int n3;
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        this.imageReadParam = imageReadParam;
        this.seekToImage(n2);
        this.tileOrStripWidth = this.getTileOrStripWidth();
        this.tileOrStripHeight = this.getTileOrStripHeight();
        this.planarConfiguration = this.getPlanarConfiguration();
        this.sourceBands = imageReadParam.getSourceBands();
        if (this.sourceBands == null) {
            this.sourceBands = new int[this.numBands];
            for (int i2 = 0; i2 < this.numBands; ++i2) {
                this.sourceBands[i2] = i2;
            }
        }
        Iterator iterator = this.getImageTypes(n2);
        ImageTypeSpecifier imageTypeSpecifier = ImageUtil.getDestinationType(imageReadParam, iterator);
        int n4 = imageTypeSpecifier.getSampleModel().getNumBands();
        this.destinationBands = imageReadParam.getDestinationBands();
        if (this.destinationBands == null) {
            this.destinationBands = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                this.destinationBands[n3] = n3;
            }
        }
        if (this.sourceBands.length != this.destinationBands.length) {
            throw new IllegalArgumentException("sourceBands.length != destinationBands.length");
        }
        for (n3 = 0; n3 < this.sourceBands.length; ++n3) {
            int n5 = this.sourceBands[n3];
            if (n5 < 0 || n5 >= this.numBands) {
                throw new IllegalArgumentException("Source band out of range!");
            }
            int n6 = this.destinationBands[n3];
            if (n6 >= 0 && n6 < n4) continue;
            throw new IllegalArgumentException("Destination band out of range!");
        }
    }

    public RenderedImage readAsRenderedImage(int n2, ImageReadParam imageReadParam) throws IOException {
        this.prepareRead(n2, imageReadParam);
        return new TIFFRenderedImage(this, n2, this.imageReadParam, this.width, this.height);
    }

    private void decodeTile(int n2, int n3, int n4) throws IOException {
        Rectangle rectangle = new Rectangle(n2 * this.tileOrStripWidth, n3 * this.tileOrStripHeight, this.tileOrStripWidth, this.tileOrStripHeight);
        if (!this.isImageTiled(this.currIndex)) {
            rectangle = rectangle.intersection(new Rectangle(0, 0, this.width, this.height));
        }
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        this.dstMinX = TIFFImageReader.iceil(n5 - this.sourceXOffset, this.srcXSubsampling);
        int n9 = TIFFImageReader.ifloor(n5 + n7 - 1 - this.sourceXOffset, this.srcXSubsampling);
        this.dstMinY = TIFFImageReader.iceil(n6 - this.sourceYOffset, this.srcYSubsampling);
        int n10 = TIFFImageReader.ifloor(n6 + n8 - 1 - this.sourceYOffset, this.srcYSubsampling);
        this.dstWidth = n9 - this.dstMinX + 1;
        this.dstHeight = n10 - this.dstMinY + 1;
        this.dstMinX += this.dstXOffset;
        this.dstMinY += this.dstYOffset;
        Rectangle rectangle2 = new Rectangle(this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight);
        rectangle2 = rectangle2.intersection(this.theImage.getRaster().getBounds());
        this.dstMinX = rectangle2.x;
        this.dstMinY = rectangle2.y;
        this.dstWidth = rectangle2.width;
        this.dstHeight = rectangle2.height;
        if (this.dstWidth <= 0 || this.dstHeight <= 0) {
            return;
        }
        int n11 = (this.dstMinX - this.dstXOffset) * this.srcXSubsampling + this.sourceXOffset;
        int n12 = (this.dstMinX + this.dstWidth - 1 - this.dstXOffset) * this.srcXSubsampling + this.sourceXOffset;
        int n13 = n12 - n11 + 1;
        int n14 = (this.dstMinY - this.dstYOffset) * this.srcYSubsampling + this.sourceYOffset;
        int n15 = (this.dstMinY + this.dstHeight - 1 - this.dstYOffset) * this.srcYSubsampling + this.sourceYOffset;
        int n16 = n15 - n14 + 1;
        this.decompressor.setSrcMinX(n5);
        this.decompressor.setSrcMinY(n6);
        this.decompressor.setSrcWidth(n7);
        this.decompressor.setSrcHeight(n8);
        this.decompressor.setDstMinX(this.dstMinX);
        this.decompressor.setDstMinY(this.dstMinY);
        this.decompressor.setDstWidth(this.dstWidth);
        this.decompressor.setDstHeight(this.dstHeight);
        this.decompressor.setActiveSrcMinX(n11);
        this.decompressor.setActiveSrcMinY(n14);
        this.decompressor.setActiveSrcWidth(n13);
        this.decompressor.setActiveSrcHeight(n16);
        int n17 = n3 * this.tilesAcross + n2;
        if (this.planarConfiguration == 2) {
            n17 += n4 * this.tilesAcross * this.tilesDown;
        }
        long l2 = this.getTileOrStripOffset(n17);
        long l3 = this.getTileOrStripByteCount(n17);
        long l4 = this.stream.length();
        if (l4 > 0L && l2 + l3 > l4) {
            this.processWarningOccurred("Attempting to process truncated stream.");
            l3 = l4 - l2;
            if (Math.max(l3, 0L) == 0L) {
                this.processWarningOccurred("No bytes in strip/tile: skipping.");
                return;
            }
        }
        this.decompressor.setStream(this.stream);
        this.decompressor.setOffset(l2);
        this.decompressor.setByteCount((int)l3);
        this.decompressor.beginDecoding();
        this.stream.mark();
        this.decompressor.decode();
        this.stream.reset();
    }

    private void reportProgress() {
        this.pixelsRead += this.dstWidth * this.dstHeight;
        this.processImageProgress(100.0f * (float)this.pixelsRead / (float)this.pixelsToRead);
        this.processImageUpdate(this.theImage, this.dstMinX, this.dstMinY, this.dstWidth, this.dstHeight, 1, 1, this.destinationBands);
    }

    public BufferedImage read(int n2, ImageReadParam imageReadParam) throws IOException {
        Object object;
        this.prepareRead(n2, imageReadParam);
        this.theImage = TIFFImageReader.getDestination(imageReadParam, this.getImageTypes(n2), this.width, this.height);
        this.srcXSubsampling = this.imageReadParam.getSourceXSubsampling();
        this.srcYSubsampling = this.imageReadParam.getSourceYSubsampling();
        Point point = this.imageReadParam.getDestinationOffset();
        this.dstXOffset = point.x;
        this.dstYOffset = point.y;
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        TIFFImageReader.computeRegions(this.imageReadParam, this.width, this.height, this.theImage, rectangle, rectangle2);
        this.sourceXOffset = rectangle.x;
        this.sourceYOffset = rectangle.y;
        this.pixelsToRead = rectangle2.width * rectangle2.height;
        this.pixelsRead = 0;
        this.processImageStarted(n2);
        this.processImageProgress(0.0f);
        this.tilesAcross = (this.width + this.tileOrStripWidth - 1) / this.tileOrStripWidth;
        this.tilesDown = (this.height + this.tileOrStripHeight - 1) / this.tileOrStripHeight;
        int n3 = this.getCompression();
        TIFFColorConverter tIFFColorConverter = null;
        if (this.imageReadParam instanceof TIFFImageReadParam) {
            object = (TIFFImageReadParam)this.imageReadParam;
            this.decompressor = ((TIFFImageReadParam)object).getTIFFDecompressor();
            tIFFColorConverter = ((TIFFImageReadParam)object).getColorConverter();
        }
        if (this.decompressor == null) {
            int n4;
            if (n3 == 1) {
                object = this.imageMetadata.getTIFFField(266);
                this.decompressor = object != null && ((TIFFField)object).getAsInt(0) == 2 ? new TIFFLSBDecompressor() : new TIFFNullDecompressor();
            } else if (n3 == 4) {
                if (PackageUtil.isCodecLibAvailable()) {
                    try {
                        this.decompressor = new TIFFCodecLibFaxDecompressor(n3);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if (this.decompressor == null) {
                    this.decompressor = new TIFFFaxDecompressor();
                }
            } else if (n3 == 3) {
                if (PackageUtil.isCodecLibAvailable()) {
                    try {
                        this.decompressor = new TIFFCodecLibFaxDecompressor(n3);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if (this.decompressor == null) {
                    this.decompressor = new TIFFFaxDecompressor();
                }
            } else if (n3 == 2) {
                this.decompressor = new TIFFFaxDecompressor();
            } else if (n3 == 32773) {
                this.decompressor = new TIFFPackBitsDecompressor();
            } else if (n3 == 5) {
                object = this.imageMetadata.getTIFFField(317);
                n4 = object == null ? 1 : ((TIFFField)object).getAsInt(0);
                this.decompressor = new TIFFLZWDecompressor(n4);
            } else if (n3 == 7) {
                this.decompressor = new TIFFJPEGDecompressor();
            } else if (n3 == 8 || n3 == 32946) {
                object = this.imageMetadata.getTIFFField(317);
                n4 = object == null ? 1 : ((TIFFField)object).getAsInt(0);
                this.decompressor = new TIFFDeflateDecompressor(n4);
            } else if (n3 == 6) {
                object = this.imageMetadata.getTIFFField(512);
                if (object == null) {
                    this.processWarningOccurred("JPEGProc field missing; assuming baseline sequential JPEG process.");
                } else if (((TIFFField)object).getAsInt(0) != 1) {
                    throw new IIOException("Old-style JPEG supported for baseline sequential JPEG process only!");
                }
                this.decompressor = new TIFFOldJPEGDecompressor();
            } else {
                throw new IIOException("Unsupported compression type (tag number = " + n3 + ")!");
            }
            if (this.photometricInterpretation == 6 && n3 != 7 && n3 != 6) {
                boolean bl2 = this.theImage.getColorModel().getColorSpace().getType() == 5;
                TIFFDecompressor tIFFDecompressor = this.decompressor instanceof TIFFNullDecompressor ? null : this.decompressor;
                this.decompressor = new TIFFYCbCrDecompressor(tIFFDecompressor, bl2);
            }
        }
        if (tIFFColorConverter == null) {
            if (this.photometricInterpretation == 8 && this.theImage.getColorModel().getColorSpace().getType() == 5) {
                tIFFColorConverter = new TIFFCIELabColorConverter();
            } else if (this.photometricInterpretation == 6 && !(this.decompressor instanceof TIFFYCbCrDecompressor) && n3 != 7 && n3 != 6) {
                tIFFColorConverter = new TIFFYCbCrColorConverter(this.imageMetadata);
            }
        }
        this.decompressor.setReader(this);
        this.decompressor.setMetadata(this.imageMetadata);
        this.decompressor.setImage(this.theImage);
        this.decompressor.setPhotometricInterpretation(this.photometricInterpretation);
        this.decompressor.setCompression(n3);
        this.decompressor.setSamplesPerPixel(this.samplesPerPixel);
        this.decompressor.setBitsPerSample(this.bitsPerSample);
        this.decompressor.setSampleFormat(this.sampleFormat);
        this.decompressor.setExtraSamples(this.extraSamples);
        this.decompressor.setColorMap(this.colorMap);
        this.decompressor.setColorConverter(tIFFColorConverter);
        this.decompressor.setSourceXOffset(this.sourceXOffset);
        this.decompressor.setSourceYOffset(this.sourceYOffset);
        this.decompressor.setSubsampleX(this.srcXSubsampling);
        this.decompressor.setSubsampleY(this.srcYSubsampling);
        this.decompressor.setDstXOffset(this.dstXOffset);
        this.decompressor.setDstYOffset(this.dstYOffset);
        this.decompressor.setSourceBands(this.sourceBands);
        this.decompressor.setDestinationBands(this.destinationBands);
        int n5 = TIFFImageWriter.XToTileX(rectangle.x, 0, this.tileOrStripWidth);
        int n6 = TIFFImageWriter.YToTileY(rectangle.y, 0, this.tileOrStripHeight);
        int n7 = TIFFImageWriter.XToTileX(rectangle.x + rectangle.width - 1, 0, this.tileOrStripWidth);
        int n8 = TIFFImageWriter.YToTileY(rectangle.y + rectangle.height - 1, 0, this.tileOrStripHeight);
        boolean bl3 = false;
        if (this.planarConfiguration == 2) {
            this.decompressor.setPlanar(true);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            for (int i2 = n6; i2 <= n8; ++i2) {
                for (int i3 = n5; i3 <= n7; ++i3) {
                    for (int i4 = 0; i4 < this.numBands; ++i4) {
                        nArray[0] = this.sourceBands[i4];
                        this.decompressor.setSourceBands(nArray);
                        nArray2[0] = this.destinationBands[i4];
                        this.decompressor.setDestinationBands(nArray2);
                        if (this.abortRequested()) {
                            bl3 = true;
                            break;
                        }
                        this.decodeTile(i3, i2, i4);
                    }
                    if (bl3) break;
                    this.reportProgress();
                }
                if (!bl3) {
                    continue;
                }
                break;
            }
        } else {
            for (int i5 = n6; i5 <= n8; ++i5) {
                for (int i6 = n5; i6 <= n7; ++i6) {
                    if (this.abortRequested()) {
                        bl3 = true;
                        break;
                    }
                    this.decodeTile(i6, i5, -1);
                    this.reportProgress();
                }
                if (!bl3) {
                    continue;
                }
                break;
            }
        }
        if (bl3) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return this.theImage;
    }

    public void reset() {
        super.reset();
        this.resetLocal();
    }

    protected void resetLocal() {
        this.stream = null;
        this.gotHeader = false;
        this.imageReadParam = this.getDefaultReadParam();
        this.streamMetadata = null;
        this.currIndex = -1;
        this.imageMetadata = null;
        this.imageStartPosition = new ArrayList();
        this.numImages = -1;
        this.imageTypeMap = new HashMap();
        this.width = -1;
        this.height = -1;
        this.numBands = -1;
        this.tileOrStripWidth = -1;
        this.tileOrStripHeight = -1;
        this.planarConfiguration = 1;
        this.rowsDone = 0;
    }

    void forwardWarningMessage(String string) {
        this.processWarningOccurred(string);
    }

    protected static BufferedImage getDestination(ImageReadParam imageReadParam, Iterator iterator, int n2, int n3) throws IIOException {
        Object object;
        Object object2;
        if (iterator == null || !iterator.hasNext()) {
            throw new IllegalArgumentException("imageTypes null or empty!");
        }
        BufferedImage bufferedImage = null;
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (imageReadParam != null) {
            bufferedImage = imageReadParam.getDestination();
            if (bufferedImage != null) {
                return bufferedImage;
            }
            imageTypeSpecifier = imageReadParam.getDestinationType();
        }
        if (imageTypeSpecifier == null) {
            object2 = iterator.next();
            if (!(object2 instanceof ImageTypeSpecifier)) {
                throw new IllegalArgumentException("Non-ImageTypeSpecifier retrieved from imageTypes!");
            }
            imageTypeSpecifier = (ImageTypeSpecifier)object2;
        } else {
            boolean bl2 = false;
            while (iterator.hasNext()) {
                object = (ImageTypeSpecifier)iterator.next();
                if (!((ImageTypeSpecifier)object).equals(imageTypeSpecifier)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                throw new IIOException("Destination type from ImageReadParam does not match!");
            }
        }
        object2 = new Rectangle(0, 0, 0, 0);
        object = new Rectangle(0, 0, 0, 0);
        TIFFImageReader.computeRegions(imageReadParam, n2, n3, null, object2, (Rectangle)object);
        int n4 = ((Rectangle)object).x + ((Rectangle)object).width;
        int n5 = ((Rectangle)object).y + ((Rectangle)object).height;
        if ((long)n4 * (long)n5 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("width*height > Integer.MAX_VALUE!");
        }
        return imageTypeSpecifier.createBufferedImage(n4, n5);
    }
}

