/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.EXIFParentTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.EXIFTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFColorConverter;
import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFImageWriteParam;
import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.common.SingleTileRenderedImage;
import com.sun.media.imageioimpl.plugins.tiff.EmptyImage;
import com.sun.media.imageioimpl.plugins.tiff.TIFFCIELabColorConverter;
import com.sun.media.imageioimpl.plugins.tiff.TIFFCodecLibRLECompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFCodecLibT4Compressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFCodecLibT6Compressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFDeflateCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFEXIFJPEGCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import com.sun.media.imageioimpl.plugins.tiff.TIFFJPEGCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFLSBCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFLZWCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFNullCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFPackBitsCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFRLECompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFStreamMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFT4Compressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFT6Compressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFYCbCrColorConverter;
import com.sun.media.imageioimpl.plugins.tiff.TIFFZLibCompressor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.IIOParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;

public class TIFFImageWriter
extends ImageWriter {
    private static final boolean DEBUG = false;
    static final String EXIF_JPEG_COMPRESSION_TYPE = "EXIF JPEG";
    public static final int DEFAULT_BYTES_PER_STRIP = 8192;
    public static final String[] TIFFCompressionTypes = new String[]{"CCITT RLE", "CCITT T.4", "CCITT T.6", "LZW", "JPEG", "ZLib", "PackBits", "Deflate", "EXIF JPEG"};
    public static final String[] compressionTypes = new String[]{"CCITT RLE", "CCITT T.4", "CCITT T.6", "LZW", "Old JPEG", "JPEG", "ZLib", "PackBits", "Deflate", "EXIF JPEG"};
    public static final boolean[] isCompressionLossless = new boolean[]{true, true, true, true, false, false, true, true, true, false};
    public static final int[] compressionNumbers = new int[]{2, 3, 4, 5, 6, 7, 8, 32773, 32946, 6};
    ImageOutputStream stream;
    long headerPosition;
    RenderedImage image;
    ImageTypeSpecifier imageType;
    ByteOrder byteOrder;
    ImageWriteParam param;
    TIFFCompressor compressor;
    TIFFColorConverter colorConverter;
    TIFFStreamMetadata streamMetadata;
    TIFFImageMetadata imageMetadata;
    int sourceXOffset;
    int sourceYOffset;
    int sourceWidth;
    int sourceHeight;
    int[] sourceBands;
    int periodX;
    int periodY;
    int bitDepth;
    int numBands;
    int tileWidth;
    int tileLength;
    int tilesAcross;
    int tilesDown;
    int[] sampleSize = null;
    int scalingBitDepth = -1;
    boolean isRescaling = false;
    boolean isBilevel;
    boolean isImageSimple;
    boolean isInverted;
    boolean isTiled;
    int nativePhotometricInterpretation;
    int photometricInterpretation;
    char[] bitsPerSample;
    int sampleFormat = 4;
    byte[][] scale = null;
    byte[] scale0 = null;
    byte[][] scaleh = null;
    byte[][] scalel = null;
    int compression;
    int predictor;
    int totalPixels;
    int pixelsDone;
    long nextIFDPointerPos;
    long nextSpace = 0L;
    boolean isWritingSequence = false;
    private boolean isInsertingEmpty = false;
    private boolean isWritingEmpty = false;
    private Object replacePixelsLock = new Object();
    private int replacePixelsIndex = -1;
    private TIFFImageMetadata replacePixelsMetadata = null;
    private long[] replacePixelsTileOffsets = null;
    private long[] replacePixelsByteCounts = null;
    private long replacePixelsOffsetsPosition = 0L;
    private long replacePixelsByteCountsPosition = 0L;
    private Rectangle replacePixelsRegion = null;
    private boolean inReplacePixelsNest = false;
    private TIFFImageReader reader = null;

    public static int XToTileX(int n2, int n3, int n4) {
        if ((n2 -= n3) < 0) {
            n2 += 1 - n4;
        }
        return n2 / n4;
    }

    public static int YToTileY(int n2, int n3, int n4) {
        if ((n2 -= n3) < 0) {
            n2 += 1 - n4;
        }
        return n2 / n4;
    }

    public TIFFImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new TIFFImageWriteParam(this.getLocale());
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException("output not an ImageOutputStream!");
            }
            this.stream = (ImageOutputStream)object;
            try {
                this.headerPosition = this.stream.getStreamPosition();
                try {
                    byte[] byArray = new byte[4];
                    this.stream.readFully(byArray);
                    this.nextSpace = byArray[0] == 73 && byArray[1] == 73 && byArray[2] == 42 && byArray[3] == 0 || byArray[0] == 77 && byArray[1] == 77 && byArray[2] == 0 && byArray[3] == 42 ? this.stream.length() : this.headerPosition;
                }
                catch (IOException iOException) {
                    this.nextSpace = this.headerPosition;
                }
                this.stream.seek(this.headerPosition);
            }
            catch (IOException iOException) {
                this.headerPosition = 0L;
                this.nextSpace = 0L;
            }
        } else {
            this.stream = null;
        }
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return new TIFFStreamMetadata();
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        TIFFImageMetadata tIFFImageMetadata;
        ArrayList<BaselineTIFFTagSet> arrayList = new ArrayList<BaselineTIFFTagSet>(1);
        arrayList.add(BaselineTIFFTagSet.getInstance());
        TIFFImageMetadata tIFFImageMetadata2 = new TIFFImageMetadata(arrayList);
        if (imageTypeSpecifier != null && (tIFFImageMetadata = (TIFFImageMetadata)this.convertImageMetadata(tIFFImageMetadata2, imageTypeSpecifier, imageWriteParam)) != null) {
            tIFFImageMetadata2 = tIFFImageMetadata;
        }
        return tIFFImageMetadata2;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        TIFFStreamMetadata tIFFStreamMetadata = null;
        if (iIOMetadata instanceof TIFFStreamMetadata) {
            tIFFStreamMetadata = new TIFFStreamMetadata();
            tIFFStreamMetadata.byteOrder = ((TIFFStreamMetadata)iIOMetadata).byteOrder;
            return tIFFStreamMetadata;
        }
        if (Arrays.asList(iIOMetadata.getMetadataFormatNames()).contains("com_sun_media_imageio_plugins_tiff_stream_1.0")) {
            tIFFStreamMetadata = new TIFFStreamMetadata();
            String string = "com_sun_media_imageio_plugins_tiff_stream_1.0";
            try {
                tIFFStreamMetadata.mergeTree(string, iIOMetadata.getAsTree(string));
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                // empty catch block
            }
        }
        return tIFFStreamMetadata;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        Object object;
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        TIFFImageMetadata tIFFImageMetadata = null;
        if (iIOMetadata instanceof TIFFImageMetadata) {
            object = ((TIFFImageMetadata)iIOMetadata).getRootIFD();
            tIFFImageMetadata = new TIFFImageMetadata(((TIFFIFD)object).getShallowClone());
        } else if (Arrays.asList(iIOMetadata.getMetadataFormatNames()).contains("com_sun_media_imageio_plugins_tiff_image_1.0")) {
            try {
                tIFFImageMetadata = this.convertNativeImageMetadata(iIOMetadata);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {}
        } else if (iIOMetadata.isStandardMetadataFormatSupported()) {
            try {
                tIFFImageMetadata = this.convertStandardImageMetadata(iIOMetadata);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                // empty catch block
            }
        }
        if (tIFFImageMetadata != null) {
            object = new TIFFImageWriter(this.originatingProvider);
            ((TIFFImageWriter)object).imageMetadata = tIFFImageMetadata;
            ((TIFFImageWriter)object).param = imageWriteParam;
            SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
            try {
                ((TIFFImageWriter)object).setupMetadata(imageTypeSpecifier.getColorModel(), sampleModel, sampleModel.getWidth(), sampleModel.getHeight());
                return ((TIFFImageWriter)object).imageMetadata;
            }
            catch (IIOException iIOException) {
                return null;
            }
        }
        return tIFFImageMetadata;
    }

    private TIFFImageMetadata convertStandardImageMetadata(IIOMetadata iIOMetadata) throws IIOInvalidTreeException {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (!iIOMetadata.isStandardMetadataFormatSupported()) {
            throw new IllegalArgumentException("inData does not support standard metadata format!");
        }
        TIFFImageMetadata tIFFImageMetadata = null;
        String string = "javax_imageio_1.0";
        Node node = iIOMetadata.getAsTree(string);
        if (node != null) {
            ArrayList<BaselineTIFFTagSet> arrayList = new ArrayList<BaselineTIFFTagSet>(1);
            arrayList.add(BaselineTIFFTagSet.getInstance());
            tIFFImageMetadata = new TIFFImageMetadata(arrayList);
            tIFFImageMetadata.setFromTree(string, node);
        }
        return tIFFImageMetadata;
    }

    private TIFFImageMetadata convertNativeImageMetadata(IIOMetadata iIOMetadata) throws IIOInvalidTreeException {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (!Arrays.asList(iIOMetadata.getMetadataFormatNames()).contains("com_sun_media_imageio_plugins_tiff_image_1.0")) {
            throw new IllegalArgumentException("inData does not support native metadata format!");
        }
        TIFFImageMetadata tIFFImageMetadata = null;
        String string = "com_sun_media_imageio_plugins_tiff_image_1.0";
        Node node = iIOMetadata.getAsTree(string);
        if (node != null) {
            ArrayList<BaselineTIFFTagSet> arrayList = new ArrayList<BaselineTIFFTagSet>(1);
            arrayList.add(BaselineTIFFTagSet.getInstance());
            tIFFImageMetadata = new TIFFImageMetadata(arrayList);
            tIFFImageMetadata.setFromTree(string, node);
        }
        return tIFFImageMetadata;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setupMetadata(ColorModel colorModel, SampleModel sampleModel, int n2, int n3) throws IIOException {
        Object object;
        TIFFField tIFFField;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Object object2;
        TIFFField tIFFField2;
        int n9;
        boolean bl2;
        int n10;
        int n11;
        Object object3;
        Object object4;
        TIFFIFD tIFFIFD = this.imageMetadata.getRootIFD();
        BaselineTIFFTagSet baselineTIFFTagSet = BaselineTIFFTagSet.getInstance();
        TIFFField tIFFField3 = tIFFIFD.getTIFFField(284);
        if (tIFFField3 != null && tIFFField3.getAsInt(0) != 1) {
            object4 = new TIFFField(baselineTIFFTagSet.getTag(284), 1);
            tIFFIFD.addTIFFField((TIFFField)object4);
        }
        object4 = null;
        this.photometricInterpretation = -1;
        boolean bl3 = false;
        tIFFField3 = tIFFIFD.getTIFFField(262);
        if (tIFFField3 != null) {
            this.photometricInterpretation = tIFFField3.getAsInt(0);
            if (this.photometricInterpretation == 3 && !(colorModel instanceof IndexColorModel)) {
                this.photometricInterpretation = -1;
            } else {
                bl3 = true;
            }
        }
        int[] nArray = sampleModel.getSampleSize();
        int n12 = sampleModel.getNumBands();
        int n13 = 0;
        if (n12 > 1 && colorModel != null && colorModel.hasAlpha()) {
            --n12;
            n13 = 1;
            object4 = new char[1];
            object4[0] = colorModel.isAlphaPremultiplied() ? (Object)true : (Object)2;
        }
        if (n12 == 3) {
            this.nativePhotometricInterpretation = 2;
            if (this.photometricInterpretation == -1) {
                this.photometricInterpretation = 2;
            }
        } else if (sampleModel.getNumBands() == 1 && colorModel instanceof IndexColorModel) {
            object3 = (IndexColorModel)colorModel;
            int n14 = ((IndexColorModel)object3).getRed(0);
            n11 = ((IndexColorModel)object3).getRed(1);
            if (!(((IndexColorModel)object3).getMapSize() != 2 || n14 != ((IndexColorModel)object3).getGreen(0) || n14 != ((IndexColorModel)object3).getBlue(0) || n11 != ((IndexColorModel)object3).getGreen(1) || n11 != ((IndexColorModel)object3).getBlue(1) || n14 != 0 && n14 != 255 || n11 != 0 && n11 != 255 || n14 == n11)) {
                this.nativePhotometricInterpretation = n14 == 0 ? 1 : 0;
                if (this.photometricInterpretation != 1 && this.photometricInterpretation != 0) {
                    this.photometricInterpretation = n14 == 0 ? 1 : 0;
                }
            } else {
                this.photometricInterpretation = 3;
                this.nativePhotometricInterpretation = 3;
            }
        } else {
            if (colorModel != null) {
                switch (colorModel.getColorSpace().getType()) {
                    case 1: {
                        this.nativePhotometricInterpretation = 8;
                        break;
                    }
                    case 3: {
                        this.nativePhotometricInterpretation = 6;
                        break;
                    }
                    case 9: {
                        this.nativePhotometricInterpretation = 5;
                        break;
                    }
                    default: {
                        this.nativePhotometricInterpretation = 1;
                        break;
                    }
                }
            } else {
                this.nativePhotometricInterpretation = 1;
            }
            if (this.photometricInterpretation == -1) {
                this.photometricInterpretation = this.nativePhotometricInterpretation;
            }
        }
        this.compressor = null;
        this.colorConverter = null;
        if (this.param instanceof TIFFImageWriteParam) {
            object3 = (TIFFImageWriteParam)this.param;
            if (((ImageWriteParam)object3).getCompressionMode() == 2) {
                this.compressor = ((TIFFImageWriteParam)object3).getTIFFCompressor();
                String string = this.param.getCompressionType();
                if (this.compressor != null && !this.compressor.getCompressionType().equals(string)) {
                    this.compressor = null;
                }
            } else {
                this.compressor = null;
            }
            this.colorConverter = ((TIFFImageWriteParam)object3).getColorConverter();
            if (this.colorConverter != null) {
                this.photometricInterpretation = ((TIFFImageWriteParam)object3).getPhotometricInterpretation();
            }
        }
        int n15 = this.param instanceof TIFFImageWriteParam ? this.param.getCompressionMode() : 1;
        switch (n15) {
            case 2: {
                String string = this.param.getCompressionType();
                if (string == null) {
                    this.compression = 1;
                } else {
                    n11 = compressionTypes.length;
                    for (n10 = 0; n10 < n11; ++n10) {
                        if (!string.equals(compressionTypes[n10])) continue;
                        this.compression = compressionNumbers[n10];
                    }
                }
                if (this.compressor == null || this.compressor.getCompressionTagValue() == this.compression) break;
                this.compressor = null;
                break;
            }
            case 3: {
                TIFFField tIFFField4 = tIFFIFD.getTIFFField(259);
                if (tIFFField4 != null) {
                    this.compression = tIFFField4.getAsInt(0);
                    break;
                }
            }
            default: {
                this.compression = 1;
            }
        }
        TIFFField tIFFField5 = tIFFIFD.getTIFFField(317);
        if (tIFFField5 != null) {
            this.predictor = tIFFField5.getAsInt(0);
            if (nArray[0] != 8 || this.predictor != 1 && this.predictor != 2) {
                this.predictor = 1;
                TIFFField tIFFField6 = new TIFFField(baselineTIFFTagSet.getTag(317), this.predictor);
                tIFFIFD.addTIFFField(tIFFField6);
            }
        }
        TIFFField tIFFField7 = new TIFFField(baselineTIFFTagSet.getTag(259), this.compression);
        tIFFIFD.addTIFFField(tIFFField7);
        n10 = 0;
        if (n12 == 3 && nArray[0] == 8 && nArray[1] == 8 && nArray[2] == 8) {
            if (tIFFIFD.getTIFFField(34665) != null) {
                if (this.compression == 1 && (this.photometricInterpretation == 2 || this.photometricInterpretation == 6)) {
                    n10 = 1;
                } else if (this.compression == 6) {
                    n10 = 1;
                }
            } else if (n15 == 2 && EXIF_JPEG_COMPRESSION_TYPE.equals(this.param.getCompressionType())) {
                n10 = 1;
            }
        }
        boolean bl4 = bl2 = n10 != 0 && this.compression == 6;
        if (this.compressor == null) {
            if (this.compression == 2) {
                if (PackageUtil.isCodecLibAvailable()) {
                    try {
                        this.compressor = new TIFFCodecLibRLECompressor();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if (this.compressor == null) {
                    this.compressor = new TIFFRLECompressor();
                }
                if (!bl3) {
                    this.photometricInterpretation = 0;
                }
            } else if (this.compression == 3) {
                if (PackageUtil.isCodecLibAvailable()) {
                    try {
                        this.compressor = new TIFFCodecLibT4Compressor();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if (this.compressor == null) {
                    this.compressor = new TIFFT4Compressor();
                }
                if (!bl3) {
                    this.photometricInterpretation = 0;
                }
            } else if (this.compression == 4) {
                if (PackageUtil.isCodecLibAvailable()) {
                    try {
                        this.compressor = new TIFFCodecLibT6Compressor();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if (this.compressor == null) {
                    this.compressor = new TIFFT6Compressor();
                }
                if (!bl3) {
                    this.photometricInterpretation = 0;
                }
            } else if (this.compression == 5) {
                this.compressor = new TIFFLZWCompressor(this.predictor);
            } else if (this.compression == 6) {
                if (n10 == 0) throw new IIOException("Old JPEG compression not supported!");
                this.compressor = new TIFFEXIFJPEGCompressor(this.param);
            } else if (this.compression == 7) {
                if (n12 == 3 && nArray[0] == 8 && nArray[1] == 8 && nArray[2] == 8) {
                    this.photometricInterpretation = 6;
                } else {
                    if (n12 != 1 || nArray[0] != 8) throw new IIOException("JPEG compression supported for 1- and 3-band byte images only!");
                    this.photometricInterpretation = 1;
                }
                this.compressor = new TIFFJPEGCompressor(this.param);
            } else if (this.compression == 8) {
                this.compressor = new TIFFZLibCompressor(this.param, this.predictor);
            } else if (this.compression == 32773) {
                this.compressor = new TIFFPackBitsCompressor();
            } else if (this.compression == 32946) {
                this.compressor = new TIFFDeflateCompressor(this.param, this.predictor);
            } else {
                tIFFField3 = tIFFIFD.getTIFFField(266);
                boolean bl5 = tIFFField3 != null && tIFFField3.getAsInt(0) == 2;
                this.compressor = bl5 ? new TIFFLSBCompressor() : new TIFFNullCompressor();
            }
        }
        if (this.colorConverter == null && colorModel != null && colorModel.getColorSpace().getType() == 5) {
            if (this.photometricInterpretation == 6 && this.compression != 7) {
                this.colorConverter = new TIFFYCbCrColorConverter(this.imageMetadata);
            } else if (this.photometricInterpretation == 8) {
                this.colorConverter = new TIFFCIELabColorConverter();
            }
        }
        if (this.photometricInterpretation == 6 && this.compression != 7) {
            tIFFIFD.removeTIFFField(530);
            tIFFIFD.removeTIFFField(531);
            tIFFIFD.addTIFFField(new TIFFField(baselineTIFFTagSet.getTag(530), 3, 2, new char[]{'\u0001', '\u0001'}));
            tIFFIFD.addTIFFField(new TIFFField(baselineTIFFTagSet.getTag(531), 3, 1, new char[]{'\u0002'}));
        }
        TIFFField tIFFField8 = new TIFFField(baselineTIFFTagSet.getTag(262), this.photometricInterpretation);
        tIFFIFD.addTIFFField(tIFFField8);
        this.bitsPerSample = new char[n12 + n13];
        this.bitDepth = 0;
        for (n9 = 0; n9 < n12; ++n9) {
            this.bitDepth = Math.max(this.bitDepth, nArray[n9]);
        }
        if (this.bitDepth == 3) {
            this.bitDepth = 4;
        } else if (this.bitDepth > 4 && this.bitDepth < 8) {
            this.bitDepth = 8;
        } else if (this.bitDepth > 8 && this.bitDepth < 16) {
            this.bitDepth = 16;
        } else if (this.bitDepth > 16) {
            this.bitDepth = 32;
        }
        for (n9 = 0; n9 < this.bitsPerSample.length; ++n9) {
            this.bitsPerSample[n9] = (char)this.bitDepth;
        }
        if (this.bitsPerSample.length != 1 || this.bitsPerSample[0] != '\u0001') {
            tIFFField2 = new TIFFField(baselineTIFFTagSet.getTag(258), 3, this.bitsPerSample.length, this.bitsPerSample);
            tIFFIFD.addTIFFField(tIFFField2);
        } else {
            int[] nArray2;
            tIFFField2 = tIFFIFD.getTIFFField(258);
            if (tIFFField2 != null && ((nArray2 = tIFFField2.getAsInts()) == null || nArray2.length != 1 || nArray2[0] != 1)) {
                tIFFIFD.removeTIFFField(258);
            }
        }
        tIFFField3 = tIFFIFD.getTIFFField(339);
        if (tIFFField3 == null && (this.bitDepth == 16 || this.bitDepth == 32)) {
            int n16 = sampleModel.getDataType();
            char c2 = this.bitDepth == 16 && n16 == 1 ? (char)'\u0001' : (this.bitDepth == 32 && n16 == 4 ? (char)'\u0003' : '\u0002');
            this.sampleFormat = c2;
            object2 = new char[this.bitsPerSample.length];
            Arrays.fill((char[])object2, c2);
            TIFFTag tIFFTag = baselineTIFFTagSet.getTag(339);
            TIFFField tIFFField9 = new TIFFField(tIFFTag, 3, ((char[])object2).length, object2);
            tIFFIFD.addTIFFField(tIFFField9);
        } else {
            this.sampleFormat = tIFFField3 != null ? tIFFField3.getAsInt(0) : 4;
        }
        if (object4 != null) {
            TIFFField tIFFField10 = new TIFFField(baselineTIFFTagSet.getTag(338), 3, ((Object)object4).length, object4);
            tIFFIFD.addTIFFField(tIFFField10);
        } else {
            tIFFIFD.removeTIFFField(338);
        }
        TIFFField tIFFField11 = new TIFFField(baselineTIFFTagSet.getTag(277), this.bitsPerSample.length);
        tIFFIFD.addTIFFField(tIFFField11);
        if (this.photometricInterpretation == 3 && colorModel instanceof IndexColorModel) {
            char[] cArray = new char[3 * ('\u0001' << this.bitsPerSample[0])];
            object2 = (IndexColorModel)colorModel;
            int n17 = '\u0001' << this.bitsPerSample[0];
            int n18 = Math.min(n17, ((IndexColorModel)object2).getMapSize());
            for (int i2 = 0; i2 < n18; ++i2) {
                cArray[i2] = (char)(((IndexColorModel)object2).getRed(i2) * 65535 / 255);
                cArray[n17 + i2] = (char)(((IndexColorModel)object2).getGreen(i2) * 65535 / 255);
                cArray[2 * n17 + i2] = (char)(((IndexColorModel)object2).getBlue(i2) * 65535 / 255);
            }
            TIFFField tIFFField12 = new TIFFField(baselineTIFFTagSet.getTag(320), 3, cArray.length, cArray);
            tIFFIFD.addTIFFField(tIFFField12);
        } else {
            tIFFIFD.removeTIFFField(320);
        }
        if (colorModel != null && tIFFIFD.getTIFFField(34675) == null && ImageUtil.isNonStandardICCColorSpace(colorModel.getColorSpace())) {
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)colorModel.getColorSpace();
            object2 = iCC_ColorSpace.getProfile().getData();
            TIFFField tIFFField13 = new TIFFField(baselineTIFFTagSet.getTag(34675), 7, ((Object)object2).length, object2);
            tIFFIFD.addTIFFField(tIFFField13);
        }
        TIFFField tIFFField14 = tIFFIFD.getTIFFField(282);
        object2 = tIFFIFD.getTIFFField(283);
        if (tIFFField14 == null && object2 == null) {
            long[][] lArray = new long[1][2];
            lArray[0] = new long[2];
            TIFFField tIFFField15 = tIFFIFD.getTIFFField(296);
            if (tIFFField15 == null && tIFFIFD.getTIFFField(286) == null && tIFFIFD.getTIFFField(287) == null) {
                lArray[0][0] = 1L;
                lArray[0][1] = 1L;
                tIFFField15 = new TIFFField(tIFFIFD.getTag(296), 1);
                tIFFIFD.addTIFFField(tIFFField15);
            } else {
                int n19 = tIFFField15 != null ? tIFFField15.getAsInt(0) : 2;
                int n20 = Math.max(n2, n3);
                switch (n19) {
                    case 2: {
                        lArray[0][0] = n20;
                        lArray[0][1] = 4L;
                        break;
                    }
                    case 3: {
                        lArray[0][0] = 100L * (long)n20;
                        lArray[0][1] = 1016L;
                        break;
                    }
                    default: {
                        lArray[0][0] = 1L;
                        lArray[0][1] = 1L;
                    }
                }
            }
            tIFFField14 = new TIFFField(tIFFIFD.getTag(282), 5, 1, lArray);
            tIFFIFD.addTIFFField(tIFFField14);
            object2 = new TIFFField(tIFFIFD.getTag(283), 5, 1, lArray);
            tIFFIFD.addTIFFField((TIFFField)object2);
        } else if (tIFFField14 == null && object2 != null) {
            long[] lArray = (long[])((TIFFField)object2).getAsRational(0).clone();
            tIFFField14 = new TIFFField(tIFFIFD.getTag(282), 5, 1, lArray);
            tIFFIFD.addTIFFField(tIFFField14);
        } else if (tIFFField14 != null && object2 == null) {
            long[] lArray = (long[])tIFFField14.getAsRational(0).clone();
            object2 = new TIFFField(tIFFIFD.getTag(283), 5, 1, lArray);
            tIFFIFD.addTIFFField((TIFFField)object2);
        }
        int n21 = n2;
        TIFFField tIFFField16 = new TIFFField(baselineTIFFTagSet.getTag(256), n21);
        tIFFIFD.addTIFFField(tIFFField16);
        int n22 = n3;
        TIFFField tIFFField17 = new TIFFField(baselineTIFFTagSet.getTag(257), n22);
        tIFFIFD.addTIFFField(tIFFField17);
        TIFFField tIFFField18 = tIFFIFD.getTIFFField(278);
        if (tIFFField18 != null) {
            n8 = tIFFField18.getAsInt(0);
            if (n8 < 0) {
                n8 = n22;
            }
        } else {
            n7 = this.bitDepth * (n12 + n13);
            n6 = (n7 * n21 + 7) / 8;
            n8 = Math.max(Math.max(8192 / n6, 1), 8);
        }
        n8 = Math.min(n8, n22);
        n7 = 0;
        int n23 = n6 = this.param instanceof TIFFImageWriteParam ? this.param.getTilingMode() : 1;
        if (n6 == 0 || n6 == 1) {
            this.tileWidth = n21;
            this.tileLength = n8;
            n7 = 0;
        } else if (n6 == 2) {
            this.tileWidth = this.param.getTileWidth();
            this.tileLength = this.param.getTileHeight();
            n7 = 1;
        } else {
            if (n6 != 3) throw new IIOException("Illegal value of tilingMode!");
            tIFFField3 = tIFFIFD.getTIFFField(322);
            if (tIFFField3 == null) {
                this.tileWidth = n21;
                n7 = 0;
            } else {
                this.tileWidth = tIFFField3.getAsInt(0);
                n7 = 1;
            }
            tIFFField3 = tIFFIFD.getTIFFField(323);
            if (tIFFField3 == null) {
                this.tileLength = n8;
            } else {
                this.tileLength = tIFFField3.getAsInt(0);
                n7 = 1;
            }
        }
        if (this.compression == 7) {
            int n24;
            if (n12 == 1) {
                n5 = 1;
                n4 = 1;
            } else {
                n5 = 2;
                n4 = 2;
            }
            if (n7 != 0) {
                n24 = 8 * n4;
                int n25 = 8 * n5;
                this.tileWidth = Math.max(n24 * ((this.tileWidth + n24 / 2) / n24), n24);
                this.tileLength = Math.max(n25 * ((this.tileLength + n25 / 2) / n25), n25);
            } else if (n8 < n22) {
                n24 = 8 * Math.max(n4, n5);
                n8 = this.tileLength = Math.max(n24 * ((this.tileLength + n24 / 2) / n24), n24);
            }
        } else if (bl2) {
            this.tileWidth = n21;
            this.tileLength = n22;
        } else if (n7 != 0) {
            n4 = this.tileWidth % 16;
            if (n4 != 0) {
                this.tileWidth = Math.max(16 * ((this.tileWidth + 8) / 16), 16);
            }
            if ((n5 = this.tileLength % 16) != 0) {
                this.tileLength = Math.max(16 * ((this.tileLength + 8) / 16), 16);
            }
        }
        this.tilesAcross = (n21 + this.tileWidth - 1) / this.tileWidth;
        this.tilesDown = (n22 + this.tileLength - 1) / this.tileLength;
        if (n7 == 0) {
            this.isTiled = false;
            tIFFIFD.removeTIFFField(322);
            tIFFIFD.removeTIFFField(323);
            tIFFIFD.removeTIFFField(324);
            tIFFIFD.removeTIFFField(325);
            tIFFField18 = new TIFFField(baselineTIFFTagSet.getTag(278), n8);
            tIFFIFD.addTIFFField(tIFFField18);
            tIFFField = new TIFFField(baselineTIFFTagSet.getTag(273), 4, this.tilesDown);
            tIFFIFD.addTIFFField(tIFFField);
            object = new TIFFField(baselineTIFFTagSet.getTag(279), 4, this.tilesDown);
            tIFFIFD.addTIFFField((TIFFField)object);
        } else {
            this.isTiled = true;
            tIFFIFD.removeTIFFField(278);
            tIFFIFD.removeTIFFField(273);
            tIFFIFD.removeTIFFField(279);
            tIFFField = new TIFFField(baselineTIFFTagSet.getTag(322), this.tileWidth);
            tIFFIFD.addTIFFField(tIFFField);
            object = new TIFFField(baselineTIFFTagSet.getTag(323), this.tileLength);
            tIFFIFD.addTIFFField((TIFFField)object);
            TIFFField tIFFField19 = new TIFFField(baselineTIFFTagSet.getTag(324), 4, this.tilesDown * this.tilesAcross);
            tIFFIFD.addTIFFField(tIFFField19);
            TIFFField tIFFField20 = new TIFFField(baselineTIFFTagSet.getTag(325), 4, this.tilesDown * this.tilesAcross);
            tIFFIFD.addTIFFField(tIFFField20);
        }
        if (n10 == 0) return;
        boolean bl6 = this.isEncodingEmpty();
        if (this.compression == 6) {
            tIFFIFD.removeTIFFField(256);
            tIFFIFD.removeTIFFField(257);
            tIFFIFD.removeTIFFField(258);
            if (bl6) {
                tIFFIFD.removeTIFFField(259);
            }
            tIFFIFD.removeTIFFField(262);
            tIFFIFD.removeTIFFField(273);
            tIFFIFD.removeTIFFField(277);
            tIFFIFD.removeTIFFField(278);
            tIFFIFD.removeTIFFField(279);
            tIFFIFD.removeTIFFField(284);
            if (tIFFIFD.getTIFFField(296) == null) {
                tIFFField3 = new TIFFField(baselineTIFFTagSet.getTag(296), 2);
                tIFFIFD.addTIFFField(tIFFField3);
            }
            if (bl6) {
                tIFFIFD.removeTIFFField(513);
                tIFFIFD.removeTIFFField(514);
                tIFFIFD.removeTIFFField(530);
                if (tIFFIFD.getTIFFField(531) == null) {
                    tIFFField3 = new TIFFField(baselineTIFFTagSet.getTag(531), 3, 1, new char[]{'\u0001'});
                    tIFFIFD.addTIFFField(tIFFField3);
                }
            } else {
                tIFFField3 = new TIFFField(baselineTIFFTagSet.getTag(513), 4, 1);
                tIFFIFD.addTIFFField(tIFFField3);
                tIFFField3 = new TIFFField(baselineTIFFTagSet.getTag(514), 4, 1);
                tIFFIFD.addTIFFField(tIFFField3);
                tIFFIFD.removeTIFFField(530);
            }
        } else {
            if (tIFFIFD.getTIFFField(296) == null) {
                tIFFField3 = new TIFFField(baselineTIFFTagSet.getTag(296), 2);
                tIFFIFD.addTIFFField(tIFFField3);
            }
            tIFFIFD.removeTIFFField(513);
            tIFFIFD.removeTIFFField(514);
            if (this.photometricInterpretation == 2) {
                tIFFIFD.removeTIFFField(529);
                tIFFIFD.removeTIFFField(530);
                tIFFIFD.removeTIFFField(531);
            }
        }
        object = EXIFTIFFTagSet.getInstance();
        TIFFIFD tIFFIFD2 = null;
        tIFFField3 = tIFFIFD.getTIFFField(34665);
        if (tIFFField3 != null) {
            tIFFIFD2 = (TIFFIFD)tIFFField3.getData();
        } else if (bl6) {
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(object);
            tIFFIFD2 = new TIFFIFD(arrayList);
            EXIFParentTIFFTagSet eXIFParentTIFFTagSet = EXIFParentTIFFTagSet.getInstance();
            TIFFTag tIFFTag = eXIFParentTIFFTagSet.getTag(34665);
            tIFFIFD.addTIFFField(new TIFFField(tIFFTag, 4, 1, tIFFIFD2));
        }
        if (tIFFIFD2 == null) return;
        if (tIFFIFD2.getTIFFField(36864) == null) {
            tIFFField3 = new TIFFField(((TIFFTagSet)object).getTag(36864), 7, 4, EXIFTIFFTagSet.EXIF_VERSION_2_2);
            tIFFIFD2.addTIFFField(tIFFField3);
        }
        if (this.compression == 6) {
            if (tIFFIFD2.getTIFFField(37121) == null) {
                tIFFField3 = new TIFFField(((TIFFTagSet)object).getTag(37121), 7, 4, new byte[]{1, 2, 3, 0});
                tIFFIFD2.addTIFFField(tIFFField3);
            }
        } else {
            tIFFIFD2.removeTIFFField(37121);
            tIFFIFD2.removeTIFFField(37122);
        }
        if (tIFFIFD2.getTIFFField(40960) == null) {
            tIFFField3 = new TIFFField(((TIFFTagSet)object).getTag(40960), 7, 4, new byte[]{48, 49, 48, 48});
            tIFFIFD2.addTIFFField(tIFFField3);
        }
        if (tIFFIFD2.getTIFFField(40961) == null) {
            tIFFField3 = new TIFFField(((TIFFTagSet)object).getTag(40961), 3, 1, new char[]{'\u0001'});
            tIFFIFD2.addTIFFField(tIFFField3);
        }
        if (this.compression == 6) {
            if (tIFFIFD2.getTIFFField(40962) == null) {
                tIFFField3 = new TIFFField(((TIFFTagSet)object).getTag(40962), n21);
                tIFFIFD2.addTIFFField(tIFFField3);
            }
            if (tIFFIFD2.getTIFFField(40963) != null) return;
            tIFFField3 = new TIFFField(((TIFFTagSet)object).getTag(40963), n22);
            tIFFIFD2.addTIFFField(tIFFField3);
            return;
        } else {
            tIFFIFD2.removeTIFFField(40965);
        }
    }

    private int writeTile(Rectangle rectangle, TIFFCompressor tIFFCompressor) throws IOException {
        int n2;
        SampleModel sampleModel;
        boolean bl2;
        Rectangle rectangle2;
        Rectangle rectangle3 = new Rectangle(this.image.getMinX(), this.image.getMinY(), this.image.getWidth(), this.image.getHeight());
        if (!this.isTiled) {
            rectangle = rectangle2 = rectangle.intersection(rectangle3);
            bl2 = false;
        } else if (rectangle3.contains(rectangle)) {
            rectangle2 = rectangle;
            bl2 = false;
        } else {
            rectangle2 = rectangle3.intersection(rectangle);
            bl2 = true;
        }
        if (rectangle2.isEmpty()) {
            return 0;
        }
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        if (this.isImageSimple) {
            Object object;
            SampleModel sampleModel2 = this.image.getSampleModel();
            Object object2 = this.image.getData(rectangle2);
            if (bl2) {
                object = ((Raster)object2).createCompatibleWritableRaster(n3, n4, n5, n6);
                ((WritableRaster)object).setRect((Raster)object2);
                object2 = object;
            }
            if (this.isBilevel) {
                object = ImageUtil.getPackedBinaryData((Raster)object2, rectangle);
                if (this.isInverted) {
                    DataBuffer dataBuffer = ((Raster)object2).getDataBuffer();
                    if (dataBuffer instanceof DataBufferByte && object == ((DataBufferByte)dataBuffer).getData()) {
                        byte[] byArray = new byte[((Object)object).length];
                        int n7 = ((Object)object).length;
                        for (int i2 = 0; i2 < n7; ++i2) {
                            byArray[i2] = (byte)(object[i2] ^ 0xFF);
                        }
                        object = byArray;
                    } else {
                        int n8 = ((Object)object).length;
                        int n9 = 0;
                        while (n9 < n8) {
                            Object object3 = object;
                            int n10 = n9++;
                            object3[n10] = (byte)(object3[n10] ^ 0xFF);
                        }
                    }
                }
                return tIFFCompressor.encode((byte[])object, 0, n5, n6, this.sampleSize, (rectangle.width + 7) / 8);
            }
            if (this.bitDepth == 8 && sampleModel2.getDataType() == 0) {
                object = (ComponentSampleModel)((Raster)object2).getSampleModel();
                byte[] byArray = ((DataBufferByte)((Raster)object2).getDataBuffer()).getData();
                int n11 = ((ComponentSampleModel)object).getOffset(n3 - ((Raster)object2).getSampleModelTranslateX(), n4 - ((Raster)object2).getSampleModelTranslateY());
                return tIFFCompressor.encode(byArray, n11, n5, n6, this.sampleSize, ((ComponentSampleModel)object).getScanlineStride());
            }
        }
        int n12 = n3;
        int n13 = this.periodX;
        int n14 = n4;
        int n15 = this.periodY;
        int n16 = (n5 + n13 - 1) / n13;
        int n17 = (n6 + n15 - 1) / n15;
        if (n16 == 0 || n17 == 0) {
            return 0;
        }
        n12 *= this.numBands;
        n13 *= this.numBands;
        int n18 = 8 / this.bitDepth;
        int n19 = n5 * this.numBands;
        int n20 = n16 * this.numBands;
        if (this.bitDepth < 8) {
            n20 = (n20 + n18 - 1) / n18;
        } else if (this.bitDepth == 16) {
            n20 *= 2;
        } else if (this.bitDepth == 32) {
            n20 *= 4;
        }
        int[] nArray = null;
        float[] fArray = null;
        if (this.sampleFormat == 3) {
            fArray = new float[n19];
        } else {
            nArray = new int[n19];
        }
        byte[] byArray = new byte[n20 * n17];
        if (!this.isInverted && !this.isRescaling && this.sourceBands == null && this.periodX == 1 && this.periodY == 1 && this.colorConverter == null && (sampleModel = this.image.getSampleModel()) instanceof ComponentSampleModel && this.bitDepth == 8 && sampleModel.getDataType() == 0) {
            Object object;
            Object object4 = this.image.getData(rectangle2);
            if (bl2) {
                object = ((Raster)object4).createCompatibleWritableRaster(n3, n4, n5, n6);
                ((WritableRaster)object).setRect((Raster)object4);
                object4 = object;
            }
            object = (ComponentSampleModel)((Raster)object4).getSampleModel();
            int[] nArray2 = ((ComponentSampleModel)object).getBankIndices();
            byte[][] byArray2 = ((DataBufferByte)((Raster)object4).getDataBuffer()).getBankData();
            int n21 = ((ComponentSampleModel)object).getScanlineStride();
            int n22 = ((ComponentSampleModel)object).getPixelStride();
            for (int i3 = 0; i3 < this.numBands; ++i3) {
                byte[] byArray3 = byArray2[nArray2[i3]];
                int n23 = ((ComponentSampleModel)object).getOffset(((Raster)object4).getMinX() - ((Raster)object4).getSampleModelTranslateX(), ((Raster)object4).getMinY() - ((Raster)object4).getSampleModelTranslateY(), i3);
                int n24 = i3;
                for (int i4 = 0; i4 < n17; ++i4) {
                    int n25 = n23;
                    for (int i5 = 0; i5 < n16; ++i5) {
                        byArray[n24] = byArray3[n25];
                        n24 += this.numBands;
                        n25 += n22;
                    }
                    n23 += n21;
                }
            }
            return tIFFCompressor.encode(byArray, 0, n5, n6, this.sampleSize, n5 * this.numBands);
        }
        int n26 = 0;
        int n27 = rectangle2.x;
        int n28 = rectangle2.y;
        int n29 = n28 + rectangle2.height - 1;
        int n30 = rectangle2.width;
        SampleModel sampleModel3 = null;
        if (bl2) {
            sampleModel3 = this.image.getSampleModel().createCompatibleSampleModel(n5, 1);
        }
        block11: for (int i6 = n14; i6 < n14 + n6; i6 += n15) {
            Object object;
            Object object5 = null;
            if (bl2) {
                object = Raster.createWritableRaster(sampleModel3, new Point(n3, i6));
                if (i6 >= n28 && i6 <= n29) {
                    Rectangle rectangle4 = new Rectangle(n27, i6, n30, 1);
                    object5 = this.image.getData(rectangle4);
                    ((WritableRaster)object).setRect((Raster)object5);
                }
                object5 = object;
            } else {
                object = new Rectangle(n3, i6, n5, 1);
                object5 = this.image.getData((Rectangle)object);
            }
            if (this.sourceBands != null) {
                object5 = ((Raster)object5).createChild(n3, i6, n5, 1, n3, i6, this.sourceBands);
            }
            if (this.sampleFormat == 3) {
                ((Raster)object5).getPixels(n3, i6, n5, 1, fArray);
            } else {
                ((Raster)object5).getPixels(n3, i6, n5, 1, nArray);
                if (this.nativePhotometricInterpretation == 1 && this.photometricInterpretation == 0 || this.nativePhotometricInterpretation == 0 && this.photometricInterpretation == 1) {
                    int n31 = (1 << this.bitDepth) - 1;
                    int n32 = 0;
                    while (n32 < n19) {
                        int n33 = n32++;
                        nArray[n33] = nArray[n33] ^ n31;
                    }
                }
            }
            if (this.colorConverter != null) {
                float f2;
                int n34 = 0;
                float[] fArray2 = new float[3];
                if (this.sampleFormat == 3) {
                    for (int i7 = 0; i7 < n5; ++i7) {
                        float f3 = fArray[n34];
                        float f4 = fArray[n34 + 1];
                        f2 = fArray[n34 + 2];
                        this.colorConverter.fromRGB(f3, f4, f2, fArray2);
                        fArray[n34] = fArray2[0];
                        fArray[n34 + 1] = fArray2[1];
                        fArray[n34 + 2] = fArray2[2];
                        n34 += 3;
                    }
                } else {
                    for (int i8 = 0; i8 < n5; ++i8) {
                        float f5 = nArray[n34];
                        float f6 = nArray[n34 + 1];
                        f2 = nArray[n34 + 2];
                        this.colorConverter.fromRGB(f5, f6, f2, fArray2);
                        nArray[n34] = (int)fArray2[0];
                        nArray[n34 + 1] = (int)fArray2[1];
                        nArray[n34 + 2] = (int)fArray2[2];
                        n34 += 3;
                    }
                }
            }
            int n35 = 0;
            int n36 = 0;
            switch (this.bitDepth) {
                case 1: 
                case 2: 
                case 4: {
                    int n37;
                    if (this.isRescaling) {
                        for (n37 = 0; n37 < n19; n37 += n13) {
                            byte by2 = this.scale0[nArray[n37]];
                            n35 = n35 << this.bitDepth | by2;
                            if (++n36 != n18) continue;
                            byArray[n26++] = (byte)n35;
                            n35 = 0;
                            n36 = 0;
                        }
                    } else {
                        for (n37 = 0; n37 < n19; n37 += n13) {
                            byte by3 = (byte)nArray[n37];
                            n35 = n35 << this.bitDepth | by3;
                            if (++n36 != n18) continue;
                            byArray[n26++] = (byte)n35;
                            n35 = 0;
                            n36 = 0;
                        }
                    }
                    if (n36 == 0) continue block11;
                    byArray[n26++] = (byte)(n35 <<= (8 / this.bitDepth - n36) * this.bitDepth);
                    continue block11;
                }
                case 8: {
                    if (this.numBands == 1) {
                        if (this.isRescaling) {
                            for (int i9 = 0; i9 < n19; i9 += n13) {
                                byArray[n26++] = this.scale0[nArray[i9]];
                            }
                            continue block11;
                        }
                        for (int i10 = 0; i10 < n19; i10 += n13) {
                            byArray[n26++] = (byte)nArray[i10];
                        }
                        continue block11;
                    }
                    if (this.isRescaling) {
                        for (int i11 = 0; i11 < n19; i11 += n13) {
                            for (int i12 = 0; i12 < this.numBands; ++i12) {
                                byArray[n26++] = this.scale[i12][nArray[i11 + i12]];
                            }
                        }
                        continue block11;
                    }
                    for (int i13 = 0; i13 < n19; i13 += n13) {
                        for (int i14 = 0; i14 < this.numBands; ++i14) {
                            byArray[n26++] = (byte)nArray[i13 + i14];
                        }
                    }
                    continue block11;
                }
                case 16: {
                    if (this.isRescaling) {
                        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                            for (int i15 = 0; i15 < n19; i15 += n13) {
                                for (int i16 = 0; i16 < this.numBands; ++i16) {
                                    int n38 = nArray[i15 + i16];
                                    byArray[n26++] = this.scaleh[i16][n38];
                                    byArray[n26++] = this.scalel[i16][n38];
                                }
                            }
                            continue block11;
                        }
                        for (int i17 = 0; i17 < n19; i17 += n13) {
                            for (int i18 = 0; i18 < this.numBands; ++i18) {
                                int n39 = nArray[i17 + i18];
                                byArray[n26++] = this.scalel[i18][n39];
                                byArray[n26++] = this.scaleh[i18][n39];
                            }
                        }
                        continue block11;
                    }
                    if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                        for (int i19 = 0; i19 < n19; i19 += n13) {
                            for (int i20 = 0; i20 < this.numBands; ++i20) {
                                int n40 = nArray[i19 + i20];
                                byArray[n26++] = (byte)(n40 >>> 8 & 0xFF);
                                byArray[n26++] = (byte)(n40 & 0xFF);
                            }
                        }
                        continue block11;
                    }
                    for (int i21 = 0; i21 < n19; i21 += n13) {
                        for (int i22 = 0; i22 < this.numBands; ++i22) {
                            int n41 = nArray[i21 + i22];
                            byArray[n26++] = (byte)(n41 & 0xFF);
                            byArray[n26++] = (byte)(n41 >>> 8 & 0xFF);
                        }
                    }
                    continue block11;
                }
                case 32: {
                    if (this.sampleFormat == 3) {
                        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                            for (int i23 = 0; i23 < n19; i23 += n13) {
                                for (int i24 = 0; i24 < this.numBands; ++i24) {
                                    float f7 = fArray[i23 + i24];
                                    int n42 = Float.floatToIntBits(f7);
                                    byArray[n26++] = (byte)((n42 & 0xFF000000) >> 24);
                                    byArray[n26++] = (byte)((n42 & 0xFF0000) >> 16);
                                    byArray[n26++] = (byte)((n42 & 0xFF00) >> 8);
                                    byArray[n26++] = (byte)(n42 & 0xFF);
                                }
                            }
                            continue block11;
                        }
                        for (int i25 = 0; i25 < n19; i25 += n13) {
                            for (int i26 = 0; i26 < this.numBands; ++i26) {
                                float f8 = fArray[i25 + i26];
                                int n43 = Float.floatToIntBits(f8);
                                byArray[n26++] = (byte)(n43 & 0xFF);
                                byArray[n26++] = (byte)((n43 & 0xFF00) >> 8);
                                byArray[n26++] = (byte)((n43 & 0xFF0000) >> 16);
                                byArray[n26++] = (byte)((n43 & 0xFF000000) >> 24);
                            }
                        }
                        continue block11;
                    }
                    if (this.isRescaling) {
                        long l2;
                        int n44;
                        int n45;
                        long[] lArray = new long[this.numBands];
                        long[] lArray2 = new long[this.numBands];
                        long l3 = (1L << (int)((long)this.bitDepth)) - 1L;
                        for (n45 = 0; n45 < this.numBands; ++n45) {
                            lArray[n45] = (1L << (int)((long)this.sampleSize[n45])) - 1L;
                            lArray2[n45] = lArray[n45] / 2L;
                        }
                        if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                            for (n45 = 0; n45 < n19; n45 += n13) {
                                for (n44 = 0; n44 < this.numBands; ++n44) {
                                    l2 = ((long)nArray[n45 + n44] * l3 + lArray2[n44]) / lArray[n44];
                                    byArray[n26++] = (byte)((l2 & 0xFFFFFFFFFF000000L) >> 24);
                                    byArray[n26++] = (byte)((l2 & 0xFF0000L) >> 16);
                                    byArray[n26++] = (byte)((l2 & 0xFF00L) >> 8);
                                    byArray[n26++] = (byte)(l2 & 0xFFL);
                                }
                            }
                            continue block11;
                        }
                        for (n45 = 0; n45 < n19; n45 += n13) {
                            for (n44 = 0; n44 < this.numBands; ++n44) {
                                l2 = ((long)nArray[n45 + n44] * l3 + lArray2[n44]) / lArray[n44];
                                byArray[n26++] = (byte)(l2 & 0xFFL);
                                byArray[n26++] = (byte)((l2 & 0xFF00L) >> 8);
                                byArray[n26++] = (byte)((l2 & 0xFF0000L) >> 16);
                                byArray[n26++] = (byte)((l2 & 0xFFFFFFFFFF000000L) >> 24);
                            }
                        }
                        continue block11;
                    }
                    if (this.stream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                        for (int i27 = 0; i27 < n19; i27 += n13) {
                            for (int i28 = 0; i28 < this.numBands; ++i28) {
                                int n46 = nArray[i27 + i28];
                                byArray[n26++] = (byte)((n46 & 0xFF000000) >> 24);
                                byArray[n26++] = (byte)((n46 & 0xFF0000) >> 16);
                                byArray[n26++] = (byte)((n46 & 0xFF00) >> 8);
                                byArray[n26++] = (byte)(n46 & 0xFF);
                            }
                        }
                        continue block11;
                    }
                    for (int i29 = 0; i29 < n19; i29 += n13) {
                        for (int i30 = 0; i30 < this.numBands; ++i30) {
                            int n47 = nArray[i29 + i30];
                            byArray[n26++] = (byte)(n47 & 0xFF);
                            byArray[n26++] = (byte)((n47 & 0xFF00) >> 8);
                            byArray[n26++] = (byte)((n47 & 0xFF0000) >> 16);
                            byArray[n26++] = (byte)((n47 & 0xFF000000) >> 24);
                        }
                    }
                    continue block11;
                }
            }
        }
        int[] nArray3 = new int[this.numBands];
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            nArray3[n2] = this.bitDepth;
        }
        n2 = tIFFCompressor.encode(byArray, 0, n16, n17, nArray3, n20);
        return n2;
    }

    private boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    private void initializeScaleTables(int[] nArray) {
        int n2;
        if (this.bitDepth == this.scalingBitDepth && this.equals(nArray, this.sampleSize)) {
            return;
        }
        this.isRescaling = false;
        this.scalingBitDepth = -1;
        this.scaleh = null;
        this.scalel = this.scaleh;
        this.scale = this.scaleh;
        this.scale0 = null;
        this.sampleSize = nArray;
        if (this.bitDepth <= 16) {
            for (n2 = 0; n2 < this.numBands; ++n2) {
                if (nArray[n2] == this.bitDepth) continue;
                this.isRescaling = true;
                break;
            }
        }
        if (!this.isRescaling) {
            return;
        }
        this.scalingBitDepth = this.bitDepth;
        n2 = (1 << this.bitDepth) - 1;
        if (this.bitDepth <= 8) {
            this.scale = new byte[this.numBands][];
            for (int i2 = 0; i2 < this.numBands; ++i2) {
                int n3 = (1 << nArray[i2]) - 1;
                int n4 = n3 / 2;
                this.scale[i2] = new byte[n3 + 1];
                for (int i3 = 0; i3 <= n3; ++i3) {
                    this.scale[i2][i3] = (byte)((i3 * n2 + n4) / n3);
                }
            }
            this.scale0 = this.scale[0];
            this.scalel = null;
            this.scaleh = this.scalel;
        } else if (this.bitDepth <= 16) {
            this.scaleh = new byte[this.numBands][];
            this.scalel = new byte[this.numBands][];
            for (int i4 = 0; i4 < this.numBands; ++i4) {
                int n5 = (1 << nArray[i4]) - 1;
                int n6 = n5 / 2;
                this.scaleh[i4] = new byte[n5 + 1];
                this.scalel[i4] = new byte[n5 + 1];
                for (int i5 = 0; i5 <= n5; ++i5) {
                    int n7 = (i5 * n2 + n6) / n5;
                    this.scaleh[i4][i5] = (byte)(n7 >> 8);
                    this.scalel[i4][i5] = (byte)(n7 & 0xFF);
                }
            }
            this.scale = null;
            this.scale0 = null;
        }
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.write(iIOMetadata, iIOImage, imageWriteParam, true, true);
    }

    private void writeHeader() throws IOException {
        this.byteOrder = this.streamMetadata != null ? this.streamMetadata.byteOrder : ByteOrder.BIG_ENDIAN;
        this.stream.setByteOrder(this.byteOrder);
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.stream.writeShort(19789);
        } else {
            this.stream.writeShort(18761);
        }
        this.stream.writeShort(42);
        this.stream.writeInt(0);
        this.nextSpace = this.stream.getStreamPosition();
        this.headerPosition = this.nextSpace - 8L;
    }

    private void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam, boolean bl2, boolean bl3) throws IOException {
        Object object;
        int[] nArray;
        int n2;
        if (this.stream == null) {
            throw new IllegalStateException("output == null!");
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (iIOImage.hasRaster() && !this.canWriteRasters()) {
            throw new UnsupportedOperationException("TIFF ImageWriter cannot write Rasters!");
        }
        this.image = iIOImage.getRenderedImage();
        SampleModel sampleModel = this.image.getSampleModel();
        this.sourceXOffset = this.image.getMinX();
        this.sourceYOffset = this.image.getMinY();
        this.sourceWidth = this.image.getWidth();
        this.sourceHeight = this.image.getHeight();
        Rectangle rectangle = new Rectangle(this.sourceXOffset, this.sourceYOffset, this.sourceWidth, this.sourceHeight);
        ColorModel colorModel = null;
        if (imageWriteParam == null) {
            this.param = this.getDefaultWriteParam();
            this.sourceBands = null;
            this.periodX = 1;
            this.periodY = 1;
            this.numBands = sampleModel.getNumBands();
            colorModel = this.image.getColorModel();
        } else {
            ColorModel colorModel2;
            this.param = imageWriteParam;
            Rectangle rectangle2 = this.param.getSourceRegion();
            if (rectangle2 != null) {
                rectangle2 = rectangle2.intersection(rectangle);
                this.sourceXOffset = rectangle2.x;
                this.sourceYOffset = rectangle2.y;
                this.sourceWidth = rectangle2.width;
                this.sourceHeight = rectangle2.height;
            }
            n2 = this.param.getSubsamplingXOffset();
            int n3 = this.param.getSubsamplingYOffset();
            this.sourceXOffset += n2;
            this.sourceYOffset += n3;
            this.sourceWidth -= n2;
            this.sourceHeight -= n3;
            this.periodX = this.param.getSourceXSubsampling();
            this.periodY = this.param.getSourceYSubsampling();
            nArray = this.param.getSourceBands();
            if (nArray != null) {
                this.sourceBands = nArray;
                this.numBands = this.sourceBands.length;
            } else {
                this.numBands = sampleModel.getNumBands();
            }
            object = imageWriteParam.getDestinationType();
            if (object != null && (colorModel2 = ((ImageTypeSpecifier)object).getColorModel()).getNumComponents() == this.numBands) {
                colorModel = colorModel2;
            }
            if (colorModel == null) {
                colorModel = this.image.getColorModel();
            }
        }
        this.imageType = new ImageTypeSpecifier(colorModel, sampleModel);
        ImageUtil.canEncodeImage(this, this.imageType);
        int n4 = (this.sourceWidth + this.periodX - 1) / this.periodX;
        n2 = (this.sourceHeight + this.periodY - 1) / this.periodY;
        if (n4 <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Empty source region!");
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        if (bl2) {
            this.streamMetadata = null;
            if (iIOMetadata != null) {
                this.streamMetadata = (TIFFStreamMetadata)this.convertStreamMetadata(iIOMetadata, this.param);
            }
            if (this.streamMetadata == null) {
                this.streamMetadata = (TIFFStreamMetadata)this.getDefaultStreamMetadata(this.param);
            }
            this.writeHeader();
            this.stream.seek(this.headerPosition + 4L);
            this.nextSpace = this.nextSpace + 3L & 0xFFFFFFFFFFFFFFFCL;
            this.stream.writeInt((int)this.nextSpace);
        }
        this.imageMetadata = null;
        IIOMetadata iIOMetadata2 = iIOImage.getMetadata();
        if (iIOMetadata2 != null) {
            if (iIOMetadata2 instanceof TIFFImageMetadata) {
                this.imageMetadata = ((TIFFImageMetadata)iIOMetadata2).getShallowClone();
            } else if (Arrays.asList(iIOMetadata2.getMetadataFormatNames()).contains("com_sun_media_imageio_plugins_tiff_image_1.0")) {
                this.imageMetadata = this.convertNativeImageMetadata(iIOMetadata2);
            } else if (iIOMetadata2.isStandardMetadataFormatSupported()) {
                try {
                    this.imageMetadata = this.convertStandardImageMetadata(iIOMetadata2);
                }
                catch (IIOInvalidTreeException iIOInvalidTreeException) {
                    // empty catch block
                }
            }
        }
        if (this.imageMetadata == null) {
            this.imageMetadata = (TIFFImageMetadata)this.getDefaultImageMetadata(this.imageType, this.param);
        }
        this.setupMetadata(colorModel, sampleModel, n4, n2);
        this.compressor.setWriter(this);
        this.compressor.setMetadata(this.imageMetadata);
        this.compressor.setStream(this.stream);
        nArray = sampleModel.getSampleSize();
        this.initializeScaleTables(sampleModel.getSampleSize());
        this.isBilevel = ImageUtil.isBinary(this.image.getSampleModel());
        this.isInverted = this.nativePhotometricInterpretation == 1 && this.photometricInterpretation == 0 || this.nativePhotometricInterpretation == 0 && this.photometricInterpretation == 1;
        this.isImageSimple = (this.isBilevel || !this.isInverted && ImageUtil.imageIsContiguous(this.image)) && !this.isRescaling && this.sourceBands == null && this.periodX == 1 && this.periodY == 1 && this.colorConverter == null;
        object = this.imageMetadata.getRootIFD();
        ((TIFFIFD)object).writeToStream(this.stream);
        this.nextIFDPointerPos = this.stream.getStreamPosition();
        this.stream.writeInt(0);
        long l2 = ((TIFFIFD)object).getLastPosition();
        this.stream.seek(l2);
        if (l2 > this.nextSpace) {
            this.nextSpace = l2;
        }
        if (!bl3) {
            return;
        }
        long l3 = ((TIFFIFD)object).getStripOrTileByteCountsPosition();
        long l4 = ((TIFFIFD)object).getStripOrTileOffsetsPosition();
        this.totalPixels = this.tileWidth * this.tileLength * this.tilesDown * this.tilesAcross;
        this.pixelsDone = 0;
        for (int i2 = 0; i2 < this.tilesDown; ++i2) {
            for (int i3 = 0; i3 < this.tilesAcross; ++i3) {
                long l5 = this.stream.getStreamPosition();
                Rectangle rectangle3 = new Rectangle(this.sourceXOffset + i3 * this.tileWidth * this.periodX, this.sourceYOffset + i2 * this.tileLength * this.periodY, this.tileWidth * this.periodX, this.tileLength * this.periodY);
                try {
                    int n5 = this.writeTile(rectangle3, this.compressor);
                    if (l5 + (long)n5 > this.nextSpace) {
                        this.nextSpace = l5 + (long)n5;
                    }
                    this.pixelsDone += rectangle3.width * rectangle3.height;
                    this.processImageProgress(100.0f * (float)this.pixelsDone / (float)this.totalPixels);
                    this.stream.mark();
                    this.stream.seek(l4);
                    this.stream.writeInt((int)l5);
                    l4 += 4L;
                    this.stream.seek(l3);
                    this.stream.writeInt(n5);
                    l3 += 4L;
                    this.stream.reset();
                }
                catch (IOException iOException) {
                    throw new IIOException("I/O error writing TIFF file!", iOException);
                }
                if (!this.abortRequested()) continue;
                this.processWriteAborted();
                return;
            }
        }
        this.processImageComplete();
    }

    public boolean canWriteSequence() {
        return true;
    }

    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        if (iIOMetadata != null) {
            iIOMetadata = this.convertStreamMetadata(iIOMetadata, null);
        }
        if (iIOMetadata == null) {
            iIOMetadata = this.getDefaultStreamMetadata(null);
        }
        this.streamMetadata = (TIFFStreamMetadata)iIOMetadata;
        this.writeHeader();
        this.isWritingSequence = true;
    }

    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (!this.isWritingSequence) {
            throw new IllegalStateException("prepareWriteSequence() has not been called!");
        }
        this.writeInsert(-1, iIOImage, imageWriteParam);
    }

    public void endWriteSequence() throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        if (!this.isWritingSequence) {
            throw new IllegalStateException("prepareWriteSequence() has not been called!");
        }
        this.isWritingSequence = false;
    }

    public boolean canInsertImage(int n2) throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        this.stream.mark();
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        this.locateIFD(n2, lArray, lArray2);
        this.stream.reset();
        return true;
    }

    private void locateIFD(int n2, long[] lArray, long[] lArray2) throws IOException {
        if (n2 < -1) {
            throw new IndexOutOfBoundsException("imageIndex < -1!");
        }
        long l2 = this.stream.getStreamPosition();
        this.stream.seek(this.headerPosition);
        int n3 = this.stream.readUnsignedShort();
        if (n3 == 19789) {
            this.stream.setByteOrder(ByteOrder.BIG_ENDIAN);
        } else if (n3 == 18761) {
            this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.stream.seek(l2);
            throw new IIOException("Illegal byte order");
        }
        if (this.stream.readUnsignedShort() != 42) {
            this.stream.seek(l2);
            throw new IIOException("Illegal magic number");
        }
        lArray[0] = this.stream.getStreamPosition();
        lArray2[0] = this.stream.readUnsignedInt();
        if (lArray2[0] == 0L) {
            if (n2 > 0) {
                this.stream.seek(l2);
                throw new IndexOutOfBoundsException("imageIndex is greater than the largest available index!");
            }
            return;
        }
        this.stream.seek(lArray2[0]);
        for (int i2 = 0; n2 == -1 || i2 < n2; ++i2) {
            short s2;
            try {
                s2 = this.stream.readShort();
            }
            catch (EOFException eOFException) {
                this.stream.seek(l2);
                lArray2[0] = 0L;
                return;
            }
            this.stream.skipBytes(12 * s2);
            lArray[0] = this.stream.getStreamPosition();
            lArray2[0] = this.stream.readUnsignedInt();
            if (lArray2[0] == 0L) {
                if (n2 == -1 || i2 >= n2 - 1) break;
                this.stream.seek(l2);
                throw new IndexOutOfBoundsException("imageIndex is greater than the largest available index!");
            }
            this.stream.seek(lArray2[0]);
        }
    }

    public void writeInsert(int n2, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.insert(n2, iIOImage, imageWriteParam, true);
    }

    private void insert(int n2, IIOImage iIOImage, ImageWriteParam imageWriteParam, boolean bl2) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("Output not set!");
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        this.locateIFD(n2, lArray, lArray2);
        this.stream.seek(lArray[0]);
        if (lArray[0] + 4L > this.nextSpace) {
            this.nextSpace = lArray[0] + 4L;
        }
        this.nextSpace = this.nextSpace + 3L & 0xFFFFFFFFFFFFFFFCL;
        this.stream.writeInt((int)this.nextSpace);
        this.stream.seek(this.nextSpace);
        this.write(null, iIOImage, imageWriteParam, false, bl2);
        this.stream.seek(this.nextIFDPointerPos);
        this.stream.writeInt((int)lArray2[0]);
    }

    private boolean isEncodingEmpty() {
        return this.isInsertingEmpty || this.isWritingEmpty;
    }

    public boolean canInsertEmpty(int n2) throws IOException {
        return this.canInsertImage(n2);
    }

    public boolean canWriteEmpty() throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        return true;
    }

    private void checkParamsEmpty(ImageTypeSpecifier imageTypeSpecifier, int n2, int n3, List list) {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        if (n2 < 1 || n3 < 1) {
            throw new IllegalArgumentException("width < 1 || height < 1!");
        }
        if (list != null) {
            int n4 = list.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                Object e2 = list.get(i2);
                if (e2 != null && e2 instanceof BufferedImage) continue;
                throw new IllegalArgumentException("thumbnails contains null references or objects other than BufferedImages!");
            }
        }
        if (this.isInsertingEmpty) {
            throw new IllegalStateException("Previous call to prepareInsertEmpty() without corresponding call to endInsertEmpty()!");
        }
        if (this.isWritingEmpty) {
            throw new IllegalStateException("Previous call to prepareWriteEmpty() without corresponding call to endWriteEmpty()!");
        }
    }

    public void prepareInsertEmpty(int n2, ImageTypeSpecifier imageTypeSpecifier, int n3, int n4, IIOMetadata iIOMetadata, List list, ImageWriteParam imageWriteParam) throws IOException {
        this.checkParamsEmpty(imageTypeSpecifier, n3, n4, list);
        this.isInsertingEmpty = true;
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        EmptyImage emptyImage = new EmptyImage(0, 0, n3, n4, 0, 0, sampleModel.getWidth(), sampleModel.getHeight(), sampleModel, imageTypeSpecifier.getColorModel());
        this.insert(n2, new IIOImage(emptyImage, null, iIOMetadata), imageWriteParam, false);
    }

    public void prepareWriteEmpty(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, int n2, int n3, IIOMetadata iIOMetadata2, List list, ImageWriteParam imageWriteParam) throws IOException {
        this.checkParamsEmpty(imageTypeSpecifier, n2, n3, list);
        this.isWritingEmpty = true;
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        EmptyImage emptyImage = new EmptyImage(0, 0, n2, n3, 0, 0, sampleModel.getWidth(), sampleModel.getHeight(), sampleModel, imageTypeSpecifier.getColorModel());
        this.write(iIOMetadata, new IIOImage(emptyImage, null, iIOMetadata2), imageWriteParam, true, false);
    }

    public void endInsertEmpty() throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        if (!this.isInsertingEmpty) {
            throw new IllegalStateException("No previous call to prepareInsertEmpty()!");
        }
        if (this.isWritingEmpty) {
            throw new IllegalStateException("Previous call to prepareWriteEmpty() without corresponding call to endWriteEmpty()!");
        }
        if (this.inReplacePixelsNest) {
            throw new IllegalStateException("In nested call to prepareReplacePixels!");
        }
        this.isInsertingEmpty = false;
    }

    public void endWriteEmpty() throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        if (!this.isWritingEmpty) {
            throw new IllegalStateException("No previous call to prepareWriteEmpty()!");
        }
        if (this.isInsertingEmpty) {
            throw new IllegalStateException("Previous call to prepareInsertEmpty() without corresponding call to endInsertEmpty()!");
        }
        if (this.inReplacePixelsNest) {
            throw new IllegalStateException("In nested call to prepareReplacePixels!");
        }
        this.isWritingEmpty = false;
    }

    private TIFFIFD readIFD(int n2) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("Output not set!");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("imageIndex < 0!");
        }
        this.stream.mark();
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        this.locateIFD(n2, lArray, lArray2);
        if (lArray2[0] == 0L) {
            this.stream.reset();
            throw new IndexOutOfBoundsException("imageIndex out of bounds!");
        }
        ArrayList<BaselineTIFFTagSet> arrayList = new ArrayList<BaselineTIFFTagSet>(1);
        arrayList.add(BaselineTIFFTagSet.getInstance());
        TIFFIFD tIFFIFD = new TIFFIFD(arrayList);
        tIFFIFD.initialize(this.stream, true);
        this.stream.reset();
        return tIFFIFD;
    }

    public boolean canReplacePixels(int n2) throws IOException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("getOutput() == null!");
        }
        TIFFIFD tIFFIFD = this.readIFD(n2);
        TIFFField tIFFField = tIFFIFD.getTIFFField(259);
        int n3 = tIFFField.getAsInt(0);
        return n3 == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareReplacePixels(int n2, Rectangle rectangle) throws IOException {
        Object object = this.replacePixelsLock;
        synchronized (object) {
            if (this.stream == null) {
                throw new IllegalStateException("Output not set!");
            }
            if (rectangle == null) {
                throw new IllegalArgumentException("region == null!");
            }
            if (rectangle.getWidth() < 1.0) {
                throw new IllegalArgumentException("region.getWidth() < 1!");
            }
            if (rectangle.getHeight() < 1.0) {
                throw new IllegalArgumentException("region.getHeight() < 1!");
            }
            if (this.inReplacePixelsNest) {
                throw new IllegalStateException("In nested call to prepareReplacePixels!");
            }
            TIFFIFD tIFFIFD = this.readIFD(n2);
            TIFFField tIFFField = tIFFIFD.getTIFFField(259);
            int n3 = tIFFField.getAsInt(0);
            if (n3 != 1) {
                throw new UnsupportedOperationException("canReplacePixels(imageIndex) == false!");
            }
            tIFFField = tIFFIFD.getTIFFField(256);
            if (tIFFField == null) {
                throw new IIOException("Cannot read ImageWidth field.");
            }
            int n4 = tIFFField.getAsInt(0);
            tIFFField = tIFFIFD.getTIFFField(257);
            if (tIFFField == null) {
                throw new IIOException("Cannot read ImageHeight field.");
            }
            int n5 = tIFFField.getAsInt(0);
            Rectangle rectangle2 = new Rectangle(0, 0, n4, n5);
            if ((rectangle = rectangle.intersection(rectangle2)).isEmpty()) {
                throw new IIOException("Region does not intersect image bounds");
            }
            this.replacePixelsRegion = rectangle;
            tIFFField = tIFFIFD.getTIFFField(324);
            if (tIFFField == null) {
                tIFFField = tIFFIFD.getTIFFField(273);
            }
            this.replacePixelsTileOffsets = tIFFField.getAsLongs();
            tIFFField = tIFFIFD.getTIFFField(325);
            if (tIFFField == null) {
                tIFFField = tIFFIFD.getTIFFField(279);
            }
            this.replacePixelsByteCounts = tIFFField.getAsLongs();
            this.replacePixelsOffsetsPosition = tIFFIFD.getStripOrTileOffsetsPosition();
            this.replacePixelsByteCountsPosition = tIFFIFD.getStripOrTileByteCountsPosition();
            this.replacePixelsMetadata = new TIFFImageMetadata(tIFFIFD);
            this.replacePixelsIndex = n2;
            this.inReplacePixelsNest = true;
        }
    }

    private Raster subsample(Raster raster, int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7, Rectangle rectangle) {
        int n8 = raster.getMinX();
        int n9 = raster.getMinY();
        int n10 = raster.getWidth();
        int n11 = raster.getHeight();
        int n12 = raster.getSampleModel().getNumBands();
        int n13 = raster.getSampleModel().getDataType();
        int n14 = TIFFImageWriter.XToTileX(n8, n2, n4) + n6;
        int n15 = TIFFImageWriter.YToTileY(n9, n3, n5) + n7;
        int n16 = TIFFImageWriter.XToTileX(n8 + n10 - 1, n2, n4) + n6;
        int n17 = TIFFImageWriter.YToTileY(n9 + n11 - 1, n3, n5) + n7;
        int n18 = n16 - n14 + 1;
        int n19 = n17 - n15 + 1;
        if (n18 <= 0 || n19 <= 0) {
            return null;
        }
        int n20 = (n14 - n6) * n4 + n2;
        int n21 = (n16 - n6) * n4 + n2;
        int n22 = n21 - n20 + 1;
        int n23 = (n15 - n7) * n5 + n3;
        int n24 = (n17 - n7) * n5 + n3;
        int n25 = n24 - n23 + 1;
        WritableRaster writableRaster = raster.createCompatibleWritableRaster(n14, n15, n18, n19);
        int n26 = n23 + n25;
        if (n13 == 4 || n13 == 5) {
            float[] fArray = new float[n22];
            float[] fArray2 = new float[n18];
            for (int i2 = 0; i2 < n12; ++i2) {
                int n27 = n15;
                for (int i3 = n23; i3 < n26; i3 += n5) {
                    raster.getSamples(n20, i3, n22, 1, i2, fArray);
                    int n28 = 0;
                    for (int i4 = 0; i4 < n22; i4 += n4) {
                        fArray2[n28++] = fArray[i4];
                    }
                    writableRaster.setSamples(n14, n27++, n18, 1, i2, fArray2);
                }
            }
        } else {
            int[] nArray2 = new int[n22];
            int[] nArray3 = new int[n18];
            for (int i5 = 0; i5 < n12; ++i5) {
                int n29 = n15;
                for (int i6 = n23; i6 < n26; i6 += n5) {
                    raster.getSamples(n20, i6, n22, 1, i5, nArray2);
                    int n30 = 0;
                    for (int i7 = 0; i7 < n22; i7 += n4) {
                        nArray3[n30++] = nArray2[i7];
                    }
                    writableRaster.setSamples(n14, n29++, n18, 1, i5, nArray3);
                }
            }
        }
        return writableRaster.createChild(n14, n15, rectangle.width, rectangle.height, rectangle.x, rectangle.y, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replacePixels(RenderedImage renderedImage, ImageWriteParam object) throws IOException {
        Object object2 = this.replacePixelsLock;
        synchronized (object2) {
            int n2;
            Object object3;
            if (this.stream == null) {
                throw new IllegalStateException("stream == null!");
            }
            if (renderedImage == null) {
                throw new IllegalArgumentException("image == null!");
            }
            if (!this.inReplacePixelsNest) {
                throw new IllegalStateException("No previous call to prepareReplacePixels!");
            }
            int n3 = 1;
            int n4 = 1;
            int n5 = 0;
            int n6 = 0;
            if (object == null) {
                object = this.getDefaultWriteParam();
            } else {
                object3 = this.getDefaultWriteParam();
                ((ImageWriteParam)object3).setCompressionMode(0);
                ((ImageWriteParam)object3).setTilingMode(3);
                ((IIOParam)object3).setDestinationOffset(((IIOParam)object).getDestinationOffset());
                ((IIOParam)object3).setSourceBands(((IIOParam)object).getSourceBands());
                ((IIOParam)object3).setSourceRegion(((IIOParam)object).getSourceRegion());
                n3 = ((IIOParam)object).getSourceXSubsampling();
                n4 = ((IIOParam)object).getSourceYSubsampling();
                n5 = ((IIOParam)object).getSubsamplingXOffset();
                n6 = ((IIOParam)object).getSubsamplingYOffset();
                object = object3;
            }
            object3 = this.replacePixelsMetadata.getTIFFField(258);
            if (object3 == null) {
                throw new IIOException("Cannot read destination BitsPerSample");
            }
            int[] nArray = ((TIFFField)object3).getAsInts();
            int[] nArray2 = renderedImage.getSampleModel().getSampleSize();
            int[] nArray3 = ((IIOParam)object).getSourceBands();
            if (nArray3 != null) {
                if (nArray3.length != nArray.length) {
                    throw new IIOException("Source and destination have different SamplesPerPixel");
                }
                for (n2 = 0; n2 < nArray3.length; ++n2) {
                    if (nArray[n2] == nArray2[nArray3[n2]]) continue;
                    throw new IIOException("Source and destination have different BitsPerSample");
                }
            } else {
                n2 = renderedImage.getSampleModel().getNumBands();
                if (n2 != nArray.length) {
                    throw new IIOException("Source and destination have different SamplesPerPixel");
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (nArray[i2] == nArray2[i2]) continue;
                    throw new IIOException("Source and destination have different BitsPerSample");
                }
            }
            Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            Rectangle rectangle2 = ((IIOParam)object).getSourceRegion();
            if (rectangle2 == null) {
                rectangle2 = rectangle;
            }
            int n7 = n3;
            int n8 = n4;
            int n9 = n5 + rectangle2.x;
            int n10 = n6 + rectangle2.y;
            if (!rectangle2.equals(rectangle) && (rectangle2 = rectangle2.intersection(rectangle)).isEmpty()) {
                throw new IllegalArgumentException("Source region does not intersect source image!");
            }
            Point point = ((IIOParam)object).getDestinationOffset();
            int n11 = TIFFImageWriter.XToTileX(rectangle2.x, n9, n7) + point.x;
            int n12 = TIFFImageWriter.YToTileY(rectangle2.y, n10, n8) + point.y;
            int n13 = TIFFImageWriter.XToTileX(rectangle2.x + rectangle2.width, n9, n7) + point.x;
            int n14 = TIFFImageWriter.YToTileY(rectangle2.y + rectangle2.height, n10, n8) + point.y;
            Rectangle rectangle3 = new Rectangle(point.x, point.y, n13 - n11, n14 - n12);
            if ((rectangle3 = rectangle3.intersection(this.replacePixelsRegion)).isEmpty()) {
                throw new IllegalArgumentException("Forward mapped source region does not intersect destination region!");
            }
            int n15 = (rectangle3.x - point.x) * n7 + n9;
            int n16 = (rectangle3.y - point.y) * n8 + n10;
            int n17 = (rectangle3.x + rectangle3.width - 1 - point.x) * n7 + n9;
            int n18 = n17 - n15 + 1;
            int n19 = (rectangle3.y + rectangle3.height - 1 - point.y) * n8 + n10;
            int n20 = n19 - n16 + 1;
            Rectangle rectangle4 = new Rectangle(n15, n16, n18, n20);
            if (rectangle4.intersection(rectangle).isEmpty()) {
                throw new IllegalArgumentException("Backward mapped destination region does not intersect source image!");
            }
            if (this.reader == null) {
                this.reader = new TIFFImageReader(new TIFFImageReaderSpi());
            } else {
                this.reader.reset();
            }
            this.stream.mark();
            try {
                this.stream.seek(this.headerPosition);
                this.reader.setInput(this.stream);
                this.imageMetadata = this.replacePixelsMetadata;
                this.param = object;
                SampleModel sampleModel = renderedImage.getSampleModel();
                ColorModel colorModel = renderedImage.getColorModel();
                this.numBands = sampleModel.getNumBands();
                this.imageType = new ImageTypeSpecifier(renderedImage);
                this.periodX = ((IIOParam)object).getSourceXSubsampling();
                this.periodY = ((IIOParam)object).getSourceYSubsampling();
                this.sourceBands = null;
                int[] nArray4 = ((IIOParam)object).getSourceBands();
                if (nArray4 != null) {
                    this.sourceBands = nArray4;
                    this.numBands = nArray3.length;
                }
                this.setupMetadata(colorModel, sampleModel, this.reader.getWidth(this.replacePixelsIndex), this.reader.getHeight(this.replacePixelsIndex));
                int[] nArray5 = sampleModel.getSampleSize();
                this.initializeScaleTables(nArray5);
                this.isBilevel = ImageUtil.isBinary(renderedImage.getSampleModel());
                this.isInverted = this.nativePhotometricInterpretation == 1 && this.photometricInterpretation == 0 || this.nativePhotometricInterpretation == 0 && this.photometricInterpretation == 1;
                this.isImageSimple = (this.isBilevel || !this.isInverted && ImageUtil.imageIsContiguous(renderedImage)) && !this.isRescaling && nArray3 == null && this.periodX == 1 && this.periodY == 1 && this.colorConverter == null;
                int n21 = TIFFImageWriter.XToTileX(rectangle3.x, 0, this.tileWidth);
                int n22 = TIFFImageWriter.YToTileY(rectangle3.y, 0, this.tileLength);
                int n23 = TIFFImageWriter.XToTileX(rectangle3.x + rectangle3.width - 1, 0, this.tileWidth);
                int n24 = TIFFImageWriter.YToTileY(rectangle3.y + rectangle3.height - 1, 0, this.tileLength);
                TIFFNullCompressor tIFFNullCompressor = new TIFFNullCompressor();
                tIFFNullCompressor.setWriter(this);
                tIFFNullCompressor.setStream(this.stream);
                tIFFNullCompressor.setMetadata(this.imageMetadata);
                Rectangle rectangle5 = new Rectangle();
                for (int i3 = n22; i3 <= n24; ++i3) {
                    for (int i4 = n21; i4 <= n23; ++i4) {
                        WritableRaster writableRaster;
                        Object object4;
                        boolean bl2;
                        int n25 = i3 * this.tilesAcross + i4;
                        boolean bl3 = bl2 = this.replacePixelsByteCounts[n25] == 0L;
                        if (bl2) {
                            object4 = sampleModel.createCompatibleSampleModel(this.tileWidth, this.tileLength);
                            writableRaster = Raster.createWritableRaster((SampleModel)object4, null);
                        } else {
                            object4 = this.reader.readTile(this.replacePixelsIndex, i4, i3);
                            writableRaster = ((BufferedImage)object4).getRaster();
                        }
                        rectangle5.setLocation(i4 * this.tileWidth, i3 * this.tileLength);
                        rectangle5.setSize(writableRaster.getWidth(), writableRaster.getHeight());
                        writableRaster = writableRaster.createWritableTranslatedChild(rectangle5.x, rectangle5.y);
                        object4 = rectangle5.intersection(rectangle3);
                        int n26 = (((Rectangle)object4).x - point.x) * n7 + n9;
                        int n27 = (((Rectangle)object4).x + ((Rectangle)object4).width - 1 - point.x) * n7 + n9;
                        int n28 = n27 - n26 + 1;
                        int n29 = (((Rectangle)object4).y - point.y) * n8 + n10;
                        int n30 = (((Rectangle)object4).y + ((Rectangle)object4).height - 1 - point.y) * n8 + n10;
                        int n31 = n30 - n29 + 1;
                        Rectangle rectangle6 = new Rectangle(n26, n29, n28, n31);
                        Raster raster = renderedImage.getData(rectangle6);
                        if (n7 == 1 && n8 == 1 && n9 == 0 && n10 == 0) {
                            raster = raster.createChild(rectangle6.x, rectangle6.y, rectangle6.width, rectangle6.height, ((Rectangle)object4).x, ((Rectangle)object4).y, nArray3);
                        } else if ((raster = this.subsample(raster, nArray3, n9, n10, n7, n8, point.x, point.y, (Rectangle)object4)) == null) continue;
                        writableRaster.setRect(raster);
                        if (bl2) {
                            this.stream.seek(this.nextSpace);
                        } else {
                            this.stream.seek(this.replacePixelsTileOffsets[n25]);
                        }
                        this.image = new SingleTileRenderedImage(writableRaster, colorModel);
                        int n32 = this.writeTile(rectangle5, tIFFNullCompressor);
                        if (!bl2) continue;
                        this.stream.mark();
                        this.stream.seek(this.replacePixelsOffsetsPosition + (long)(4 * n25));
                        this.stream.writeInt((int)this.nextSpace);
                        this.stream.seek(this.replacePixelsByteCountsPosition + (long)(4 * n25));
                        this.stream.writeInt(n32);
                        this.stream.reset();
                        this.nextSpace += (long)n32;
                    }
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                this.stream.reset();
            }
        }
    }

    public void replacePixels(Raster raster, ImageWriteParam imageWriteParam) throws IOException {
        if (raster == null) {
            throw new IllegalArgumentException("raster == null!");
        }
        this.replacePixels(new SingleTileRenderedImage(raster, this.image.getColorModel()), imageWriteParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endReplacePixels() throws IOException {
        Object object = this.replacePixelsLock;
        synchronized (object) {
            if (!this.inReplacePixelsNest) {
                throw new IllegalStateException("No previous call to prepareReplacePixels()!");
            }
            this.replacePixelsIndex = -1;
            this.replacePixelsMetadata = null;
            this.replacePixelsTileOffsets = null;
            this.replacePixelsByteCounts = null;
            this.replacePixelsOffsetsPosition = 0L;
            this.replacePixelsByteCountsPosition = 0L;
            this.replacePixelsRegion = null;
            this.inReplacePixelsNest = false;
        }
    }

    public void reset() {
        super.reset();
        this.stream = null;
        this.image = null;
        this.imageType = null;
        this.byteOrder = null;
        this.param = null;
        this.compressor = null;
        this.colorConverter = null;
        this.streamMetadata = null;
        this.imageMetadata = null;
        this.isWritingSequence = false;
        this.isWritingEmpty = false;
        this.isInsertingEmpty = false;
        this.replacePixelsIndex = -1;
        this.replacePixelsMetadata = null;
        this.replacePixelsTileOffsets = null;
        this.replacePixelsByteCounts = null;
        this.replacePixelsOffsetsPosition = 0L;
        this.replacePixelsByteCountsPosition = 0L;
        this.replacePixelsRegion = null;
        this.inReplacePixelsNest = false;
    }

    public void dispose() {
        this.reset();
        super.dispose();
    }
}

