/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import com.sun.media.imageioimpl.common.LZWCompressor;
import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;

public class TIFFLZWCompressor
extends TIFFCompressor {
    int predictor;

    public TIFFLZWCompressor(int n2) {
        super("LZW", 5, true);
        this.predictor = n2;
    }

    public void setStream(ImageOutputStream imageOutputStream) {
        super.setStream(imageOutputStream);
    }

    public int encode(byte[] byArray, int n2, int n3, int n4, int[] nArray, int n5) throws IOException {
        boolean bl2;
        int n6;
        LZWCompressor lZWCompressor = new LZWCompressor(this.stream, 8, true);
        int n7 = nArray.length;
        int n8 = 0;
        for (n6 = 0; n6 < n7; ++n6) {
            n8 += nArray[n6];
        }
        n6 = (n8 * n3 + 7) / 8;
        long l2 = this.stream.getStreamPosition();
        boolean bl3 = bl2 = this.predictor == 2;
        if (n6 == n5 && !bl2) {
            lZWCompressor.compress(byArray, n2, n6 * n4);
        } else {
            byte[] byArray2 = bl2 ? new byte[n6] : null;
            for (int i2 = 0; i2 < n4; ++i2) {
                if (bl2) {
                    System.arraycopy(byArray, n2, byArray2, 0, n6);
                    for (int i3 = n6 - 1; i3 >= n7; --i3) {
                        int n9 = i3;
                        byArray2[n9] = (byte)(byArray2[n9] - byArray2[i3 - n7]);
                    }
                    lZWCompressor.compress(byArray2, 0, n6);
                } else {
                    lZWCompressor.compress(byArray, n2, n6);
                }
                n2 += n5;
            }
        }
        lZWCompressor.flush();
        int n10 = (int)(this.stream.getStreamPosition() - l2);
        return n10;
    }
}

