/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import java.io.IOException;
import javax.imageio.IIOException;

public class TIFFLZWDecompressor
extends TIFFDecompressor {
    private static final boolean DEBUG = false;
    private static final int[] andTable = new int[]{511, 1023, 2047, 4095};
    int predictor;
    byte[] srcData;
    byte[] dstData;
    int srcIndex;
    int dstIndex;
    byte[][] stringTable;
    int tableIndex;
    int bitsToGet = 9;
    int nextData = 0;
    int nextBits = 0;

    public TIFFLZWDecompressor(int n2) throws IIOException {
        if (n2 != 1 && n2 != 2) {
            throw new IIOException("Illegal value for Predictor in TIFF file");
        }
        this.predictor = n2;
    }

    public void decodeRaw(byte[] byArray, int n2, int n3, int n4) throws IOException {
        int n5;
        byte[] byArray2;
        int n6;
        if (this.predictor == 2) {
            int n7 = this.bitsPerSample.length;
            for (n6 = 0; n6 < n7; ++n6) {
                if (this.bitsPerSample[n6] == 8) continue;
                throw new IIOException(this.bitsPerSample[n6] + "-bit samples " + "are not supported for Horizontal " + "differencing Predictor");
            }
        }
        this.stream.seek(this.offset);
        byte[] byArray3 = new byte[this.byteCount];
        this.stream.readFully(byArray3);
        n6 = (this.srcWidth * n3 + 7) / 8;
        if (n6 == n4) {
            byArray2 = byArray;
            n5 = n2;
        } else {
            byArray2 = new byte[n6 * this.srcHeight];
            n5 = 0;
        }
        int n8 = this.decode(byArray3, 0, byArray2, n5);
        if (n6 != n4) {
            int n9 = 0;
            for (int i2 = 0; i2 < this.srcHeight; ++i2) {
                System.arraycopy(byArray2, n9, byArray, n2, n6);
                n9 += n6;
                n2 += n4;
            }
        }
    }

    public int decode(byte[] byArray, int n2, byte[] byArray2, int n3) throws IOException {
        int n4;
        if (byArray[0] == 0 && byArray[1] == 1) {
            throw new IIOException("TIFF 5.0-style LZW compression is not supported!");
        }
        this.srcData = byArray;
        this.dstData = byArray2;
        this.srcIndex = n2;
        this.dstIndex = n3;
        this.nextData = 0;
        this.nextBits = 0;
        this.initializeStringTable();
        int n5 = 0;
        while ((n4 = this.getNextCode()) != 257) {
            byte[] byArray3;
            if (n4 == 256) {
                this.initializeStringTable();
                n4 = this.getNextCode();
                if (n4 == 257) break;
                this.writeString(this.stringTable[n4]);
                n5 = n4;
                continue;
            }
            if (n4 < this.tableIndex) {
                byArray3 = this.stringTable[n4];
                this.writeString(byArray3);
                this.addStringToTable(this.stringTable[n5], byArray3[0]);
                n5 = n4;
                continue;
            }
            byArray3 = this.stringTable[n5];
            byArray3 = this.composeString(byArray3, byArray3[0]);
            this.writeString(byArray3);
            this.addStringToTable(byArray3);
            n5 = n4;
        }
        if (this.predictor == 2) {
            for (int i2 = 0; i2 < this.srcHeight; ++i2) {
                int n6 = n3 + this.samplesPerPixel * (i2 * this.srcWidth + 1);
                for (int i3 = this.samplesPerPixel; i3 < this.srcWidth * this.samplesPerPixel; ++i3) {
                    int n7 = n6;
                    this.dstData[n7] = (byte)(this.dstData[n7] + this.dstData[n6 - this.samplesPerPixel]);
                    ++n6;
                }
            }
        }
        return this.dstIndex - n3;
    }

    public void initializeStringTable() {
        this.stringTable = new byte[4096][];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.stringTable[i2] = new byte[1];
            this.stringTable[i2][0] = (byte)i2;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    public void writeString(byte[] byArray) {
        if (this.dstIndex < this.dstData.length) {
            int n2 = Math.min(byArray.length, this.dstData.length - this.dstIndex);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.dstData[this.dstIndex++] = byArray[i2];
            }
        }
    }

    public void addStringToTable(byte[] byArray, byte by2) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = by2;
        this.stringTable[this.tableIndex++] = byArray2;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public void addStringToTable(byte[] byArray) {
        this.stringTable[this.tableIndex++] = byArray;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public byte[] composeString(byte[] byArray, byte by2) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = by2;
        return byArray2;
    }

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.srcData[this.srcIndex++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.srcData[this.srcIndex++] & 0xFF;
                this.nextBits += 8;
            }
            int n2 = this.nextData >> this.nextBits - this.bitsToGet & andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 257;
        }
    }
}

