/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import java.io.IOException;
import javax.imageio.IIOException;

public class TIFFLZWUtil {
    private static final boolean debug = false;
    byte[] srcData;
    int srcIndex;
    byte[] dstData;
    int dstIndex = 0;
    byte[][] stringTable;
    int tableIndex;
    int bitsToGet = 9;
    int predictor;
    int samplesPerPixel;
    int nextData = 0;
    int nextBits = 0;
    private static final int[] andTable = new int[]{511, 1023, 2047, 4095};

    public byte[] decode(byte[] byArray, int n2, int n3, int n4, int n5) throws IOException {
        int n6;
        if (byArray[0] == 0 && byArray[1] == 1) {
            throw new IIOException("TIFF 5.0-style LZW compression is not supported!");
        }
        this.srcData = byArray;
        this.srcIndex = 0;
        this.nextData = 0;
        this.nextBits = 0;
        this.dstData = new byte[8192];
        this.dstIndex = 0;
        this.initializeStringTable();
        int n7 = 0;
        while ((n6 = this.getNextCode()) != 257) {
            byte[] byArray2;
            if (n6 == 256) {
                this.initializeStringTable();
                n6 = this.getNextCode();
                if (n6 == 257) break;
                this.writeString(this.stringTable[n6]);
                n7 = n6;
                continue;
            }
            if (n6 < this.tableIndex) {
                byArray2 = this.stringTable[n6];
                this.writeString(byArray2);
                this.addStringToTable(this.stringTable[n7], byArray2[0]);
                n7 = n6;
                continue;
            }
            byArray2 = this.stringTable[n7];
            byArray2 = this.composeString(byArray2, byArray2[0]);
            this.writeString(byArray2);
            this.addStringToTable(byArray2);
            n7 = n6;
        }
        if (n2 == 2) {
            for (int i2 = 0; i2 < n5; ++i2) {
                int n8 = n3 * (i2 * n4 + 1);
                for (int i3 = n3; i3 < n4 * n3; ++i3) {
                    int n9 = n8;
                    this.dstData[n9] = (byte)(this.dstData[n9] + this.dstData[n8 - n3]);
                    ++n8;
                }
            }
        }
        byte[] byArray3 = new byte[this.dstIndex];
        System.arraycopy(this.dstData, 0, byArray3, 0, this.dstIndex);
        return byArray3;
    }

    public void initializeStringTable() {
        this.stringTable = new byte[4096][];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.stringTable[i2] = new byte[1];
            this.stringTable[i2][0] = (byte)i2;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    private void ensureCapacity(int n2) {
        if (this.dstIndex + n2 > this.dstData.length) {
            byte[] byArray = new byte[Math.max((int)((float)this.dstData.length * 1.2f), this.dstIndex + n2)];
            System.arraycopy(this.dstData, 0, byArray, 0, this.dstData.length);
            this.dstData = byArray;
        }
    }

    public void writeString(byte[] byArray) {
        this.ensureCapacity(byArray.length);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.dstData[this.dstIndex++] = byArray[i2];
        }
    }

    public void addStringToTable(byte[] byArray, byte by2) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = by2;
        this.stringTable[this.tableIndex++] = byArray2;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public void addStringToTable(byte[] byArray) {
        this.stringTable[this.tableIndex++] = byArray;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public byte[] composeString(byte[] byArray, byte by2) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = by2;
        return byArray2;
    }

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.srcData[this.srcIndex++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.srcData[this.srcIndex++] & 0xFF;
                this.nextBits += 8;
            }
            int n2 = this.nextData >> this.nextBits - this.bitsToGet & andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 257;
        }
    }
}

