/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import java.io.IOException;

public class TIFFNullDecompressor
extends TIFFDecompressor {
    private static final boolean DEBUG = false;
    private boolean isReadActiveOnly = false;
    private int originalSrcMinX;
    private int originalSrcMinY;
    private int originalSrcWidth;
    private int originalSrcHeight;

    public void beginDecoding() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.bitsPerSample.length; ++i2) {
            n2 += this.bitsPerSample[i2];
        }
        if ((this.activeSrcMinX != this.srcMinX || this.activeSrcMinY != this.srcMinY || this.activeSrcWidth != this.srcWidth || this.activeSrcHeight != this.srcHeight) && (this.activeSrcMinX - this.srcMinX) * n2 % 8 == 0) {
            this.isReadActiveOnly = true;
            this.originalSrcMinX = this.srcMinX;
            this.originalSrcMinY = this.srcMinY;
            this.originalSrcWidth = this.srcWidth;
            this.originalSrcHeight = this.srcHeight;
            this.srcMinX = this.activeSrcMinX;
            this.srcMinY = this.activeSrcMinY;
            this.srcWidth = this.activeSrcWidth;
            this.srcHeight = this.activeSrcHeight;
        } else {
            this.isReadActiveOnly = false;
        }
        super.beginDecoding();
    }

    public void decode() throws IOException {
        super.decode();
        if (this.isReadActiveOnly) {
            this.srcMinX = this.originalSrcMinX;
            this.srcMinY = this.originalSrcMinY;
            this.srcWidth = this.originalSrcWidth;
            this.srcHeight = this.originalSrcHeight;
            this.isReadActiveOnly = false;
        }
    }

    public void decodeRaw(byte[] byArray, int n2, int n3, int n4) throws IOException {
        if (this.isReadActiveOnly) {
            int n5 = (this.activeSrcWidth * n3 + 7) / 8;
            int n6 = (this.originalSrcWidth * n3 + 7) / 8;
            int n7 = n6 - n5;
            this.stream.seek(this.offset + (long)((this.activeSrcMinY - this.originalSrcMinY) * n6) + (long)((this.activeSrcMinX - this.originalSrcMinX) * n3 / 8));
            int n8 = this.activeSrcHeight - 1;
            for (int i2 = 0; i2 < this.activeSrcHeight; ++i2) {
                this.stream.read(byArray, n2, n5);
                n2 += n4;
                if (i2 == n8) continue;
                this.stream.skipBytes(n7);
            }
        } else {
            this.stream.seek(this.offset);
            int n9 = (this.srcWidth * n3 + 7) / 8;
            if (n9 == n4) {
                this.stream.read(byArray, n2, n9 * this.srcHeight);
            } else {
                for (int i3 = 0; i3 < this.srcHeight; ++i3) {
                    this.stream.read(byArray, n2, n9);
                    n2 += n4;
                }
            }
        }
    }
}

