/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFJPEGDecompressor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class TIFFOldJPEGDecompressor
extends TIFFJPEGDecompressor {
    private static final boolean DEBUG = false;
    private static final int DHT = 196;
    private static final int DQT = 219;
    private static final int DRI = 221;
    private static final int SOF0 = 192;
    private static final int SOS = 218;
    private boolean isInitialized = false;
    private Long JPEGStreamOffset = null;
    private int SOFPosition = -1;
    private byte[] SOSMarker = null;
    private int subsamplingX = 2;
    private int subsamplingY = 2;

    private synchronized void initialize() throws IOException {
        int n2;
        TIFFField tIFFField;
        long[] lArray;
        boolean bl2;
        if (this.isInitialized) {
            return;
        }
        TIFFImageMetadata tIFFImageMetadata = (TIFFImageMetadata)this.metadata;
        TIFFField tIFFField2 = tIFFImageMetadata.getTIFFField(513);
        TIFFField tIFFField3 = tIFFImageMetadata.getTIFFField(324);
        if (tIFFField3 == null && (tIFFField3 = tIFFImageMetadata.getTIFFField(273)) == null) {
            tIFFField3 = tIFFField2;
        }
        boolean bl3 = bl2 = (lArray = tIFFField3.getAsLongs()).length > 1;
        if (!bl2) {
            this.stream.seek(this.offset);
            this.stream.mark();
            if (this.stream.read() == 255 && this.stream.read() == 216) {
                this.JPEGStreamOffset = new Long(this.offset);
                ((TIFFImageReader)this.reader).forwardWarningMessage("SOI marker detected at start of strip or tile.");
                this.isInitialized = true;
                this.stream.reset();
                return;
            }
            this.stream.reset();
            if (tIFFField2 != null) {
                long l2 = tIFFField2.getAsLong(0);
                this.stream.mark();
                this.stream.seek(l2);
                if (this.stream.read() == 255 && this.stream.read() == 216) {
                    this.JPEGStreamOffset = new Long(l2);
                } else {
                    ((TIFFImageReader)this.reader).forwardWarningMessage("JPEGInterchangeFormat does not point to SOI");
                }
                this.stream.reset();
                TIFFField tIFFField4 = tIFFImageMetadata.getTIFFField(514);
                if (tIFFField4 == null) {
                    ((TIFFImageReader)this.reader).forwardWarningMessage("JPEGInterchangeFormatLength field is missing");
                } else {
                    long l3 = tIFFField4.getAsLong(0);
                    if (l2 >= lArray[0] || l2 + l3 <= lArray[0]) {
                        ((TIFFImageReader)this.reader).forwardWarningMessage("JPEGInterchangeFormatLength field value is invalid");
                    }
                }
                if (this.JPEGStreamOffset != null) {
                    this.isInitialized = true;
                    return;
                }
            }
        }
        if ((tIFFField = tIFFImageMetadata.getTIFFField(530)) != null) {
            this.subsamplingX = tIFFField.getAsChars()[0];
            this.subsamplingY = tIFFField.getAsChars()[1];
        }
        if (tIFFField2 != null) {
            long l4 = tIFFField2.getAsLong(0);
            TIFFField tIFFField5 = tIFFImageMetadata.getTIFFField(514);
            if (tIFFField5 != null) {
                long l5 = tIFFField5.getAsLong(0);
                if (l5 >= 2L && l4 + l5 <= lArray[0]) {
                    this.stream.mark();
                    this.stream.seek(l4 + l5 - 2L);
                    this.tables = this.stream.read() == 255 && this.stream.read() == 217 ? new byte[(int)(l5 - 2L)] : new byte[(int)l5];
                    this.stream.reset();
                    this.stream.mark();
                    this.stream.seek(l4);
                    this.stream.readFully(this.tables);
                    this.stream.reset();
                    ((TIFFImageReader)this.reader).forwardWarningMessage("Incorrect JPEG interchange format: using JPEGInterchangeFormat offset to derive tables.");
                } else {
                    ((TIFFImageReader)this.reader).forwardWarningMessage("JPEGInterchangeFormat+JPEGInterchangeFormatLength > offset to first strip or tile.");
                }
            }
        }
        if (this.tables == null) {
            Object object;
            int n3;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            long l6 = this.stream.length();
            byteArrayOutputStream.write(255);
            byteArrayOutputStream.write(216);
            TIFFField tIFFField6 = tIFFImageMetadata.getTIFFField(519);
            if (tIFFField6 == null) {
                throw new IIOException("JPEGQTables field missing!");
            }
            long[] lArray2 = tIFFField6.getAsLongs();
            for (n2 = 0; n2 < lArray2.length; ++n2) {
                byteArrayOutputStream.write(255);
                byteArrayOutputStream.write(219);
                n3 = 67;
                byteArrayOutputStream.write(n3 >>> 8 & 0xFF);
                byteArrayOutputStream.write(n3 & 0xFF);
                byteArrayOutputStream.write(n2);
                object = new byte[64];
                if (l6 != -1L && lArray2[n2] > l6) {
                    throw new IIOException("JPEGQTables offset for index " + n2 + " is not in the stream!");
                }
                this.stream.seek(lArray2[n2]);
                this.stream.readFully((byte[])object);
                byteArrayOutputStream.write((byte[])object);
            }
            for (n2 = 0; n2 < 2; ++n2) {
                n3 = n2 == 0 ? 520 : 521;
                tIFFField6 = tIFFImageMetadata.getTIFFField(n3);
                Object object2 = object = n3 == 520 ? "JPEGDCTables" : "JPEGACTables";
                if (tIFFField6 == null) {
                    throw new IIOException((String)object + " field missing!");
                }
                lArray2 = tIFFField6.getAsLongs();
                for (int i2 = 0; i2 < lArray2.length; ++i2) {
                    int n4;
                    byteArrayOutputStream.write(255);
                    byteArrayOutputStream.write(196);
                    byte[] byArray = new byte[16];
                    if (l6 != -1L && lArray2[i2] > l6) {
                        throw new IIOException((String)object + " offset for index " + i2 + " is not in the stream!");
                    }
                    this.stream.seek(lArray2[i2]);
                    this.stream.readFully(byArray);
                    int n5 = 0;
                    for (n4 = 0; n4 < 16; ++n4) {
                        n5 += byArray[n4] & 0xFF;
                    }
                    n4 = (char)(19 + n5);
                    byteArrayOutputStream.write(n4 >>> 8 & 0xFF);
                    byteArrayOutputStream.write(n4 & 0xFF);
                    byteArrayOutputStream.write(i2 | n2 << 4);
                    byteArrayOutputStream.write(byArray);
                    byte[] byArray2 = new byte[n5];
                    this.stream.readFully(byArray2);
                    byteArrayOutputStream.write(byArray2);
                }
            }
            byteArrayOutputStream.write(-1);
            byteArrayOutputStream.write(-64);
            n2 = (short)(8 + 3 * this.samplesPerPixel);
            byteArrayOutputStream.write((byte)(n2 >>> 8 & 0xFF));
            byteArrayOutputStream.write((byte)(n2 & 0xFF));
            byteArrayOutputStream.write(8);
            n2 = (short)this.srcHeight;
            byteArrayOutputStream.write((byte)(n2 >>> 8 & 0xFF));
            byteArrayOutputStream.write((byte)(n2 & 0xFF));
            n2 = (short)this.srcWidth;
            byteArrayOutputStream.write((byte)(n2 >>> 8 & 0xFF));
            byteArrayOutputStream.write((byte)(n2 & 0xFF));
            byteArrayOutputStream.write((byte)this.samplesPerPixel);
            if (this.samplesPerPixel == 1) {
                byteArrayOutputStream.write(1);
                byteArrayOutputStream.write(17);
                byteArrayOutputStream.write(0);
            } else {
                for (n3 = 0; n3 < 3; ++n3) {
                    byteArrayOutputStream.write((byte)(n3 + 1));
                    byteArrayOutputStream.write((byte)(n3 != 0 ? 17 : (byte)((this.subsamplingX & 0xF) << 4 | this.subsamplingY & 0xF)));
                    byteArrayOutputStream.write((byte)n3);
                }
            }
            tIFFField6 = tIFFImageMetadata.getTIFFField(515);
            if (tIFFField6 != null && (n3 = tIFFField6.getAsChars()[0]) != 0) {
                byteArrayOutputStream.write(-1);
                byteArrayOutputStream.write(-35);
                n2 = 4;
                byteArrayOutputStream.write((byte)(n2 >>> 8 & 0xFF));
                byteArrayOutputStream.write((byte)(n2 & 0xFF));
                byteArrayOutputStream.write((byte)(n3 >>> 8 & 0xFF));
                byteArrayOutputStream.write((byte)(n3 & 0xFF));
            }
            this.tables = byteArrayOutputStream.toByteArray();
        }
        int n6 = this.tables.length - 1;
        for (int i3 = 0; i3 < n6; ++i3) {
            if ((this.tables[i3] & 0xFF) != 255 || (this.tables[i3 + 1] & 0xFF) != 192) continue;
            this.SOFPosition = i3;
            break;
        }
        if (this.SOFPosition == -1) {
            byte[] byArray = new byte[this.tables.length + 10 + 3 * this.samplesPerPixel];
            System.arraycopy(this.tables, 0, byArray, 0, this.tables.length);
            int n7 = this.tables.length;
            this.SOFPosition = this.tables.length;
            this.tables = byArray;
            this.tables[n7++] = -1;
            this.tables[n7++] = -64;
            short s2 = (short)(8 + 3 * this.samplesPerPixel);
            this.tables[n7++] = (byte)(s2 >>> 8 & 0xFF);
            this.tables[n7++] = (byte)(s2 & 0xFF);
            this.tables[n7++] = 8;
            s2 = (short)this.srcHeight;
            this.tables[n7++] = (byte)(s2 >>> 8 & 0xFF);
            this.tables[n7++] = (byte)(s2 & 0xFF);
            s2 = (short)this.srcWidth;
            this.tables[n7++] = (byte)(s2 >>> 8 & 0xFF);
            this.tables[n7++] = (byte)(s2 & 0xFF);
            this.tables[n7++] = (byte)this.samplesPerPixel;
            if (this.samplesPerPixel == 1) {
                this.tables[n7++] = 1;
                this.tables[n7++] = 17;
                this.tables[n7++] = 0;
            } else {
                for (n2 = 0; n2 < 3; ++n2) {
                    this.tables[n7++] = (byte)(n2 + 1);
                    this.tables[n7++] = (byte)(n2 != 0 ? 17 : (byte)((this.subsamplingX & 0xF) << 4 | this.subsamplingY & 0xF));
                    this.tables[n7++] = (byte)n2;
                }
            }
        }
        this.stream.mark();
        this.stream.seek(lArray[0]);
        if (this.stream.read() == 255 && this.stream.read() == 218) {
            int n8 = this.stream.read() << 8 | this.stream.read();
            this.SOSMarker = new byte[n8 + 2];
            this.SOSMarker[0] = -1;
            this.SOSMarker[1] = -38;
            this.SOSMarker[2] = (byte)((n8 & 0xFF00) >> 8);
            this.SOSMarker[3] = (byte)(n8 & 0xFF);
            this.stream.readFully(this.SOSMarker, 4, n8 - 2);
        } else {
            this.SOSMarker = new byte[8 + 2 * this.samplesPerPixel];
            int n9 = 0;
            this.SOSMarker[n9++] = -1;
            this.SOSMarker[n9++] = -38;
            short s3 = (short)(6 + 2 * this.samplesPerPixel);
            this.SOSMarker[n9++] = (byte)(s3 >>> 8 & 0xFF);
            this.SOSMarker[n9++] = (byte)(s3 & 0xFF);
            this.SOSMarker[n9++] = (byte)this.samplesPerPixel;
            if (this.samplesPerPixel == 1) {
                this.SOSMarker[n9++] = 1;
                this.SOSMarker[n9++] = 0;
            } else {
                for (int i4 = 0; i4 < 3; ++i4) {
                    this.SOSMarker[n9++] = (byte)(i4 + 1);
                    this.SOSMarker[n9++] = (byte)(i4 << 4 | i4);
                }
            }
            this.SOSMarker[n9++] = 0;
            this.SOSMarker[n9++] = 63;
            this.SOSMarker[n9++] = 0;
        }
        this.stream.reset();
        this.isInitialized = true;
    }

    public void decodeRaw(byte[] byArray, int n2, int n3, int n4) throws IOException {
        this.initialize();
        TIFFImageMetadata tIFFImageMetadata = (TIFFImageMetadata)this.metadata;
        if (this.JPEGStreamOffset != null) {
            this.stream.seek(this.JPEGStreamOffset);
            this.JPEGReader.setInput(this.stream, false, true);
        } else {
            int n5 = this.tables.length;
            int n6 = n5 + this.SOSMarker.length + this.byteCount + 2;
            byte[] byArray2 = new byte[n6];
            if (this.tables != null) {
                System.arraycopy(this.tables, 0, byArray2, 0, n5);
            }
            int n7 = n5;
            short s2 = (short)this.srcHeight;
            byArray2[this.SOFPosition + 5] = (byte)(s2 >>> 8 & 0xFF);
            byArray2[this.SOFPosition + 6] = (byte)(s2 & 0xFF);
            s2 = (short)this.srcWidth;
            byArray2[this.SOFPosition + 7] = (byte)(s2 >>> 8 & 0xFF);
            byArray2[this.SOFPosition + 8] = (byte)(s2 & 0xFF);
            this.stream.seek(this.offset);
            byte[] byArray3 = new byte[2];
            this.stream.readFully(byArray3);
            if ((byArray3[0] & 0xFF) != 255 || (byArray3[1] & 0xFF) != 218) {
                System.arraycopy(this.SOSMarker, 0, byArray2, n7, this.SOSMarker.length);
                n7 += this.SOSMarker.length;
            }
            byArray2[n7++] = byArray3[0];
            byArray2[n7++] = byArray3[1];
            this.stream.readFully(byArray2, n7, this.byteCount - 2);
            n7 += this.byteCount - 2;
            byArray2[n7++] = -1;
            byArray2[n7++] = -39;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2, 0, n7);
            MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(byteArrayInputStream);
            this.JPEGReader.setInput(memoryCacheImageInputStream, true, true);
        }
        this.JPEGParam.setDestination(this.rawImage);
        this.JPEGReader.read(0, this.JPEGParam);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.JPEGReader.dispose();
    }
}

