/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxDecompressor;
import java.io.IOException;
import javax.imageio.IIOException;

public class TIFFRLECompressor
extends TIFFFaxCompressor {
    public TIFFRLECompressor() {
        super("CCITT RLE", 2, true);
    }

    public int encodeRLE(byte[] byArray, int n2, int n3, int n4, byte[] byArray2) {
        this.initBitBuf();
        int n5 = this.encode1D(byArray, n2, n3, n4, byArray2, 0);
        while (this.ndex > 0) {
            byArray2[n5++] = (byte)(this.bits >>> 24);
            this.bits <<= 8;
            this.ndex -= 8;
        }
        if (this.inverseFill) {
            byte[] byArray3 = TIFFFaxDecompressor.flipTable;
            for (int i2 = 0; i2 < n5; ++i2) {
                byArray2[i2] = byArray3[byArray2[i2] & 0xFF];
            }
        }
        return n5;
    }

    public int encode(byte[] byArray, int n2, int n3, int n4, int[] nArray, int n5) throws IOException {
        if (nArray.length != 1 || nArray[0] != 1) {
            throw new IIOException("Bits per sample must be 1 for RLE compression!");
        }
        int n6 = 9 * ((n3 + 1) / 2) + 2;
        byte[] byArray2 = new byte[(n6 + 7) / 8];
        int n7 = 0;
        int n8 = n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n9 = this.encodeRLE(byArray, n8, 0, n3, byArray2);
            this.stream.write(byArray2, 0, n9);
            n8 += n5;
            n7 += n9;
        }
        return n7;
    }
}

