/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFImageReadParam;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;

public class TIFFRenderedImage
implements RenderedImage {
    TIFFImageReader reader;
    int imageIndex;
    ImageReadParam tileParam;
    int subsampleX;
    int subsampleY;
    boolean isSubsampling;
    int width;
    int height;
    int tileWidth;
    int tileHeight;
    ImageTypeSpecifier its;

    public TIFFRenderedImage(TIFFImageReader tIFFImageReader, int n2, ImageReadParam imageReadParam, int n3, int n4) throws IOException {
        this.reader = tIFFImageReader;
        this.imageIndex = n2;
        this.tileParam = this.cloneImageReadParam(imageReadParam, false);
        this.subsampleX = this.tileParam.getSourceXSubsampling();
        this.subsampleY = this.tileParam.getSourceYSubsampling();
        this.isSubsampling = this.subsampleX != 1 || this.subsampleY != 1;
        this.width = n3 / this.subsampleX;
        this.height = n4 / this.subsampleY;
        this.tileWidth = tIFFImageReader.getTileWidth(n2) / this.subsampleX;
        this.tileHeight = tIFFImageReader.getTileHeight(n2) / this.subsampleY;
        Iterator iterator = tIFFImageReader.getImageTypes(n2);
        this.its = (ImageTypeSpecifier)iterator.next();
        this.tileParam.setDestinationType(this.its);
    }

    private ImageReadParam cloneImageReadParam(ImageReadParam imageReadParam, boolean bl2) {
        TIFFImageReadParam tIFFImageReadParam = new TIFFImageReadParam();
        tIFFImageReadParam.setSourceSubsampling(imageReadParam.getSourceXSubsampling(), imageReadParam.getSourceYSubsampling(), imageReadParam.getSubsamplingXOffset(), imageReadParam.getSubsamplingYOffset());
        tIFFImageReadParam.setSourceBands(imageReadParam.getSourceBands());
        tIFFImageReadParam.setDestinationBands(imageReadParam.getDestinationBands());
        tIFFImageReadParam.setDestinationOffset(imageReadParam.getDestinationOffset());
        if (imageReadParam instanceof TIFFImageReadParam) {
            Iterator iterator;
            List list;
            TIFFImageReadParam tIFFImageReadParam2 = (TIFFImageReadParam)imageReadParam;
            tIFFImageReadParam.setTIFFDecompressor(tIFFImageReadParam2.getTIFFDecompressor());
            tIFFImageReadParam.setColorConverter(tIFFImageReadParam2.getColorConverter());
            if (bl2 && (list = tIFFImageReadParam2.getAllowedTagSets()) != null && (iterator = list.iterator()) != null) {
                while (iterator.hasNext()) {
                    TIFFTagSet tIFFTagSet = (TIFFTagSet)iterator.next();
                    tIFFImageReadParam.addAllowedTagSet(tIFFTagSet);
                }
            }
        } else {
            tIFFImageReadParam.setTIFFDecompressor(null);
            tIFFImageReadParam.setColorConverter(null);
        }
        return tIFFImageReadParam;
    }

    public Vector getSources() {
        return null;
    }

    public Object getProperty(String string) {
        return Image.UndefinedProperty;
    }

    public String[] getPropertyNames() {
        return null;
    }

    public ColorModel getColorModel() {
        return this.its.getColorModel();
    }

    public SampleModel getSampleModel() {
        return this.its.getSampleModel();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMinX() {
        return 0;
    }

    public int getMinY() {
        return 0;
    }

    public int getNumXTiles() {
        return (this.width + this.tileWidth - 1) / this.tileWidth;
    }

    public int getNumYTiles() {
        return (this.height + this.tileHeight - 1) / this.tileHeight;
    }

    public int getMinTileX() {
        return 0;
    }

    public int getMinTileY() {
        return 0;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileGridXOffset() {
        return 0;
    }

    public int getTileGridYOffset() {
        return 0;
    }

    public Raster getTile(int n2, int n3) {
        Rectangle rectangle = new Rectangle(n2 * this.tileWidth, n3 * this.tileHeight, this.tileWidth, this.tileHeight);
        return this.getData(rectangle);
    }

    public Raster getData() {
        return this.read(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public Raster getData(Rectangle rectangle) {
        return this.read(rectangle);
    }

    public synchronized WritableRaster read(Rectangle rectangle) {
        this.tileParam.setSourceRegion(this.isSubsampling ? new Rectangle(this.subsampleX * rectangle.x, this.subsampleY * rectangle.y, this.subsampleX * rectangle.width, this.subsampleY * rectangle.height) : rectangle);
        try {
            BufferedImage bufferedImage = this.reader.read(this.imageIndex, this.tileParam);
            WritableRaster writableRaster = bufferedImage.getRaster();
            return writableRaster.createWritableChild(0, 0, writableRaster.getWidth(), writableRaster.getHeight(), rectangle.x, rectangle.y, null);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        if (writableRaster == null) {
            return this.read(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }
        WritableRaster writableRaster2 = this.read(writableRaster.getBounds());
        writableRaster.setRect(writableRaster2);
        return writableRaster;
    }
}

