/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.metadata.IIOMetadata;

public class TIFFT4Compressor
extends TIFFFaxCompressor {
    private boolean is1DMode = false;
    private boolean isEOLAligned = false;

    public TIFFT4Compressor() {
        super("CCITT T.4", 3, true);
    }

    public void setMetadata(IIOMetadata iIOMetadata) {
        super.setMetadata(iIOMetadata);
        if (iIOMetadata instanceof TIFFImageMetadata) {
            TIFFImageMetadata tIFFImageMetadata = (TIFFImageMetadata)iIOMetadata;
            TIFFField tIFFField = tIFFImageMetadata.getTIFFField(292);
            if (tIFFField != null) {
                int n2 = tIFFField.getAsInt(0);
                this.is1DMode = (n2 & 1) == 0;
                this.isEOLAligned = (n2 & 4) == 4;
            } else {
                long[] lArray = new long[]{(this.isEOLAligned ? 4 : 0) | (this.is1DMode ? 0 : 1)};
                BaselineTIFFTagSet baselineTIFFTagSet = BaselineTIFFTagSet.getInstance();
                TIFFField tIFFField2 = new TIFFField(baselineTIFFTagSet.getTag(292), 4, 1, lArray);
                tIFFImageMetadata.rootIFD.addTIFFField(tIFFField2);
            }
        }
    }

    public int encodeT4(boolean bl2, boolean bl3, byte[] byArray, int n2, int n3, int n4, int n5, byte[] byArray2) {
        int n6;
        byte[] byArray3 = byArray;
        int n7 = 0;
        int n8 = 0;
        this.initBitBuf();
        int n9 = 2;
        for (n6 = 0; n6 < n5; ++n6) {
            if (bl2 || n6 % n9 == 0) {
                n8 += this.addEOL(bl2, bl3, true, byArray2, n8);
                n8 += this.encode1D(byArray, n7, n3, n4, byArray2, n8);
            } else {
                n8 += this.addEOL(bl2, bl3, false, byArray2, n8);
                int n10 = n7 - n2;
                int n11 = n3;
                int n12 = n11 + n4;
                int n13 = (byArray[n7 + (n11 >>> 3)] & 0xFF) >>> 7 - (n11 & 7) & 1;
                int n14 = n13 != 0 ? n11 : this.nextState(byArray, n7, n11, n12);
                n13 = (byArray3[n10 + (n11 >>> 3)] & 0xFF) >>> 7 - (n11 & 7) & 1;
                int n15 = n13 != 0 ? n11 : this.nextState(byArray3, n10, n11, n12);
                int n16 = 0;
                while (true) {
                    int n17;
                    if ((n17 = this.nextState(byArray3, n10, n15, n12)) < n14) {
                        n8 += this.add2DBits(byArray2, n8, pass, 0);
                        n11 = n17;
                    } else {
                        int n18 = n15 - n14 + 3;
                        if (n18 <= 6 && n18 >= 0) {
                            n8 += this.add2DBits(byArray2, n8, vert, n18);
                            n11 = n14;
                        } else {
                            int n19 = this.nextState(byArray, n7, n14, n12);
                            n8 += this.add2DBits(byArray2, n8, horz, 0);
                            n8 += this.add1DBits(byArray2, n8, n14 - n11, n16);
                            n8 += this.add1DBits(byArray2, n8, n19 - n14, n16 ^ 1);
                            n11 = n19;
                        }
                    }
                    if (n11 >= n12) break;
                    n16 = (byArray[n7 + (n11 >>> 3)] & 0xFF) >>> 7 - (n11 & 7) & 1;
                    n14 = this.nextState(byArray, n7, n11, n12);
                    n15 = this.nextState(byArray3, n10, n11, n12);
                    n13 = (byArray3[n10 + (n15 >>> 3)] & 0xFF) >>> 7 - (n15 & 7) & 1;
                    if (n13 != n16) continue;
                    n15 = this.nextState(byArray3, n10, n15, n12);
                }
            }
            n7 += n2;
        }
        for (n6 = 0; n6 < 6; ++n6) {
            n8 += this.addEOL(bl2, bl3, true, byArray2, n8);
        }
        while (this.ndex > 0) {
            byArray2[n8++] = (byte)(this.bits >>> 24);
            this.bits <<= 8;
            this.ndex -= 8;
        }
        if (this.inverseFill) {
            for (n6 = 0; n6 < n8; ++n6) {
                byArray2[n6] = TIFFFaxDecompressor.flipTable[byArray2[n6] & 0xFF];
            }
        }
        return n8;
    }

    public int encode(byte[] byArray, int n2, int n3, int n4, int[] nArray, int n5) throws IOException {
        if (nArray.length != 1 || nArray[0] != 1) {
            throw new IIOException("Bits per sample must be 1 for T4 compression!");
        }
        int n6 = 9 * ((n3 + 1) / 2) + 2;
        int n7 = (n6 + 7) / 8;
        n7 = n4 * (n7 + 2) + 12;
        byte[] byArray2 = new byte[n7];
        int n8 = this.encodeT4(this.is1DMode, this.isEOLAligned, byArray, n5, 8 * n2, n3, n4, byArray2);
        this.stream.write(byArray2, 0, n8);
        return n8;
    }
}

