/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class TIFFYCbCrDecompressor
extends TIFFDecompressor {
    private static final boolean debug = false;
    private static final int FRAC_BITS = 16;
    private static final float FRAC_SCALE = 65536.0f;
    private float LumaRed = 0.299f;
    private float LumaGreen = 0.587f;
    private float LumaBlue = 0.114f;
    private float referenceBlackY = 0.0f;
    private float referenceWhiteY = 255.0f;
    private float referenceBlackCb = 128.0f;
    private float referenceWhiteCb = 255.0f;
    private float referenceBlackCr = 128.0f;
    private float referenceWhiteCr = 255.0f;
    private float codingRangeY = 255.0f;
    private int[] iYTab = new int[256];
    private int[] iCbTab = new int[256];
    private int[] iCrTab = new int[256];
    private int[] iGYTab = new int[256];
    private int[] iGCbTab = new int[256];
    private int[] iGCrTab = new int[256];
    private int chromaSubsampleH = 2;
    private int chromaSubsampleV = 2;
    private boolean colorConvert;
    private TIFFDecompressor decompressor;
    private BufferedImage tmpImage;

    public TIFFYCbCrDecompressor(TIFFDecompressor tIFFDecompressor, boolean bl2) {
        this.decompressor = tIFFDecompressor;
        this.colorConvert = bl2;
    }

    private void warning(String string) {
        if (this.reader instanceof TIFFImageReader) {
            ((TIFFImageReader)this.reader).forwardWarningMessage(string);
        }
    }

    public void setReader(ImageReader imageReader) {
        if (this.decompressor != null) {
            this.decompressor.setReader(imageReader);
        }
        super.setReader(imageReader);
    }

    public void setMetadata(IIOMetadata iIOMetadata) {
        if (this.decompressor != null) {
            this.decompressor.setMetadata(iIOMetadata);
        }
        super.setMetadata(iIOMetadata);
    }

    public void setPhotometricInterpretation(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setPhotometricInterpretation(n2);
        }
        super.setPhotometricInterpretation(n2);
    }

    public void setCompression(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setCompression(n2);
        }
        super.setCompression(n2);
    }

    public void setPlanar(boolean bl2) {
        if (this.decompressor != null) {
            this.decompressor.setPlanar(bl2);
        }
        super.setPlanar(bl2);
    }

    public void setSamplesPerPixel(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setSamplesPerPixel(n2);
        }
        super.setSamplesPerPixel(n2);
    }

    public void setBitsPerSample(int[] nArray) {
        if (this.decompressor != null) {
            this.decompressor.setBitsPerSample(nArray);
        }
        super.setBitsPerSample(nArray);
    }

    public void setSampleFormat(int[] nArray) {
        if (this.decompressor != null) {
            this.decompressor.setSampleFormat(nArray);
        }
        super.setSampleFormat(nArray);
    }

    public void setExtraSamples(int[] nArray) {
        if (this.decompressor != null) {
            this.decompressor.setExtraSamples(nArray);
        }
        super.setExtraSamples(nArray);
    }

    public void setColorMap(char[] cArray) {
        if (this.decompressor != null) {
            this.decompressor.setColorMap(cArray);
        }
        super.setColorMap(cArray);
    }

    public void setStream(ImageInputStream imageInputStream) {
        if (this.decompressor != null) {
            this.decompressor.setStream(imageInputStream);
        } else {
            super.setStream(imageInputStream);
        }
    }

    public void setOffset(long l2) {
        if (this.decompressor != null) {
            this.decompressor.setOffset(l2);
        }
        super.setOffset(l2);
    }

    public void setByteCount(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setByteCount(n2);
        }
        super.setByteCount(n2);
    }

    public void setSrcMinX(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setSrcMinX(n2);
        }
        super.setSrcMinX(n2);
    }

    public void setSrcMinY(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setSrcMinY(n2);
        }
        super.setSrcMinY(n2);
    }

    public void setSrcWidth(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setSrcWidth(n2);
        }
        super.setSrcWidth(n2);
    }

    public void setSrcHeight(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setSrcHeight(n2);
        }
        super.setSrcHeight(n2);
    }

    public void setSourceXOffset(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setSourceXOffset(n2);
        }
        super.setSourceXOffset(n2);
    }

    public void setDstXOffset(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setDstXOffset(n2);
        }
        super.setDstXOffset(n2);
    }

    public void setSourceYOffset(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setSourceYOffset(n2);
        }
        super.setSourceYOffset(n2);
    }

    public void setDstYOffset(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setDstYOffset(n2);
        }
        super.setDstYOffset(n2);
    }

    public void setSourceBands(int[] nArray) {
        if (this.decompressor != null) {
            this.decompressor.setSourceBands(nArray);
        }
        super.setSourceBands(nArray);
    }

    public void setDestinationBands(int[] nArray) {
        if (this.decompressor != null) {
            this.decompressor.setDestinationBands(nArray);
        }
        super.setDestinationBands(nArray);
    }

    public void setImage(BufferedImage bufferedImage) {
        if (this.decompressor != null) {
            ColorModel colorModel = bufferedImage.getColorModel();
            this.tmpImage = new BufferedImage(colorModel, bufferedImage.getRaster().createCompatibleWritableRaster(1, 1), colorModel.isAlphaPremultiplied(), null);
            this.decompressor.setImage(this.tmpImage);
        }
        super.setImage(bufferedImage);
    }

    public void setDstMinX(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setDstMinX(n2);
        }
        super.setDstMinX(n2);
    }

    public void setDstMinY(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setDstMinY(n2);
        }
        super.setDstMinY(n2);
    }

    public void setDstWidth(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setDstWidth(n2);
        }
        super.setDstWidth(n2);
    }

    public void setDstHeight(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setDstHeight(n2);
        }
        super.setDstHeight(n2);
    }

    public void setActiveSrcMinX(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setActiveSrcMinX(n2);
        }
        super.setActiveSrcMinX(n2);
    }

    public void setActiveSrcMinY(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setActiveSrcMinY(n2);
        }
        super.setActiveSrcMinY(n2);
    }

    public void setActiveSrcWidth(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setActiveSrcWidth(n2);
        }
        super.setActiveSrcWidth(n2);
    }

    public void setActiveSrcHeight(int n2) {
        if (this.decompressor != null) {
            this.decompressor.setActiveSrcHeight(n2);
        }
        super.setActiveSrcHeight(n2);
    }

    private byte clamp(int n2) {
        if (n2 < 0) {
            return 0;
        }
        if (n2 > 0xFF0000) {
            return -1;
        }
        return (byte)(n2 >> 16);
    }

    public void beginDecoding() {
        TIFFImageMetadata tIFFImageMetadata;
        TIFFField tIFFField;
        if (this.decompressor != null) {
            this.decompressor.beginDecoding();
        }
        if ((tIFFField = (tIFFImageMetadata = (TIFFImageMetadata)this.metadata).getTIFFField(530)) != null) {
            if (tIFFField.getCount() == 2) {
                this.chromaSubsampleH = tIFFField.getAsInt(0);
                this.chromaSubsampleV = tIFFField.getAsInt(1);
                if (this.chromaSubsampleH != 1 && this.chromaSubsampleH != 2 && this.chromaSubsampleH != 4) {
                    this.warning("Y_CB_CR_SUBSAMPLING[0] has illegal value " + this.chromaSubsampleH + " (should be 1, 2, or 4), setting to 1");
                    this.chromaSubsampleH = 1;
                }
                if (this.chromaSubsampleV != 1 && this.chromaSubsampleV != 2 && this.chromaSubsampleV != 4) {
                    this.warning("Y_CB_CR_SUBSAMPLING[1] has illegal value " + this.chromaSubsampleV + " (should be 1, 2, or 4), setting to 1");
                    this.chromaSubsampleV = 1;
                }
            } else {
                this.warning("Y_CB_CR_SUBSAMPLING count != 2, assuming no subsampling");
            }
        }
        if ((tIFFField = tIFFImageMetadata.getTIFFField(529)) != null) {
            if (tIFFField.getCount() == 3) {
                this.LumaRed = tIFFField.getAsFloat(0);
                this.LumaGreen = tIFFField.getAsFloat(1);
                this.LumaBlue = tIFFField.getAsFloat(2);
            } else {
                this.warning("Y_CB_CR_COEFFICIENTS count != 3, assuming default values for CCIR 601-1");
            }
        }
        if ((tIFFField = tIFFImageMetadata.getTIFFField(532)) != null) {
            if (tIFFField.getCount() == 6) {
                this.referenceBlackY = tIFFField.getAsFloat(0);
                this.referenceWhiteY = tIFFField.getAsFloat(1);
                this.referenceBlackCb = tIFFField.getAsFloat(2);
                this.referenceWhiteCb = tIFFField.getAsFloat(3);
                this.referenceBlackCr = tIFFField.getAsFloat(4);
                this.referenceWhiteCr = tIFFField.getAsFloat(5);
            } else {
                this.warning("REFERENCE_BLACK_WHITE count != 6, ignoring it");
            }
        } else {
            this.warning("REFERENCE_BLACK_WHITE not found, assuming 0-255/128-255/128-255");
        }
        this.colorConvert = true;
        float f2 = 2.0f - 2.0f * this.LumaBlue;
        float f3 = 2.0f - 2.0f * this.LumaRed;
        float f4 = (1.0f - this.LumaBlue - this.LumaRed) / this.LumaGreen;
        float f5 = 2.0f * this.LumaBlue * (this.LumaBlue - 1.0f) / this.LumaGreen;
        float f6 = 2.0f * this.LumaRed * (this.LumaRed - 1.0f) / this.LumaGreen;
        for (int i2 = 0; i2 < 256; ++i2) {
            float f7 = ((float)i2 - this.referenceBlackY) * this.codingRangeY / (this.referenceWhiteY - this.referenceBlackY);
            float f8 = ((float)i2 - this.referenceBlackCb) * 127.0f / (this.referenceWhiteCb - this.referenceBlackCb);
            float f9 = ((float)i2 - this.referenceBlackCr) * 127.0f / (this.referenceWhiteCr - this.referenceBlackCr);
            this.iYTab[i2] = (int)(f7 * 65536.0f);
            this.iCbTab[i2] = (int)(f8 * f2 * 65536.0f);
            this.iCrTab[i2] = (int)(f9 * f3 * 65536.0f);
            this.iGYTab[i2] = (int)(f7 * f4 * 65536.0f);
            this.iGCbTab[i2] = (int)(f8 * f5 * 65536.0f);
            this.iGCrTab[i2] = (int)(f9 * f6 * 65536.0f);
        }
    }

    public void decodeRaw(byte[] byArray, int n2, int n3, int n4) throws IOException {
        int n5;
        byte[] byArray2 = new byte[3 * this.srcWidth * this.chromaSubsampleV];
        int n6 = this.chromaSubsampleH * this.chromaSubsampleV + 2;
        byte[] byArray3 = new byte[n6];
        if (this.decompressor != null) {
            n5 = 3 * this.srcWidth;
            byte[] byArray4 = new byte[n5 * this.srcHeight];
            this.decompressor.decodeRaw(byArray4, n2, n3, n5);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray4);
            this.stream = new MemoryCacheImageInputStream(byteArrayInputStream);
        } else {
            this.stream.seek(this.offset);
        }
        for (n5 = this.srcMinY; n5 < this.srcMinY + this.srcHeight; n5 += this.chromaSubsampleV) {
            block3: for (int i2 = this.srcMinX; i2 < this.srcMinX + this.srcWidth; i2 += this.chromaSubsampleH) {
                int n7;
                int n8;
                try {
                    this.stream.readFully(byArray3);
                }
                catch (EOFException eOFException) {
                    System.out.println("e = " + eOFException);
                    return;
                }
                byte by2 = byArray3[n6 - 2];
                byte by3 = byArray3[n6 - 1];
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                if (this.colorConvert) {
                    n8 = by2 & 0xFF;
                    n7 = by3 & 0xFF;
                    n9 = this.iCbTab[n8];
                    n10 = this.iCrTab[n7];
                    n11 = this.iGCbTab[n8];
                    n12 = this.iGCrTab[n7];
                }
                n8 = 0;
                for (n7 = 0; n7 < this.chromaSubsampleV; ++n7) {
                    int n13 = n2 + 3 * (i2 - this.srcMinX) + n4 * (n5 - this.srcMinY + n7);
                    if (n5 + n7 >= this.srcMinY + this.srcHeight) continue block3;
                    for (int i3 = 0; i3 < this.chromaSubsampleH && i2 + i3 < this.srcMinX + this.srcWidth; ++i3) {
                        byte by4 = byArray3[n8++];
                        if (this.colorConvert) {
                            int n14 = by4 & 0xFF;
                            int n15 = this.iYTab[n14];
                            int n16 = this.iGYTab[n14];
                            int n17 = n15 + n10;
                            int n18 = n16 + n11 + n12;
                            int n19 = n15 + n9;
                            byte by5 = this.clamp(n17);
                            byte by6 = this.clamp(n18);
                            byte by7 = this.clamp(n19);
                            byArray[n13] = by5;
                            byArray[n13 + 1] = by6;
                            byArray[n13 + 2] = by7;
                        } else {
                            byArray[n13] = by4;
                            byArray[n13 + 1] = by2;
                            byArray[n13 + 2] = by3;
                        }
                        n13 += 3;
                    }
                }
            }
        }
    }
}

