/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.wbmp;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.wbmp.I18N;
import com.sun.media.imageioimpl.plugins.wbmp.WBMPMetadata;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class WBMPImageReader
extends ImageReader {
    private ImageInputStream iis = null;
    private boolean gotHeader = false;
    private long imageDataOffset;
    private int width;
    private int height;
    private int wbmpType;
    private WBMPMetadata metadata;

    public WBMPImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public void setInput(Object object, boolean bl2, boolean bl3) {
        super.setInput(object, bl2, bl3);
        this.iis = (ImageInputStream)object;
        this.gotHeader = false;
    }

    public int getNumImages(boolean bl2) throws IOException {
        if (this.iis == null) {
            throw new IllegalStateException(I18N.getString("GetNumImages0"));
        }
        if (this.seekForwardOnly && bl2) {
            throw new IllegalStateException(I18N.getString("GetNumImages1"));
        }
        return 1;
    }

    public int getWidth(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        return this.width;
    }

    public int getHeight(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        return this.height;
    }

    public boolean isRandomAccessEasy(int n2) throws IOException {
        this.checkIndex(n2);
        return true;
    }

    private void checkIndex(int n2) {
        if (n2 != 0) {
            throw new IndexOutOfBoundsException(I18N.getString("WBMPImageReader0"));
        }
    }

    public void readHeader() throws IOException {
        if (this.gotHeader) {
            this.iis.seek(this.imageDataOffset);
            return;
        }
        if (this.iis == null) {
            throw new IllegalStateException(I18N.getString("WBMPImageReader1"));
        }
        this.metadata = new WBMPMetadata();
        this.wbmpType = this.iis.readByte();
        byte by2 = this.iis.readByte();
        if (by2 != 0 || !this.isValidWbmpType(this.wbmpType)) {
            throw new IIOException(I18N.getString("WBMPImageReader2"));
        }
        this.metadata.wbmpType = this.wbmpType;
        this.metadata.width = this.width = ImageUtil.readMultiByteInteger(this.iis);
        this.metadata.height = this.height = ImageUtil.readMultiByteInteger(this.iis);
        this.gotHeader = true;
        this.imageDataOffset = this.iis.getStreamPosition();
    }

    public Iterator getImageTypes(int n2) throws IOException {
        this.checkIndex(n2);
        this.readHeader();
        BufferedImage bufferedImage = new BufferedImage(1, 1, 12);
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        arrayList.add(new ImageTypeSpecifier(bufferedImage));
        return arrayList.iterator();
    }

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    public IIOMetadata getImageMetadata(int n2) throws IOException {
        this.checkIndex(n2);
        if (this.metadata == null) {
            this.readHeader();
        }
        return this.metadata;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public BufferedImage read(int n2, ImageReadParam imageReadParam) throws IOException {
        if (this.iis == null) {
            throw new IllegalStateException(I18N.getString("WBMPImageReader1"));
        }
        this.checkIndex(n2);
        this.clearAbortRequest();
        this.processImageStarted(n2);
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        this.readHeader();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        WBMPImageReader.computeRegions(imageReadParam, this.width, this.height, imageReadParam.getDestination(), rectangle, rectangle2);
        int n3 = imageReadParam.getSourceXSubsampling();
        int n4 = imageReadParam.getSourceYSubsampling();
        int n5 = imageReadParam.getSubsamplingXOffset();
        int n6 = imageReadParam.getSubsamplingYOffset();
        BufferedImage bufferedImage = imageReadParam.getDestination();
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, 12);
        }
        boolean bl2 = rectangle2.equals(new Rectangle(0, 0, this.width, this.height)) && rectangle2.equals(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        WritableRaster writableRaster = bufferedImage.getWritableTile(0, 0);
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)bufferedImage.getSampleModel();
        if (bl2) {
            if (this.abortRequested()) {
                this.processReadAborted();
                return bufferedImage;
            }
            this.iis.read(((DataBufferByte)writableRaster.getDataBuffer()).getData(), 0, this.height * multiPixelPackedSampleModel.getScanlineStride());
            this.processImageUpdate(bufferedImage, 0, 0, this.width, this.height, 1, 1, new int[]{0});
            this.processImageProgress(100.0f);
        } else {
            int n7 = (this.width + 7) / 8;
            byte[] byArray = new byte[n7];
            byte[] byArray2 = ((DataBufferByte)writableRaster.getDataBuffer()).getData();
            int n8 = multiPixelPackedSampleModel.getScanlineStride();
            this.iis.skipBytes(n7 * rectangle.y);
            int n9 = n7 * (n4 - 1);
            int[] nArray = new int[rectangle2.width];
            int[] nArray2 = new int[rectangle2.width];
            int[] nArray3 = new int[rectangle2.width];
            int[] nArray4 = new int[rectangle2.width];
            int n10 = rectangle2.x;
            int n11 = rectangle.x;
            int n12 = 0;
            while (n10 < rectangle2.x + rectangle2.width) {
                nArray3[n12] = n11 >> 3;
                nArray[n12] = 7 - (n11 & 7);
                nArray4[n12] = n10 >> 3;
                nArray2[n12] = 7 - (n10 & 7);
                ++n10;
                ++n12;
                n11 += n3;
            }
            n10 = 0;
            n11 = rectangle.y;
            n12 = rectangle2.y * n8;
            while (n10 < rectangle2.height && !this.abortRequested()) {
                this.iis.read(byArray, 0, n7);
                for (int i2 = 0; i2 < rectangle2.width; ++i2) {
                    int n13 = byArray[nArray3[i2]] >> nArray[i2] & 1;
                    int n14 = n12 + nArray4[i2];
                    byArray2[n14] = (byte)(byArray2[n14] | n13 << nArray2[i2]);
                }
                n12 += n8;
                this.iis.skipBytes(n9);
                this.processImageUpdate(bufferedImage, 0, n10, rectangle2.width, 1, 1, 1, new int[]{0});
                this.processImageProgress(100.0f * (float)n10 / (float)rectangle2.height);
                ++n10;
                n11 += n4;
            }
        }
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return bufferedImage;
    }

    public boolean canReadRaster() {
        return true;
    }

    public Raster readRaster(int n2, ImageReadParam imageReadParam) throws IOException {
        BufferedImage bufferedImage = this.read(n2, imageReadParam);
        return bufferedImage.getData();
    }

    public void reset() {
        super.reset();
        this.iis = null;
        this.gotHeader = false;
    }

    boolean isValidWbmpType(int n2) {
        return n2 == 0;
    }
}

