/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.wbmp;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.wbmp.WBMPImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class WBMPImageReaderSpi
extends ImageReaderSpi {
    private static String[] writerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.wbmp.WBMPImageWriterSpi"};
    private static String[] formatNames = new String[]{"wbmp", "WBMP"};
    private static String[] entensions = new String[]{"wbmp"};
    private static String[] mimeType = new String[]{"image/vnd.wap.wbmp"};
    private boolean registered = false;

    public WBMPImageReaderSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), formatNames, entensions, mimeType, "com.sun.media.imageioimpl.plugins.wbmp.WBMPImageReader", STANDARD_INPUT_TYPE, writerSpiNames, true, null, null, null, null, true, "com_sun_media_imageio_plugins_wbmp_image_1.0", "com.sun.media.imageioimpl.plugins.wbmp.WBMPMetadataFormat", null, null);
    }

    public void onRegistration(ServiceRegistry serviceRegistry, Class clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
        ImageUtil.processOnRegistration(serviceRegistry, clazz, "WBMP", this, 8, 7);
    }

    public String getDescription(Locale locale) {
        String string = PackageUtil.getSpecificationTitle() + " WBMP Image Reader";
        return string;
    }

    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        byte by2 = imageInputStream.readByte();
        byte by3 = imageInputStream.readByte();
        int n2 = ImageUtil.readMultiByteInteger(imageInputStream);
        int n3 = ImageUtil.readMultiByteInteger(imageInputStream);
        long l2 = imageInputStream.length() - imageInputStream.getStreamPosition();
        imageInputStream.reset();
        if (by2 != 0 || by3 != 0) {
            return false;
        }
        if (n2 <= 0 || n3 <= 0) {
            return false;
        }
        long l3 = n2 / 8 + (n2 % 8 == 0 ? 0 : 1);
        return l2 == l3 * (long)n3;
    }

    public ImageReader createReaderInstance(Object object) throws IIOException {
        return new WBMPImageReader(this);
    }
}

