/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.wbmp;

import com.sun.media.imageioimpl.plugins.wbmp.I18N;
import com.sun.media.imageioimpl.plugins.wbmp.WBMPMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class WBMPImageWriter
extends ImageWriter {
    private ImageOutputStream stream = null;

    private static int getNumBits(int n2) {
        int n3 = 32;
        for (int i2 = Integer.MIN_VALUE; i2 != 0 && (n2 & i2) == 0; i2 >>>= 1) {
            --n3;
        }
        return n3;
    }

    private static byte[] intToMultiByte(int n2) {
        int n3 = WBMPImageWriter.getNumBits(n2);
        byte[] byArray = new byte[(n3 + 6) / 7];
        int n4 = byArray.length - 1;
        for (int i2 = 0; i2 <= n4; ++i2) {
            byArray[i2] = (byte)(n2 >>> (n4 - i2) * 7 & 0x7F);
            if (i2 == n4) continue;
            int n5 = i2;
            byArray[n5] = (byte)(byArray[n5] | 0xFFFFFF80);
        }
        return byArray;
    }

    public WBMPImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("WBMPImageWriter"));
            }
            this.stream = (ImageOutputStream)object;
        } else {
            this.stream = null;
        }
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        WBMPMetadata wBMPMetadata = new WBMPMetadata();
        wBMPMetadata.wbmpType = 0;
        return wBMPMetadata;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public boolean canWriteRasters() {
        return true;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Object object;
        WritableRaster writableRaster;
        if (this.stream == null) {
            throw new IllegalStateException(I18N.getString("WBMPImageWriter3"));
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException(I18N.getString("WBMPImageWriter4"));
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        }
        RenderedImage renderedImage = null;
        Raster raster = null;
        boolean bl2 = iIOImage.hasRaster();
        Rectangle rectangle = imageWriteParam.getSourceRegion();
        SampleModel sampleModel = null;
        if (bl2) {
            raster = iIOImage.getRaster();
            sampleModel = raster.getSampleModel();
        } else {
            renderedImage = iIOImage.getRenderedImage();
            sampleModel = renderedImage.getSampleModel();
            raster = renderedImage.getData();
        }
        this.checkSampleModel(sampleModel);
        rectangle = rectangle == null ? raster.getBounds() : rectangle.intersection(raster.getBounds());
        if (rectangle.isEmpty()) {
            throw new RuntimeException(I18N.getString("WBMPImageWriter1"));
        }
        int n7 = imageWriteParam.getSourceXSubsampling();
        int n8 = imageWriteParam.getSourceYSubsampling();
        int n9 = imageWriteParam.getSubsamplingXOffset();
        int n10 = imageWriteParam.getSubsamplingYOffset();
        rectangle.translate(n9, n10);
        rectangle.width -= n9;
        rectangle.height -= n10;
        int n11 = rectangle.x / n7;
        int n12 = rectangle.y / n8;
        int n13 = (rectangle.width + n7 - 1) / n7;
        int n14 = (rectangle.height + n8 - 1) / n8;
        Rectangle rectangle2 = new Rectangle(n11, n12, n13, n14);
        SampleModel sampleModel2 = sampleModel = sampleModel.createCompatibleSampleModel(n13, n14);
        if (sampleModel.getDataType() != 0 || !(sampleModel instanceof MultiPixelPackedSampleModel) || ((MultiPixelPackedSampleModel)sampleModel).getDataBitOffset() != 0) {
            sampleModel2 = new MultiPixelPackedSampleModel(0, n13, n14, 1, n13 + 7 >> 3, 0);
        }
        if (!rectangle2.equals(rectangle)) {
            if (n7 == 1 && n8 == 1) {
                raster = raster.createChild(raster.getMinX(), raster.getMinY(), n13, n14, n11, n12, null);
            } else {
                writableRaster = Raster.createWritableRaster(sampleModel2, new Point(n11, n12));
                object = ((DataBufferByte)writableRaster.getDataBuffer()).getData();
                n6 = n12;
                int n15 = rectangle.y;
                n5 = 0;
                while (n6 < n12 + n14) {
                    n4 = 0;
                    n3 = rectangle.x;
                    while (n4 < n13) {
                        n2 = raster.getSample(n3, n15, 0);
                        Object object2 = object;
                        int n16 = n5 + (n4 >> 3);
                        object2[n16] = (byte)(object2[n16] | n2 << 7 - (n4 & 7));
                        ++n4;
                        n3 += n7;
                    }
                    n5 += n13 + 7 >> 3;
                    ++n6;
                    n15 += n8;
                }
                raster = writableRaster;
            }
        }
        if (!sampleModel2.equals(raster.getSampleModel())) {
            writableRaster = Raster.createWritableRaster(sampleModel2, new Point(raster.getMinX(), raster.getMinY()));
            writableRaster.setRect(raster);
            raster = writableRaster;
        }
        boolean bl3 = false;
        if (!bl2 && renderedImage.getColorModel() instanceof IndexColorModel) {
            object = (IndexColorModel)renderedImage.getColorModel();
            bl3 = ((IndexColorModel)object).getRed(0) > ((IndexColorModel)object).getRed(1);
        }
        int n17 = ((MultiPixelPackedSampleModel)sampleModel2).getScanlineStride();
        n6 = (n13 + 7) / 8;
        byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
        this.stream.write(0);
        this.stream.write(0);
        this.stream.write(WBMPImageWriter.intToMultiByte(n13));
        this.stream.write(WBMPImageWriter.intToMultiByte(n14));
        if (!bl3 && n17 == n6) {
            this.stream.write(byArray, 0, n14 * n6);
            this.processImageProgress(100.0f);
        } else {
            n5 = 0;
            if (!bl3) {
                for (n4 = 0; n4 < n14 && !this.abortRequested(); ++n4) {
                    this.stream.write(byArray, n5, n6);
                    n5 += n17;
                    this.processImageProgress(100.0f * (float)n4 / (float)n14);
                }
            } else {
                byte[] byArray2 = new byte[n6];
                for (n3 = 0; n3 < n14 && !this.abortRequested(); ++n3) {
                    for (n2 = 0; n2 < n6; ++n2) {
                        byArray2[n2] = ~byArray[n2 + n5];
                    }
                    this.stream.write(byArray2, 0, n6);
                    n5 += n17;
                    this.processImageProgress(100.0f * (float)n3 / (float)n14);
                }
            }
        }
        if (this.abortRequested()) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
            this.stream.flushBefore(this.stream.getStreamPosition());
        }
    }

    public void reset() {
        super.reset();
        this.stream = null;
    }

    private void checkSampleModel(SampleModel sampleModel) {
        int n2 = sampleModel.getDataType();
        if (n2 < 0 || n2 > 3 || sampleModel.getNumBands() != 1 || sampleModel.getSampleSize(0) != 1) {
            throw new IllegalArgumentException(I18N.getString("WBMPImageWriter2"));
        }
    }
}

