/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.JaiI18N;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.BMPCodec;
import com.sun.media.jai.codecimpl.FPXCodec;
import com.sun.media.jai.codecimpl.GIFCodec;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.JPEGCodec;
import com.sun.media.jai.codecimpl.PNGCodec;
import com.sun.media.jai.codecimpl.PNMCodec;
import com.sun.media.jai.codecimpl.TIFFCodec;
import com.sun.media.jai.codecimpl.WBMPCodec;
import com.sun.media.jai.codecimpl.util.FloatDoubleColorModel;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ImageCodec {
    private static Hashtable codecs = new Hashtable();
    private static final byte[][] grayIndexCmaps;
    private static final int[] GrayBits8;
    private static final ComponentColorModel colorModelGray8;
    private static final int[] GrayAlphaBits8;
    private static final ComponentColorModel colorModelGrayAlpha8;
    private static final int[] GrayBits16;
    private static final ComponentColorModel colorModelGray16;
    private static final int[] GrayAlphaBits16;
    private static final ComponentColorModel colorModelGrayAlpha16;
    private static final int[] GrayBits32;
    private static final ComponentColorModel colorModelGray32;
    private static final int[] GrayAlphaBits32;
    private static final ComponentColorModel colorModelGrayAlpha32;
    private static final int[] RGBBits8;
    private static final ComponentColorModel colorModelRGB8;
    private static final int[] RGBABits8;
    private static final ComponentColorModel colorModelRGBA8;
    private static final int[] RGBBits16;
    private static final ComponentColorModel colorModelRGB16;
    private static final int[] RGBABits16;
    private static final ComponentColorModel colorModelRGBA16;
    private static final int[] RGBBits32;
    private static final ComponentColorModel colorModelRGB32;
    private static final int[] RGBABits32;
    private static final ComponentColorModel colorModelRGBA32;
    static /* synthetic */ Class class$com$sun$media$jai$codec$ImageCodec;

    protected ImageCodec() {
    }

    public static ImageCodec getCodec(String string) {
        return (ImageCodec)codecs.get(string.toLowerCase());
    }

    public static void registerCodec(ImageCodec imageCodec) {
        codecs.put(imageCodec.getFormatName().toLowerCase(), imageCodec);
    }

    public static void unregisterCodec(String string) {
        codecs.remove(string.toLowerCase());
    }

    public static Enumeration getCodecs() {
        return codecs.elements();
    }

    public static ImageEncoder createImageEncoder(String string, OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageEncoder(outputStream, imageEncodeParam);
    }

    public static ImageDecoder createImageDecoder(String string, InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageDecoder(inputStream, imageDecodeParam);
    }

    public static ImageDecoder createImageDecoder(String string, File file, ImageDecodeParam imageDecodeParam) throws IOException {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageDecoder(file, imageDecodeParam);
    }

    public static ImageDecoder createImageDecoder(String string, SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageDecoder(seekableStream, imageDecodeParam);
    }

    private static String[] vectorToStrings(Vector vector) {
        int n2 = vector.size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = (String)vector.elementAt(n3);
            ++n3;
        }
        return stringArray;
    }

    public static String[] getDecoderNames(SeekableStream seekableStream) {
        if (!seekableStream.canSeekBackwards() && !seekableStream.markSupported()) {
            throw new IllegalArgumentException(JaiI18N.getString("ImageCodec2"));
        }
        Enumeration enumeration = codecs.elements();
        Vector<String> vector = new Vector<String>();
        Object var3_3 = null;
        while (enumeration.hasMoreElements()) {
            ImageCodec imageCodec = (ImageCodec)enumeration.nextElement();
            int n2 = imageCodec.getNumHeaderBytes();
            if (n2 == 0 && !seekableStream.canSeekBackwards()) continue;
            try {
                if (n2 > 0) {
                    seekableStream.mark(n2);
                    byte[] byArray = new byte[n2];
                    seekableStream.readFully(byArray);
                    seekableStream.reset();
                    if (!imageCodec.isFormatRecognized(byArray)) continue;
                    vector.add(imageCodec.getFormatName());
                    continue;
                }
                long l2 = seekableStream.getFilePointer();
                seekableStream.seek(0L);
                if (imageCodec.isFormatRecognized(seekableStream)) {
                    vector.add(imageCodec.getFormatName());
                }
                seekableStream.seek(l2);
            }
            catch (IOException iOException) {
                ImagingListenerProxy.errorOccurred(JaiI18N.getString("ImageCodec3"), iOException, class$com$sun$media$jai$codec$ImageCodec == null ? ImageCodec.class$("com.sun.media.jai.codec.ImageCodec") : class$com$sun$media$jai$codec$ImageCodec, false);
            }
        }
        return ImageCodec.vectorToStrings(vector);
    }

    public static String[] getEncoderNames(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        Enumeration enumeration = codecs.elements();
        Vector<String> vector = new Vector<String>();
        Object var4_4 = null;
        while (enumeration.hasMoreElements()) {
            ImageCodec imageCodec = (ImageCodec)enumeration.nextElement();
            if (!imageCodec.canEncodeImage(renderedImage, imageEncodeParam)) continue;
            vector.add(imageCodec.getFormatName());
        }
        return ImageCodec.vectorToStrings(vector);
    }

    public abstract String getFormatName();

    public int getNumHeaderBytes() {
        return 0;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        throw new RuntimeException(JaiI18N.getString("ImageCodec0"));
    }

    public boolean isFormatRecognized(SeekableStream seekableStream) throws IOException {
        throw new RuntimeException(JaiI18N.getString("ImageCodec1"));
    }

    protected abstract Class getEncodeParamClass();

    protected abstract Class getDecodeParamClass();

    protected abstract ImageEncoder createImageEncoder(OutputStream var1, ImageEncodeParam var2);

    public abstract boolean canEncodeImage(RenderedImage var1, ImageEncodeParam var2);

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        SeekableStream seekableStream = SeekableStream.wrapInputStream(inputStream, true);
        return this.createImageDecoder(seekableStream, imageDecodeParam);
    }

    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        return this.createImageDecoder(new FileSeekableStream(file), imageDecodeParam);
    }

    protected abstract ImageDecoder createImageDecoder(SeekableStream var1, ImageDecodeParam var2);

    public static ColorModel createGrayIndexColorModel(SampleModel sampleModel, boolean bl2) {
        byte[] byArray;
        int n2;
        block7: {
            block6: {
                if (sampleModel.getNumBands() != 1) {
                    throw new IllegalArgumentException();
                }
                n2 = sampleModel.getSampleSize(0);
                byArray = null;
                if (n2 >= 8) break block6;
                byArray = grayIndexCmaps[n2];
                if (bl2) break block7;
                int n3 = byArray.length;
                byte[] byArray2 = new byte[n3];
                int n4 = 0;
                while (n4 < n3) {
                    byArray2[n4] = byArray[n3 - n4 - 1];
                    ++n4;
                }
                byArray = byArray2;
                break block7;
            }
            byArray = new byte[256];
            if (bl2) {
                int n5 = 0;
                while (n5 < 256) {
                    byArray[n5] = (byte)n5;
                    ++n5;
                }
            } else {
                int n6 = 0;
                while (n6 < 256) {
                    byArray[n6] = (byte)(255 - n6);
                    ++n6;
                }
            }
        }
        return new IndexColorModel(n2, byArray.length, byArray, byArray, byArray);
    }

    public static ColorModel createComponentColorModel(SampleModel sampleModel) {
        int n2 = sampleModel.getDataType();
        int n3 = sampleModel.getNumBands();
        ComponentColorModel componentColorModel = null;
        if (n2 == 0) {
            switch (n3) {
                case 1: {
                    componentColorModel = colorModelGray8;
                    break;
                }
                case 2: {
                    componentColorModel = colorModelGrayAlpha8;
                    break;
                }
                case 3: {
                    componentColorModel = colorModelRGB8;
                    break;
                }
                case 4: {
                    componentColorModel = colorModelRGBA8;
                }
            }
        } else if (n2 == 1) {
            switch (n3) {
                case 1: {
                    componentColorModel = colorModelGray16;
                    break;
                }
                case 2: {
                    componentColorModel = colorModelGrayAlpha16;
                    break;
                }
                case 3: {
                    componentColorModel = colorModelRGB16;
                    break;
                }
                case 4: {
                    componentColorModel = colorModelRGBA16;
                }
            }
        } else if (n2 == 3) {
            switch (n3) {
                case 1: {
                    componentColorModel = colorModelGray32;
                    break;
                }
                case 2: {
                    componentColorModel = colorModelGrayAlpha32;
                    break;
                }
                case 3: {
                    componentColorModel = colorModelRGB32;
                    break;
                }
                case 4: {
                    componentColorModel = colorModelRGBA32;
                }
            }
        } else if (n2 == 4 && n3 >= 1 && n3 <= 4) {
            ColorSpace colorSpace = n3 <= 2 ? ColorSpace.getInstance(1003) : ColorSpace.getInstance(1000);
            boolean bl2 = n3 % 2 == 0;
            componentColorModel = new FloatDoubleColorModel(colorSpace, bl2, false, bl2 ? 3 : 1, 4);
        }
        return componentColorModel;
    }

    public static ColorModel createComponentColorModel(SampleModel sampleModel, ColorSpace colorSpace) {
        int n2;
        if (colorSpace == null) {
            return ImageCodec.createComponentColorModel(sampleModel);
        }
        int n3 = sampleModel.getDataType();
        int n4 = sampleModel.getNumBands();
        ComponentColorModel componentColorModel = null;
        int[] nArray = null;
        int n5 = -1;
        boolean bl2 = n4 % 2 == 0;
        int n6 = n2 = bl2 ? 3 : 1;
        if (n3 == 0) {
            n5 = 0;
            switch (n4) {
                case 1: {
                    nArray = GrayBits8;
                    break;
                }
                case 2: {
                    nArray = GrayAlphaBits8;
                    break;
                }
                case 3: {
                    nArray = RGBBits8;
                    break;
                }
                case 4: {
                    nArray = RGBABits8;
                }
            }
        } else if (n3 == 1) {
            n5 = 1;
            switch (n4) {
                case 1: {
                    nArray = GrayBits16;
                    break;
                }
                case 2: {
                    nArray = GrayAlphaBits16;
                    break;
                }
                case 3: {
                    nArray = RGBBits16;
                    break;
                }
                case 4: {
                    nArray = RGBABits16;
                }
            }
        } else if (n3 == 3) {
            n5 = 3;
            switch (n4) {
                case 1: {
                    nArray = GrayBits32;
                    break;
                }
                case 2: {
                    nArray = GrayAlphaBits32;
                    break;
                }
                case 3: {
                    nArray = RGBBits32;
                    break;
                }
                case 4: {
                    nArray = RGBABits32;
                }
            }
        }
        componentColorModel = n3 == 4 && n4 >= 1 && n4 <= 4 ? new FloatDoubleColorModel(colorSpace, bl2, false, n2, 4) : new ComponentColorModel(colorSpace, nArray, bl2, false, n2, n5);
        return componentColorModel;
    }

    public static boolean isIndicesForGrayscale(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray.length != byArray2.length || byArray.length != byArray3.length) {
            return false;
        }
        int n2 = byArray.length;
        if (n2 != 256) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            byte by2 = (byte)n3;
            if (byArray[n3] != by2 || byArray2[n3] != by2 || byArray3[n3] != by2) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ImageCodec.registerCodec(new BMPCodec());
        ImageCodec.registerCodec(new GIFCodec());
        ImageCodec.registerCodec(new FPXCodec());
        ImageCodec.registerCodec(new JPEGCodec());
        ImageCodec.registerCodec(new PNGCodec());
        ImageCodec.registerCodec(new PNMCodec());
        ImageCodec.registerCodec(new TIFFCodec());
        ImageCodec.registerCodec(new WBMPCodec());
        grayIndexCmaps = new byte[][]{null, {0, -1}, {0, 85, -86, -1}, null, {0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1}};
        GrayBits8 = new int[]{8};
        colorModelGray8 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits8, false, false, 1, 0);
        GrayAlphaBits8 = new int[]{8, 8};
        colorModelGrayAlpha8 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits8, true, false, 3, 0);
        GrayBits16 = new int[]{16};
        colorModelGray16 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits16, false, false, 1, 1);
        GrayAlphaBits16 = new int[]{16, 16};
        colorModelGrayAlpha16 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits16, true, false, 3, 1);
        GrayBits32 = new int[]{32};
        colorModelGray32 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits32, false, false, 1, 3);
        GrayAlphaBits32 = new int[]{32, 32};
        colorModelGrayAlpha32 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits32, true, false, 3, 3);
        RGBBits8 = new int[]{8, 8, 8};
        colorModelRGB8 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits8, false, false, 1, 0);
        RGBABits8 = new int[]{8, 8, 8, 8};
        colorModelRGBA8 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits8, true, false, 3, 0);
        RGBBits16 = new int[]{16, 16, 16};
        colorModelRGB16 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits16, false, false, 1, 1);
        RGBABits16 = new int[]{16, 16, 16, 16};
        colorModelRGBA16 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits16, true, false, 3, 1);
        RGBBits32 = new int[]{32, 32, 32};
        colorModelRGB32 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits32, false, false, 1, 3);
        RGBABits32 = new int[]{32, 32, 32, 32};
        colorModelRGBA32 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits32, true, false, 3, 3);
    }
}

