/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.JaiI18N;

public class JPEGEncodeParam
implements ImageEncodeParam {
    private static int JPEG_MAX_BANDS = 3;
    private int[] hSamp = new int[JPEG_MAX_BANDS];
    private int[] vSamp = new int[JPEG_MAX_BANDS];
    private int[][] qTab;
    private int[] qTabSlot = new int[JPEG_MAX_BANDS];
    private float qual;
    private int rstInterval;
    private boolean writeImageOnly;
    private boolean writeTablesOnly;
    private boolean writeJFIFHeader;
    private boolean qualitySet;
    private boolean[] qTabSet;

    public JPEGEncodeParam() {
        this.qTab = new int[JPEG_MAX_BANDS][];
        this.qTabSet = new boolean[JPEG_MAX_BANDS];
        this.hSamp[0] = 1;
        this.vSamp[0] = 1;
        this.qTabSlot[0] = 0;
        this.qTab[0] = null;
        this.qTabSet[0] = false;
        this.hSamp[1] = 2;
        this.vSamp[1] = 2;
        this.qTabSlot[1] = 1;
        this.qTab[1] = null;
        this.qTabSet[1] = false;
        this.hSamp[2] = 2;
        this.vSamp[2] = 2;
        this.qTabSlot[2] = 1;
        this.qTab[2] = null;
        this.qTabSet[2] = false;
        this.qual = 0.75f;
        this.rstInterval = 0;
        this.writeImageOnly = false;
        this.writeTablesOnly = false;
        this.writeJFIFHeader = true;
    }

    public void setHorizontalSubsampling(int n2, int n3) {
        this.hSamp[n2] = n3;
    }

    public int getHorizontalSubsampling(int n2) {
        return this.hSamp[n2];
    }

    public void setVerticalSubsampling(int n2, int n3) {
        this.vSamp[n2] = n3;
    }

    public int getVerticalSubsampling(int n2) {
        return this.vSamp[n2];
    }

    public void setLumaQTable(int[] nArray) {
        this.setQTable(0, 0, nArray);
        this.qTabSet[0] = true;
        this.qualitySet = false;
    }

    public void setChromaQTable(int[] nArray) {
        this.setQTable(1, 1, nArray);
        this.setQTable(2, 1, nArray);
        this.qTabSet[1] = true;
        this.qTabSet[2] = true;
        this.qualitySet = false;
    }

    public void setQTable(int n2, int n3, int[] nArray) {
        this.qTab[n2] = (int[])nArray.clone();
        this.qTabSlot[n2] = n3;
        this.qTabSet[n2] = true;
        this.qualitySet = false;
    }

    public boolean isQTableSet(int n2) {
        return this.qTabSet[n2];
    }

    public int[] getQTable(int n2) {
        if (!this.qTabSet[n2]) {
            throw new IllegalStateException(JaiI18N.getString("JPEGEncodeParam0"));
        }
        return this.qTab[n2];
    }

    public int getQTableSlot(int n2) {
        if (!this.qTabSet[n2]) {
            throw new IllegalStateException(JaiI18N.getString("JPEGEncodeParam0"));
        }
        return this.qTabSlot[n2];
    }

    public void setRestartInterval(int n2) {
        this.rstInterval = n2;
    }

    public int getRestartInterval() {
        return this.rstInterval;
    }

    public void setQuality(float f2) {
        this.qual = f2;
        int n2 = 0;
        while (n2 < JPEG_MAX_BANDS) {
            this.qTabSet[n2] = false;
            ++n2;
        }
        this.qualitySet = true;
    }

    public boolean isQualitySet() {
        return this.qualitySet;
    }

    public float getQuality() {
        return this.qual;
    }

    public void setWriteTablesOnly(boolean bl2) {
        this.writeTablesOnly = bl2;
    }

    public boolean getWriteTablesOnly() {
        return this.writeTablesOnly;
    }

    public void setWriteImageOnly(boolean bl2) {
        this.writeImageOnly = bl2;
    }

    public boolean getWriteImageOnly() {
        return this.writeImageOnly;
    }

    public void setWriteJFIFHeader(boolean bl2) {
        this.writeJFIFHeader = bl2;
    }

    public boolean getWriteJFIFHeader() {
        return this.writeJFIFHeader;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

