/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import java.io.Serializable;

public class TIFFField
implements Comparable,
Serializable {
    public static final int TIFF_BYTE = 1;
    public static final int TIFF_ASCII = 2;
    public static final int TIFF_SHORT = 3;
    public static final int TIFF_LONG = 4;
    public static final int TIFF_RATIONAL = 5;
    public static final int TIFF_SBYTE = 6;
    public static final int TIFF_UNDEFINED = 7;
    public static final int TIFF_SSHORT = 8;
    public static final int TIFF_SLONG = 9;
    public static final int TIFF_SRATIONAL = 10;
    public static final int TIFF_FLOAT = 11;
    public static final int TIFF_DOUBLE = 12;
    int tag;
    int type;
    int count;
    Object data;

    TIFFField() {
    }

    public TIFFField(int n2, int n3, int n4, Object object) {
        this.tag = n2;
        this.type = n3;
        this.count = n4;
        this.data = object;
    }

    public int getTag() {
        return this.tag;
    }

    public int getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getAsBytes() {
        return (byte[])this.data;
    }

    public char[] getAsChars() {
        return (char[])this.data;
    }

    public short[] getAsShorts() {
        return (short[])this.data;
    }

    public int[] getAsInts() {
        return (int[])this.data;
    }

    public long[] getAsLongs() {
        return (long[])this.data;
    }

    public float[] getAsFloats() {
        return (float[])this.data;
    }

    public double[] getAsDoubles() {
        return (double[])this.data;
    }

    public int[][] getAsSRationals() {
        return (int[][])this.data;
    }

    public long[][] getAsRationals() {
        return (long[][])this.data;
    }

    public int getAsInt(int n2) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[n2] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[n2];
            }
            case 3: {
                return ((char[])this.data)[n2] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[n2];
            }
            case 9: {
                return ((int[])this.data)[n2];
            }
        }
        throw new ClassCastException();
    }

    public long getAsLong(int n2) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[n2] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[n2];
            }
            case 3: {
                return ((char[])this.data)[n2] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[n2];
            }
            case 9: {
                return ((int[])this.data)[n2];
            }
            case 4: {
                return ((long[])this.data)[n2];
            }
        }
        throw new ClassCastException();
    }

    public float getAsFloat(int n2) {
        switch (this.type) {
            case 1: {
                return ((byte[])this.data)[n2] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[n2];
            }
            case 3: {
                return ((char[])this.data)[n2] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[n2];
            }
            case 9: {
                return ((int[])this.data)[n2];
            }
            case 4: {
                return ((long[])this.data)[n2];
            }
            case 11: {
                return ((float[])this.data)[n2];
            }
            case 12: {
                return (float)((double[])this.data)[n2];
            }
            case 10: {
                int[] nArray = this.getAsSRational(n2);
                return (float)((double)nArray[0] / (double)nArray[1]);
            }
            case 5: {
                long[] lArray = this.getAsRational(n2);
                return (float)((double)lArray[0] / (double)lArray[1]);
            }
        }
        throw new ClassCastException();
    }

    public double getAsDouble(int n2) {
        switch (this.type) {
            case 1: {
                return ((byte[])this.data)[n2] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[n2];
            }
            case 3: {
                return ((char[])this.data)[n2] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[n2];
            }
            case 9: {
                return ((int[])this.data)[n2];
            }
            case 4: {
                return ((long[])this.data)[n2];
            }
            case 11: {
                return ((float[])this.data)[n2];
            }
            case 12: {
                return ((double[])this.data)[n2];
            }
            case 10: {
                int[] nArray = this.getAsSRational(n2);
                return (double)nArray[0] / (double)nArray[1];
            }
            case 5: {
                long[] lArray = this.getAsRational(n2);
                return (double)lArray[0] / (double)lArray[1];
            }
        }
        throw new ClassCastException();
    }

    public String getAsString(int n2) {
        return ((String[])this.data)[n2];
    }

    public int[] getAsSRational(int n2) {
        return ((int[][])this.data)[n2];
    }

    public long[] getAsRational(int n2) {
        return ((long[][])this.data)[n2];
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        int n2 = ((TIFFField)object).getTag();
        if (this.tag < n2) {
            return -1;
        }
        if (this.tag > n2) {
            return 1;
        }
        return 0;
    }
}

